import {__} from "@wordpress/i18n";
import PopupContainer from "../../container";
import {
    getParameterTypesForPopup
} from "../../../pages/settings/pages/actions/actions/add-edit/_constants/parameter-types";

const PARAMETER_TYPES = getParameterTypesForPopup();

export default function AddParameter({close, onSelect}) {

    const handleSelect = (item) => {
        if (item.disabled) {
            return;
        }
        if (onSelect) {
            onSelect(item.type);
        }
        close();
    };

    return (
        <PopupContainer
            title={__("Add parameter", 'limb-chatbot')}
            description={__("Choose the type of data to collect from users", 'limb-chatbot')}
            close={close}
            headerActions={
                <button
                    className="lbaic-settings-popup-header-action"
                    onClick={close}
                >
                    <svg className='lbaic-settings-popup-header-action-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                         viewBox='0 0 24 24'>
                        <use href='#lbaic-settings-close'/>
                    </svg>
                </button>
            }
            popupClassName="lbaic-settings-popup-md lbaic-settings-popup-add-action"
        >
            <div className="lbaic-settings-mp-popup-body">
                {PARAMETER_TYPES.map((item, index) => (
                    <div
                        key={index}
                        className={`lbaic-settings-mp-popup-body-in${item.disabled ? ' lbaic-settings-pointer-none' : ''}`}
                        onClick={() => handleSelect(item)}
                    >
                        {item.badge}
                        <div className={`lbaic-settings-mp-popup-body-inner${item.disabled ? ' lbaic-settings-disabled' : ''}`}>
                            <svg className='lbaic-settings-mp-popup-icon' xmlns='http://www.w3.org/2000/svg' fill='none'
                                 viewBox='0 0 24 24'>
                                <use href={`#lbaic-settings-${item.icon}`}/>
                            </svg>
                            <span className="lbaic-settings-mp-popup-body-label">{item.label}</span>
                            {item.integration}
                        </div>
                    </div>
                ))}
            </div>
        </PopupContainer>
    );
}