import {__} from "@wordpress/i18n";
import PopupContainer from "../../container";
import Badge from "../../../fields/badge";

export const CALLBACK_TYPES = [
    {
        type: 'email',
        label: __("Email", 'limb-chatbot'),
        icon: 'callback-type-email',
        comingSoon: false,
    },
    {
        type: 'slack',
        label: __("Slack", 'limb-chatbot'),
        icon: 'callback-type-slack-notification',
        comingSoon: false,
    },
];

export default function AddCallback({close, onSelect}) {
    const handleSelect = (item) => {
        if (item.comingSoon) {
            return; // Don't allow selection if coming soon
        }
        if (onSelect) {
            onSelect(item.type);
        }
        close();
    };

    return (
        <PopupContainer
            title={__("Select handler type", 'limb-chatbot')}
            description={__("Handlers execute in order. Each can return data for later handlers to use. Mix retrieval, creation, and notifications in one action.", 'limb-chatbot')}
            close={close}
            headerActions={
                <button
                    className="lbaic-settings-popup-header-action"
                    onClick={close}
                >
                    <svg className='lbaic-settings-popup-header-action-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                         viewBox='0 0 24 24'>
                        <use href='#lbaic-settings-close'/>
                    </svg>
                </button>
            }
            popupClassName="lbaic-settings-popup-md lbaic-settings-popup-add-action"
        >
            <div className="lbaic-settings-mp-popup-body">
                {CALLBACK_TYPES.map((item, index) => {
                    const isComingSoon = item.comingSoon === true;
                    return (
                        <div
                            key={index}
                            className={`lbaic-settings-mp-popup-body-in${isComingSoon ? ' lbaic-settings-pointer-none' : ''}`}
                            onClick={() => handleSelect(item)}
                        >
                            {isComingSoon && (
                                <Badge
                                    label={__("Soon", 'limb-chatbot')}
                                    isSmall={true}
                                    className="lbaic-settings-mp-popup-body-item-badge"
                                />
                            )}
                            <div className={`lbaic-settings-mp-popup-body-inner${item.comingSoon ? ' lbaic-settings-disabled' : ''}`}>
                                <svg className='lbaic-settings-mp-popup-icon' xmlns='http://www.w3.org/2000/svg' fill='none'
                                     viewBox='0 0 24 24'>
                                    <use href={`#lbaic-settings-${item.icon}`}/>
                                </svg>
                                {item.type === 'slack' && (
                                    <svg
                                        className='lbaic-settings-mp-popup-body-item-badge-icon lbaic-settings-mp-popup-body-item-badge-icon-slack'
                                        xmlns='http://www.w3.org/2000/svg'
                                        viewBox='0 0 24 24'
                                        width='24'
                                        height='24'>
                                        <use href='#lbaic-settings-integration-slack'/>
                                    </svg>
                                )}
                                <span className="lbaic-settings-mp-popup-body-label">{item.label}</span>
                            </div>
                        </div>
                    );
                })}
            </div>
        </PopupContainer>
    );
}