import {useState} from '@wordpress/element';
import {__} from '@wordpress/i18n';
import {getNavLinkToParams} from "../../../../helpers";
import SettingsUninstall from "../pages/settings/uninstall";
import SettingsGeneral from "../pages/settings/general";

/**
 * Navigation elements, including page tabs
 *
 * @return {object[]}
 */
const getNavItems = () => {
    const navItems = [
        // Settings
        {
            label: __("Settings", 'limb-chatbot'),
            slug: 'settings',
            icon: <svg className='lbaic-settings-nav-item-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                       viewBox='0 0 24 24'>
                <use href='#lbaic-settings-tab-settings'/>
            </svg>,
            tabs: LimbChatbot.Hooks.applyFilters('lbaic.admin.page.settings.navItems.settings.tabs', [
                {
                    icon: <svg className='lbaic-settings-tab-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                               viewBox='0 0 24 24'>
                        <use href='#lbaic-settings-tab-settings-general' className='lbaic-settings-tab-icon stroke default'/>
                        <use href='#lbaic-settings-tab-settings-general' className='lbaic-settings-tab-icon stroke active'/>
                    </svg>,
                    label: __("General", 'limb-chatbot'),
                    subTitle: __("Manage how Limb Chatbot handles its data when the plugin is uninstalled.", 'limb-chatbot'),
                    slug: 'general',
                },
                {
                    icon: <svg className='lbaic-settings-tab-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                               viewBox='0 0 24 24'>
                        <use href='#lbaic-settings-tab-uninstall' className='lbaic-settings-tab-icon stroke default'/>
                        <use href='#lbaic-settings-tab-uninstall' className='lbaic-settings-tab-icon stroke active'/>
                    </svg>,
                    label: __("Uninstall", 'limb-chatbot'),
                    subTitle: __("Reset plugin data to defaults.", 'limb-chatbot'),
                    slug: 'uninstall',
                },
            ])
        },
    ];
    return LimbChatbot.Hooks.applyFilters('lbaic.admin.page.settings.navItems', navItems);
}

/**
 * Get pages with their unique keys
 * to handle content changes based on react routing
 *
 * @return {object}
 */
const getPages = () => {
    const pages = {
        // Settings
        [getNavLinkToParams('settings', 'general', true)]: SettingsGeneral,
        [getNavLinkToParams('settings', 'uninstall', true)]: SettingsUninstall,
    };

    return LimbChatbot.Hooks.applyFilters('lbaic.admin.page.settings.pages', pages);
}

/**
 * Settings state
 *
 * @return {{setPages: *, pages: *, setNavItems: *, navItems: *}}
 */
const useSettings = () => {
    const [navItems, setNavItems] = useState(getNavItems());
    const [pages, setPages] = useState(getPages());

    return {
        navItems,
        setNavItems,
        pages,
        setPages,
    };
};

export default useSettings;