import {useState} from "@wordpress/element";
import {__} from '@wordpress/i18n';
import Toggle from "../../../../../fields/toggle";
import Notice from "../../../../../sections/notice";
import TabSettings from "../../../../components/tab-settings";
import Container from "../../../containers/content/container";

const TAB_NAME = 'settings.settings.general';

export default function SettingsGeneral({notifications}) {
    const settings = {
        'remove_plugin_data': useState(false),
    };

    return (
        <TabSettings
            name={TAB_NAME}
            settings={settings}
            keysPrefix='lbaic.plugin'
            notifications={notifications}
        >
            <Container>
                <div className="lbaic-settings-column">
                    <div className="lbaic-settings-column-in">
                        <Notice
                            type='warning'
                            desc={__("When enabled, all plugin-related data - such as settings, chat logs, and knowledge items - will be permanently deleted from the database when you delete the plugin.", 'limb-chatbot')}
                            dismissible={false}
                        />
                    </div>
                </div>
                <div className='lbaic-settings-column'>
                    <div className='lbaic-settings-column-in'>
                        <Toggle label={__("Remove all plugin data when the plugin is deleted", 'limb-chatbot')}
                                isActive={!!settings['remove_plugin_data'][0]}
                                onClick={() => settings['remove_plugin_data'][1](prevState => !prevState)}/>
                    </div>
                    <div className='lbaic-settings-column-in'/>
                </div>
            </Container>
        </TabSettings>
    );
}


