import {useState} from "@wordpress/element";
import {__} from "@wordpress/i18n";
import Toggle from "../../../../../fields/toggle";
import Container from "../../../containers/content/container";
import TabSettings from "../../../../components/tab-settings";

const TAB_NAME = 'settings.notifications.settings';
const SETTINGS_KEYS_PREFIX = 'lbaic.notifications.notification_type';

const ADMIN_ACCORDION_KEY = 'admin';

export default function NotificationsSettings({notifications}) {
    const [activeAccordionKey, setActiveAccordionKey] = useState(ADMIN_ACCORDION_KEY);

    const settings = {
        chat_created: useState(false),
        lead_captured: useState(false),
    };

    const toggleAccordion = (key) => {
        setActiveAccordionKey(activeAccordionKey === key ? '' : key);
    };

    return (
        <TabSettings
            name={TAB_NAME}
            settings={settings}
            keysPrefix={SETTINGS_KEYS_PREFIX}
            notifications={notifications}
        >
            <Container className="lbaic-settings-notifications">
                <div
                    className="lbaic-settings-table-accordion-wrapper lbaic-settings-scroll-style lbaic-settings-scroll-x">
                    <table className="lbaic-settings-table-accordion">
                        <thead className="lbaic-settings-table-accordion-header"/>
                        <tbody className="lbaic-settings-table-accordion-body">
                        <tr
                            className={`lbaic-settings-table-accordion-body-in lbaic-settings-table-accordion-summary lbaic-settings-cb-cl-table-summary${activeAccordionKey === ADMIN_ACCORDION_KEY ? ' active' : ''}`}
                            onClick={() => toggleAccordion(ADMIN_ACCORDION_KEY)}
                        >
                            <td className="lbaic-settings-table-accordion-body-item">
                                <div className="lbaic-settings-cb-cl-table-item">
                                    <span
                                        className="lbaic-settings-table-accordion-body-label">{__("Admin", 'limb-chatbot')}</span>
                                </div>
                            </td>
                            <td className="lbaic-settings-table-accordion-body-item lbaic-settings-table-accordion-body-arrow">
                                <svg className="lbaic-settings-table-accordion-body-arrow-i"
                                     xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                    <use href="#lbaic-settings-arrow"/>
                                </svg>
                            </td>
                        </tr>
                        <tr className={`lbaic-settings-table-accordion-body-in lbaic-settings-table-accordion-details${activeAccordionKey === ADMIN_ACCORDION_KEY ? ' opened' : ''}`}>
                            <td className="lbaic-settings-table-accordion-body-item lbaic-settings-table-accordion-body-item lbaic-settings-table-accordion-details-in"
                                colSpan={2}>
                                <div className="lbaic-settings-table-accordion-content">
                                    <div className="lbaic-settings-column">
                                        <div className="lbaic-settings-column-in">
                                            <Toggle
                                                label={__("Chat created", 'limb-chatbot')}
                                                isActive={settings['chat_created'][0]}
                                                onClick={() => settings['chat_created'][1](!settings['chat_created'][0])}
                                            />
                                        </div>
                                        <div className="lbaic-settings-column-in">
                                            <Toggle
                                                label={__("Lead captured", 'limb-chatbot')}
                                                isActive={settings['lead_captured'][0]}
                                                onClick={() => settings['lead_captured'][1](!settings['lead_captured'][0])}
                                            />
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </Container>
        </TabSettings>
    );
}
