import {__} from "@wordpress/i18n";
import Badge from "../../../../../../fields/badge";
import KebabMenu from "../../../../../../button/kebab-menu";

export default function DatasetRowActions({
                                              row,
                                              index,
                                              processState,
                                              syncing,
                                              deleting,
                                              preparing,
                                              onSync,
                                              onDelete,
                                              isRowDisabled
                                          }) {
    const isThisSyncing = syncing.indexOf(row.id) !== -1;
    const isThisDeleting = deleting.indexOf(row.id) !== -1;

    // Sync state
    const isSynced = !!(+row.metas?.find(item => item.meta_key === 'synced')?.meta_value);

    // Individual disabled states for each action
    const isSyncDisabled = isSynced || preparing || processState?.type;
    const isDeleteDisabled = preparing || processState?.type;

    const actions = [
        {
            label: __("Update", 'limb-chatbot'),
            icon: 'sync',
            onClick: () => {
                if (!isSyncDisabled) {
                    onSync(row, index);
                }
            },
            disabled: isSyncDisabled,
            loading: isThisSyncing
        },
        {
            label: __("Delete", 'limb-chatbot'),
            icon: 'delete',
            onClick: () => {
                if (!isDeleteDisabled) {
                    onDelete(row, index);
                }
            },
            className: 'delete',
            disabled: isDeleteDisabled,
            loading: isThisDeleting
        },
    ];

    // Check if kebab menu should be disabled
    const isKebabMenuDisabled = preparing || actions.every(action => action.disabled);

    return (
        <div className='lbaic-settings-table-card-actions'>
            {!isRowDisabled && isSynced && (
                <Badge label={__("Synced", 'limb-chatbot')} icon='check' className='lbaic-settings-badge-green'/>
            )}
            <KebabMenu actions={actions} disabled={isKebabMenuDisabled}/>
        </div>
    );
}
