import {BackgroundProcessProvider} from "../../../../../contexts/background-process";
import KnowledgeDSItems from "./body";

/**
 * Wrapper component that provides BackgroundProcessContext to KnowledgeDSItems
 * This ensures that the background process context is only available for this specific component
 */
export default function KnowledgeDataSourcesItemsWrapper({notifications, ...props}) {
    return (
        <BackgroundProcessProvider notifications={notifications} pageSlug="sources">
            <KnowledgeDSItems notifications={notifications} {...props} />
        </BackgroundProcessProvider>
    );
}
