import {useCallback, useEffect, useState} from "@wordpress/element";
import {__} from "@wordpress/i18n";
import Dropdown from "../../../../../../fields/dropdown";
import Input from "../../../../../../fields/input";
import {SOURCE_TYPES} from "../_data";
import {AI_PROVIDERS} from "../../../../../../../constants/chatbot/ai";
import {DATABASES} from "../../storages/data";
import Description from "../../../../../../sections/description";

export default function FilterForm({
                                       searchValue,
                                       setSearchValue,
                                       sourceTypeValue,
                                       setSourceTypeValue,
                                       syncedValue,
                                       setSyncedValue,
                                       aiProviderIdValue,
                                       setAIProviderIdValue,
                                       vectorIndexIdValue,
                                       setVectorIndexIdValue,
                                       disabled
                                   }) {
    const [localSearchValue, setLocalSearchValue] = useState(searchValue || '');

    // Prepare source types options with "Select" option
    const sourceTypesOptions = [
        {label: __("Select", 'limb-chatbot'), value: null},
        ...SOURCE_TYPES.filter(item => item.value !== 'q_a' && item.value !== '')
    ];

    // Prepare synced options
    const syncedOptions = [
        {label: __("Select", 'limb-chatbot'), value: null},
        {label: __("Yes", 'limb-chatbot'), value: 1},
        {label: __("No", 'limb-chatbot'), value: 0}
    ];

    // Prepare AI provider options with "Select" option
    const aiProviderOptions = [
        {label: __("Select", 'limb-chatbot'), value: null},
        ...AI_PROVIDERS.map(provider => ({
            label: provider.label,
            value: provider.value,
            icon: provider.icon
        }))
    ];

    // Prepare storage options with "Select" option (using DATABASES from Knowledge Settings)
    const storageOptionsWithSelect = [
        {label: __("Select", 'limb-chatbot'), value: null},
        ...DATABASES
    ];

    // Sync local search value with prop when it changes externally (e.g., when filters are discarded)
    useEffect(() => {
        setLocalSearchValue(searchValue || '');
    }, [searchValue]);

    /**
     * Handle search input change (only update local state, no automatic filter application)
     */
    const handleSearchChange = useCallback((value) => {
        // Update local state immediately for responsive UI
        setLocalSearchValue(value);
        // Update the filter state (but don't apply filters automatically)
        setSearchValue(value);
    }, [setSearchValue]);

    return (
        <div className='lbaic-settings-a-ei-body'>
            <div className='lbaic-settings-column'>
                <div className='lbaic-settings-column-in'>
                    <Input
                        value={localSearchValue}
                        setValue={handleSearchChange}
                        placeholder={__("Search", 'limb-chatbot')}
                        disabled={disabled}
                    />
                    <Description>{__("Search knowledge sources by name", 'limb-chatbot')}</Description>
                </div>
                <div className='lbaic-settings-column-in'>
                    <Dropdown
                        value={sourceTypeValue}
                        setValue={setSourceTypeValue}
                        options={sourceTypesOptions}
                        placeholder={__("Source", 'limb-chatbot')}
                        disabled={disabled}
                        iconClassName='lbaic-settings-dropdown-kb-icon'
                    />
                    <Description>{__("Select the type of content", 'limb-chatbot')}</Description>
                </div>
            </div>
            <div className='lbaic-settings-column'>
                <div className='lbaic-settings-column-in'>
                    <Dropdown
                        value={syncedValue}
                        setValue={setSyncedValue}
                        options={syncedOptions}
                        placeholder={__("Synced", 'limb-chatbot')}
                        disabled={disabled}
                    />
                    <Description>{__("Select whether sources are synced", 'limb-chatbot')}</Description>
                </div>
                <div className='lbaic-settings-column-in'>
                    <Dropdown
                        value={aiProviderIdValue}
                        setValue={setAIProviderIdValue}
                        options={aiProviderOptions}
                        placeholder={__("AI provider", 'limb-chatbot')}
                        disabled={disabled}
                    />
                    <Description>{__("Select AI provider used for knowledge collecting", 'limb-chatbot')}</Description>
                </div>
            </div>
            <div className='lbaic-settings-column'>
                <div className='lbaic-settings-column-in'>
                    <Dropdown
                        value={vectorIndexIdValue}
                        setValue={setVectorIndexIdValue}
                        options={storageOptionsWithSelect}
                        placeholder={__("Storage type", 'limb-chatbot')}
                        disabled={disabled}
                    />
                    <Description>{__("Select storage type", 'limb-chatbot')}</Description>
                </div>
                <div className='lbaic-settings-column-in'/>
            </div>
        </div>
    );
}
