export const WP_POST_TYPES_ICONS = [
    'post',
    'page',
];

export const FILES_TYPES_ICONS = {
    'application/pdf': 'pdf',
    'application/x-pdf': 'pdf',
    'text/plain': 'txt'
};

// Default file support for all providers (PDF only, 10MB)
const DEFAULT_FILE_SUPPORT = {
    'document': {
        display: '.pdf',
        accept: 'application/pdf, application/x-pdf',
    },
    'image': {
        display: '',
        accept: '',
    },
    // File size limit in bytes (10MB for all providers)
    maxSize: 10 * 1024 * 1024,
};

export const SUPPORTED_FILES = {
    'open-ai': DEFAULT_FILE_SUPPORT,
    'gemini': DEFAULT_FILE_SUPPORT,
    'deep-seek': DEFAULT_FILE_SUPPORT,
};