import {__} from "@wordpress/i18n";
import useIsEllipsed from "../../../../../../../../../helpers/hooks/use-is-ellipsed";
import Tooltip from "../../../../../../../fields/tooltip";

export default function SourceLink({name, link, className, _default}) {
    if (!link) {
        return _default;
    }

    const text = name || __("N/A", 'limb-chatbot');

    const [textRef, isEllipsed] = useIsEllipsed([text]);

    return (
        <a
            href={link}
            target="_blank"
            rel="noopener"
            className={`lbaic-settings-table-card-body-input-link${className ? ' ' + className : ''}`}
            onClick={(e) => e.stopPropagation()}
        >
            {isEllipsed ? (
                <Tooltip
                    label={text}
                    className='no-hover-bg'
                >
                    <span
                        ref={textRef}
                        className='lbaic-settings-table-card-body-input-link-in'
                        dangerouslySetInnerHTML={{__html: text}}
                    />
                </Tooltip>
            ) : (
                <span
                    ref={textRef}
                    className='lbaic-settings-table-card-body-input-link-in'
                    dangerouslySetInnerHTML={{__html: text}}
                />
            )}
            <svg className='lbaic-settings-table-card-body-i lbaic-settings-table-card-body-input-i'
                 xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 24 24'>
                <use href='#lbaic-settings-external-arrow' className="lbaic-settings-external-arrow"/>
                <use href='#lbaic-external-box'/>
            </svg>
        </a>
    );
}