import {__} from "@wordpress/i18n";

export const SOURCE_TYPES = [
    {
        label: __('Select source type', 'limb-chatbot'),
        value: '',
        icon: '',
    },
    {
        label: __('Posts', 'limb-chatbot'),
        value: 'post',
        icon: 'post',
    },
    {
        label: __('Q/A', 'limb-chatbot'),
        value: 'q_a',
        icon: 'q_a',
    },
    {
        label: __('Text', 'limb-chatbot'),
        value: 'text',
        icon: 'text',
    },
    {
        label: __('Files', 'limb-chatbot'),
        value: 'file',
        icon: 'file',
    },
    {
        label: __('URL', 'limb-chatbot'),
        value: 'url',
        icon: 'source-url',
    },
    {
        label: __('Sitemap', 'limb-chatbot'),
        value: 'sitemap',
        icon: 'source-sitemap',
        iconClassName: 'lbaic-i-stroke'
    }
];

export const DATASET_PROCESSES_INFO = {
    'dataset_generating': {
        success: __("Sources added to the knowledge base.", 'limb-chatbot'),
        error: __("Failed to add sources to the knowledge base.", 'limb-chatbot'),
        processName: __("Learning", 'limb-chatbot'),
        inPageTitle: __("Learned", 'limb-chatbot'),
    },
    'dataset_sync': {
        success: __("Sources updated successfully.", 'limb-chatbot'),
        error: __("Failed to update sources.", 'limb-chatbot'),
        processName: __("Updating", 'limb-chatbot'),
        inPageTitle: __("Updated", 'limb-chatbot'),
    },
    'dataset_delete': {
        success: __("Sources removed from the knowledge base.", 'limb-chatbot'),
        error: __("Failed to remove sources from the knowledge base.", 'limb-chatbot'),
        processName: __("Deleting", 'limb-chatbot'),
        inPageTitle: __("Deleted", 'limb-chatbot'),
    },
    'sitemap_scrape': {
        success: __("Sitemap scraped.", 'limb-chatbot'),
        error: __("Failed to scrape sitemap.", 'limb-chatbot'),
        processName: __("Sitemap scraping", 'limb-chatbot'),
        inPageTitle: __("Sitemap scraped", 'limb-chatbot'),
    },
};