import {__} from "@wordpress/i18n";
import Input from "../../../../../../../fields/input";
import LexicalEditor from "../../../../../../../fields/lexical";

export default function Details({show, question, setQuestion, answer, setAnswer, saving, saveDisabled, save, notifications, fullWidth}) {
    return <>
        <div className="lbaic-settings-column">
            <div className="lbaic-settings-column-in">
                <Input key={show} // Rerender to autofocus
                       value={question}
                       setValue={setQuestion}
                       placeholder={__("Question", 'limb-chatbot')}
                       autofocus/>
            </div>
            {!fullWidth && <div className="lbaic-settings-c olumn-in"/>}
        </div>
        <div className="lbaic-settings-column">
            <div className="lbaic-settings-column-in">
                <LexicalEditor
                    key={show}
                    value={answer}
                    setValue={setAnswer}
                />
            </div>
        </div>
        <div className="lbaic-settings-table-card-details-footer">
            <div className="lbaic-settings-table-card-details-footer-in">
                <button
                    className={`lbaic-settings-button lbaic-settings-button-center lbaic-settings-button-h-40 lbaic-settings-button-primary${saveDisabled ? ' lbaic-settings-button-disabled' : ''}`}
                    onClick={() => !saveDisabled && save()}>
                    {saving && (
                        <svg className='lbaic-settings-button-i lbaic-settings-loading-circle'
                             xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 24 24'>
                            <use href='#lbaic-settings-circle'/>
                        </svg>
                    )}
                    <span className="lbaic-settings-button-label">{__("Save", 'limb-chatbot')}</span>
                </button>
            </div>
        </div>
    </>
}