import {BackgroundProcessProvider} from "../../../../../contexts/background-process";
import KnowledgeRecommendations from "./body";

/**
 * Wrapper component that provides BackgroundProcessContext to KnowledgeRecommendations
 * This ensures that the background process context is only available for this specific component
 */
export default function KnowledgeRecommendationsWrapper({notifications, ...props}) {
    return (
        <BackgroundProcessProvider notifications={notifications} pageSlug="recommendations">
            <KnowledgeRecommendations notifications={notifications} {...props} />
        </BackgroundProcessProvider>
    );
}