import {useState} from "@wordpress/element";
import {__} from "@wordpress/i18n";
import Badge from "../../../../../../fields/badge";
import ContentFooter from "../../../../containers/content/footer";
import Toggle from "../../../../../../fields/toggle";
import ContentBodyInner from "../../../../containers/content/body-inner";
import Container from "../../../../containers/content/container";
import Description from "../../../../../../sections/description";

export default function ImageGenerator() {
    const [isActive, setIsActive] = useState(false);

    return (
        <>
            <ContentBodyInner>
                <Container>
                    <Toggle label={__("Image generator", 'limb-chatbot')} onClick={() => setIsActive(!isActive)}
                            isActive={isActive}>
                        <div className="lbaic-settings-label-badge">
                            <Badge label='Premium'/>
                        </div>
                    </Toggle>
                    <Description>Automatic title suggestions for different content types ( post/page/product/category/etc ... )</Description>
                </Container>
            </ContentBodyInner>
            <ContentFooter save={() => console.log('--save--')} discard={() => console.log('--discard--')}/>
        </>
    )
}