import {__, sprintf} from "@wordpress/i18n";

export const LOCATIONS = [
    {
        label: __("Home", 'limb-chatbot'),
        value: 'home',
    },
    {
        label: __("New chat", 'limb-chatbot'),
        value: 'new_chat',
    },
    {
        label: __("Near chatbot icon", 'limb-chatbot'),
        value: 'chatbot_icon',
    },
];

export const GROUP_ITEM_TYPES = [
    {
        label: __("Text", 'limb-chatbot'),
        value: 'text',
        icon: 'widget-text',
    },
    {
        label: __("Prompt", 'limb-chatbot'),
        value: 'prompt',
        icon: 'pw',
    },
    {
        label: __("Link", 'limb-chatbot'),
        value: 'link',
        icon: 'link',
    },
    {
        label: __("Message", 'limb-chatbot'),
        value: 'message',
        icon: 'message',
    },
    {
        label: __("Chat history", 'limb-chatbot'),
        value: 'chat_history',
        icon: 'history',
    },
    {
        label: __("Lead capture", 'limb-chatbot'),
        value: 'lead_capture',
        icon: 'lead-capture',
    }
];

export const GROUP_ITEMS_DATA = {
    'prompt': {
        content: [
            {
                type: 'text',
                text: {
                    value: '',
                },
            }
        ],
        message: '',
    },
    'link': {
        url: '',
        text: '',
        target: false,
    },
    'message': {
        content: [
            {
                type: 'text',
                text: {
                    value: '',
                },
            }
        ],
    },
    'chat_history': {
        title: '',
    },
    'text': {
        content: '',
    },
    'lead_capture': {
        heading: __("Start Chatting with AI", 'limb-chatbot'),
        description: __("Please provide your details to begin your conversation with our AI assistant.", 'limb-chatbot'),
        submit_button_text: __("Start chat", 'limb-chatbot'),
        required: false,
        fields: [
            {
                type: 'text',
                required: false,
                name: 'name',
                label: __("Name", 'limb-chatbot'),
                placeholder: __("Enter your full name", 'limb-chatbot')
            },
            {
                type: 'email',
                required: true,
                name: 'email',
                label: __("Email", 'limb-chatbot'),
                placeholder: __("your@email.com", 'limb-chatbot'),
            },
        ],
    },
};

/**
 * Wait until appear options for message widgets near chatbot icon
 */
export const APPEAR_AFTER = [
    {
        label: __("Immediately", 'limb-chatbot'),
        value: 0
    },
    {
        label: sprintf(__("%d sec", 'limb-chatbot'), 2),
        value: 2
    },
    {
        label: sprintf(__("%d sec", 'limb-chatbot'), 5),
        value: 5
    },
    {
        label: sprintf(__("%d sec", 'limb-chatbot'), 10),
        value: 10
    },
    ...JSON.parse(localStorage.getItem('lbaic.settings.chatbot.widgets.message.appear_after') || '[]')
];

/**
 * Get available locations for a widget type
 * @param {string} type Widget type
 * @return {Array} Available locations
 */
export const getAvailableLocationsForType = (type) => {
    switch (type) {
        case 'prompt':
            // Prompt can be in home, new_chat, and chatbot_icon
            return LOCATIONS;
        case 'message':
            // Message can be in new_chat and chatbot_icon (excluded from home)
            return LOCATIONS.filter(loc => loc.value !== 'home');
        case 'link':
        case 'chat_history':
        case 'text':
            // Link, chat_history, and text can only be in home
            return LOCATIONS.filter(loc => loc.value === 'home');
        case 'lead_capture':
            // Lead capture can be in new_chat or near chatbot icon
            return LOCATIONS.filter(loc => loc.value === 'new_chat' || loc.value === 'chatbot_icon');
        default:
            return LOCATIONS;
    }
};
