import {__} from "@wordpress/i18n";
import LexicalEditor from "../../../../../../../../../fields/lexical";
import {removeStyleAttributes} from "../../../../../../../../../../helpers";

export default function TextWidget({widgetItem, index, update}) {
    return (
        <div className="lbaic-settings-column">
            <div className="lbaic-settings-column-in">
                <LexicalEditor
                    value={widgetItem.data?.content || ''}
                    setValue={value => update(prevState => prevState.map((item, i) => {
                        if (i === index) {
                            return {
                                ...item,
                                data: {
                                    ...item.data,
                                    content: removeStyleAttributes(value)
                                }
                            };
                        }
                        return item;
                    }))}
                    placeholder={__("Content", 'limb-chatbot')}
                    autofocus
                    convertToMarkdown={false}
                />
            </div>
        </div>
    );
}
