import {__} from "@wordpress/i18n";
import Input from "../../../../../../../../../fields/input";
import Emoji from "../../../../../../../../../button/emoji";
import Copilot from "../../../../../../../../../button/copilot";

export default function PromptWidget({widgetItem, index, update, notifications}) {
    return (
        <>
            <div className="lbaic-settings-column">
                <div className="lbaic-settings-column-in">
                    <Input
                        value={widgetItem.data?.content?.find(item => item.type === 'text')?.text?.value || ''}
                        setValue={value => update(prevState => prevState.map((item, i) => {
                            if (i === index) {
                                return {
                                    ...item,
                                    data: {
                                        ...(item.data || {}),
                                        content: item.data?.content?.map(item3 => {
                                            if (item3.type === 'text') {
                                                return {
                                                    ...item3,
                                                    text: {
                                                        ...(item3.text || {}),
                                                        value: value
                                                    }
                                                };
                                            }
                                            return item3;
                                        })
                                    }
                                };
                            }
                            return item;
                        }))}
                        placeholder={__("Content", 'limb-chatbot')}
                        autofocus
                        actions={[
                            {
                                component: Emoji,
                                props: {
                                    chosen: obj => update(prevState => prevState.map((item, i) => {
                                        if (i === index) {
                                            return {
                                                ...item,
                                                data: {
                                                    ...item.data,
                                                    content: item.data?.content?.map(item3 => {
                                                        if (item3.type === 'text') {
                                                            return {
                                                                ...item3,
                                                                text: {
                                                                    ...(item3.text || {}),
                                                                    value: (item3.text?.value || '') + obj.emoji
                                                                },
                                                            };
                                                        }
                                                        return item3;
                                                    })
                                                }
                                            };
                                        }
                                        return item;
                                    }))
                                },
                            },
                            {
                                component: Copilot,
                                props: {
                                    text: widgetItem.data?.content?.find(item => item.type === 'text')?.text?.value || '',
                                    className: 'lbaic-settings-cb-pw-textarea',
                                    generated: value => update(prevState => prevState.map((item, i) => {
                                        if (i === index) {
                                            return {
                                                ...item,
                                                data: {
                                                    ...item.data,
                                                    content: item.data?.content?.map(item3 => {
                                                        if (item3.type === 'text') {
                                                            return {
                                                                ...item3,
                                                                text: {
                                                                    ...(item3.text || {}),
                                                                    value: value
                                                                }
                                                            };
                                                        }
                                                        return item3;
                                                    })
                                                }
                                            };
                                        }
                                        return item;
                                    })),
                                    notifications: notifications
                                },
                            },
                        ]}
                    />
                </div>
            </div>
            <div className="lbaic-settings-column">
                <div className="lbaic-settings-column-in">
                    <Input
                        value={widgetItem.data?.message || ''}
                        setValue={value => update(prevState => prevState.map((item, i) => {
                            if (i === index) {
                                return {
                                    ...item,
                                    data: {
                                        ...(item.data || {}),
                                        message: value
                                    }
                                };
                            }
                            return item;
                        }))}
                        placeholder={__("Message", 'limb-chatbot')}
                        actions={[
                            {
                                component: Emoji,
                                props: {
                                    chosen: obj => update(prevState => prevState.map((item, i) => {
                                        if (i === index) {
                                            return {
                                                ...item,
                                                data: {
                                                    ...item.data,
                                                    message: (item.data?.message || '') + obj.emoji
                                                }
                                            };
                                        }
                                        return item;
                                    }))
                                },
                            },
                            {
                                component: Copilot,
                                props: {
                                    text: widgetItem.data?.message || '',
                                    className: 'lbaic-settings-cb-pw-textarea',
                                    generated: value => update(prevState => prevState.map((item, i) => {
                                        if (i === index) {
                                            return {
                                                ...item,
                                                data: {
                                                    ...item.data,
                                                    message: value
                                                }
                                            };
                                        }
                                        return item;
                                    })),
                                    notifications: notifications
                                },
                            },
                        ]}
                    />
                </div>
            </div>
        </>
    );
}
