import {__} from "@wordpress/i18n";
import Input from "../../../../../../../../../fields/input";
import Toggle from "../../../../../../../../../fields/toggle";
import Description from "../../../../../../../../../sections/description";
import Dropdown from "../../../../../../../../../fields/dropdown";
import Emoji from "../../../../../../../../../button/emoji";
import Copilot from "../../../../../../../../../button/copilot";
import {APPEAR_AFTER} from "../../../_data";

export default function MessageWidget({
                                          widgetItem,
                                          index,
                                          update,
                                          notifications,
                                          showWaitUntilAppear,
                                          currentWaitUntilAppear,
                                          setShowAddNewWaitOptionPopup
                                      }) {
    return (
        <>
            <div className="lbaic-settings-column">
                <div className="lbaic-settings-column-in">
                    <Input
                        value={widgetItem.data?.content?.find(item => item.type === 'text')?.text?.value || ''}
                        setValue={value => update(prevState => prevState.map((item, i) => {
                            if (i === index) {
                                return {
                                    ...item,
                                    data: {
                                        ...item.data,
                                        content: item.data?.content?.map(item3 => {
                                            if (item3.type === 'text') {
                                                return {
                                                    ...item3,
                                                    text: {
                                                        ...(item3.text || {}),
                                                        value: value
                                                    }
                                                };
                                            }
                                            return item3;
                                        })
                                    }
                                };
                            }
                            return item;
                        }))}
                        placeholder={__("Content", 'limb-chatbot')}
                        actions={[
                            {
                                component: Emoji,
                                props: {
                                    chosen: obj => update(prevState => prevState.map((item, i) => {
                                        if (i === index) {
                                            return {
                                                ...item,
                                                data: {
                                                    ...item.data,
                                                    content: item.data?.content?.map(item3 => {
                                                        if (item3.type === 'text') {
                                                            return {
                                                                ...item3,
                                                                text: {
                                                                    ...(item3.text || {}),
                                                                    value: (item3.text?.value || '') + obj.emoji
                                                                }
                                                            };
                                                        }
                                                        return item3;
                                                    })
                                                }
                                            };
                                        }
                                        return item;
                                    }))
                                },
                            },
                            {
                                component: Copilot,
                                props: {
                                    text: widgetItem.data?.content?.find(item => item.type === 'text')?.text?.value || '',
                                    generated: value => update(prevState => prevState.map((item, i) => {
                                        if (i === index) {
                                            return {
                                                ...item,
                                                data: {
                                                    ...item.data,
                                                    content: item.data?.content?.map(item3 => {
                                                        if (item3.type === 'text') {
                                                            return {
                                                                ...item3,
                                                                text: {
                                                                    ...(item3.text || {}),
                                                                    value: value
                                                                }
                                                            };
                                                        }
                                                        return item3;
                                                    })
                                                }
                                            };
                                        }
                                        return item;
                                    })),
                                    notifications: notifications
                                },
                            },
                        ]}/>
                </div>
            </div>
            <div className="lbaic-settings-column">
                <div className="lbaic-settings-column-in">
                    <Toggle
                        label={__("Notify", 'limb-chatbot')}
                        isActive={widgetItem.notify || false}
                        onClick={() => update(prevState => prevState.map((item, i) => {
                            if (i === index) {
                                return {
                                    ...item,
                                    notify: !(item.notify || false)
                                };
                            }
                            return item;
                        }))}
                    />
                    <Description>{__("Play notification sound for widget messages", 'limb-chatbot')}</Description>
                </div>
                <div className="lbaic-settings-column-in">
                    {showWaitUntilAppear && (
                        <>
                            <Dropdown
                                value={currentWaitUntilAppear}
                                setValue={value => update(prevState => prevState.map((item, i) => {
                                    if (i === index) {
                                        return {
                                            ...item,
                                            appear_after: value
                                        };
                                    }
                                    return item;
                                }))}
                                options={APPEAR_AFTER}
                                defaultIcon="schedule"
                                addNew={() => setShowAddNewWaitOptionPopup(true)}
                                placeholder={__("Wait until appear", 'limb-chatbot')}
                            />
                            <Description>{__("Delay in seconds before the message appears near chatbot icon", 'limb-chatbot')}</Description>
                        </>
                    )}
                </div>
            </div>
        </>
    );
}
