import {__} from "@wordpress/i18n";
import Input from "../../../../../../../../../fields/input";
import Checkbox from "../../../../../../../../../fields/checkbox";
import Emoji from "../../../../../../../../../button/emoji";

export default function LinkWidget({widgetItem, index, update}) {
    return (
        <>
            <div className="lbaic-settings-column">
                <div className="lbaic-settings-column-in">
                    <Input value={widgetItem.data?.url}
                           setValue={value => update(prevState => prevState.map((item, i) => {
                               if (i === index) {
                                   return {
                                       ...item,
                                       data: {
                                           ...item.data,
                                           url: value
                                       }
                                   };
                               }
                               return item;
                           }))}
                           placeholder={__("URL", 'limb-chatbot')}
                           autofocus/>
                </div>
                <div className="lbaic-settings-column-in">
                    <Input value={widgetItem.data?.text || ''}
                           setValue={value => update(prevState => prevState.map((item, i) => {
                               if (i === index) {
                                   return {
                                       ...item,
                                       data: {
                                           ...item.data,
                                           text: value
                                       }
                                   };
                               }
                               return item;
                           }))}
                           placeholder={__("Link text", 'limb-chatbot')}
                           actions={[
                               {
                                   component: Emoji,
                                   props: {
                                       chosen: obj => update(prevState => prevState.map((item, i) => {
                                           if (i === index) {
                                               return {
                                                   ...item,
                                                   data: {
                                                       ...item.data,
                                                       text: (item.data?.text || '') + obj.emoji
                                                   }
                                               };
                                           }
                                           return item;
                                       }))
                                   },
                               },
                           ]}/>
                </div>
            </div>
            <div className="lbaic-settings-column">
                <div className="lbaic-settings-column-in">
                    <Checkbox isChecked={widgetItem.data?.target === '_blank'}
                              toggleValue={() => update(prevState => prevState.map((item, i) => {
                                  if (i === index) {
                                      return {
                                          ...item,
                                          data: {
                                              ...item.data,
                                              target: item.data?.target ? false : '_blank',
                                          }
                                      };
                                  }
                                  return item;
                              }))}
                              label={__("Open in new tab", 'limb-chatbot')}/>
                </div>
            </div>
        </>
    );
}
