import {__} from "@wordpress/i18n";
import Input from "../../../../../../../../../fields/input";
import Emoji from "../../../../../../../../../button/emoji";
import Copilot from "../../../../../../../../../button/copilot";

export default function ChatHistoryWidget({widgetItem, index, update, notifications}) {
    return (
        <div className="lbaic-settings-column">
            <div className="lbaic-settings-column-in">
                <Input value={widgetItem.title || ''}
                       setValue={value => update(prevState => prevState.map((item, i) => {
                           if (i === index) {
                               return {
                                   ...item,
                                   title: value
                               };
                           }
                           return item;
                       }))}
                       placeholder={__("Header", 'limb-chatbot')}
                       autofocus
                       actions={[
                           {
                               component: Emoji,
                               props: {
                                   chosen: obj => update(prevState => prevState.map((item, i) => {
                                       if (i === index) {
                                           return {
                                               ...item,
                                               title: (item.title || '') + obj.emoji
                                           };
                                       }
                                       return item;
                                   }))
                               },
                           },
                           {
                               component: Copilot,
                               props: {
                                   text: widgetItem.title || '',
                                   generated: value => update(prevState => prevState.map((item, i) => {
                                       if (i === index) {
                                           return {
                                               ...item,
                                               title: value
                                           };
                                       }
                                       return item;
                                   })),
                                   notifications: notifications
                               },
                           },
                       ]}/>
            </div>
        </div>
    );
}
