import {stripHtml} from "../../../../../../../../../helpers";

/**
 * Get widget title based on widget type
 * @param {Object} widgetItem Widget item
 * @return {string} Widget title
 */
export function getWidgetTitle(widgetItem) {
    switch (widgetItem.type) {
        case 'prompt':
        case 'message':
            return widgetItem.data?.content?.find(item => item.type === 'text')?.text?.value || '';
        case 'link':
            return widgetItem.data?.text;
        case 'chat_history':
            return widgetItem.title;
        case 'text':
            // Extract first few words from content for title
            const textContent = stripHtml(widgetItem.data?.content || '');
            const firstWords = textContent.split(/\s+/).slice(0, 10).join(' ');
            return firstWords || '';
        case 'lead_capture':
            return widgetItem.data?.heading || '';
        default:
            return false;
    }
}
