import {__} from "@wordpress/i18n";
import {handleError} from "../../../../../../../../../helpers/notifications";
import {numberFormat} from "../../../../../../../../../../helpers";
import {getNavLinkTo} from "../../../../../../../../../helpers";

/**
 * Get trend percent
 *
 * @param {number} value Value
 * @param {number} previousValue Previous value
 * @return {number|null}
 */
const getTrendPercent = (value, previousValue) => {
    try {
        if (value === previousValue) {
            return 0;
        }

        if (previousValue === 0) {
            return value > 0 ? 100 : -100;
        }

        return ((value - previousValue) / previousValue) * 100;
    } catch (e) {
        handleError(e);
        return null;
    }
};

export default function Card({card, isSelected, onClick, loading, navigate}) {
    const handleConversionsLogsClick = (e) => {
        e.stopPropagation();
        navigate(getNavLinkTo('chatbot', 'chats'));
    }

    const trendPercent = getTrendPercent(card.current_period_total, card.previous_period_total);
    const trendDirection = trendPercent > 0 ? 'up' : trendPercent < 0 ? 'down' : null;
    const change = card.current_period_total - card.previous_period_total;

    const icon = card.type_group === 'actions' ? 'tab-actions' : ('dashboard-' + card.name);

    // Render loading skeleton
    if (loading) {
        return (
            <div className="lbaic-settings-dashboard-card lbaic-settings-dashboard-card--loading">
                <div className="lbaic-settings-dashboard-card-header">
                    <div className="lbaic-settings-dashboard-card-icon lbaic-settings-dashboard-card-shimmer"/>
                    <div className="lbaic-settings-dashboard-card-trend lbaic-settings-dashboard-card-shimmer"/>
                </div>
                <div className="lbaic-settings-dashboard-card-label lbaic-settings-dashboard-card-shimmer"/>
                <div className="lbaic-settings-dashboard-card-footer">
                    <div className="lbaic-settings-dashboard-card-values">
                        <div className="lbaic-settings-dashboard-card-value lbaic-settings-dashboard-card-shimmer"/>
                        <div className="lbaic-settings-dashboard-card-change lbaic-settings-dashboard-card-shimmer"/>
                    </div>
                    {/*<div className="lbaic-settings-dashboard-card-logs-btn lbaic-settings-dashboard-card-shimmer"/>*/}
                </div>
            </div>
        );
    }

    return (
        <div
            className={`lbaic-settings-dashboard-card selectable${isSelected ? ' lbaic-settings-dashboard-card--selected' : ''}`}
            onClick={onClick}
        >
            <div className="lbaic-settings-dashboard-card-header">
                <div
                    className={`lbaic-settings-dashboard-card-icon${isSelected ? ' lbaic-settings-dashboard-card-icon--selected' : ''}`}>
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <use href={`#lbaic-settings-${icon}`}/>
                    </svg>
                </div>
                {trendDirection && (
                    <div
                        className={`lbaic-settings-dashboard-card-trend lbaic-settings-dashboard-card-trend--${trendDirection}`}
                    >
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                            <use href={`#lbaic-settings-trending-${trendDirection}`}/>
                        </svg>
                        <span>{numberFormat(Math.abs(trendPercent), 2, true)}%</span>
                    </div>
                )}
            </div>
            <div className="lbaic-settings-dashboard-card-label">
                <span>{card.label}</span>
            </div>
            <div className="lbaic-settings-dashboard-card-footer">
                <div className="lbaic-settings-dashboard-card-values">
                    <div className="lbaic-settings-dashboard-card-value">{card.current_period_total}</div>
                    {change > 0 && (
                        <div
                            className={`lbaic-settings-dashboard-card-change lbaic-settings-dashboard-card-change--${change > 0 ? 'up' : 'down'}`}
                        >
                            <span>{change > 0 ? '+' : ''}{change}</span>
                        </div>
                    )}
                </div>
                {card.name === 'conversations' && (
                    <button
                        type="button"
                        className="lbaic-settings-dashboard-card-logs-btn"
                        onClick={handleConversionsLogsClick}
                    >
                        <span>{__("Logs", 'limb-chatbot')}</span>
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                            <use href="#lbaic-settings-arrow-right"/>
                        </svg>
                    </button>
                )}
            </div>
        </div>
    );
}