import {useEffect, useState} from "@wordpress/element";
import Container from "../../../../containers/content/container";
import LoadingBar from "../../../../../../fields/loading-bar";
import ChatsNav from "./components/chats-nav";
import ChatConversation from "./components/chat-conversation";
import ChatDetails from "./components/chat-details";
import Empty from "../../../../containers/content/empty";
import {__} from "@wordpress/i18n";

// Constants
const TAB_NAME = 'settings.chatbot.chats';

export default function Chats({notifications}) {
    const [loading, setLoading] = useState(0);
    const [selectedChat, setSelectedChat] = useState(null);
    const [detailsOpen, setDetailsOpen] = useState(false);
    const [activeTab, setActiveTab] = useState('nav'); // 'body', 'details'

    useEffect(() => {
        if (detailsOpen) {
            setActiveTab('details');
        } else if (selectedChat?.uuid) {
            setActiveTab('body');
        } else {
            setActiveTab('nav');
        }
    }, [selectedChat, detailsOpen]);

    return <>
        <Container className="lbaic-settings-chats-container">
            <div
                className={`lbaic-settings-chats-nav lbaic-settings-scroll-y${activeTab === 'nav' ? ' lbaic-settings-chats-active-tab' : ''}`}>
                <ChatsNav
                    chatbotUuid={null}
                    currentChatUuid={selectedChat?.uuid}
                    setSelectedChat={setSelectedChat}
                    setLoading={setLoading}
                    notifications={notifications}
                />
            </div>
            <div
                className={`lbaic-settings-chats-body${activeTab === 'body' ? ' lbaic-settings-chats-active-tab' : ''} lbaic-settings-scroll-color`}>
                {
                    selectedChat?.uuid ? (
                        <>
                            <div className="lbaic-settings-chats-details-toggler">
                                <button
                                    type='button'
                                    className={`lbaic-settings-chats-column lbaic-settings-chats-action lbaic-settings-chats-details-button lbaic-settings-chats-details-button-left`}
                                    onClick={() => setActiveTab('nav')}>
                                    <svg className='lbaic-settings-chats-action-i lbaic-settings-chats-action-i-fill'
                                         xmlns='http://www.w3.org/2000/svg' fill='none'
                                         viewBox='0 0 24 24'>
                                        <use href='#lbaic-settings-arrow'/>
                                    </svg>
                                </button>
                                {Boolean(selectedChat?.uuid) && (
                                    <button
                                        type='button'
                                        className={`lbaic-settings-chats-column lbaic-settings-chats-action lbaic-settings-chats-details-button lbaic-settings-chats-details-button-right ${detailsOpen ? 'right' : ''}`}
                                        onClick={() => setDetailsOpen((prev) => !prev)}>
                                        <svg
                                            className='lbaic-settings-chats-action-i lbaic-settings-chats-action-i-fill'
                                            xmlns='http://www.w3.org/2000/svg' fill='none'
                                            viewBox='0 0 24 24'>
                                            <use href='#lbaic-settings-arrow'/>
                                        </svg>
                                    </button>
                                )}
                            </div>
                            <div className='lbaic-settings-chats-column lbaic-settings-chats-h-full'>
                                <ChatConversation
                                    key={selectedChat.uuid}
                                    chat={selectedChat}
                                    setDetailsOpen={setDetailsOpen}
                                    loading={loading}
                                    setLoading={setLoading}
                                    notifications={notifications}
                                /></div>
                        </>

                    ) : (
                        <Empty title={__("Select a chat", 'limb-chatbot')}
                               className="lbaic-settings-chats-column lbaic-settings-chats-h-full"
                               subtitle={__("Choose a chat from the nav to start viewing the conversation.", 'limb-chatbot')}
                               icon="empty-qas-active"/>
                    )
                }
            </div>
            <div
                className={`lbaic-settings-chats-details${activeTab === 'details' ? ' lbaic-settings-chats-active-tab' : ''}`}
                style={{
                    "--lbaic-settings-chats-details-width": detailsOpen ? "265px" : ""
                }}
            >
                {selectedChat?.uuid && (
                    <ChatDetails
                        chat={selectedChat}
                        setIsOpen={setDetailsOpen}
                    />
                )}
            </div>
        </Container>
        {loading > 0 && (
            <LoadingBar/>
        )}
    </>
}