import {__} from "@wordpress/i18n";
import {handleError} from "../../../../../../../../helpers/notifications";

/**
 * Get chat user name letters
 *
 * @param {string} name Name
 * @return {*}
 */
export const getChatUserNameLetters = (name) => {
    try {
        const parts = name.split(" ");
        return (parts[0]?.[0] || '') + (parts[1]?.[0] || parts[0]?.[1] || '');
    } catch (e) {
        handleError(e);
    }

    return __("N/A", 'limb-chatbot');
}

/**
 * Get chat user name
 *
 * @param {object} user User
 * @return {{name: string, letters: string}}
 */
export const getChatUserInfo = (user) => {
    const data = {
        name: __("N/A", 'limb-chatbot'),
        letters: __("N/A", 'limb-chatbot'),
    };
    try {
        if (user) {
            if (user.wp_user_id) {
                // WP user
                data.name = user.name;
                data.letters = getChatUserNameLetters(user.name);
            } else {
                // Guest user
                if (user.name) {
                    data.name = user.name;
                    data.letters = getChatUserNameLetters(user.name);
                } else {
                    data.name = __("Guest", 'limb-chatbot');
                    data.letters = data.name[0] + data.name[1];
                }
            }
        }
    } catch (e) {
        handleError(e);
    }

    return data;
}