import {__} from "@wordpress/i18n";
import Tooltip from "../../../../../../../../fields/tooltip";
import {getChatUserInfo} from "../../helpers";
import {getFormatedDate} from "../../../../../../../../../../helpers";

export default function UserInfo({user, onClose}) {
    // Name/letters
    const userInfo = getChatUserInfo(user);
    // ID
    let userIdInfo = __("ID", 'limb-chatbot') + ': ' + user?.id || __("N/A", 'limb-chatbot');
    if (user?.wp_user_id) {
        userIdInfo = __("WP", 'limb-chatbot') + ' ' + userIdInfo;
    }

    return (
        <div className="lbaic-settings-container">
            <div className="lbaic-settings-chats-column lbaic-settings-chats-column-gap-10.5 lbaic-settings-chats-column-jc-sb lbaic-settings-chats-mb-7">
                <div className="lbaic-settings-chats-row">
                    <div className='lbaic-settings-chats-avatar'>
                        <div className='lbaic-settings-chats-avatar-in'>
                            <span className='lbaic-settings-chats-avatar-off'>{userInfo.letters}</span>
                        </div>
                    </div>
                    <div className='lbaic-settings-chats-mb-7'>
                        <Tooltip
                            contentClassName='lbaic-settings-chats-tooltip-content'
                            copyText={userInfo.name}
                        >
                            <div className='lbaic-settings-chats-column lbaic-settings-chats-column-gap-10.5 lbaic-settings-chats-column-jc-sb'>
                                <div className='lbaic-settings-chats-row'>
                                    <span className='lbaic-settings-chats-row-in'>{userInfo.name}</span>
                                </div>
                            </div>
                        </Tooltip>
                        <p className="lbaic-settings-chats-desc lbaic-settings-chats-text-break">{userIdInfo}</p>
                    </div>
                </div>
                <button
                    type="button"
                    className="lbaic-settings-chats-column lbaic-settings-chats-action lbaic-settings-chats-action-close"
                    onClick={onClose}
                >
                    <svg className="lbaic-settings-chats-action-i lbaic-settings-chats-action-i-fill"
                         xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <use href="#lbaic-settings-close"></use>
                    </svg>
                </button>
            </div>
            {/*IP address*/}
            {Boolean(user?.ip) && (
                <div className="lbaic-settings-chats-column lbaic-settings-chats-column-gap-3.5 lbaic-settings-chats-last-changes-in lbaic-settings-chats-mb-7">
                    <Tooltip
                        contentClassName='lbaic-settings-chats-tooltip-content'
                        copyText={user.ip}
                    >
                        <div
                            className='lbaic-settings-chats-column lbaic-settings-chats-column-gap-3.5 lbaic-settings-chats-last-changes-in lbaic-settings-chats-mb-7'>
                            <svg className='lbaic-settings-chats-action-i lbaic-settings-chats-action-i-fill'
                                 xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 24 24'>
                                <use href='#lbaic-settings-people'/>
                            </svg>
                            <span
                                className='lbaic-settings-chats-desc'>{__('IP Address', 'limb-chatbot')}: {user.ip}</span>
                        </div>
                    </Tooltip>
                </div>
            )}
            {/*Email*/}
            {Boolean(user?.email) && (
                <div className="lbaic-settings-chats-column lbaic-settings-chats-column-gap-3.5 lbaic-settings-chats-last-changes-in lbaic-settings-chats-mb-7">
                    <Tooltip
                        contentClassName='lbaic-settings-chats-tooltip-content'
                        copyText={user.email}
                    >
                        <div
                            className='lbaic-settings-chats-column lbaic-settings-chats-column-gap-3.5 lbaic-settings-chats-last-changes-in lbaic-settings-chats-mb-7'>
                            <svg className='lbaic-settings-chats-action-i lbaic-settings-chats-action-i-stroke'
                                 xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 24 24'>
                                <use href='#lbaic-settings-letter'/>
                            </svg>
                            <span className='lbaic-settings-chats-desc'>{__('Email', 'limb-chatbot')}: {user.email}</span>
                        </div>
                    </Tooltip>
                </div>
            )}
            {/*Location*/}
            {/*<div
                className="lbaic-settings-chats-column lbaic-settings-chats-column-gap-3.5 lbaic-settings-chats-last-changes-in lbaic-settings-chats-mb-7">
                <svg className='lbaic-settings-chats-action-i lbaic-settings-chats-action-i-stroke'
                     xmlns='http://www.w3.org/2000/svg' fill='none'
                     viewBox='0 0 24 24'>
                    <use href='#lbaic-settings-location'/>
                </svg>
                <span className='lbaic-settings-chats-desc'>San Francisco, CA</span>
            </div>*/}
            <div
                className="lbaic-settings-chats-column lbaic-settings-chats-column-gap-3.5 lbaic-settings-chats-last-changes-in lbaic-settings-chats-mb-7">
                <svg className='lbaic-settings-chats-action-i lbaic-settings-chats-action-i-stroke'
                     xmlns='http://www.w3.org/2000/svg' fill='none'
                     viewBox='0 0 24 24'>
                    <use href='#lbaic-settings-callendar'/>
                </svg>
                <span className='lbaic-settings-chats-desc'>{__('Joined', 'limb-chatbot')} {getFormatedDate(user?.created_at, 'MMM, YYYY')}</span>
            </div>
        </div>
    );
}
