import {__} from "@wordpress/i18n";
import Badge from "../../../../../../../../fields/badge";
import Tooltip from "../../../../../../../../fields/tooltip";

export default function TicketItem({ticket}) {
    return (
        <div className={`lbaic-settings-chats-card lbaic-settings-chats-card-ticket lbaic-settings-chats-mb-7 ${ticket.status}`}>
            <div className="lbaic-settings-chats-card-in">
                <div
                    className="lbaic-settings-chats-column lbaic-settings-chats-column-gap-10.5 lbaic-settings-chats-column-jc-sb lbaic-settings-chats-column-ai-start lbaic-settings-chats-mb-7">
                    <div className="lbaic-settings-chats-row lbaic-settings-chats-row-ai-start">
                        <svg
                            className="lbaic-settings-chats-action-i lbaic-settings-chats-action-i-fill lbaic-settings-chats-action-i-stroke-none lbaic-settings-chats-card-header-i"
                            xmlns="http://www.w3.org/2000/svg"
                            fill="none"
                            viewBox="0 0 24 24">
                            <use href='#lbaic-settings-chats-functionality'/>
                        </svg>
                        <div className='lbaic-settings-chats-mb-7'>
                            <div
                                className='lbaic-settings-chats-column lbaic-settings-chats-column-gap-10.5 lbaic-settings-chats-column-jc-sb'>
                                <div className='lbaic-settings-chats-row'>
                                    <span className='lbaic-settings-chats-desc no-viewed'>{ticket.title}</span>
                                </div>
                            </div>
                            <p className="lbaic-settings-chats-desc lbaic-settings-chats-text-break">#{ticket.id}</p>
                        </div>
                    </div>
                    <Tooltip label={__('Open in Trello', 'limb-chatbot')}
                             contentClassName='lbaic-settings-chats-tooltip-content'>
                        <button type="button" className="lbaic-settings-chats-column lbaic-settings-chats-action">
                            <svg
                                className="lbaic-settings-chats-action-i lbaic-settings-chats-action-i-fill lbaic-settings-chats-action-i-stroke-none lbaic-settings-chats-card-header-i"
                                xmlns="http://www.w3.org/2000/svg"
                                fill="none"
                                viewBox="0 0 24 24">
                                <use href='#lbaic-settings-chats-external-link'/>
                            </svg>
                        </button>
                    </Tooltip>
                </div>
                <div className="lbaic-settings-chats-column lbaic-settings-chats-column-jc-sb">
                    <Badge label={ticket.status}/>
                    <div
                        className='lbaic-settings-chats-column lbaic-settings-chats-column-gap-3.5 lbaic-settings-chats-last-changes-in'>
                        <svg className='lbaic-settings-chats-action-i lbaic-settings-chats-action-i-stroke'
                             xmlns='http://www.w3.org/2000/svg' fill='none'
                             viewBox='0 0 24 24'>
                            <use href='#lbaic-settings-time'/>
                        </svg>
                        <span className='lbaic-settings-chats-desc'>{ticket.date}</span>
                    </div>
                </div>
            </div>
        </div>
    );
}
