import {__} from "@wordpress/i18n";
import PopupContainer from "../../../../../../../../../popups/container";
import {useId} from "@wordpress/element";

export default function FilterChatsPopup({
                                             onClose,
                                             startDate,
                                             endDate,
                                             setStartDate,
                                             setEndDate,
                                             onApplyFilters
                                         }) {
    const fieldsId = useId();

    const fromFieldId = 'from-' + fieldsId;
    const toFieldId = 'to-' + fieldsId;

    return (
        <PopupContainer
            close={onClose}
            title={__('Filter chats by date', 'limb-chatbot')}
            footer={
                <>

                    <button
                        type='button'
                        className='lbaic-settings-button lbaic-settings-button-center lbaic-settings-button-h-40 lbaic-settings-button-primary'
                        onClick={() => onApplyFilters(startDate, endDate)}
                    >
                        <span className='lbaic-settings-button-label'>{__("Apply", 'limb-chatbot')}</span>
                    </button>
                    <button
                        type='button'
                        className='lbaic-settings-button lbaic-settings-button-center lbaic-settings-button-h-40 lbaic-settings-button-secondary'
                        onClick={() => onApplyFilters('', '')}
                    >
                        <span className='lbaic-settings-button-label'>{__("Close", 'limb-chatbot')}</span>
                    </button>
                </>
            }
        >
            <div className="lbaic-settings-column lbaic-settings-column-gap-10">
                <div className="lbaic-settings-column-in">
                    <div className='lbaic-settings-calendar-placeholder'>
                        <label htmlFor={fromFieldId}
                               className='lbaic-settings-calendar-placeholder-in'>{__("From", "limb-chatbot")}</label>
                    </div>
                    <div className="lbaic-settings-calendar">
                        <div className="lbaic-settings-calendar-in">
                            <div className="lbaic-settings-calendar-input lbaic-settings-input-h-42">
                                <input
                                    id={fromFieldId}
                                    type="date"
                                    className="lbaic-settings-calendar-input-in"
                                    value={startDate}
                                    onChange={(e) => setStartDate(e.target.value)}
                                />
                            </div>
                        </div>
                    </div>
                </div>
                <div className="lbaic-settings-column-in">
                    <div className='lbaic-settings-calendar-placeholder'>
                        <label htmlFor={toFieldId}
                               className='lbaic-settings-calendar-placeholder-in'>{__("To", "limb-chatbot")}</label>
                    </div>
                    <div className="lbaic-settings-calendar">
                        <div className="lbaic-settings-calendar-in">
                            <div className="lbaic-settings-calendar-input lbaic-settings-input-h-42">
                                <input
                                    id={toFieldId}
                                    type="date"
                                    className="lbaic-settings-calendar-input-in"
                                    value={endDate}
                                    onChange={(e) => setEndDate(e.target.value)}
                                />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </PopupContainer>
    );
}
