import {__} from "@wordpress/i18n";
import Accordion from "../accordion";
import TicketItem from "../ticket-item";

export default function ConnectedTickets() {
    // Sample tickets data - in real app this would come from props or API
    const tickets = [
        {
            id: 2,
            title: __("Feature request: Export functionality", 'limb-chatbot'),
            status: "pending",
            date: "2024-01-10"
        },
        {
            id: 2,
            title: __("UI improvement suggestions", 'limb-chatbot'),
            status: "open",
            date: "2024-01-10"
        },
        {
            id: 2,
            title: __("Bug report: Search functionality", 'limb-chatbot'),
            status: "closed",
            date: "2024-01-10"
        },
        {
            id: 2,
            title: __("Export functionality", 'limb-chatbot'),
            status: "open",
            date: "2024-01-10"
        },
        {
            id: 2,
            title: __("Export functionality", 'limb-chatbot'),
            status: "pending",
            date: "2024-01-10"
        }
    ];

    return (
        <Accordion
            title={__('Connected Tickets', 'limb-chatbot')}
            icon="#lbaic-settings-ticket"
        >
            {tickets.map((ticket, index) => (
                <TicketItem key={index} ticket={ticket}/>
            ))}
        </Accordion>
    );
}
