import {__} from "@wordpress/i18n";
import Tooltip from "../../../../../../../../../../fields/tooltip";

const SelectedChatsActions = ({selectedChats, setSelectedChats, deleteChats}) => {
    return (
        <div className="lbaic-settings-container lbaic-settings-chats-mb-7">
            <div className="lbaic-settings-chats-column lbaic-settings-chats-column-gap-10.5 lbaic-settings-chats-column-jc-sb">
                <div className="lbaic-settings-chats-column">
                    <Tooltip contentClassName='lbaic-settings-chats-tooltip-content'
                             label={__('Clear selected', 'limb-chatbot')}>
                        <button
                            type="button"
                            className="lbaic-settings-chats-column lbaic-settings-chats-column-jc-center lbaic-settings-chats-action"
                            onClick={() => setSelectedChats([])}
                        >
                            <svg className="lbaic-settings-chats-action-i lbaic-settings-chats-action-i-fill"
                                 xmlns="http://www.w3.org/2000/svg"
                                 fill="none"
                                 viewBox="0 0 24 24">
                                <use href="#lbaic-settings-close"></use>
                            </svg>
                        </button>
                    </Tooltip>
                    <p className="lbaic-settings-chats-desc">{`${selectedChats.length} selected`}</p>
                </div>
                <div className="lbaic-settings-chats-nav-header-actions">
                    <Tooltip contentClassName='lbaic-settings-chats-tooltip-content'
                             label={__('Delete selected', 'limb-chatbot')}>
                        <button
                            type="button"
                            className="lbaic-settings-chats-column lbaic-settings-chats-column-jc-center lbaic-settings-chats-action"
                            onClick={() => deleteChats([...selectedChats])}>
                            <svg className="lbaic-settings-chats-action-i lbaic-settings-chats-action-i-fill"
                                 xmlns="http://www.w3.org/2000/svg"
                                 fill="none"
                                 viewBox="0 0 24 24">
                                <use href="#lbaic-settings-delete"></use>
                            </svg>
                        </button>
                    </Tooltip>
                </div>
            </div>
        </div>
    );
};

export default SelectedChatsActions;
