import {__} from "@wordpress/i18n";

export default function ChatsSearch({value, onChange}) {
    return (
        <div className='lbaic-settings-chats-nav-search'>
            <div className="lbaic-settings-search">
                <svg className="lbaic-settings-search-i lbaic-settings-chats-action-i lbaic-settings-chats-action-i-fill"
                     xmlns="http://www.w3.org/2000/svg"
                     fill="none"
                     viewBox="0 0 24 24">
                    <use href="#lbaic-settings-search"></use>
                </svg>
                <input
                    placeholder={__("Search chats", 'limb-chatbot') + "..."}
                    className="lbaic-settings-search-input lbaic-settings-input-reset"
                    value={value}
                    onChange={e => onChange(e.target.value)}
                    autoComplete="off"
                />
            </div>
        </div>
    );
};
