import {__, sprintf} from "@wordpress/i18n";
import Tooltip from "../../../../../../../../../../fields/tooltip";
import KebabMenu from "../../../../../../../../../../button/kebab-menu";

export default function ChatsNavHeader({chats, chatsPagination, setShowFilterPopup, refresh, sortNewestFirst, sortOldestFirst}) {
    return (
        <div className="lbaic-settings-container lbaic-settings-chats-mb-7">
            <div className="lbaic-settings-chats-column lbaic-settings-chats-column-gap-10.5 lbaic-settings-chats-column-jc-sb">
                <p className="lbaic-settings-chats-desc">{sprintf(__("%d / %d chats", 'limb-chatbot'), chats.length, chatsPagination.total)}</p>
                <div className="lbaic-settings-chats-nav-header-actions">
                    <Tooltip
                        label={__("Sort chats", 'limb-chatbot')}
                        contentClassName='lbaic-settings-chats-tooltip-content'
                    >
                        <KebabMenu
                            actions={[
                                {
                                    label: __("Newest First", 'limb-chatbot'),
                                    onClick: sortNewestFirst
                                },
                                {
                                    label: __("Oldest First", 'limb-chatbot'),
                                    onClick: sortOldestFirst
                                },
                            ]}
                            className='lbaic-settings-chats'
                            itemClass='lbaic-settings-chats-column lbaic-settings-chats-column-jc-center lbaic-settings-chats-action'
                            iconClass='lbaic-settings-chats-action-i lbaic-settings-chats-action-i-fill'
                            icon='sortable'
                        />
                    </Tooltip>
                    <Tooltip
                        label={__("Filter chats", 'limb-chatbot')}
                        contentClassName='lbaic-settings-chats-tooltip-content'
                    >
                        <button
                            type="button"
                            className="lbaic-settings-chats-column lbaic-settings-chats-column-jc-center lbaic-settings-chats-action"
                            onClick={() => setShowFilterPopup(true)}
                        >
                            <svg className="lbaic-settings-chats-action-i lbaic-settings-chats-action-i-fill"
                                 xmlns="http://www.w3.org/2000/svg"
                                 fill="none"
                                 viewBox="0 0 24 24">
                                <use href="#lbaic-settings-filter"></use>
                            </svg>
                        </button>
                    </Tooltip>
                    <Tooltip
                        label={__("Refresh chat list", 'limb-chatbot')}
                        contentClassName='lbaic-settings-chats-tooltip-content'
                    >
                        <button
                            type="button"
                            className="lbaic-settings-chats-column lbaic-settings-chats-column-jc-center lbaic-settings-chats-action"
                            onClick={refresh}
                        >
                            <svg className="lbaic-settings-chats-action-i lbaic-settings-chats-action-i-fill"
                                 xmlns="http://www.w3.org/2000/svg"
                                 fill="none"
                                 viewBox="0 0 24 24">
                                <use href="#lbaic-settings-refresh-chat"></use>
                            </svg>
                        </button>
                    </Tooltip>
                    {/*<Tooltip
                        label={__("Export chat logs", 'limb-chatbot')}
                        contentClassName='lbaic-settings-chats-tooltip-content'
                    >
                        <KebabMenu
                            actions={[
                                {
                                    label: __("Export JSON", 'limb-chatbot'),
                                    icon: 'export-json',

                                },
                                {
                                    label: __("Export PDF", 'limb-chatbot'),
                                    icon: 'export-pdf',
                                },
                            ]}
                            className='lbaic-settings-chats'
                            itemClass='lbaic-settings-chats-column lbaic-settings-chats-column-jc-center lbaic-settings-chats-action'
                            iconClass='lbaic-settings-chats-action-i lbaic-settings-chats-action-i-fill'
                            icon='export-chat'
                        />
                    </Tooltip>*/}
                </div>
            </div>
        </div>
    );
};
