import ChatItem from "../chat-item";

const ChatList = ({chats, currentChatUuid, selectedChats, toggleChat, onSelect, markAsUnread, deleteChats, chatsNavRef, sentinelRef}) => {
    return (
        <div className='lbaic-settings-chats-nav-body-in lbaic-settings-scroll-y lbaic-settings-scroll-style' ref={chatsNavRef}>
            {chats.map((chat, index) => (
                <ChatItem
                    key={index}
                    chat={chat}
                    isOpened={currentChatUuid === chat.uuid}
                    selectedChats={selectedChats}
                    toggleChat={toggleChat}
                    onSelect={onSelect}
                    markAsUnread={markAsUnread}
                    deleteChats={deleteChats}
                />
            ))}
            <div ref={sentinelRef} style={{height: '1px', width: '100%', visibility: 'hidden'}}/>
        </div>
    );
};

export default ChatList;
