import {__} from "@wordpress/i18n";
import {prepareChatbotMessage} from "../../../../../../../../../../../../helpers";
import Checkbox from "../../../../../../../../../../fields/checkbox";
import KebabMenu from "../../../../../../../../../../button/kebab-menu";
import RealTimeRelativeTime from "../../../../../../../../../../fields/real-time-relative-time";
import {getChatUserInfo} from "../../../../helpers";

const ChatItem = ({chat, isOpened, selectedChats, toggleChat, onSelect, markAsUnread, deleteChats}) => {
    // User info
    const userInfo = getChatUserInfo(chat?.user);
    // Last message content
    let lastMessageContent;
    if (chat.messages?.length > 0) {
        const lastMessageObj = chat.messages[chat.messages.length - 1];
        lastMessageContent = lastMessageObj.content?.length > 0 ? lastMessageObj.content[lastMessageObj.content.length - 1] : null;
    }

    const isAdminRead = +(chat.metas?.find(item => item.meta_key === 'admin_read')?.meta_value || 0) === 1;

    const handleClick = (e) => {
        if (
            e.target.closest('.lbaic-settings-kebab-menu')
            || e.target.closest('.lbaic-settings-checkbox')
        ) {
            return;
        }
        onSelect(chat);
    }

    return (
        <div
            className={`lbaic-settings-chats-column lbaic-settings-chats-column-jc-sb lbaic-settings-chats-column-gap-10.5 lbaic-settings-chats-user lbaic-settings-pointer${selectedChats.includes(chat.uuid) ? ' active' : ''}${isOpened ? ' selected' : ''}`}
            onClick={handleClick}
        >
            <div className='lbaic-settings-chats-avatar'>
                <div className='lbaic-settings-chats-avatar-in'>
                    <span className='lbaic-settings-chats-avatar-off'>{userInfo.letters}</span>
                    {!isAdminRead && <div className="lbaic-settings-chats-avatar-badge"/>}
                </div>
                <div className="lbaic-settings-chats-selected">
                    <Checkbox
                        iconClassName='lbaic-settings-chats-checkbox-i'
                        isChecked={selectedChats.includes(chat.uuid)}
                        toggleValue={() => toggleChat(chat.uuid)}
                    />
                </div>
            </div>
            <div className='lbaic-settings-container lbaic-settings-chats-user-in lbaic-settings-chats-mb-7'>
                <div className='lbaic-settings-chats-user-name lbaic-settings-chats-column lbaic-settings-chats-column-gap-10.5 lbaic-settings-chats-column-jc-sb'>
                    <div className='lbaic-settings-chats-row'>
                        <span className='lbaic-settings-chats-row-in'>{userInfo.name}</span>
                        <div className="lbaic-settings-chats-user-chat-title-icon">
                            <svg
                                className='lbaic-settings-chats-action-i lbaic-settings-chats-action-i-stroke lbaic-settings-chats-user-chat-title-i'
                                xmlns='http://www.w3.org/2000/svg' fill='none'
                                viewBox='0 0 24 24'>
                                <use href='#lbaic-settings-people'/>
                            </svg>
                        </div>
                    </div>

                    <KebabMenu
                        actions={[
                            // {
                            //     label: __("Mark as Read", 'limb-chatbot'),
                            //     icon: 'mark-read',
                            // },
                            {
                                label: __("Mark as unread", 'limb-chatbot'),
                                icon: 'mark-unread',
                                onClick: () => markAsUnread(chat),
                                closeOnClick: true,
                            },
                            // {
                            //     label: __("Block User", 'limb-chatbot'),
                            //     icon: 'block',
                            // },
                            {
                                label: __("Delete Chat", 'limb-chatbot'),
                                icon: 'delete',
                                className: 'delete',
                                onClick: () => deleteChats([chat.uuid]),
                                closeOnClick: true,
                            },
                        ]}
                        itemClass='lbaic-settings-chats-action'
                        iconClass='lbaic-settings-chats-action-i lbaic-settings-chats-action-i-fill'
                        icon='more'
                    />
                </div>
                {Boolean(lastMessageContent) && (
                    // Text
                    lastMessageContent.type === 'text' && (
                        <p className={`lbaic-settings-chats-desc lbaic-settings-chats-user-desc lbaic-settings-chats-text-break lbaic-settings-chats-mb-3.5${!isAdminRead ? ' no-viewed' : ''}`}
                           dangerouslySetInnerHTML={{__html: prepareChatbotMessage(lastMessageContent[lastMessageContent.type].value)}}></p>
                    )
                )}
                <div className="lbaic-settings-chats-column lbaic-settings-chats-column-jc-sb lbaic-settings-chats-last-changes">
                    <div className="lbaic-settings-chats-column lbaic-settings-chats-column-gap-3.5 lbaic-settings-chats-last-changes-in">
                        <svg className='lbaic-settings-chats-action-i lbaic-settings-chats-action-i-stroke'
                             xmlns='http://www.w3.org/2000/svg' fill='none'
                             viewBox='0 0 24 24'>
                            <use href='#lbaic-settings-time'/>
                        </svg>
                        <RealTimeRelativeTime
                            dateString={chat.updated_at}
                            className='lbaic-settings-chats-desc'
                            tooltipProps={{
                                contentClassName: 'lbaic-settings-chats-tooltip-content',
                            }}
                            showTooltip={false}
                        />
                    </div>
                    <div className="lbaic-settings-chats-column lbaic-settings-chats-column-gap-3.5 lbaic-settings-chats-last-changes-in">
                        <svg className='lbaic-settings-chats-action-i lbaic-settings-chats-action-i-stroke'
                             xmlns='http://www.w3.org/2000/svg' fill='none'
                             viewBox='0 0 24 24'>
                            <use href='#lbaic-settings-comment'/>
                        </svg>
                        <span className='lbaic-settings-chats-desc'>{chat?.messages_count || 0}</span>
                    </div>
                </div>
            </div>
        </div>
    );
};

export default ChatItem;
