import {__} from "@wordpress/i18n";
import Accordion from "../accordion";
import {formatNumber} from "../../../../../../../../../../helpers";
import Tooltip from "../../../../../../../../fields/tooltip";

export default function ChatStats({chat}) {
    // const confidence = formatNumber((chat?.conversation_state?.confidence || 0) * 100);

    return (
        <Accordion
            title={__('Chat details', 'limb-chatbot')}
            icon="#lbaic-settings-join-chat"
            defaultOpen
        >
            {/*UUID*/}
            {Boolean(chat?.uuid) && (
                <div
                    className='lbaic-settings-chats-column lbaic-settings-chats-column-gap-10.5 lbaic-settings-chats-column-jc-sb lbaic-settings-chats-mb-10.5'>
                    <p className="lbaic-settings-chats-desc lbaic-settings-chats-text-break">{__('ID', 'limb-chatbot')}</p>
                    <Tooltip
                        contentClassName='lbaic-settings-chats-tooltip-content'
                        copyText={chat.uuid}
                    >
                        <p className="lbaic-settings-chats-desc lbaic-settings-chats-text-break">{chat.uuid}</p>
                    </Tooltip>
                </div>
            )}
            {/*Total messages*/}
            <div
                className='lbaic-settings-chats-column lbaic-settings-chats-column-gap-10.5 lbaic-settings-chats-column-jc-sb lbaic-settings-chats-mb-10.5'>
                <p className="lbaic-settings-chats-desc lbaic-settings-chats-text-break">{__('Total messages', 'limb-chatbot')}</p>
                <p className="lbaic-settings-chats-desc lbaic-settings-chats-text-break">{chat?.messages_count || 0}</p>
            </div>
            {/*Token usage*/}
            {/*<div className="lbaic-settings-chats-details-nested-in lbaic-settings-chats-mb-10.5">
                <div
                    className="lbaic-settings-chats-column lbaic-settings-chats-column-jc-sb lbaic-settings-chats-column-gap-3.5 lbaic-settings-chats-mb-7 lbaic-settings-pointer">
                    <p className="lbaic-settings-chats-desc lbaic-settings-chats-text-break">{__('Token Usage', 'limb-chatbot')}</p>
                    <p className="lbaic-settings-chats-desc lbaic-settings-chats-text-break">8,750 / 10,000</p>
                </div>
                <div className="lbaic-settings-progress" aria-label='progress' aria-busy='true'
                     style={{
                         '--lbaic-settings-progress-fill-width': '10%'
                     }}>
                    <div className="lbaic-settings-progress-bar"></div>
                </div>
                <div
                    className="lbaic-settings-chats-column lbaic-settings-chats-column-jc-sb lbaic-settings-chats-column-gap-3.5 lbaic-settings-chats-mb-7 lbaic-settings-pointer">
                    <p className="lbaic-settings-chats-desc lbaic-settings-chats-text-break">{sprintf(__('%d%% used', 'limb-chatbot'), 88)}</p>
                </div>
            </div>*/}
            {/*AI confidence*/}
            {/*<div
                className="lbaic-settings-chats-column lbaic-settings-chats-column-jc-sb lbaic-settings-chats-column-gap-3.5 lbaic-settings-chats-mb-10.5 lbaic-settings-pointer">
                <p className="lbaic-settings-chats-desc lbaic-settings-chats-text-break">{__('AI confidence', 'limb-chatbot')}</p>
                <button
                    type="button"
                    className="lbaic-settings-chats-column lbaic-settings-chats-column lbaic-settings-chats-column-gap-5.25 lbaic-settings-chats-action lbaic-settings-chats-message-actions-in">
                    <span className='lbaic-settings-chats-desc lbaic-settings-chats-details-badge'>{confidence}%</span>
                </button>
            </div>*/}
            {/*Knowledge sources*/}
            {/*<div
                className="lbaic-settings-chats-column lbaic-settings-chats-column-jc-sb lbaic-settings-chats-column-gap-3.5 lbaic-settings-chats-mb-7 lbaic-settings-pointer">
                <p className="lbaic-settings-chats-desc lbaic-settings-chats-text-break">{__('Knowledge Sources', 'limb-chatbot')}</p>
                <button
                    type="button"
                    className="lbaic-settings-chats-column lbaic-settings-chats-column lbaic-settings-chats-column-gap-5.25 lbaic-settings-chats-action lbaic-settings-chats-message-actions-in">
                    <span className='lbaic-settings-chats-desc'>8</span>
                </button>
            </div>*/}
        </Accordion>
    );
}
