import {useState} from "@wordpress/element";
import {__} from "@wordpress/i18n";
import Input from "../../../../../../../../../../fields/input";
import Emoji from "../../../../../../../../../../button/emoji";

export default function Footer() {
    const [joined, setJoined] = useState(false);
    const [message, setMessage] = useState('');

    const sendButtonDisabled = !message.trim().length;

    const handleSendMessage = () => {
        console.log("send message: ", message)
    }

    return (
        <div className="lbaic-settings-chats-content-footer">
            <div className="lbaic-settings-chats-content-footer-in">
                <div className="lbaic-settings-chats-input">
                    {joined ? (
                        <div className="lbaic-settings-chats-input-in">
                            <Input
                                value={message}
                                setValue={setMessage}
                                staticPlaceholder={__("Type your message...", 'limb-chatbot')}
                            />
                            <Emoji chosen={obj => setMessage(prev => prev + obj.emoji)}/>

                            <button
                                type="button"
                                className="lbaic-settings-chats-column lbaic-settings-chats-action lbaic-settings-chats-add-file"
                            >
                                <svg className="lbaic-settings-chats-action-i lbaic-settings-chats-action-i-fill"
                                     xmlns="http://www.w3.org/2000/svg"
                                     fill="none"
                                     viewBox="0 0 24 24">
                                    <use href="#lbaic-settings-add-file"></use>
                                </svg>
                            </button>
                            <button
                                type="button"
                                className={`lbaic-settings-chats-column lbaic-settings-chats-action lbaic-settings-chats-send-message${sendButtonDisabled ? ' lbaic-settings-disabled' : ''}`}
                                onClick={handleSendMessage}
                            >
                                <svg className="lbaic-settings-chats-action-i lbaic-settings-chats-action-i-fill"
                                     xmlns="http://www.w3.org/2000/svg"
                                     fill="none"
                                     viewBox="0 0 24 24">
                                    <use href="#lbaic-settings-send-message"></use>
                                </svg>
                            </button>
                        </div>
                    ) : (
                        <div className="lbaic-settings-chats-column lbaic-settings-chats-column-jc-sb lbaic-settings-chats-input-join">
                            <div className="lbaic-settings-chats-column lbaic-settings-chats-column-gap-3.5 lbaic-settings-pointer">
                                <div className='lbaic-settings-chats-avatar'>
                                    <div className='lbaic-settings-chats-avatar-in'>
                                        <svg className="lbaic-settings-chats-action-i lbaic-settings-chats-action-i-fill"
                                             xmlns="http://www.w3.org/2000/svg"
                                             fill="none"
                                             viewBox="0 0 24 24">
                                            <use href="#lbaic-settings-join-chat"></use>
                                        </svg>
                                    </div>
                                </div>
                                <div className='lbaic-settings-container lbaic-settings-chats-mb-7'>
                                    <div
                                        className='lbaic-settings-chats-column lbaic-settings-chats-column-gap-10.5 lbaic-settings-chats-column-jc-sb'>
                                        <div className='lbaic-settings-chats-row'>
                                            <span
                                                className='lbaic-settings-chats-title'>{__('Join Conversation', 'limb-chatbot')}</span>
                                        </div>
                                    </div>
                                    <p className="lbaic-settings-chats-desc lbaic-settings-chats-text-break">{__('Take over this chat to provide personalized support', 'limb-chatbot')}</p>
                                </div>
                            </div>
                            <button
                                type="button"
                                className='lbaic-settings-button lbaic-settings-button-center lbaic-settings-button-primary'
                                onClick={() => setJoined(true)}
                            >
                                <span>{__('Join', 'limb-chatbot')}</span>
                            </button>
                        </div>
                    )}
                </div>
            </div>
        </div>
    );
}