import {useState} from "@wordpress/element";

export default function Accordion({
    title,
    icon,
    children,
    className = "",
    contentClassName = "",
    defaultOpen = false
}) {
    const [isOpen, setIsOpen] = useState(defaultOpen);

    const handleToggleButtonClick = (e) => {
        e.stopPropagation();
        setIsOpen(prev => !prev);
    }

    return (
        <div className={`lbaic-settings-chats-details-container${isOpen ? ' active' : ''} ${className}`}>
            <div
                className="lbaic-settings-chats-column lbaic-settings-chats-column-gap-10.5 lbaic-settings-chats-mb-10.5 lbaic-settings-chats-column-jc-sb lbaic-settings-pointer"
                onClick={() => setIsOpen((prev) => !prev)}
            >
                <div className='lbaic-settings-chats-row'>
                    <div className='lbaic-settings-chats-column lbaic-settings-chats-column-gap-10.5 lbaic-settings-chats-column-jc-sb'>
                        <div className='lbaic-settings-chats-row lbaic-settings-chats-details-title'>
                            {icon && (
                                <svg className="lbaic-settings-chats-action-i lbaic-settings-chats-action-i-fill"
                                     xmlns="http://www.w3.org/2000/svg"
                                     fill="none"
                                     viewBox="0 0 24 24">
                                    <use href={icon}></use>
                                </svg>
                            )}
                            <span className='lbaic-settings-chats-row-in'>{title}</span>
                        </div>
                    </div>
                </div>
                <button
                    type="button"
                    className="lbaic-settings-chats-column lbaic-settings-chats-action lbaic-settings-chats-details-action"
                    onClick={handleToggleButtonClick}
                >
                    <svg className="lbaic-settings-chats-details-arrow lbaic-settings-chats-action-i lbaic-settings-chats-action-i-fill"
                         xmlns="http://www.w3.org/2000/svg"
                         fill="none"
                         viewBox="0 0 24 24">
                        <use href="#lbaic-settings-arrow"></use>
                    </svg>
                </button>
            </div>
            <div className={`lbaic-settings-chats-details-nested ${contentClassName}`} style={{
                '--lbaic-settings-display-block': isOpen ? 'block' : ''
            }}>
                {children}
            </div>
        </div>
    );
}
