import {forwardRef, useEffect, useImperativeHandle, useRef, useState} from "@wordpress/element";
import {__} from "@wordpress/i18n";
import Utility from "../../../_components/utility";
import Model from "../../../../../../../fields/specific-fields/model";
import Config from "../../../../../../../fields/specific-fields/config";

const FineTuning = forwardRef(({slug, active, toggle, loading, setLoading, hasUnsavedChanges, setHasUnsavedChanges, notifications}, ref) => {
    const utilityRef = useRef(null);
    // Actions states
    const [isDataReady, setIsDataReady] = useState(false);
    const [isDataFetched, setIsDataFetched] = useState(false);
    const [isConfigsFetched, setIsConfigsFetched] = useState(false);
    const [isModelsFetched, setIsModelsFetched] = useState(false);
    // Settings
    const settings = {
        'ai_model_id': useState(''),
        'config_id': useState(''),
    };
    const settingsDefault = {
        'ai_provider_id': useState(''),
    };

    useImperativeHandle(ref, () => ({
        saved: () => {
            utilityRef.current.saved();
        },
        discard: () => {
            utilityRef.current.discard();
        }
    }));

    useEffect(() => {
        setIsDataReady(isDataFetched && isConfigsFetched && isModelsFetched);
    }, [isDataFetched, isConfigsFetched, isModelsFetched]);

    return <Utility ref={utilityRef}
                    title={__("Fine-tuning", 'limb-chatbot')}
                    slug={slug}
                    active={active}
                    toggle={toggle}
                    aiProviderId="open-ai"
                    settings={settings}
                    settingsDefault={settingsDefault}
                    dataFetched={() => setIsDataFetched(true)}
                    isDataReady={isDataReady}
                    setLoading={setLoading}
                    setHasUnsavedChanges={setHasUnsavedChanges}
                    notifications={notifications}>
        <div className="lbaic-settings-column">
            <div className="lbaic-settings-column-in">
                <Model aiProviderId="open-ai"
                       isAIProviderRequired={true}
                       isDataFetched={isDataFetched}
                       modelId={settings['ai_model_id'][0]}
                       setModelId={settings['ai_model_id'][1]}
                       endpoints={['fine_tuning']}
                       setFetched={setIsModelsFetched}
                       setLoading={setLoading}
                       notifications={notifications}/>
            </div>
            <div className="lbaic-settings-column-in">
                <Config aiProviderId="open-ai"
                        isDataFetched={isDataFetched}
                        configId={settings['config_id'][0]}
                        setConfigId={settings['config_id'][1]}
                        setFetched={setIsConfigsFetched}
                        setLoading={setLoading}
                        notifications={notifications}/>
            </div>
        </div>
    </Utility>
});

export default FineTuning;