import {forwardRef, useEffect, useImperativeHandle, useRef, useState} from "@wordpress/element";
import {__} from "@wordpress/i18n";
import Model from "../../../../../../../fields/specific-fields/model";
import Config from "../../../../../../../fields/specific-fields/config";
import Utility from "../../../_components/utility";

const Chatbot = forwardRef(({slug, active, toggle, loading, setLoading, hasUnsavedChanges, setHasUnsavedChanges, notifications}, ref) => {
    const utilityRef = useRef(null);
    // Actions states
    const [isDataReady, setIsDataReady] = useState(false);
    const [isDataFetched, setIsDataFetched] = useState(false);
    const [aiProviderModelsFetched, setAIProviderModelsFetched] = useState(false);
    const [aiProviderConfigsFetched, setAIProviderConfigsFetched] = useState(false);
    // Settings
    const settings = {
        'ai_model_id': useState(''),
        'config_id': useState(''),
    };
    const settingsDefault = {
        'ai_provider_id': useState(''),
    };

    useImperativeHandle(ref, () => ({
        saved: () => {
            utilityRef.current.saved();
        },
        discard: () => {
            utilityRef.current.discard();
        }
    }));

    useEffect(() => {
        setIsDataReady(isDataFetched && aiProviderModelsFetched && aiProviderConfigsFetched);
    }, [isDataFetched, aiProviderModelsFetched, aiProviderConfigsFetched]);

    return <Utility ref={utilityRef}
                    title={__("Chatbot", 'limb-chatbot')}
                    slug={slug}
                    active={active}
                    toggle={toggle}
                    aiProviderId="open-ai"
                    settings={settings}
                    settingsDefault={settingsDefault}
                    dataFetched={() => setIsDataFetched(true)}
                    isDataReady={isDataReady}
                    setLoading={setLoading}
                    setHasUnsavedChanges={setHasUnsavedChanges}
                    notifications={notifications}>
        <div className="lbaic-settings-column">
            <div className="lbaic-settings-column-in">
                <Model aiProviderId="open-ai"
                       isAIProviderRequired={true}
                       isDataFetched={isDataFetched}
                       modelId={settings['ai_model_id'][0]}
                       setModelId={settings['ai_model_id'][1]}
                       endpoints={[/*'assistants',*/ 'chat_completions']}
                       setFetched={setAIProviderModelsFetched}
                       setLoading={setLoading}
                       notifications={notifications}/>
            </div>
            <div className="lbaic-settings-column-in">
                <Config aiProviderId="open-ai"
                        isDataFetched={isDataFetched}
                        configId={settings['config_id'][0]}
                        setConfigId={settings['config_id'][1]}
                        setFetched={setAIProviderConfigsFetched}
                        setLoading={setLoading}
                        notifications={notifications}/>
            </div>
        </div>
    </Utility>
});

export default Chatbot;