import {useMemo} from "@wordpress/element";
import {__} from "@wordpress/i18n";

/**
 * Calculate available variables for insert variable menu
 * Includes parameters
 *
 * @param {object} callback Current callback
 * @param {array} allParameters All action parameters
 * @param {array} allCallbacks All action callbacks
 * @param {string} filterType Optional parameter type filter (e.g., 'email')
 * @return {object} Variables object with parameters
 */
export const useAvailableVariables = (callback, allParameters = [], allCallbacks = [], filterType = null) => {
    return useMemo(() => {
        let filteredParameters = allParameters.filter(param => param.name && String(param.name).trim());

        // Filter by type if specified
        if (filterType) {
            filteredParameters = filteredParameters.filter(param => param.type === filterType);
        }

        return {
            parameters: {
                label: __('Parameters', 'limb-chatbot'),
                items: filteredParameters.map(param => ({
                    label: param.label || param.name,
                    value: `{${param.name}}`
                })),
            },
        };
    }, [callback?.id, callback?.order, allParameters, allCallbacks, filterType]);
};