/**
 * Generate a name from a label
 * Converts label to lowercase, replaces spaces and special characters with underscores
 *
 * @param {string} label Label text
 * @returns {string} Generated name
 */
export const generateNameFromLabel = (label) => {
    if (!label || typeof label !== 'string') {
        return '';
    }

    // Trim the label
    let name = label.trim();

    // Convert to lowercase
    name = name.toLowerCase();

    // Replace spaces and special characters with underscores
    // Keep only alphanumeric characters and underscores
    name = name.replace(/[^a-z0-9_]+/g, '_');

    // Remove leading/trailing underscores
    name = name.replace(/^_+|_+$/g, '');

    // Remove consecutive underscores
    name = name.replace(/_+/g, '_');

    return name;
};