import {__} from "@wordpress/i18n";

/**
 * Parameter types configuration
 * This is the single source of truth for all parameter types
 */
export const PARAMETER_TYPES = [
    {
        type: 'text',
        value: 'text',
        label: __("Text", 'limb-chatbot'),
        icon: 'parameter-type-text',
        description: __("Short text input", 'limb-chatbot'),
    },
    {
        type: 'textarea',
        value: 'textarea',
        label: __("Textarea", 'limb-chatbot'),
        icon: 'parameter-type-textarea',
        description: __("Long text input", 'limb-chatbot'),
    },
    {
        type: 'email',
        value: 'email',
        label: __("Email", 'limb-chatbot'),
        icon: 'parameter-type-email',
        description: __("Email address", 'limb-chatbot'),
    },
    {
        type: 'url',
        value: 'url',
        label: __("URL", 'limb-chatbot'),
        icon: 'parameter-type-url',
        description: __("Web address", 'limb-chatbot'),
    },
    {
        type: 'buttons',
        value: 'buttons',
        label: __("Choices", 'limb-chatbot'),
        icon: 'parameter-type-buttons',
        description: __("Button selection", 'limb-chatbot'),
    },
    {
        type: 'vector_search',
        value: 'vector_search',
        label: __("Recommendations", 'limb-chatbot'),
        icon: 'parameter-type-vector_search',
        description: __("Vector search recommendations", 'limb-chatbot'),
    },
];

/**
 * Get parameter types formatted for popup selection (uses 'type' property)
 * @return {Array} Parameter types for popup
 */
export const getParameterTypesForPopup = () => {
    return PARAMETER_TYPES.map(({type, label, icon, description, disabled, badge, integration}) => ({
        type,
        label,
        icon,
        description,
        disabled: disabled || false,
        badge: badge || null,
        integration: integration || null,
    }));
};

/**
 * Get parameter types formatted for dropdown (uses 'value' property)
 * @return {Array} Parameter types for dropdown
 */
export const getParameterTypesForDropdown = () => {
    return PARAMETER_TYPES.map(({value, label, icon, disabled, optionBadge}) => ({
        value,
        label,
        icon,
        disabled: disabled || false,
        badge: optionBadge || null,
    }));
};