import {__} from "@wordpress/i18n";
import SlackConfiguration from "./configuration";

export const SLACK_TABS = [
    {
        label: __("Configuration", 'limb-chatbot'),
        slug: 'configuration',
    },
];

const getPanels = (props) => {
    const {validationRef, ...restProps} = props;
    return {
        'configuration': <SlackConfiguration {...restProps} ref={validationRef} validationRef={validationRef}/>,
    };
};

const SlackTypeConfig = {
    tabs: SLACK_TABS,
    getPanels,
    defaultValues: () => ({
        name: 'slack',
    }),
};

export default SlackTypeConfig;