import {__} from "@wordpress/i18n";
import EmailConfiguration from "./configuration";

export const EMAIL_TABS = [
    {
        label: __("Configuration", 'limb-chatbot'),
        slug: 'configuration',
    },
];

const getPanels = (props) => {
    const {validationRef, ...restProps} = props;
    return {
        'configuration': <EmailConfiguration {...restProps} ref={validationRef} validationRef={validationRef}/>,
    };
};

const EmailTypeConfig = {
    tabs: EMAIL_TABS,
    getPanels,
    defaultValues: () => ({
        name: 'email',
    }),
};

export default EmailTypeConfig;