function Utilities() {
    return (
        <div className='lbaic-settings-utilities'>
            <svg
                xmlns='http://www.w3.org/2000/svg'
                fill='none'
                viewBox='0 0 24 24'
            >
                <symbol id="lbaic-settings-nav-chatbot" viewBox="0 0 24 24">
                    <path
                        fillRule="evenodd"
                        d="M18.115 5C19.432 5 20.5 6.044 20.5 7.331v8.297c0 1.207-.939 2.2-2.141 2.32l-.245.012H7.922L4.3 20.89l-.061.043a.49.49 0 0 1-.732-.337l-.006-.073V7.33c0-1.207.939-2.2 2.142-2.32L5.886 5zM5.886 6.5c-.522 0-.886.404-.886.831v8.297l.001.02v2.746l1.978-1.6.103-.077a1.5 1.5 0 0 1 .84-.257h10.192c.522 0 .886-.405.886-.832V7.33c0-.426-.364-.83-.886-.831z"
                        clipRule="evenodd"
                    ></path>
                    <path
                        d="M13.757 11.725a.75.75 0 1 1 0 1.5h-5.63a.75.75 0 0 1 0-1.5zM15.757 8.725a.75.75 0 1 1 0 1.5h-7.63a.75.75 0 0 1 0-1.5z"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-nav-open-ai" viewBox="0 0 24 24">
                    <path
                        d="M18.95 10.547a3.95 3.95 0 0 0-.349-3.273 4.07 4.07 0 0 0-1.88-1.674 4.14 4.14 0 0 0-2.52-.26 4.1 4.1 0 0 0-1.778-1.14 4.15 4.15 0 0 0-2.117-.113 4.1 4.1 0 0 0-1.892.947 4.04 4.04 0 0 0-1.158 1.752 4.1 4.1 0 0 0-1.562.68 4 4 0 0 0-1.14 1.254 3.99 3.99 0 0 0 .502 4.731 3.94 3.94 0 0 0 .345 3.274A4.07 4.07 0 0 0 7.283 18.4a4.14 4.14 0 0 0 2.521.259c.383.424.852.763 1.377.994.526.231 1.095.35 1.67.347.868 0 1.714-.271 2.415-.775a4.04 4.04 0 0 0 1.487-2.03 4.1 4.1 0 0 0 1.562-.679 4 4 0 0 0 1.14-1.253 3.99 3.99 0 0 0-.505-4.716m-6.098 8.406c-.71.001-1.399-.244-1.944-.693l.095-.054 3.23-1.839a.54.54 0 0 0 .265-.454v-4.491l1.366.778a.05.05 0 0 1 .025.035v3.722a2.98 2.98 0 0 1-.891 2.117c-.57.561-1.341.877-2.146.88m-6.53-2.75a2.95 2.95 0 0 1-.361-2.01l.096.057 3.233 1.84a.53.53 0 0 0 .527 0l3.95-2.247v1.555a.05.05 0 0 1-.023.041l-3.271 1.86a3.08 3.08 0 0 1-2.306.299 3.04 3.04 0 0 1-1.845-1.395m-.851-6.94c.36-.61.926-1.075 1.599-1.315v3.785a.51.51 0 0 0 .262.451l3.93 2.237-1.365.778a.06.06 0 0 1-.048 0l-3.264-1.857a3 3 0 0 1-1.415-1.82 2.97 2.97 0 0 1 .3-2.274zm11.218 2.57-3.943-2.257 1.362-.776a.05.05 0 0 1 .048 0l3.265 1.86c.5.284.907.703 1.174 1.206a2.96 2.96 0 0 1-.27 3.2c-.349.454-.82.8-1.361.998v-3.786a.52.52 0 0 0-.275-.444m1.358-2.015-.095-.056-3.227-1.855a.53.53 0 0 0-.53 0l-3.946 2.246V8.598a.05.05 0 0 1 .019-.04l3.264-1.859a3.08 3.08 0 0 1 3.258.14c.473.326.843.778 1.066 1.303.222.525.289 1.102.191 1.664zm-8.543 2.757L8.139 11.8a.05.05 0 0 1-.026-.038V8.05a2.97 2.97 0 0 1 .477-1.607c.31-.48.752-.863 1.275-1.104a3.08 3.08 0 0 1 3.233.409l-.096.053-3.23 1.839a.54.54 0 0 0-.265.454zM10.246 11l1.758-1 1.762 1v1.999l-1.755 1-1.762-1z"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-nav-new-open-ai" viewBox="0 0 24 24">
                    <path
                        fillRule="evenodd"
                        d="M7.247 6.991A3.62 3.62 0 0 1 10.807 4c.92 0 1.76.344 2.397.911a4 4 0 0 0-.182.1L8.89 7.4a.36.36 0 0 0-.182.316l.024 5.35-1.538-.88V7.62q0-.322.054-.628m11.075-.026c.46.798.582 1.698.411 2.535a4 4 0 0 0-.178-.108l-4.133-2.39a.36.36 0 0 0-.364 0L9.443 9.7l-.008-1.774 3.95-2.284q.28-.161.57-.267a3.61 3.61 0 0 1 4.367 1.591m-8.863 6.52-.013-2.946 2.541-1.485 2.554 1.462.013 2.945-2.54 1.485zm7.892-2.199-4.64-2.655 1.53-.894 3.951 2.285q.279.161.517.36a3.624 3.624 0 0 1-1.18 6.207q.005-.103.005-.208v-4.78c0-.13-.07-.25-.183-.315m-2.058 4.997-.024-5.35 1.538.88v4.568q0 .322-.054.628A3.62 3.62 0 0 1 13.193 20c-.92 0-1.76-.344-2.397-.911q.092-.048.182-.1l4.133-2.39a.36.36 0 0 0 .182-.316m-5.35.714 4.615-2.696.008 1.774-3.951 2.284a3.613 3.613 0 0 1-4.937-1.325 3.6 3.6 0 0 1-.41-2.534q.086.057.176.108l4.134 2.39a.36.36 0 0 0 .364 0M6.65 12.714l4.639 2.655-1.53.894-3.951-2.284a3.624 3.624 0 0 1 .664-6.568 4 4 0 0 0-.005.208v4.78c0 .13.07.25.183.315"
                        clipRule="evenodd"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-nav-gemini" viewBox="0 0 24 24">
                    <path
                        stroke="#232323"
                        fill="none"
                        d="M11.235 3.705A.75.75 0 0 1 11.984 3h.031c.397 0 .726.309.75.705a8.037 8.037 0 0 0 7.53 7.53.75.75 0 0 1 .705.749v.032a.75.75 0 0 1-.705.749 8.04 8.04 0 0 0-7.53 7.53.75.75 0 0 1-.75.705h-.03a.75.75 0 0 1-.75-.705 8.037 8.037 0 0 0-7.53-7.53.75.75 0 0 1-.705-.748v-.033a.75.75 0 0 1 .705-.749 8.04 8.04 0 0 0 7.53-7.53Z"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-nav-new-gemini" viewBox="0 0 24 24">
                    <path
                        d="M11.235 3.705A.75.75 0 0 1 11.984 3h.031c.397 0 .726.309.75.705a8.037 8.037 0 0 0 7.53 7.53.75.75 0 0 1 .705.749v.032a.75.75 0 0 1-.705.749 8.04 8.04 0 0 0-7.53 7.53.75.75 0 0 1-.75.705h-.03a.75.75 0 0 1-.75-.705 8.037 8.037 0 0 0-7.53-7.53.75.75 0 0 1-.705-.748v-.033a.75.75 0 0 1 .705-.749 8.04 8.04 0 0 0 7.53-7.53"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-nav-deepseek" viewBox="0 0 24 24">
                    <path
                        stroke="#232323"
                        fill="none"
                        d="M20.811 6.091c-.19-.092-.273.083-.384.172-.038.029-.07.066-.103.1-.279.292-.604.484-1.03.461-.621-.034-1.152.158-1.622.624-.1-.575-.43-.919-.935-1.14-.264-.114-.531-.228-.716-.478-.13-.177-.164-.375-.229-.57-.04-.117-.082-.237-.22-.257-.15-.023-.208.1-.267.203a2.65 2.65 0 0 0-.317 1.355c.02 1.056.476 1.898 1.379 2.497.103.069.13.137.097.238-.062.206-.135.406-.2.612-.04.132-.102.16-.246.104a4.2 4.2 0 0 1-1.303-.868c-.642-.61-1.223-1.283-1.947-1.81a9 9 0 0 0-.517-.347c-.739-.704.097-1.283.29-1.351.203-.072.071-.318-.583-.315s-1.252.217-2.015.504a2.3 2.3 0 0 1-.35.1 7.3 7.3 0 0 0-2.161-.074c-1.414.154-2.543.81-3.373 1.93-.998 1.346-1.232 2.875-.945 4.47.302 1.681 1.176 3.073 2.52 4.161 1.393 1.128 2.998 1.681 4.828 1.575 1.112-.063 2.35-.209 3.746-1.369.352.172.722.24 1.335.292.472.043.927-.023 1.279-.094.551-.115.513-.616.314-.707-1.617-.74-1.262-.439-1.584-.682.821-.954 2.059-1.945 2.543-5.155.038-.255.006-.415 0-.621-.003-.126.026-.175.173-.19a3.2 3.2 0 0 0 1.159-.349c1.047-.56 1.47-1.483 1.569-2.588.015-.17-.003-.344-.185-.433Zm-9.126 9.949c-1.566-1.209-2.326-1.607-2.64-1.59-.293.018-.24.347-.176.562.068.212.156.358.279.544.085.123.144.306-.085.444-.505.306-1.382-.103-1.423-.123-1.02-.59-1.874-1.37-2.475-2.435a7.3 7.3 0 0 1-.974-3.299c-.015-.283.07-.383.358-.435a3.6 3.6 0 0 1 1.146-.029c1.6.23 2.96.931 4.101 2.042.652.633 1.144 1.39 1.652 2.128.54.785 1.12 1.532 1.86 2.145.26.215.469.378.668.498-.601.066-1.604.08-2.29-.452Zm.751-4.74c0-.126.103-.226.232-.226q.044.001.08.014a.2.2 0 0 1 .084.055.22.22 0 0 1 .065.157.23.23 0 0 1-.232.226c-.129 0-.229-.1-.229-.226Zm2.332 1.174c-.15.06-.299.112-.443.118a.95.95 0 0 1-.598-.186c-.205-.17-.352-.264-.414-.559a1.3 1.3 0 0 1 .012-.432c.053-.24-.006-.395-.179-.536-.14-.114-.32-.146-.516-.146a.4.4 0 0 1-.19-.057c-.083-.04-.15-.14-.086-.264.02-.04.12-.137.144-.154.267-.15.575-.1.86.011.264.106.463.301.75.576.294.332.347.424.514.673.132.195.252.395.334.624.05.143-.014.26-.188.332Z"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-nav-new-deepseek" viewBox="0 0 24 24">
                    <path
                        d="M20.811 6.091c-.19-.092-.273.083-.384.172-.038.029-.07.066-.103.1-.279.292-.604.484-1.03.461-.621-.034-1.152.158-1.622.624-.1-.575-.43-.919-.935-1.14-.264-.114-.531-.228-.716-.478-.13-.177-.164-.375-.229-.57-.04-.117-.082-.237-.22-.257-.15-.023-.208.1-.267.203a2.65 2.65 0 0 0-.317 1.355c.02 1.056.476 1.898 1.379 2.497.103.069.13.137.097.238-.062.206-.135.406-.2.612-.04.132-.102.16-.246.104a4.2 4.2 0 0 1-1.303-.868c-.642-.61-1.223-1.283-1.947-1.81a9 9 0 0 0-.517-.347c-.739-.704.097-1.283.29-1.351.203-.072.071-.318-.583-.315s-1.252.217-2.015.504a2.3 2.3 0 0 1-.35.1 7.3 7.3 0 0 0-2.161-.074c-1.414.154-2.543.81-3.373 1.93-.998 1.346-1.232 2.875-.945 4.47.302 1.681 1.176 3.073 2.52 4.161 1.393 1.128 2.998 1.681 4.828 1.575 1.112-.063 2.35-.209 3.746-1.369.352.172.722.24 1.335.292.472.043.927-.023 1.279-.094.551-.115.513-.616.314-.707-1.617-.74-1.262-.439-1.584-.682.821-.954 2.059-1.945 2.543-5.155.038-.255.006-.415 0-.621-.003-.126.026-.175.173-.19a3.2 3.2 0 0 0 1.159-.349c1.047-.56 1.47-1.483 1.569-2.588.015-.17-.003-.344-.185-.433m-9.126 9.949c-1.566-1.209-2.326-1.607-2.64-1.59-.293.018-.24.347-.176.562.068.212.156.358.279.544.085.123.144.306-.085.444-.505.306-1.382-.103-1.423-.123-1.02-.59-1.874-1.37-2.475-2.435a7.3 7.3 0 0 1-.974-3.299c-.015-.283.07-.383.358-.435a3.6 3.6 0 0 1 1.146-.029c1.6.23 2.96.931 4.101 2.042.652.633 1.144 1.39 1.652 2.128.54.785 1.12 1.532 1.86 2.145.26.215.469.378.668.498-.601.066-1.604.08-2.29-.452m.751-4.74c0-.126.103-.226.232-.226q.044.001.08.014a.2.2 0 0 1 .084.055.22.22 0 0 1 .065.157.23.23 0 0 1-.232.226c-.129 0-.229-.1-.229-.226m2.332 1.174c-.15.06-.299.112-.443.118a.95.95 0 0 1-.598-.186c-.205-.17-.352-.264-.414-.559a1.3 1.3 0 0 1 .012-.432c.053-.24-.006-.395-.179-.536-.14-.114-.32-.146-.516-.146a.4.4 0 0 1-.19-.057c-.083-.04-.15-.14-.086-.264.02-.04.12-.137.144-.154.267-.15.575-.1.86.011.264.106.463.301.75.576.294.332.347.424.514.673.132.195.252.395.334.624.05.143-.014.26-.188.332"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-nav-training" viewBox="0 0 24 24">
                    <path
                        d="M3.5 17.111V9.894q0-.627.462-1.047a1.4 1.4 0 0 1 1.09-.37q1.956.3 3.714 1.162A14 14 0 0 1 12 11.84a14 14 0 0 1 3.234-2.2 12.8 12.8 0 0 1 3.714-1.162q.63-.05 1.09.37.462.42.462 1.047v7.217q0 .598-.395 1.026a1.47 1.47 0 0 1-.994.478q-1.676.26-3.181.83a13 13 0 0 0-2.882 1.54 1.7 1.7 0 0 1-.497.274 1.7 1.7 0 0 1-.552.089q-.291 0-.551-.089a1.7 1.7 0 0 1-.496-.275 13 13 0 0 0-2.877-1.539q-1.5-.57-3.186-.83a1.47 1.47 0 0 1-.994-.478 1.46 1.46 0 0 1-.395-1.026m8.5 2.77a14.8 14.8 0 0 1 3.35-1.87q1.775-.705 3.65-.93V9.988a11.8 11.8 0 0 0-3.665 1.289q-1.771.963-3.335 2.527-1.563-1.564-3.335-2.527A11.8 11.8 0 0 0 5 9.988v7.093q1.875.225 3.65.93a14.8 14.8 0 0 1 3.35 1.87m0-11.093q-1.491 0-2.553-1.062T8.385 5.173 9.447 2.62 12 1.558t2.553 1.062 1.062 2.553-1.062 2.553T12 8.788m0-1.5q.873 0 1.494-.621.621-.622.622-1.494 0-.873-.622-1.494A2.04 2.04 0 0 0 12 3.058q-.873 0-1.494.621a2.04 2.04 0 0 0-.622 1.494q0 .873.622 1.494.621.621 1.494.621"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-nav-new-training" viewBox="0 0 24 24">
                    <path
                        d="M3.5 17.111V9.894q0-.627.462-1.047.463-.42 1.09-.37 1.956.3 3.714 1.162A14 14 0 0 1 12 11.84a14 14 0 0 1 3.234-2.2 12.8 12.8 0 0 1 3.714-1.162q.627-.05 1.09.37.462.42.462 1.047v7.217q0 .598-.395 1.026a1.47 1.47 0 0 1-.994.478q-1.676.26-3.181.83a13 13 0 0 0-2.882 1.54 1.7 1.7 0 0 1-.496.274 1.7 1.7 0 0 1-.552.089 1.7 1.7 0 0 1-.552-.089 1.7 1.7 0 0 1-.496-.275 13 13 0 0 0-2.877-1.539q-1.5-.57-3.186-.83a1.47 1.47 0 0 1-.994-.478 1.46 1.46 0 0 1-.395-1.026M12 8.788q-1.497 0-2.556-1.06a3.48 3.48 0 0 1-1.06-2.555q0-1.496 1.06-2.556A3.48 3.48 0 0 1 12 1.557q1.497 0 2.556 1.06a3.48 3.48 0 0 1 1.06 2.556q0 1.496-1.06 2.556A3.48 3.48 0 0 1 12 8.789"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-nav-knowledge" viewBox="0 0 24 24">
                    <path
                        stroke="currentColor"
                        fill="none"
                        d="M17.246 15.192q0 .232-.087.438l-.068.136c-.1.172-.242.31-.435.416l-4.066 2.175-.006.003a1.063 1.063 0 0 1-.669.13l-.133-.024a1 1 0 0 1-.13-.043l-.13-.063-.006-.003-4.067-2.175a1.1 1.1 0 0 1-.351-.292l-.083-.124a1.1 1.1 0 0 1-.157-.574v-2.227l4.186 2.245v-.001a2.08 2.08 0 0 0 2.016 0l.002.001 4.184-2.245zM12.053 4.5q.07 0 .137.009l.133.025q.065.017.13.043l.131.063.004.002 7.747 4.19.016.008a.3.3 0 0 1 .062.042l.043.055c.03.05.044.1.044.16v5.158c0 .1-.029.162-.086.219a.3.3 0 0 1-.228.086.3.3 0 0 1-.227-.086.28.28 0 0 1-.086-.22v-5.59l-.737.396-6.548 3.526-.004.002a1.08 1.08 0 0 1-.934.061l-.129-.061-.003-.002-6.873-3.707a.4.4 0 0 1-.082-.057l-.025-.031a.45.45 0 0 1-.027-.278l.027-.077a.1.1 0 0 1 .024-.03l.083-.057 6.873-3.707.003-.002q.066-.036.13-.063l.131-.043q.13-.034.27-.034Z"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-nav-new-knowledge" viewBox="0 0 24 24">
                    <path
                        stroke="currentColor"
                        d="M17.246 15.192q0 .232-.087.438l-.068.136c-.1.172-.242.31-.435.416l-4.066 2.175-.006.003a1.063 1.063 0 0 1-.669.13l-.133-.024a1 1 0 0 1-.13-.043l-.13-.063-.006-.003-4.067-2.175a1.1 1.1 0 0 1-.351-.292l-.083-.124a1.1 1.1 0 0 1-.157-.574v-2.227l4.186 2.245v-.001a2.08 2.08 0 0 0 2.016 0l.002.001 4.184-2.245zM12.053 4.5q.07 0 .137.009l.133.025q.065.017.13.043l.131.063.004.002 7.747 4.19.016.008a.3.3 0 0 1 .062.042l.043.055c.03.05.044.1.044.16v5.158c0 .1-.029.162-.086.219a.3.3 0 0 1-.228.086.3.3 0 0 1-.227-.086.28.28 0 0 1-.086-.22v-5.59l-.737.396-6.548 3.526-.004.002a1.08 1.08 0 0 1-.934.061l-.129-.061-.003-.002-6.873-3.707a.4.4 0 0 1-.082-.057l-.025-.031a.45.45 0 0 1-.027-.278l.027-.077a.1.1 0 0 1 .024-.03l.083-.057 6.873-3.707.003-.002q.066-.036.13-.063l.131-.043q.13-.034.27-.034Z"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-nav-advanced" viewBox="0 0 24 24">
                    <path
                        d="m14.286 4.438.496-.063zm.234 1.86.496-.061zm.31.419-.223.447zm.224.122.26-.427zm.224.143.277-.416zm.492.052.193.461zm1.748-.734-.194-.461zm.627.21.432-.25zm1.789 3.09.432-.25zm-.131.65-.302-.399zm-1.518 1.15.302.398zm-.018 1.427-.303.398zm1.515 1.149-.302.398zm.131.648-.433-.25zm-1.788 3.089.433.25zm-.628.21-.195.46zm-1.726-.732.194-.46zm-.494.05-.272-.42v.001zm-.234.145.252.432zm-.224.12-.226-.445zm-.299.411.497.062zm-.234 1.87.496.063zm-4.076.438v.5zm-.496-.438-.496.062zm-.233-1.861.497-.062zm-.311-.417-.223.447zm-.223-.123-.26.427zm-.224-.144-.277.416zm-.492-.052-.193-.46zm-1.749.735.194.46zm-.626-.21-.432.25zm-1.789-3.091.433-.25zm.131-.648.302.398zm1.518-1.15-.302-.399zm0-1.427.302-.398zM4.198 10.25l.302-.399zm-.13-.65.432.251zm1.788-3.09-.432-.25zm.626-.21.194-.461zm1.75.734-.194.461zm.49-.05.273.419zm.236-.145-.252-.432zm.223-.121-.226-.446zm.3-.41.496.062zm.233-1.87-.496-.063zM10.21 4v-.5zM12 10.112v-.5zm-2 2h-.5zm2 2v.5zm2-2h.5zM13.79 4v.5l.496-.062.496-.063a1 1 0 0 0-.992-.875zm.496.438-.496.062.233 1.861.497-.062.496-.062-.234-1.862zm.234 1.86-.497.063c.047.373.292.658.584.803l.223-.447.223-.448a.1.1 0 0 1-.033-.026l-.004-.006zm.31.419-.223.447q.103.051.187.102l.26-.427.26-.427a4 4 0 0 0-.261-.143zm.224.122-.26.427q.102.063.207.133l.277-.417.277-.416a7 7 0 0 0-.241-.154zm.224.143-.277.417c.276.183.636.233.962.096l-.193-.46-.194-.462h-.003a.04.04 0 0 1-.018-.007zm.492.052.193.461 1.748-.734-.193-.461-.194-.461-1.748.734zm1.748-.734.193.46v.001l.434-.25.432-.25a1 1 0 0 0-1.253-.422zm.627.21-.433.251 1.789 3.09.433-.25.432-.251-1.789-3.09zm1.789 3.09-.433.251.302.399.302.399a1 1 0 0 0 .261-1.299zm-.131.65-.302-.399-1.518 1.15.302.398.302.399 1.518-1.15zm-1.518 1.15-.302-.4c-.289.22-.397.553-.397.839h1q.002-.035.008-.046c.002-.006.001-.001-.007.005zm-.2.439h-.5v.547h1v-.547zm0 .547h-.5c0 .237.066.602.38.84l.302-.399.302-.398q.015.013.023.023l.003.005-.006-.024-.003-.047zm.182.441-.302.399 1.515 1.148.302-.398.302-.399-1.515-1.148zm1.515 1.149-.302.398.433.25.433.25a1 1 0 0 0-.262-1.297zm.131.648-.433-.25-1.788 3.088.433.25.433.251 1.788-3.089zm-1.788 3.089-.433-.25-.195.46-.195.46a1 1 0 0 0 1.256-.42zm-.628.21.195-.46-1.726-.732-.195.46-.196.46 1.727.732zm-1.726-.732.194-.46a1.03 1.03 0 0 0-.96.09l.272.42.273.42a.1.1 0 0 1 .022-.009h.003zm-.494.05-.272-.419q-.106.068-.214.132l.252.432.252.432q.13-.076.255-.158zm-.234.145-.252-.432q-.096.055-.198.107l.226.446.226.446a5 5 0 0 0 .25-.135zm-.224.12-.226-.445a1.04 1.04 0 0 0-.569.794l.497.062.496.062.003-.006a.1.1 0 0 1 .026-.02zm-.299.411-.496-.062-.234 1.87.496.062.496.062.235-1.87zm-.234 1.87-.496-.062v1a1 1 0 0 0 .992-.876zm-.496.438v-.5h-3.58v1h3.58zm-3.58 0v-.5l-.496.062-.496.062a1 1 0 0 0 .992.876zm-.496-.438.496-.062-.232-1.861-.497.062-.496.062.233 1.861zm-.233-1.861.497-.062a1.05 1.05 0 0 0-.585-.803l-.223.448-.223.447a.1.1 0 0 1 .035.027l.003.005zm-.311-.417.223-.448a3 3 0 0 1-.186-.102l-.26.427-.26.427q.125.076.26.143zm-.223-.123.26-.427A6 6 0 0 1 9 16.826l-.276.416-.277.416q.117.078.241.155zm-.224-.144L9 16.826a1.02 1.02 0 0 0-.962-.097l.193.461.194.461h.003q.006.001.018.008zm-.492-.052-.193-.46-1.75.734.194.46.194.462 1.749-.735zm-1.749.735-.193-.461-.433.25-.432.252a1 1 0 0 0 1.252.42zm-.626-.21.433-.25L4.5 14.373l-.433.25-.432.25 1.789 3.091zm-1.789-3.091.433-.25-.302-.398-.302-.4a1 1 0 0 0-.261 1.298zm.131-.648.302.398 1.518-1.15-.302-.398-.302-.398-1.518 1.149zm1.518-1.15.302.399c.29-.22.397-.555.397-.84h-1q-.002.036-.008.048c-.003.006-.002.001.007-.005zm.199-.44h.5v-.547h-1v.547zm0-.547h.5c0-.286-.108-.62-.397-.838l-.302.398-.302.399c-.009-.006-.01-.011-.007-.005a.1.1 0 0 1 .008.046zm-.2-.44.303-.398L4.5 9.85l-.302.399-.302.399 1.518 1.149zM4.199 10.25l.302-.399-.433-.25-.432-.251a1 1 0 0 0 .261 1.299zm-.13-.65.432.251 1.79-3.09-.434-.25-.432-.25-1.79 3.089zm1.788-3.09.433.251.193-.461.194-.461a1 1 0 0 0-1.252.421zm.626-.21-.193.46 1.749.735.193-.46.194-.462-1.749-.734zm1.75.734-.194.461c.327.138.684.085.957-.092l-.272-.42-.273-.419a.1.1 0 0 1-.022.009h-.003zm.49-.05.273.418q.103-.066.215-.131l-.252-.432-.252-.432q-.128.075-.256.157zm.236-.145.252.432q.097-.057.197-.107l-.226-.446-.226-.446a5 5 0 0 0-.249.135zm.223-.121.226.446c.29-.147.524-.432.57-.794l-.497-.062-.496-.062q.002-.003-.003.005a.1.1 0 0 1-.026.02zm.3-.41.496.062.233-1.87-.496-.062-.496-.062-.234 1.87zm.233-1.87.496.062v-1a1 1 0 0 0-.992.875zM10.21 4v.5h3.58v-1h-3.58zM12 10.112v-.5a2.5 2.5 0 0 0-2.5 2.5h1a1.5 1.5 0 0 1 1.5-1.5zm-2 2h-.5a2.5 2.5 0 0 0 2.5 2.5v-1a1.5 1.5 0 0 1-1.5-1.5zm2 2v.5a2.5 2.5 0 0 0 2.5-2.5h-1a1.5 1.5 0 0 1-1.5 1.5zm2-2h.5a2.5 2.5 0 0 0-2.5-2.5v1a1.5 1.5 0 0 1 1.5 1.5z"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-nav-integrations" viewBox="0 0 24 24">
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="M4 14a1 1 0 0 1-.78-1.63l9.9-10.2a.5.5 0 0 1 .86.46l-1.92 6.02A1 1 0 0 0 13 10h7a1 1 0 0 1 .78 1.63l-9.9 10.2a.5.5 0 0 1-.86-.46l1.92-6.02A1 1 0 0 0 11 14z"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-nav-new-integrations" viewBox="0 0 24 24">
                    <path
                        d="M4 14a1 1 0 0 1-.78-1.63l9.9-10.2a.5.5 0 0 1 .86.46l-1.92 6.02A1 1 0 0 0 13 10h7a1 1 0 0 1 .78 1.63l-9.9 10.2a.5.5 0 0 1-.86-.46l1.92-6.02A1 1 0 0 0 11 14z"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-parameter-type-text" viewBox="0 0 24 24">
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="M12 4v16M4 7V5a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v2M9 20h6"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-parameter-type-textarea" viewBox="0 0 24 24">
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="M15 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7Z"
                    ></path>
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="M14 2v4a2 2 0 0 0 2 2h4"
                    ></path>
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="M10 9H8"
                    ></path>
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="M16 13H8"
                    ></path>
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="M16 17H8"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-parameter-type-email" viewBox="0 0 24 24">
                    <circle
                        cx="12"
                        cy="12"
                        r="4"
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                    ></circle>
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="M16 8v5a3 3 0 0 0 6 0v-1a10 10 0 1 0-4 8"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-parameter-type-url" viewBox="0 0 24 24">
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="M10 13a5 5 0 0 0 7.54.54l3-3a5 5 0 0 0-7.07-7.07l-1.72 1.71M14 11a5 5 0 0 0-7.54-.54l-3 3a5 5 0 0 0 7.07 7.07l1.71-1.71"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-parameter-type-buttons" viewBox="0 0 24 24">
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="M14 4.1 12 6"
                    ></path>
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="m5.1 8-2.9-.8"
                    ></path>
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="m6 12-1.9 2"
                    ></path>
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="M7.2 2.2 8 5.1"
                    ></path>
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="M9.037 9.69a.498.498 0 0 1 .653-.653l11 4.5a.5.5 0 0 1-.074.949l-4.349 1.041a1 1 0 0 0-.74.739l-1.04 4.35a.5.5 0 0 1-.95.074z"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-parameter-type-vector_search" viewBox="0 0 24 24">
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="M15 14c.2-1 .7-1.7 1.5-2.5 1-.9 1.5-2.2 1.5-3.5A6 6 0 0 0 6 8c0 1 .2 2.2 1.5 3.5.7.7 1.3 1.5 1.5 2.5"
                    ></path>
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="M9 18h6"
                    ></path>
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="M10 22h4"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-callback-type-email" viewBox="0 0 24 24">
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="m22 7-8.991 5.727a2 2 0 0 1-2.009 0L2 7"
                    ></path>
                    <rect
                        x="2"
                        y="4"
                        width="20"
                        height="16"
                        rx="2"
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                    ></rect>
                </symbol>
                <symbol id="lbaic-settings-callback-type-slack-notification" viewBox="0 0 24 24">
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="M10.268 21a2 2 0 0 0 3.464 0"
                    ></path>
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="M3.262 15.326A1 1 0 0 0 4 17h16a1 1 0 0 0 .74-1.673C19.41 13.956 18 12.499 18 8A6 6 0 0 0 6 8c0 4.499-1.411 5.956-2.738 7.326"
                    ></path>
                </symbol>

                <symbol viewBox='0 0 24 24' id='lbaic-settings-general'>
                    <path
                        d='M20.244 12.34a.8.8 0 0 0-.103-.29l-3.474-5.9-.001-.003a.8.8 0 0 0-.292-.293.8.8 0 0 0-.41-.104H9.036a.8.8 0 0 0-.41.104h.001a.8.8 0 0 0-.292.293l-.001.002-3.474 5.9a.75.75 0 0 0 0 .776l3.474 5.9.001.002.062.092q.096.126.23.201h-.001c.12.069.252.105.41.105h6.93a.8.8 0 0 0 .409-.105l.085-.055a.8.8 0 0 0 .207-.238l.001-.001 3.474-5.9a.75.75 0 0 0 .109-.389zm-5.304.098c0-1.262-.96-2.3-2.19-2.425L12.501 10a2.438 2.438 0 1 0 0 4.875l.249-.013a2.44 2.44 0 0 0 2.19-2.424m1.5 0a3.94 3.94 0 0 1-3.736 3.932l-.203.005a3.938 3.938 0 1 1 0-7.875l.203.005a3.94 3.94 0 0 1 3.735 3.932m5.31 0c0 .409-.11.795-.315 1.147l-.001.002-3.474 5.9c-.206.35-.488.634-.842.836a2.3 2.3 0 0 1-1.153.302h-6.93a2.3 2.3 0 0 1-1.152-.302h-.001a2.3 2.3 0 0 1-.842-.836l-3.474-5.9v-.002a2.25 2.25 0 0 1 0-2.295v-.002l3.474-5.9c.206-.35.488-.634.842-.836l.135-.072c.317-.154.66-.23 1.018-.23h6.93c.409 0 .798.1 1.152.302h.001l.13.08c.293.194.532.45.712.756l3.474 5.9v.002l.073.134c.159.315.243.656.243 1.014'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-prompts'>
                    <path
                        fillRule='evenodd'
                        d='M5.25 4.65a1.6 1.6 0 00-1.6 1.6V17.5a1.6 1.6 0 001.6 1.6h13.5a1.6 1.6 0 001.6-1.6V6.25a1.6 1.6 0 00-1.6-1.6H5.25zM3.2 4.2a2.9 2.9 0 012.05-.85h13.5a2.9 2.9 0 012.9 2.9V17.5a2.9 2.9 0 01-2.9 2.9H5.25a2.9 2.9 0 01-2.9-2.9V6.25A2.9 2.9 0 013.2 4.2zm3.278 4.965a.65.65 0 01.92 0l2.812 2.813a.65.65 0 010 .92L7.397 15.71a.65.65 0 11-.92-.92l2.354-2.352-2.353-2.353a.65.65 0 010-.92zm4.872 6.085a.65.65 0 01.65-.65h4.5a.65.65 0 110 1.3H12a.65.65 0 01-.65-.65z'
                        clipRule='evenodd'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-content-types'>
                    <path
                        d='M16.478 12.48l-4.939-4.938 4.939-4.938 4.938 4.938-4.938 4.939zm-12.67-1.672v-7h7v7h-7zm9.385 9.384v-7h7v7h-7zm-9.384 0v-7h7v7h-7zm1.5-10.884h4v-4h-4v4zm11.194 1.084l2.825-2.825-2.825-2.825-2.825 2.825 2.825 2.825zm-1.81 8.3h4v-4h-4v4zm-9.384 0h4v-4h-4v4z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-ai-providers'>
                    <path
                        d='M10 6.35a.65.65 0 0 1 .61.424l.516 1.394v.001l.456 1.214c.401 1.03.667 1.554 1.074 1.96.543.543 1.292.835 3.175 1.531h.001l1.394.517a.65.65 0 0 1 0 1.218l-1.394.517c-1.885.697-2.633.988-3.175 1.53-.542.543-.835 1.292-1.531 3.175v.001l-.517 1.394a.65.65 0 0 1-1.176.091l-.042-.091-.517-1.394c-.697-1.885-.988-2.633-1.53-3.175-.543-.542-1.292-.835-3.175-1.531h-.001l-1.394-.517a.65.65 0 0 1 0-1.218l1.394-.517 1.215-.456c1.03-.401 1.554-.667 1.96-1.074.544-.543.835-1.292 1.531-3.175v-.001l.517-1.394.042-.091A.65.65 0 0 1 10 6.35m0 2.52c-.6 1.624-.984 2.64-1.737 3.393S6.494 13.399 4.869 14c1.626.601 2.64.985 3.394 1.737.753.753 1.137 1.769 1.737 3.393.6-1.625.986-2.64 1.737-3.393.753-.753 1.769-1.137 3.393-1.737-1.625-.6-2.64-.984-3.393-1.737S10.601 10.494 10 8.869m8-6.52a.65.65 0 0 1 .61.423l.221.597.001.002.196.524c.166.425.252.582.373.704.161.16.387.259 1.225.569h.001l.599.222.09.042a.65.65 0 0 1-.09 1.176l-.596.222-.002.001c-.84.31-1.066.408-1.228.57-.12.12-.205.278-.372.703l-.197.524-.222.597a.65.65 0 0 1-1.218 0l-.222-.596-.001-.002c-.31-.84-.408-1.066-.57-1.228-.16-.16-.386-.26-1.225-.57v.001l-.599-.222a.65.65 0 0 1 0-1.218l.596-.222.002-.001.524-.196c.425-.166.582-.252.704-.373.16-.161.258-.388.569-1.228l.222-.597.042-.091A.65.65 0 0 1 18 2.35m0 2.45c-.131.277-.28.516-.481.718-.203.202-.441.35-.718.482.276.131.515.28.717.481.202.203.35.44.482.717.131-.276.28-.514.481-.716A2.5 2.5 0 0 1 19.198 6a2.5 2.5 0 0 1-.716-.481A2.5 2.5 0 0 1 18 4.8'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-advanced' stroke='currentColor'>
                    <path
                        strokeWidth="1.3"
                        d="M17.097 15.192a.96.96 0 0 1-.516.86l-4.062 2.174-.007.004a.913.913 0 0 1-.691.09 1 1 0 0 1-.227-.09l-.007-.004-4.064-2.174h.001a.96.96 0 0 1-.516-.86v-1.976l3.959 2.122a2.23 2.23 0 0 0 2.172 0h-.001l3.959-2.122zm3.167-6.228.01.006.01.005a.1.1 0 0 1 .043.037.16.16 0 0 1 .023.085v5.158c0 .063-.014.085-.041.112s-.054.043-.123.043c-.068 0-.094-.015-.122-.043s-.04-.05-.04-.112V8.833zM12.053 4.65a.9.9 0 0 1 .459.12l.005.003 7.115 3.85-.567.305-6.547 3.525-.006.003a.93.93 0 0 1-.918 0l-.005-.002-6.874-3.707a.3.3 0 0 1-.046-.031.25.25 0 0 1-.019-.103c0-.05.01-.08.019-.102a.2.2 0 0 1 .046-.032l6.874-3.706.005-.002a.915.915 0 0 1 .459-.12Z"
                    ></path>
                </symbol>

                {/*Integrations*/}
                <symbol id="lbaic-settings-integration-slack" viewBox="0 0 24 24">
                    <path fill="#33d375"
                          d="M16.5,4c0-1.105-0.896-2-2-2s-2,0.896-2,2c0,0.627,0,4.871,0,5.5c0,1.105,0.896,2,2,2s2-0.896,2-2 C16.5,8.871,16.5,4.627,16.5,4z"/>
                    <path fill="#33d375"
                          d="M21.5,9.5c0,1.105-0.896,2-2,2c-0.598,0-2,0-2,0s0-1.493,0-2c0-1.105,0.896-2,2-2S21.5,8.396,21.5,9.5z"/>
                    <path fill="#40c4ff"
                          d="M4,7c-1.105,0-2,0.896-2,2s0.896,2,2,2c0.627,0,4.871,0,5.5,0c1.105,0,2-0.896,2-2s-0.896-2-2-2 C8.871,7,4.627,7,4,7z"/>
                    <path fill="#40c4ff"
                          d="M9.5,2c1.105,0,2,0.896,2,2c0,0.598,0,2,0,2s-1.493,0-2,0c-1.105,0-2-0.896-2-2S8.396,2,9.5,2z"/>
                    <path fill="#e91e63"
                          d="M7,19.503C7,20.606,7.896,21.5,9,21.5s2-0.894,2-1.997c0-0.626,0-4.864,0-5.492 c0-1.103-0.896-1.997-2-1.997s-2,0.894-2,1.997C7,14.64,7,18.877,7,19.503z"/>
                    <path fill="#e91e63"
                          d="M2,14.011c0-1.103,0.896-1.997,2-1.997c0.598,0,2,0,2,0s0,1.491,0,1.997c0,1.103-0.896,1.997-2,1.997 S2,15.114,2,14.011z"/>
                    <path fill="#ffc107"
                          d="M19.5,16.5c1.105,0,2-0.896,2-2s-0.896-2-2-2c-0.627,0-4.871,0-5.5,0c-1.105,0-2,0.896-2,2s0.896,2,2,2 C14.629,16.5,18.873,16.5,19.5,16.5z"/>
                    <path fill="#ffc107"
                          d="M14,21.5c-1.105,0-2-0.896-2-2c0-0.598,0-2,0-2s1.493,0,2,0c1.105,0,2,0.896,2,2S15.105,21.5,14,21.5z"/>
                </symbol>
                <symbol id="lbaic-settings-integration-telegram" viewBox="0 0 24 24">
                    <path
                        d="M21.2935 2.91409C18.3406 4.13713 5.67864 9.38185 2.18016 10.8113C-0.166079 11.7269 1.20744 12.5854 1.20744 12.5854C1.20744 12.5854 3.21024 13.272 4.9272 13.7871C6.64392 14.3021 7.55952 13.7299 7.55952 13.7299L15.6283 8.29345C18.4896 6.34777 17.803 7.95001 17.1161 8.63689C15.6283 10.1249 13.1676 12.4709 11.1074 14.3595C10.1918 15.1606 10.6495 15.8472 11.0503 16.1907C12.5381 17.4497 16.6013 20.0249 16.83 20.1965C18.0389 21.0523 20.4168 22.2843 20.7785 19.6815L22.2091 10.6971C22.667 7.66417 23.1247 4.86001 23.1818 4.05889C23.3537 2.11297 21.2935 2.91409 21.2935 2.91409Z"
                        fill="#1B92D1"/>
                </symbol>
                <symbol id="lbaic-settings-integration-woocommerce" viewBox="0 0 48 48">
                    <path fill="#a64a7b"
                          d="M43,11H5c-2.209,0-4,1.791-4,4v16c0,2.209,1.791,4,4,4h19l8,4l-2-4h13c2.209,0,4-1.791,4-4V15 C47,12.791,45.209,11,43,11z"></path>
                    <path fill="#fff"
                          d="M40.443 19c.041 0 .132.005.277.038.342.077.559.198.82.686C41.85 20.283 42 21.007 42 21.939c0 1.398-.317 2.639-.973 3.802C40.321 27 39.805 27 39.557 27c-.041 0-.132-.005-.277-.038-.342-.077-.559-.198-.809-.666C38.158 25.722 38 24.963 38 24.043c0-1.399.314-2.63.963-3.765C39.691 19 40.218 19 40.443 19M40.443 16c-1.67 0-3.026.931-4.087 2.793C35.452 20.375 35 22.125 35 24.043c0 1.434.278 2.662.835 3.686.626 1.173 1.548 1.88 2.783 2.16C38.948 29.963 39.261 30 39.557 30c1.687 0 3.043-.931 4.087-2.793C44.548 25.606 45 23.856 45 21.939c0-1.452-.278-2.662-.835-3.668-.626-1.173-1.548-1.88-2.783-2.16C41.052 16.037 40.739 16 40.443 16L40.443 16zM28.443 19c.041 0 .132.005.268.036.333.076.571.207.829.689C29.85 20.283 30 21.007 30 21.939c0 1.398-.317 2.639-.973 3.802C28.321 27 27.805 27 27.557 27c-.041 0-.132-.005-.277-.038-.342-.077-.559-.198-.809-.666C26.158 25.722 26 24.963 26 24.043c0-1.399.314-2.63.963-3.765C27.691 19 28.218 19 28.443 19M28.443 16c-1.67 0-3.026.931-4.087 2.793C23.452 20.375 23 22.125 23 24.043c0 1.434.278 2.662.835 3.686.626 1.173 1.548 1.88 2.783 2.16C26.948 29.963 27.261 30 27.557 30c1.687 0 3.043-.931 4.087-2.793C32.548 25.606 33 23.856 33 21.939c0-1.452-.278-2.662-.835-3.668-.626-1.173-1.565-1.88-2.783-2.16C29.052 16.037 28.739 16 28.443 16L28.443 16zM18.5 32c-.421 0-.832-.178-1.123-.505-2.196-2.479-3.545-5.735-4.34-8.343-1.144 2.42-2.688 5.515-4.251 8.119-.309.515-.894.792-1.491.715-.596-.083-1.085-.513-1.242-1.093-2.212-8.127-3.007-13.95-3.039-14.194-.11-.82.466-1.575 1.286-1.686.831-.108 1.576.465 1.687 1.286.007.049.571 4.177 2.033 10.199 2.218-4.208 4.078-8.535 4.102-8.59.267-.62.919-.989 1.58-.895.668.09 1.194.615 1.285 1.283.007.052.542 3.825 2.245 7.451.719-7.166 2.873-10.839 2.982-11.021.427-.711 1.35-.941 2.058-.515.711.426.941 1.348.515 2.058C22.762 16.313 20 21.115 20 30.5c0 .623-.386 1.182-.968 1.402C18.858 31.968 18.679 32 18.5 32z"></path>
                </symbol>

                <symbol viewBox='0 0 24 24' id='lbaic-settings-search'>
                    <path
                        fillRule='evenodd'
                        d='M5 11c0-3.309 2.69-6 6-6 3.308 0 6 2.691 6 6 0 3.31-2.692 6-6 6-3.31 0-6-2.69-6-6m15.707 8.293l-3.395-3.396A7.952 7.952 0 0019 11c0-4.411-3.589-8-8-8s-8 3.589-8 8 3.589 8 8 8a7.952 7.952 0 004.897-1.688l3.396 3.395a.997.997 0 001.414 0 .999.999 0 000-1.414'
                        clipRule='evenodd'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-arrow'>
                    <path
                        d="M5.296 8.554a1.01 1.01 0 0 1 1.43 0l5.005 5.005 5.005-5.005a1.011 1.011 0 0 1 1.43 1.43l-5.72 5.72a1.01 1.01 0 0 1-1.43 0l-5.72-5.72a1.01 1.01 0 0 1 0-1.43"
                    ></path>
                </symbol>
                <symbol
                    viewBox='0 0 24 24'
                    id='lbaic-settings-arrow-right'
                    fill="none"
                    stroke="currentColor"
                    strokeWidth="2"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                >
                    <path d="M5 12h14"></path>
                    <path d="m12 5 7 7-7 7"></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-arrow-left'>
                    <path
                        d="M7.40275 10.9889L18.5798 10.9889C18.7118 10.9859 18.843 11.0099 18.9655 11.0595C19.0879 11.109 19.1989 11.183 19.2918 11.2769C19.3857 11.3698 19.4597 11.4808 19.5092 11.6032C19.5587 11.7256 19.5827 11.8569 19.5798 11.9889C19.5798 12.2723 19.4838 12.5099 19.2918 12.7019C19.1988 12.7957 19.0878 12.8695 18.9654 12.9189C18.8429 12.9682 18.7117 12.9921 18.5798 12.9889L7.40275 12.9889L12.3028 17.8889C12.3975 17.9786 12.4721 18.0874 12.5215 18.2081C12.571 18.3287 12.5943 18.4586 12.5898 18.5889C12.5818 18.8556 12.4778 19.0889 12.2778 19.2889C12.0778 19.4729 11.8444 19.5689 11.5778 19.5769C11.3111 19.5849 11.0778 19.4889 10.8778 19.2889L4.27775 12.6889C4.17775 12.5889 4.10675 12.4806 4.06475 12.3639C4.02342 12.2479 4.00275 12.1229 4.00275 11.9889C4.00275 11.8556 4.02342 11.7306 4.06475 11.6139C4.11124 11.4914 4.18393 11.3805 4.27775 11.2889L10.8778 4.68893C10.9673 4.59852 11.0746 4.52746 11.1927 4.48016C11.3109 4.43286 11.4375 4.41032 11.5648 4.41393C11.8401 4.41393 12.0778 4.5056 12.2778 4.68893C12.4778 4.88893 12.5778 5.1266 12.5778 5.40193C12.5778 5.6766 12.4778 5.91393 12.2778 6.11393L7.40275 10.9889Z"></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-arrow-top'>
                    <path
                        d='m11.999 11.4-3.9 3.9a.95.95 0 0 1-.7.274.95.95 0 0 1-.7-.275.95.95 0 0 1-.275-.7q0-.424.275-.7l4.6-4.6q.15-.15.325-.212.176-.063.375-.063.2 0 .375.063a.9.9 0 0 1 .325.212l4.6 4.6a.95.95 0 0 1 .275.7.95.95 0 0 1-.275.7.95.95 0 0 1-.7.275.95.95 0 0 1-.7-.275z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-close'>
                    <path
                        d='M5 17.59L6.41 19 12 13.41 17.59 19 19 17.59 13.41 12 19 6.41 17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-check'>
                    <path
                        d='M9.548 15.15l8.475-8.475c.2-.2.433-.3.7-.3.267 0 .5.1.7.3.2.2.3.438.3.713 0 .274-.1.512-.3.712l-9.175 9.2c-.2.2-.433.3-.7.3a.96.96 0 01-.7-.3l-4.3-4.3a.93.93 0 01-.287-.713 1.02 1.02 0 01.312-.712c.2-.2.438-.3.713-.3.275 0 .512.1.712.3l3.55 3.575z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-plus'>
                    <path
                        d='M21 13.286h-7.714V21h-2.572v-7.714H3v-2.572h7.714V3h2.572v7.714H21v2.572z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-plus-stroke' fill='none' stroke='currentColor'
                        strokeWidth='2' strokeLinecap='round' strokeLinejoin='round'>
                    <path d='M5 12h14'></path>
                    <path d='M12 5v14'></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-copy'>
                    <path
                        d='M9 18c-.55 0-1.02-.196-1.412-.587A1.926 1.926 0 017 16V4c0-.55.196-1.02.588-1.413A1.926 1.926 0 019 2h9c.55 0 1.02.196 1.413.587C19.803 2.98 20 3.45 20 4v12c0 .55-.196 1.02-.587 1.413A1.926 1.926 0 0118 18H9zm0-2h9V4H9v12zm-4 6c-.55 0-1.02-.196-1.413-.587A1.926 1.926 0 013 20V7c0-.283.096-.52.288-.713A.968.968 0 014 6c.283 0 .52.096.713.287.191.192.287.43.287.713v13h10c.283 0 .52.096.713.288.191.191.287.429.287.712s-.096.52-.287.712A.968.968 0 0115 22H5z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-info'>
                    <path
                        d='M11 17h2v-6h-2v6zm1-8c.283 0 .52-.096.713-.287A.967.967 0 0013 8a.967.967 0 00-.287-.713A.968.968 0 0012 7a.968.968 0 00-.713.287A.967.967 0 0011 8c0 .283.096.52.287.713.192.191.43.287.713.287zm0 13a9.738 9.738 0 01-3.9-.788 10.099 10.099 0 01-3.175-2.137c-.9-.9-1.612-1.958-2.137-3.175A9.738 9.738 0 012 12c0-1.383.263-2.683.788-3.9a10.099 10.099 0 012.137-3.175c.9-.9 1.958-1.612 3.175-2.137A9.738 9.738 0 0112 2c1.383 0 2.683.263 3.9.788a10.098 10.098 0 013.175 2.137c.9.9 1.613 1.958 2.137 3.175A9.738 9.738 0 0122 12a9.738 9.738 0 01-.788 3.9 10.098 10.098 0 01-2.137 3.175c-.9.9-1.958 1.613-3.175 2.137A9.738 9.738 0 0112 22zm0-2c2.233 0 4.125-.775 5.675-2.325C19.225 16.125 20 14.233 20 12c0-2.233-.775-4.125-2.325-5.675C16.125 4.775 14.233 4 12 4c-2.233 0-4.125.775-5.675 2.325C4.775 7.875 4 9.767 4 12c0 2.233.775 4.125 2.325 5.675C7.875 19.225 9.767 20 12 20z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-alert'>
                    <path
                        d='M12 17c.283 0 .52-.096.713-.288A.968.968 0 0013 16a.968.968 0 00-.287-.713A.968.968 0 0012 15a.968.968 0 00-.713.287A.968.968 0 0011 16c0 .283.096.52.287.712.192.192.43.288.713.288zm0-4c.283 0 .52-.096.713-.287A.968.968 0 0013 12V8a.967.967 0 00-.287-.713A.968.968 0 0012 7a.968.968 0 00-.713.287A.967.967 0 0011 8v4c0 .283.096.52.287.713.192.191.43.287.713.287zm0 9a9.738 9.738 0 01-3.9-.788 10.099 10.099 0 01-3.175-2.137c-.9-.9-1.612-1.958-2.137-3.175A9.738 9.738 0 012 12c0-1.383.263-2.683.788-3.9a10.099 10.099 0 012.137-3.175c.9-.9 1.958-1.612 3.175-2.137A9.738 9.738 0 0112 2c1.383 0 2.683.263 3.9.788a10.098 10.098 0 013.175 2.137c.9.9 1.613 1.958 2.137 3.175A9.738 9.738 0 0122 12a9.738 9.738 0 01-.788 3.9 10.098 10.098 0 01-2.137 3.175c-.9.9-1.958 1.613-3.175 2.137A9.738 9.738 0 0112 22zm0-2c2.233 0 4.125-.775 5.675-2.325C19.225 16.125 20 14.233 20 12c0-2.233-.775-4.125-2.325-5.675C16.125 4.775 14.233 4 12 4c-2.233 0-4.125.775-5.675 2.325C4.775 7.875 4 9.767 4 12c0 2.233.775 4.125 2.325 5.675C7.875 19.225 9.767 20 12 20z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-upload'>
                    <path
                        d='M8.71 9.71L11 7.41V15a1 1 0 002 0V7.41l2.29 2.3a1.001 1.001 0 001.639-.326 1 1 0 00-.219-1.094l-4-4a1 1 0 00-.33-.21 1 1 0 00-.76 0 1 1 0 00-.33.21l-4 4a1.004 1.004 0 101.42 1.42zM19 13a1 1 0 00-1 1v3a1 1 0 01-1 1H7a1 1 0 01-1-1v-3a1 1 0 10-2 0v3a3 3 0 003 3h10a3 3 0 003-3v-3a1 1 0 00-1-1z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-edit'>
                    <path
                        d='M5 19h1.425L16.2 9.225 14.775 7.8 5 17.575V19zm-2 2v-4.25L16.2 3.575c.2-.183.42-.325.663-.425.241-.1.495-.15.762-.15s.525.05.775.15c.25.1.467.25.65.45L20.425 5c.2.183.346.4.438.65a2.165 2.165 0 010 1.512 1.874 1.874 0 01-.438.663L7.25 21H3zM15.475 8.525l-.7-.725L16.2 9.225l-.725-.7z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-file'>
                    <path
                        d="M4.5 24a2.46 2.46 0 0 1-1.765-.705 2.3 2.3 0 0 1-.55-.774A2.2 2.2 0 0 1 2 21.6V2.4q0-.99.735-1.694c.229-.227.503-.407.807-.528.303-.122.63-.182.958-.178h8.969c.325 0 .646.06.947.178s.573.292.803.512l6.062 5.82c.23.221.41.483.534.771.123.289.186.597.185.91V21.6q0 .99-.734 1.695a2.4 2.4 0 0 1-.807.528c-.304.121-.63.181-.959.177zm8.75-16.8V2.4H4.5v19.2h15V8.4h-5a1.3 1.3 0 0 1-.482-.084 1.22 1.22 0 0 1-.68-.652 1.1 1.1 0 0 1-.088-.464"
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-function'>
                    <path
                        d="M7.00003 3C4.79089 3 3.00003 4.79086 3.00003 7C3.00003 7.27711 3.00537 7.5494 3.0104 7.8054L3.01115 7.84333C3.01645 8.1142 3.02106 8.3655 3.01965 8.60685C3.01679 9.09512 2.98866 9.48762 2.91211 9.81374C2.8384 10.1278 2.72568 10.3539 2.56571 10.5316C2.40635 10.7085 2.14766 10.8956 1.69126 11.0488C1.67827 11.053 1.66539 11.0575 1.6526 11.0623C1.50917 11.1153 1.38482 11.1982 1.28424 11.3014C1.19514 11.3925 1.12235 11.502 1.07233 11.6266C1.02502 11.744 0.999736 11.8706 0.999756 12C0.999736 12.1294 1.02502 12.256 1.07233 12.3734C1.12233 12.498 1.19512 12.6075 1.28419 12.6986C1.38477 12.8018 1.50915 12.8847 1.6526 12.9377C1.66536 12.9425 1.67823 12.947 1.69119 12.9512C2.1288 13.0981 2.38018 13.2793 2.53768 13.4538C2.69653 13.6298 2.81141 13.856 2.88877 14.1715C2.96884 14.498 3.00222 14.8925 3.01014 15.3824C3.01493 15.6786 3.01096 15.959 3.00667 16.262L3.00666 16.262C3.00344 16.4899 3.00003 16.7304 3.00003 17C3.00003 19.2092 4.79089 21 7.00003 21C7.55231 21 8.00003 20.5523 8.00003 20C8.00003 19.4477 7.55231 19 7.00003 19C5.89546 19 5.00003 18.1046 5.00003 17C5.00003 16.7963 5.00293 16.5738 5.00588 16.3473L5.00588 16.3472V16.3472V16.3471C5.01031 16.0069 5.01486 15.6578 5.00988 15.3501C5.00112 14.8086 4.96449 14.2386 4.83121 13.6952C4.69523 13.1406 4.45343 12.5913 4.02229 12.1137C3.98945 12.0773 3.95581 12.0417 3.92137 12.0068C3.96625 11.9623 4.00979 11.9167 4.05198 11.8698C4.48842 11.3851 4.7281 10.8292 4.85918 10.2708C4.98743 9.72447 5.01648 9.15415 5.01962 8.61856C5.0212 8.34797 5.01601 8.07208 5.01076 7.80416L5.01013 7.77202C5.00502 7.51143 5.00003 7.25693 5.00003 7C5.00003 5.89543 5.89546 5 7.00003 5C7.55231 5 8.00003 4.55228 8.00003 4C8.00003 3.44772 7.55231 3 7.00003 3ZM20.0602 12C20.0198 12.0399 19.9806 12.0807 19.9425 12.1225C19.5024 12.6049 19.2619 13.1586 19.1317 13.7172C19.0047 14.2621 18.9783 14.8319 18.9771 15.3676C18.9765 15.636 18.9824 15.9109 18.9882 16.1786L18.9883 16.1855C18.9942 16.4593 19 16.7279 19 17C19 18.1046 18.1046 19 17 19C16.4477 19 16 19.4477 16 20C16 20.5523 16.4477 21 17 21C19.2091 21 21 19.2092 21 17C21 16.7043 20.9938 16.4158 20.988 16.1463L20.9879 16.1424C20.982 15.8678 20.9765 15.6148 20.9771 15.3721C20.9782 14.881 21.0046 14.4922 21.0795 14.1712C21.1511 13.8637 21.2615 13.6442 21.42 13.4704C21.5794 13.2957 21.8415 13.108 22.3087 12.9512C22.3217 12.947 22.3346 12.9425 22.3474 12.9377C22.4909 12.8847 22.6152 12.8018 22.7158 12.6986C22.8964 12.5133 23.0003 12.2622 23.0003 12C23.0003 11.8706 22.975 11.744 22.9277 11.6266C22.8776 11.5019 22.8048 11.3924 22.7156 11.3012C22.615 11.1981 22.4908 11.1153 22.3474 11.0623C22.3346 11.0575 22.3217 11.053 22.3087 11.0488C21.8415 10.892 21.5794 10.7043 21.42 10.5296C21.2615 10.3558 21.1511 10.1363 21.0795 9.82884C21.0046 9.50782 20.9782 9.11899 20.9771 8.62794C20.9765 8.38527 20.982 8.13224 20.9879 7.85765L20.988 7.85375C20.9938 7.58421 21 7.29574 21 7C21 4.79086 19.2091 3 17 3C16.4477 3 16 3.44772 16 4C16 4.55228 16.4477 5 17 5C18.1046 5 19 5.89543 19 7C19 7.27216 18.9942 7.54074 18.9883 7.81451L18.9882 7.82144C18.9824 8.08909 18.9765 8.36405 18.9771 8.63245C18.9783 9.16818 19.0047 9.73794 19.1317 10.2829C19.2619 10.8414 19.5024 11.3951 19.9425 11.8775C19.9806 11.9193 20.0198 11.9602 20.0602 12ZM14.9762 6.78304C15.096 7.32217 14.7561 7.85635 14.2169 7.97616C13.8809 8.05082 13.6823 8.19691 13.5356 8.39076C13.3704 8.60888 13.2323 8.94179 13.1385 9.43276C13.1039 9.61357 13.0772 9.80275 13.0567 10H13.5C14.0523 10 14.5 10.4477 14.5 11C14.5 11.5523 14.0523 12 13.5 12H12.9932C12.9939 12.1369 12.9949 12.2761 12.996 12.4175V12.4176V12.4176C12.998 12.6871 13 12.9646 13 13.25C13 14.7156 12.739 15.906 12.1176 16.7494C11.4526 17.6519 10.4958 18 9.5 18C8.94772 18 8.5 17.5523 8.5 17C8.5 16.4477 8.94772 16 9.5 16C10.0042 16 10.2974 15.8481 10.5074 15.563C10.761 15.219 11 14.5343 11 13.25C11 13.0132 10.9979 12.7688 10.9957 12.5198C10.9942 12.3484 10.9927 12.1748 10.9919 12H10.5C9.94771 12 9.5 11.5523 9.5 11C9.5 10.4477 9.94771 10 10.5 10H11.0495C11.077 9.67287 11.1169 9.35612 11.174 9.05719C11.2989 8.40399 11.5202 7.73939 11.941 7.18356C12.3802 6.60345 12.9941 6.19912 13.7831 6.02378C14.3222 5.90398 14.8564 6.24391 14.9762 6.78304Z"
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-kebab-vertical'>
                    <path
                        d="M12 20C11.45 20 10.9792 19.8042 10.5875 19.4125C10.1958 19.0208 10 18.55 10 18C10 17.45 10.1958 16.9792 10.5875 16.5875C10.9792 16.1958 11.45 16 12 16C12.55 16 13.0208 16.1958 13.4125 16.5875C13.8042 16.9792 14 17.45 14 18C14 18.55 13.8042 19.0208 13.4125 19.4125C13.0208 19.8042 12.55 20 12 20ZM12 14C11.45 14 10.9792 13.8042 10.5875 13.4125C10.1958 13.0208 10 12.55 10 12C10 11.45 10.1958 10.9792 10.5875 10.5875C10.9792 10.1958 11.45 10 12 10C12.55 10 13.0208 10.1958 13.4125 10.5875C13.8042 10.9792 14 11.45 14 12C14 12.55 13.8042 13.0208 13.4125 13.4125C13.0208 13.8042 12.55 14 12 14ZM12 8C11.45 8 10.9792 7.80417 10.5875 7.4125C10.1958 7.02083 10 6.55 10 6C10 5.45 10.1958 4.97917 10.5875 4.5875C10.9792 4.19583 11.45 4 12 4C12.55 4 13.0208 4.19583 13.4125 4.5875C13.8042 4.97917 14 5.45 14 6C14 6.55 13.8042 7.02083 13.4125 7.4125C13.0208 7.80417 12.55 8 12 8Z"/>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-reload'>
                    <path
                        d="M12 21C9.9 21 8.04167 20.3625 6.425 19.0875C4.80833 17.8125 3.75833 16.1833 3.275 14.2C3.20833 13.95 3.25833 13.7208 3.425 13.5125C3.59167 13.3042 3.81667 13.1833 4.1 13.15C4.36667 13.1167 4.60833 13.1667 4.825 13.3C5.04167 13.4333 5.19167 13.6333 5.275 13.9C5.675 15.4 6.5 16.625 7.75 17.575C9 18.525 10.4167 19 12 19C13.95 19 15.6042 18.3208 16.9625 16.9625C18.3208 15.6042 19 13.95 19 12C19 10.05 18.3208 8.39583 16.9625 7.0375C15.6042 5.67917 13.95 5 12 5C10.85 5 9.775 5.26667 8.775 5.8C7.775 6.33333 6.93333 7.06667 6.25 8H8C8.28333 8 8.52083 8.09583 8.7125 8.2875C8.90417 8.47917 9 8.71667 9 9C9 9.28333 8.90417 9.52083 8.7125 9.7125C8.52083 9.90417 8.28333 10 8 10H4C3.71667 10 3.47917 9.90417 3.2875 9.7125C3.09583 9.52083 3 9.28333 3 9V5C3 4.71667 3.09583 4.47917 3.2875 4.2875C3.47917 4.09583 3.71667 4 4 4C4.28333 4 4.52083 4.09583 4.7125 4.2875C4.90417 4.47917 5 4.71667 5 5V6.35C5.85 5.28333 6.8875 4.45833 8.1125 3.875C9.3375 3.29167 10.6333 3 12 3C13.25 3 14.4208 3.2375 15.5125 3.7125C16.6042 4.1875 17.5542 4.82917 18.3625 5.6375C19.1708 6.44583 19.8125 7.39583 20.2875 8.4875C20.7625 9.57917 21 10.75 21 12C21 13.25 20.7625 14.4208 20.2875 15.5125C19.8125 16.6042 19.1708 17.5542 18.3625 18.3625C17.5542 19.1708 16.6042 19.8125 15.5125 20.2875C14.4208 20.7625 13.25 21 12 21Z"/>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-resync'>
                    <path
                        d="M17.6677 17.6442C16.0821 19.2169 14.1874 20.0047 11.9835 20.0076C9.77967 20.0104 7.8914 19.2191 6.31857 17.6335L6.19533 17.5092L6.19017 18.782C6.18916 19.0413 6.08801 19.2707 5.88685 19.4702C5.6857 19.6697 5.45552 19.769 5.19621 19.7679C4.93697 19.7669 4.70759 19.6658 4.50801 19.4646C4.3085 19.2635 4.20928 19.0333 4.21028 18.774L4.22522 15.0971C4.22637 14.8142 4.3216 14.5789 4.51093 14.3911C4.70026 14.2033 4.93634 14.11 5.21918 14.1111L8.89608 14.126C9.1554 14.1271 9.38478 14.2282 9.58429 14.4293C9.78387 14.6305 9.88308 14.8607 9.88201 15.12C9.881 15.3793 9.77985 15.6087 9.57869 15.8082C9.37754 16.0077 9.14737 16.107 8.88805 16.1059L7.61527 16.1007L7.73851 16.225C8.91225 17.4083 10.327 18.0004 11.9828 18.0011C13.6387 18.002 15.0641 17.4097 16.2592 16.2242C16.4485 16.0364 16.6232 15.8398 16.7831 15.6341C16.9431 15.4285 17.0824 15.2082 17.2012 14.9729C17.3437 14.7142 17.5389 14.5323 17.7868 14.4273C18.0347 14.3222 18.294 14.3115 18.5647 14.3951C18.8473 14.4905 19.041 14.668 19.1459 14.9278C19.251 15.1875 19.2323 15.4466 19.0897 15.7054C18.9116 16.07 18.7009 16.4139 18.458 16.737C18.2151 17.0601 17.9516 17.3625 17.6677 17.6442ZM7.73742 7.77503C7.54815 7.96278 7.37352 8.15948 7.21353 8.36512C7.05363 8.57069 6.91423 8.79112 6.79542 9.02634C6.65298 9.28502 6.45483 9.46982 6.201 9.58075C5.94717 9.69168 5.68489 9.70535 5.41417 9.62175C5.14345 9.53816 4.95559 9.36651 4.85057 9.10681C4.74555 8.84711 4.75837 8.59379 4.889 8.34682C5.0791 7.97047 5.29263 7.6178 5.52967 7.28878C5.76671 6.95976 6.03319 6.64848 6.32896 6.3551C7.9146 4.78226 9.80933 3.99445 12.0131 3.99165C14.217 3.98878 16.1053 4.78018 17.6781 6.36576L17.8013 6.49L17.8065 5.21722C17.8076 4.95793 17.9086 4.72852 18.1098 4.52901C18.311 4.32944 18.5412 4.23024 18.8004 4.23129C19.0598 4.23235 19.2891 4.33347 19.4886 4.53461C19.6882 4.73581 19.7875 4.96596 19.7863 5.22525L19.7714 8.90218C19.7703 9.18502 19.6751 9.42031 19.4857 9.60813C19.2964 9.79588 19.0603 9.88925 18.7775 9.8881L15.1005 9.87319C14.8413 9.87213 14.6119 9.77108 14.4123 9.56987C14.2128 9.36874 14.1136 9.13852 14.1146 8.87923C14.1157 8.61994 14.2168 8.39053 14.4179 8.19102C14.6191 7.99145 14.8493 7.89225 15.1086 7.8933L16.3814 7.89847L16.2581 7.77422C15.0844 6.59099 13.6696 5.99891 12.0138 5.99808C10.358 5.99726 8.93259 6.58953 7.73742 7.77503Z"/>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-delete'>
                    <path
                        d='M7 21c-.55 0-1.021-.196-1.413-.587A1.926 1.926 0 015 19V6a.968.968 0 01-.713-.287A.968.968 0 014 5c0-.283.096-.52.287-.713A.968.968 0 015 4h4c0-.283.096-.52.287-.712A.968.968 0 0110 3h4c.283 0 .52.096.712.288.192.191.288.429.288.712h4c.283 0 .52.096.712.287.192.192.288.43.288.713s-.096.52-.288.713A.967.967 0 0119 6v13c0 .55-.196 1.02-.588 1.413A1.926 1.926 0 0117 21H7zM17 6H7v13h10V6zm-7 11c.283 0 .52-.096.712-.288A.968.968 0 0011 16V9a.967.967 0 00-.288-.713A.967.967 0 0010 8a.968.968 0 00-.713.287A.968.968 0 009 9v7c0 .283.096.52.287.712.192.192.43.288.713.288zm4 0c.283 0 .52-.096.712-.288A.968.968 0 0015 16V9a.967.967 0 00-.288-.713A.967.967 0 0014 8a.968.968 0 00-.713.287A.968.968 0 0013 9v7c0 .283.096.52.287.712.192.192.43.288.713.288z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-delete-forever'>
                    <path
                        d='M7 21c-.55 0-1.02-.196-1.412-.587A1.926 1.926 0 015 19V6a.968.968 0 01-.713-.287A.968.968 0 014 5c0-.283.096-.52.287-.713A.968.968 0 015 4h4c0-.283.096-.52.287-.712A.968.968 0 0110 3h4c.283 0 .52.096.713.288.191.191.287.429.287.712h4c.283 0 .52.096.712.287.192.192.288.43.288.713s-.096.52-.288.713A.968.968 0 0119 6v13c0 .55-.196 1.02-.587 1.413A1.926 1.926 0 0117 21H7zM17 6H7v13h10V6zm-5 7.9l1.9 1.9a.948.948 0 00.7.275.948.948 0 00.7-.275.948.948 0 00.275-.7.948.948 0 00-.275-.7l-1.9-1.9 1.9-1.9a.948.948 0 00.275-.7.948.948 0 00-.275-.7.948.948 0 00-.7-.275.948.948 0 00-.7.275L12 11.1l-1.9-1.9a.948.948 0 00-.7-.275.948.948 0 00-.7.275.948.948 0 00-.275.7c0 .283.092.517.275.7l1.9 1.9-1.9 1.9a.948.948 0 00-.275.7c0 .283.092.517.275.7a.948.948 0 00.7.275.948.948 0 00.7-.275l1.9-1.9z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-run'>
                    <path
                        d='M8 17.175V6.825c0-.283.1-.52.3-.712a.98.98 0 01.963-.25c.091.025.179.062.262.112l8.15 5.175c.15.1.263.225.338.375a1.049 1.049 0 010 .95.968.968 0 01-.338.375l-8.15 5.175a1.04 1.04 0 01-.525.15.98.98 0 01-.7-.287.947.947 0 01-.3-.713z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-pause'>
                    <path
                        d="M16 19q-.825 0-1.412-.587A1.93 1.93 0 0 1 14 17V7q0-.824.588-1.412A1.93 1.93 0 0 1 16 5q.824 0 1.413.588Q18 6.175 18 7v10q0 .824-.587 1.413A1.93 1.93 0 0 1 16 19m-8 0q-.824 0-1.412-.587A1.93 1.93 0 0 1 6 17V7q0-.824.588-1.412A1.93 1.93 0 0 1 8 5q.825 0 1.412.588Q10 6.175 10 7v10q0 .824-.588 1.413A1.93 1.93 0 0 1 8 19"
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-stop'>
                    <path
                        d="M6 16V8q0-.824.588-1.412A1.93 1.93 0 0 1 8 6h8q.824 0 1.413.588Q18 7.175 18 8v8q0 .824-.587 1.413A1.93 1.93 0 0 1 16 18H8q-.824 0-1.412-.587A1.93 1.93 0 0 1 6 16"
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-sync'>
                    <path
                        d='m4.906 17.61 2.183 2.183q.345.345.33.804t-.359.804q-.345.317-.804.33-.46.015-.804-.33l-4.136-4.135a1 1 0 0 1-.244-.374 1.3 1.3 0 0 1-.072-.43q0-.23.072-.431t.244-.374l4.136-4.135q.316-.316.79-.316.473 0 .818.316.345.345.345.818 0 .474-.345.819l-2.154 2.154h16.285q.488 0 .818.33t.33.818-.33.819-.818.33zm14.188-9.19H2.809q-.488 0-.818-.33t-.33-.82.33-.818.818-.33h16.285l-2.183-2.183q-.345-.345-.33-.804t.359-.804q.345-.315.804-.33t.804.33l4.136 4.136q.172.172.244.373.072.202.072.43 0 .231-.072.432t-.244.373l-4.136 4.136q-.316.316-.79.316a1.17 1.17 0 0 1-.818-.316 1.12 1.12 0 0 1-.345-.819q0-.474.345-.818z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-checkbox-check'>
                    <path
                        d='M10.653 18.972l-.027.028L4 12.073l2.158-2.256 4.495 4.7L17.843 7 20 9.256 10.68 19l-.027-.028z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-checkbox-check-intermediate'>
                    <rect width='14' height='3' x='5' y='10.5' rx='1.5'></rect>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-checkbox-check-rounded'>
                    <path
                        d='M10.32 17.52l8.46-8.46-1.68-1.68-6.78 6.78-3.42-3.42-1.68 1.68 5.1 5.1zM12 24c-1.66 0-3.22-.315-4.68-.945a12.118 12.118 0 01-3.81-2.565 12.118 12.118 0 01-2.565-3.81C.315 15.22 0 13.66 0 12c0-1.66.315-3.22.945-4.68.63-1.46 1.485-2.73 2.565-3.81A12.118 12.118 0 017.32.945C8.78.315 10.34 0 12 0c1.66 0 3.22.315 4.68.945 1.46.63 2.73 1.485 3.81 2.565a12.118 12.118 0 012.565 3.81c.63 1.46.945 3.02.945 4.68 0 1.66-.315 3.22-.945 4.68a12.118 12.118 0 01-2.565 3.81 12.118 12.118 0 01-3.81 2.565c-1.46.63-3.02.945-4.68.945z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-menu'>
                    <path
                        d='M4 12c0-.55.196-1.02.588-1.412A1.926 1.926 0 016 10c.55 0 1.02.196 1.412.588.392.391.588.862.588 1.412 0 .55-.196 1.02-.588 1.412A1.926 1.926 0 016 14c-.55 0-1.02-.196-1.412-.588A1.926 1.926 0 014 12zm6 0c0-.55.196-1.02.588-1.412A1.926 1.926 0 0112 10c.55 0 1.02.196 1.412.588.392.391.588.862.588 1.412 0 .55-.196 1.02-.588 1.412A1.926 1.926 0 0112 14c-.55 0-1.02-.196-1.412-.588A1.926 1.926 0 0110 12zm6 0c0-.55.196-1.02.587-1.412A1.926 1.926 0 0118 10c.55 0 1.02.196 1.413.588.391.391.587.862.587 1.412 0 .55-.196 1.02-.587 1.412A1.926 1.926 0 0118 14c-.55 0-1.02-.196-1.413-.588A1.926 1.926 0 0116 12z'
                        opacity='0.8'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-circle'>
                    <circle cx='12' cy='12' r='11' strokeWidth='2'></circle>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-fast-prev'>
                    <path
                        d='m12.95 12 3.875-5.425q.35-.5.088-1.038Q16.65 5 16.025 5q-.25 0-.475.112a.85.85 0 0 0-.35.313L10.5 12l4.7 6.575q.126.2.35.313.225.111.475.112.6 0 .875-.538.276-.537-.075-1.037zM7 12l3.875-5.425q.35-.5.088-1.038Q10.7 5 10.075 5q-.25 0-.475.112a.85.85 0 0 0-.35.313L4.55 12l4.7 6.575q.125.2.35.313.226.111.475.112.6 0 .875-.538.276-.537-.075-1.037z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-prev'>
                    <path
                        d='M11.925 12 15.8 6.575q.35-.5.087-1.038Q15.625 5 15 5q-.25 0-.475.112a.85.85 0 0 0-.35.313L9.475 12l4.7 6.575q.125.2.35.313.225.111.475.112.6 0 .875-.538.275-.537-.075-1.037z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-next'>
                    <path
                        d='M12.075 12 8.2 6.575q-.35-.5-.087-1.038Q8.375 5 9 5q.25 0 .475.112.225.113.35.313l4.7 6.575-4.7 6.575a.85.85 0 0 1-.35.313Q9.25 18.999 9 19q-.6 0-.875-.538-.274-.537.075-1.037z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-fast-next'>
                    <path
                        d='M11.05 12 7.175 6.575q-.35-.5-.088-1.038Q7.35 5 7.975 5q.25 0 .475.112.225.113.35.313L13.5 12l-4.7 6.575a.85.85 0 0 1-.35.313q-.226.111-.475.112-.6 0-.875-.538-.276-.537.075-1.037zM17 12l-3.875-5.425q-.35-.5-.088-1.038Q13.3 5 13.925 5q.25 0 .475.112a.85.85 0 0 1 .35.313L19.45 12l-4.7 6.575a.85.85 0 0 1-.35.313q-.226.111-.475.112-.6 0-.875-.538-.276-.537.075-1.037z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-database'>
                    <path
                        fillRule='evenodd'
                        d='M4 5q0 .002.003.015a.3.3 0 0 0 .032.066c.043.07.13.174.291.301.33.26.87.539 1.626.79C7.454 6.674 9.592 7 12 7s4.546-.327 6.048-.827c.756-.252 1.296-.53 1.626-.79.162-.128.248-.232.29-.302a.3.3 0 0 0 .036-.08q0-.002-.003-.016a.3.3 0 0 0-.032-.066 1.2 1.2 0 0 0-.291-.301c-.33-.26-.87-.539-1.626-.79C16.546 3.326 14.408 3 12 3s-4.546.327-6.048.827c-.756.252-1.296.53-1.626.79a1.2 1.2 0 0 0-.29.302.3.3 0 0 0-.033.066zm16 2.527a9.5 9.5 0 0 1-1.32.543C16.925 8.655 14.563 9 12 9s-4.925-.345-6.68-.93A9.5 9.5 0 0 1 4 7.527V12q0 .002.003.018a.3.3 0 0 0 .033.067c.042.07.127.173.288.3.328.26.864.537 1.618.789 1.497.5 3.635.826 6.058.826s4.561-.326 6.058-.826c.754-.252 1.29-.53 1.618-.789.16-.127.246-.23.288-.3a.3.3 0 0 0 .033-.067L20 12zM22 5c0-.852-.519-1.504-1.088-1.953-.581-.458-1.36-.826-2.232-1.117C16.925 1.345 14.563 1 12 1s-4.925.345-6.68.93c-.873.29-1.651.66-2.232 1.117C2.518 3.496 2 4.148 2 5v14c0 .85.513 1.502 1.082 1.953.579.459 1.355.827 2.226 1.118C7.061 22.656 9.423 23 12 23s4.939-.344 6.692-.929c.87-.29 1.647-.66 2.226-1.118C21.487 20.502 22 19.849 22 19zm-2 9.532c-.398.203-.84.383-1.308.539-1.753.585-4.115.929-6.692.929s-4.939-.344-6.692-.929A9.5 9.5 0 0 1 4 14.531V19q0 .002.003.018a.3.3 0 0 0 .033.067c.042.07.127.173.288.3.328.26.864.537 1.618.789 1.497.5 3.635.826 6.058.826s4.561-.326 6.058-.826c.754-.252 1.29-.53 1.618-.789.16-.127.246-.23.288-.3a.3.3 0 0 0 .033-.067L20 19z'
                        clipRule='evenodd'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-equalizer'>
                    <path
                        d='M6 20.5q-.824 0-1.412-.587A1.93 1.93 0 0 1 4 18.5v-4q0-.825.588-1.412A1.93 1.93 0 0 1 6 12.5q.824 0 1.412.588Q8 13.675 8 14.5v4q0 .824-.588 1.413A1.93 1.93 0 0 1 6 20.5m6 0q-.825 0-1.412-.587A1.93 1.93 0 0 1 10 18.5v-12q0-.824.588-1.412A1.93 1.93 0 0 1 12 4.5q.825 0 1.412.588Q14 5.675 14 6.5v12q0 .824-.588 1.413A1.93 1.93 0 0 1 12 20.5m6 0q-.824 0-1.413-.587A1.93 1.93 0 0 1 16 18.5v-7q0-.825.587-1.412A1.93 1.93 0 0 1 18 9.5q.824 0 1.413.588.587.587.587 1.412v7q0 .824-.587 1.413A1.93 1.93 0 0 1 18 20.5'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-indexing'>
                    <path
                        d='M23.5 10H20v1.312L4 7.25v-.625l9-3.5V4h4V0h-4v2.062L4 5.593V5H0v4h4v-.719l16 4.063v.75L10.156 20H7v4h4v-3.344L20.437 14H24v-4zM14 1h2v2h-2zM3 8H1V6h2zm7 15H8v-2h2zm13-10h-2v-2h2z'
                    ></path>
                    <path
                        fillRule='evenodd'
                        d='M4 5.593V5H0v4h4v-.719l16 4.063v.75L10.156 20H7v4h4v-3.344L20.437 14H24v-4h-4v1.312L4 7.25v-.625l9-3.5V4h4V0h-4v2.062zm.3-.44 8.4-3.295V-.3h4.6v4.6h-4.6v-.736L4.3 6.83v.187l15.4 3.91V9.7h4.6v4.6h-3.767L11.3 20.81V24.3H6.7v-4.6h3.362l9.638-6.762v-.36L4.3 8.667V9.3H-.3V4.7h4.6zM15.7 1.3h-1.4v1.4h1.4zM1.3 7.7h1.4V6.3H1.3zm7 15h1.4v-1.4H8.3zm13-10h1.4v-1.4h-1.4zM14 1v2h2V1zM3 8V6H1v2zm7 15v-2H8v2zm13-10v-2h-2v2z'
                        clipRule='evenodd'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 20 20' id='lbaic-settings-magic'>
                    <path
                        d="M7.59 4.54c.498-1.458 2.513-1.502 3.104-.132l.05.133.672 1.967a3.33 3.33 0 0 0 1.897 2.009l.18.067 1.968.672c1.458.498 1.502 2.514.133 3.104l-.133.05-1.967.673a3.33 3.33 0 0 0-2.01 1.896l-.068.18-.671 1.968c-.499 1.458-2.514 1.503-3.104.133l-.051-.133-.672-1.967a3.33 3.33 0 0 0-1.897-2.01l-.18-.067-1.966-.672c-1.46-.498-1.504-2.513-.134-3.103l.134-.052 1.966-.672a3.33 3.33 0 0 0 2.01-1.896l.067-.18zm1.577.539-.671 1.966a5 5 0 0 1-2.909 3.041l-.208.076-1.967.672 1.967.671a5 5 0 0 1 3.04 2.909l.077.208.671 1.967.672-1.967a5 5 0 0 1 2.908-3.04l.209-.076 1.966-.672-1.966-.672a5 5 0 0 1-3.041-2.908l-.075-.209zm6.667-3.412a.83.83 0 0 1 .748.467l.04.097.292.855.856.292a.834.834 0 0 1 .098 1.537l-.098.04-.855.292-.292.856a.833.833 0 0 1-1.537.097l-.04-.097-.292-.855-.856-.292A.833.833 0 0 1 13.8 3.42l.098-.04.855-.292.292-.856a.83.83 0 0 1 .789-.564"
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-user'>
                    <path
                        fillRule='evenodd'
                        d='M12 5.7a3.1 3.1 0 1 0 0 6.2 3.1 3.1 0 0 0 0-6.2m-3.465-.365a4.9 4.9 0 1 1 6.93 6.93 4.9 4.9 0 0 1-6.93-6.93M7.258 16.222C8.511 15.387 10.19 14.9 12 14.9s3.489.487 4.742 1.322c1.247.831 2.158 2.078 2.158 3.578a.9.9 0 1 1-1.8 0c0-.71-.432-1.464-1.356-2.08-.919-.612-2.24-1.02-3.744-1.02s-2.825.408-3.744 1.02c-.924.616-1.356 1.37-1.356 2.08a.9.9 0 1 1-1.8 0c0-1.5.911-2.747 2.158-3.578'
                        clipRule='evenodd'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-chat'>
                    <path
                        fillRule='evenodd'
                        d='M12 5.28a6.72 6.72 0 0 0-4.777 11.447.84.84 0 0 1 .123 1.022l-.583.971H12a6.72 6.72 0 1 0 0-13.44M3.6 12a8.4 8.4 0 1 1 16.8 0 8.4 8.4 0 0 1-8.4 8.4H5.28a.84.84 0 0 1-.72-1.272l1.023-1.706A8.37 8.37 0 0 1 3.6 12'
                        clipRule='evenodd'
                    ></path>
                    <path
                        d='M9.69 12a1.05 1.05 0 1 1-2.1 0 1.05 1.05 0 0 1 2.1 0m3.36 0a1.05 1.05 0 1 1-2.1 0 1.05 1.05 0 0 1 2.1 0m3.36 0a1.05 1.05 0 1 1-2.1 0 1.05 1.05 0 0 1 2.1 0'
                    ></path>
                </symbol>

                <symbol viewBox='0 0 20 20' id='lbaic-settings-open-ai'>
                    <path
                        fill='#000'
                        d='M17.819 8.342a4.56 4.56 0 0 0-.393-3.733 4.6 4.6 0 0 0-4.95-2.205 4.612 4.612 0 0 0-7.813 1.649 4.56 4.56 0 0 0-3.04 2.205 4.6 4.6 0 0 0 .565 5.397 4.55 4.55 0 0 0 .388 3.734 4.6 4.6 0 0 0 4.954 2.205 4.56 4.56 0 0 0 3.428 1.53 4.61 4.61 0 0 0 4.39-3.198 4.56 4.56 0 0 0 3.039-2.205 4.61 4.61 0 0 0-.569-5.379m-6.86 9.588a3.4 3.4 0 0 1-2.188-.79l.108-.062 3.633-2.097a.61.61 0 0 0 .298-.518V9.34l1.537.888a.05.05 0 0 1 .028.04v4.245a3.425 3.425 0 0 1-3.417 3.417m-7.346-3.137a3.4 3.4 0 0 1-.407-2.292l.108.065 3.637 2.098a.59.59 0 0 0 .593 0l4.443-2.562v1.773a.06.06 0 0 1-.025.047l-3.68 2.122a3.42 3.42 0 0 1-4.67-1.251m-.958-7.914a3.42 3.42 0 0 1 1.799-1.5v4.316a.59.59 0 0 0 .295.515l4.422 2.55-1.536.889a.06.06 0 0 1-.054 0L3.908 11.53a3.425 3.425 0 0 1-1.253-4.67zm12.62 2.931L10.84 7.235l1.532-.886a.06.06 0 0 1 .054 0l3.673 2.123a3.417 3.417 0 0 1-.514 6.163v-4.318a.6.6 0 0 0-.31-.507m1.528-2.299-.107-.064-3.63-2.116a.59.59 0 0 0-.597 0L8.03 7.893V6.119a.05.05 0 0 1 .022-.046l3.673-2.12a3.422 3.422 0 0 1 5.08 3.544zm-9.611 3.145L5.656 9.77a.06.06 0 0 1-.029-.043V5.494a3.422 3.422 0 0 1 5.608-2.626l-.108.061-3.633 2.097a.61.61 0 0 0-.299.518zm.834-1.799 1.979-1.14 1.982 1.14v2.28l-1.975 1.141-1.982-1.14z'
                    ></path>
                </symbol>
                <defs>
                    <radialGradient
                        id='lbaic-settings-gemini-gradient'
                        cx='0'
                        cy='0'
                        r='1'
                        gradientTransform='rotate(18.683 -23.715 10.098)scale(21.2875 170.526)'
                        gradientUnits='userSpaceOnUse'
                    >
                        <stop offset='0.067' stopColor='#9168C0'></stop>
                        <stop offset='0.343' stopColor='#5684D1'></stop>
                        <stop offset='0.672' stopColor='#1BA1E3'></stop>
                    </radialGradient>
                </defs>
                <symbol viewBox='0 0 20 20' id='lbaic-settings-gemini'>
                    <path
                        fill='url(#lbaic-settings-gemini-gradient)'
                        d='M20 10.02A10.653 10.653 0 0 0 10.02 20h-.04A10.65 10.65 0 0 0 0 10.02v-.04A10.65 10.65 0 0 0 9.98 0h.04A10.65 10.65 0 0 0 20 9.98z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 20 20' id='lbaic-settings-deep-seek'>
                    <path
                        fill='#4D6BFE'
                        d='M18.81 3.99c-.19-.094-.272.084-.383.175-.039.029-.07.067-.103.102-.28.297-.605.492-1.03.47-.622-.035-1.153.16-1.622.635-.1-.586-.431-.936-.935-1.16-.264-.118-.531-.234-.716-.488-.13-.181-.165-.383-.23-.58-.04-.12-.082-.243-.219-.263-.15-.023-.208.102-.267.207a2.73 2.73 0 0 0-.316 1.38c.02 1.077.474 1.935 1.378 2.544.103.07.129.14.097.243-.062.21-.135.414-.2.624-.041.135-.102.163-.246.105a4.1 4.1 0 0 1-1.303-.885c-.642-.62-1.223-1.306-1.947-1.843a9 9 0 0 0-.517-.353c-.739-.718.098-1.308.291-1.377.203-.074.07-.324-.584-.321s-1.253.221-2.015.513q-.17.065-.35.102a7.2 7.2 0 0 0-2.161-.076c-1.414.157-2.543.826-3.373 1.967-.998 1.371-1.232 2.93-.945 4.554.302 1.713 1.177 3.131 2.52 4.24 1.393 1.15 2.998 1.713 4.828 1.605 1.112-.064 2.35-.213 3.746-1.395.352.175.721.245 1.335.297.472.045.927-.022 1.278-.096.552-.117.513-.627.315-.72-1.616-.753-1.262-.447-1.585-.695.822-.972 2.06-1.981 2.544-5.252.037-.26.005-.424 0-.634-.003-.127.026-.177.172-.192a3.1 3.1 0 0 0 1.16-.356c1.046-.572 1.47-1.511 1.569-2.638.015-.172-.003-.349-.185-.44M9.687 14.127c-1.567-1.232-2.327-1.638-2.64-1.62-.294.018-.241.353-.177.572.068.216.156.364.279.554.085.125.144.312-.085.452-.505.312-1.382-.105-1.423-.125-1.02-.601-1.875-1.395-2.476-2.48a7.6 7.6 0 0 1-.973-3.362c-.015-.29.07-.391.358-.444a3.5 3.5 0 0 1 1.146-.029c1.6.234 2.96.949 4.101 2.08.651.646 1.144 1.416 1.652 2.169.54.8 1.12 1.561 1.86 2.185.26.22.469.386.668.508-.602.068-1.605.083-2.29-.46m.75-4.83a.23.23 0 0 1 .31-.216.23.23 0 0 1 .15.216.23.23 0 0 1-.232.23.227.227 0 0 1-.229-.23m2.332 1.197c-.15.06-.3.113-.443.12a.93.93 0 0 1-.598-.19c-.206-.173-.353-.27-.414-.57a1.3 1.3 0 0 1 .012-.44c.053-.246-.006-.403-.18-.546-.14-.117-.319-.149-.515-.149a.4.4 0 0 1-.19-.058.19.19 0 0 1-.086-.269c.02-.04.12-.14.144-.157.267-.152.575-.102.86.012.263.108.463.306.75.586.293.338.346.432.514.686.132.198.252.402.334.636.05.146-.015.265-.188.339'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 20 20' id='lbaic-settings-claude'>
                    <path
                        fill='#D97757'
                        d='m4.532 12.969 3.54-1.987.06-.173-.06-.096H7.9l-.592-.036-2.023-.055-1.755-.073-1.7-.091-.428-.091L1 9.838l.041-.264.36-.242.515.046 1.14.077 1.708.119 1.24.073 1.836.191h.292l.04-.118-.1-.073-.077-.073-1.768-1.199L4.313 7.11l-1.003-.73-.542-.369-.273-.346-.119-.756.492-.543.661.046.169.045.67.515 1.43 1.108 1.869 1.376.273.228.11-.078.013-.054-.123-.206L6.924 5.51 5.839 3.641l-.483-.775-.127-.465a2.2 2.2 0 0 1-.078-.547l.56-.76.31-.1.748.1.315.273.464 1.062L8.3 4.1l1.167 2.274.342.674.182.625.068.191h.119v-.11l.095-1.28.178-1.572.173-2.023.06-.57.282-.683.56-.37.438.21.36.515-.05.333-.214 1.39-.42 2.178-.273 1.458h.16l.182-.182.738-.98 1.24-1.55.546-.615.638-.679.41-.323h.775l.57.848-.255.874-.798 1.012-.66.857-.948 1.276-.593 1.02.055.083.141-.014 2.142-.456 1.157-.21 1.381-.236.624.291.069.296-.246.607-1.477.364-1.731.346-2.58.611-.032.023.037.045 1.162.11.497.027h1.216l2.265.169.593.392.355.478-.06.365-.91.464-1.231-.291-2.87-.684-.985-.246h-.137v.082l.82.802 1.504 1.358 1.882 1.75.096.433-.242.342-.255-.037-1.654-1.244-.638-.56-1.445-1.217h-.095v.128l.332.487 1.76 2.643.09.811-.127.265-.456.16-.501-.092-1.03-1.445-1.062-1.626-.856-1.459-.105.06-.506 5.445-.237.278-.547.21-.455-.347-.242-.56.241-1.107.292-1.445.237-1.148.214-1.427.128-.474-.01-.031-.104.013-1.075 1.477-1.636 2.21-1.295 1.385-.31.123-.537-.278.05-.497.3-.442 1.792-2.278 1.08-1.413.697-.815-.005-.119h-.04l-4.758 3.09-.848.11-.365-.343.046-.56.173-.182 1.431-.985z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 48 48' id='lbaic-settings-grok'>
                    <path
                        fill='#000000'
                        d="M18.542 30.532l15.956-11.776c.783-.576 1.902-.354 2.274.545 1.962 4.728 1.084 10.411-2.819 14.315-3.903 3.901-9.333 4.756-14.299 2.808l-5.423 2.511c7.778 5.315 17.224 4 23.125-1.903 4.682-4.679 6.131-11.058 4.775-16.812l.011.011c-1.966-8.452.482-11.829 5.501-18.735C47.759 1.332 47.88 1.166 48 1l-6.602 6.599V7.577l-22.86 22.958M15.248 33.392c-5.582-5.329-4.619-13.579.142-18.339 3.521-3.522 9.294-4.958 14.331-2.847l5.412-2.497c-.974-.704-2.224-1.46-3.659-1.994-6.478-2.666-14.238-1.34-19.505 3.922C6.904 16.701 5.31 24.488 8.045 31.133c2.044 4.965-1.307 8.48-4.682 12.023C2.164 44.411.967 45.67 0 47l15.241-13.608"/>
                </symbol>

                <symbol viewBox='0 0 24 24' id='lbaic-settings-theme-dark'>
                    <path
                        d='M12.12 24c-1.68 0-3.255-.32-4.725-.96a12.335 12.335 0 01-3.84-2.595 12.335 12.335 0 01-2.595-3.84C.32 15.135 0 13.56 0 11.88c0-2.92.93-5.495 2.79-7.725C4.65 1.925 7.02.54 9.9 0a12.12 12.12 0 00.33 5.805 11.84 11.84 0 003 4.965 11.84 11.84 0 004.965 3c1.89.58 3.825.69 5.805.33-.52 2.88-1.9 5.25-4.14 7.11-2.24 1.86-4.82 2.79-7.74 2.79z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-theme-light'>
                    <path
                        d='M12 4.364c-.31 0-.568-.105-.777-.314a1.055 1.055 0 01-.314-.777V1.09c0-.31.105-.568.314-.777C11.432.104 11.69 0 12 0c.31 0 .568.105.777.314.21.209.314.468.314.777v2.182c0 .309-.105.568-.314.777-.209.21-.468.314-.777.314zM17.4 6.6c-.2-.2-.3-.45-.3-.75s.1-.56.3-.777l1.527-1.555c.218-.218.477-.327.777-.327.3 0 .56.109.778.327.2.2.3.455.3.764s-.1.563-.3.763L18.927 6.6c-.2.2-.454.3-.763.3-.31 0-.564-.1-.764-.3zm3.327 6.49c-.309 0-.568-.104-.777-.313a1.056 1.056 0 01-.314-.777c0-.31.105-.568.314-.777.21-.21.468-.314.777-.314h2.182c.31 0 .568.105.777.314.21.209.314.468.314.777 0 .31-.105.568-.314.777-.209.21-.468.314-.777.314h-2.182zM12 24c-.31 0-.568-.105-.777-.314a1.056 1.056 0 01-.314-.777v-2.182c0-.309.105-.568.314-.777.209-.21.468-.314.777-.314.31 0 .568.105.777.314.21.21.314.468.314.777v2.182c0 .31-.105.568-.314.777-.209.21-.468.314-.777.314zM5.073 6.6L3.518 5.073a1.078 1.078 0 01-.327-.791c0-.31.109-.564.327-.764.2-.2.455-.3.764-.3s.563.1.763.3L6.6 5.073c.2.2.3.454.3.763 0 .31-.1.564-.3.764-.218.2-.473.3-.764.3-.29 0-.545-.1-.763-.3zm13.854 13.882L17.4 18.927c-.2-.218-.3-.477-.3-.777 0-.3.1-.55.3-.75.2-.2.45-.3.75-.3s.56.1.777.3l1.555 1.527a.95.95 0 01.314.764c-.01.309-.114.573-.314.79a1.077 1.077 0 01-.791.328.99.99 0 01-.764-.327zM1.091 13.09c-.31 0-.568-.105-.777-.314A1.056 1.056 0 010 12c0-.31.105-.568.314-.777.209-.21.468-.314.777-.314h2.182c.309 0 .568.105.777.314.21.209.314.468.314.777 0 .31-.105.568-.314.777-.21.21-.468.314-.777.314H1.09zm2.427 7.39c-.2-.2-.3-.454-.3-.763s.1-.564.3-.764L5.073 17.4c.2-.2.45-.3.75-.3s.559.1.777.3c.218.218.327.477.327.777 0 .3-.109.56-.327.777l-1.527 1.528a1.077 1.077 0 01-.791.327.99.99 0 01-.764-.327zM12 18.546c-1.818 0-3.364-.636-4.636-1.909-1.273-1.272-1.91-2.818-1.91-4.636s.637-3.364 1.91-4.636C8.636 6.09 10.182 5.454 12 5.454s3.364.637 4.636 1.91c1.273 1.272 1.91 2.818 1.91 4.636s-.637 3.364-1.91 4.636c-1.272 1.273-2.818 1.91-4.636 1.91z'
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-theme-system'>
                    <path
                        d='M12.025 19a6.958 6.958 0 01-2.675-.525 6.916 6.916 0 01-2.275-1.525A6.917 6.917 0 015.025 12c0-.85.142-1.662.425-2.438.283-.774.7-1.479 1.25-2.112a.777.777 0 01.8-.237c.317.074.542.279.675.612.35.917.787 1.783 1.313 2.6a13.648 13.648 0 001.837 2.275c.7.7 1.458 1.313 2.275 1.838.817.524 1.683.962 2.6 1.312.333.133.538.358.613.675a.777.777 0 01-.238.8 6.714 6.714 0 01-2.112 1.25 7.044 7.044 0 01-2.438.425zm5.575-4.8a.901.901 0 01-.575-.512 1.357 1.357 0 01-.1-.813c.15-.8.1-1.588-.15-2.363a5.028 5.028 0 00-1.25-2.037 4.933 4.933 0 00-2.013-1.237 4.837 4.837 0 00-2.312-.163 1.31 1.31 0 01-.8-.1.993.993 0 01-.525-.575.932.932 0 01.037-.775.865.865 0 01.588-.475c1.15-.25 2.3-.213 3.45.112 1.15.326 2.158.921 3.025 1.788.85.85 1.442 1.85 1.775 3 .333 1.15.375 2.3.125 3.45a.912.912 0 01-.475.625c-.25.133-.517.158-.8.075zM12 3a.968.968 0 01-.713-.288A.967.967 0 0111 2V1c0-.283.096-.52.287-.713A.968.968 0 0112 0c.283 0 .52.096.713.287.191.192.287.43.287.713v1c0 .283-.096.52-.287.712A.968.968 0 0112 3zm0 21a.968.968 0 01-.713-.288A.968.968 0 0111 23v-1c0-.283.096-.52.287-.712A.968.968 0 0112 21c.283 0 .52.096.713.288.191.191.287.429.287.712v1c0 .283-.096.52-.287.712A.968.968 0 0112 24zm6.375-18.35c-.2-.2-.3-.438-.3-.713 0-.275.1-.512.3-.712l.7-.7a.933.933 0 01.688-.275c.274 0 .512.092.712.275.2.2.3.438.3.712 0 .276-.1.513-.3.713l-.7.7c-.2.2-.433.3-.7.3a.96.96 0 01-.7-.3zM3.525 20.475c-.2-.2-.3-.438-.3-.713 0-.274.1-.512.3-.712l.7-.7c.2-.2.433-.3.7-.3.267 0 .5.1.7.3.2.2.3.438.3.712 0 .275-.1.513-.3.713l-.7.7a.933.933 0 01-.688.275c-.275 0-.512-.092-.712-.275zM22 13a.968.968 0 01-.712-.287A.968.968 0 0121 12c0-.283.096-.52.288-.713A.968.968 0 0122 11h1c.283 0 .52.096.712.287.192.192.288.43.288.713s-.096.52-.288.713A.968.968 0 0123 13h-1zM1 13a.967.967 0 01-.713-.287A.968.968 0 010 12c0-.283.096-.52.287-.713A.967.967 0 011 11h1c.283 0 .52.096.712.287.192.192.288.43.288.713s-.096.52-.288.713A.967.967 0 012 13H1zm19.475 7.475c-.2.2-.438.3-.713.3a.973.973 0 01-.712-.3l-.7-.7a.96.96 0 01-.3-.7c0-.267.1-.5.3-.7.2-.2.438-.3.712-.3.275 0 .513.1.713.3l.7.7a.933.933 0 01.275.688c0 .274-.092.512-.275.712zM5.65 5.625c-.2.2-.438.3-.713.3a.973.973 0 01-.712-.3l-.7-.7a.933.933 0 01-.275-.688c0-.275.092-.512.275-.712.2-.2.438-.3.712-.3.276 0 .513.1.713.3l.7.7c.2.2.3.433.3.7 0 .267-.1.5-.3.7z'
                    ></path>
                </symbol>

                <symbol id='lbaic-settings-size-sm' viewBox='0 0 24 24'>
                    <path
                        fillOpacity='0.4'
                        fillRule='evenodd'
                        d='M21 3H3a1 1 0 00-1 1v16a1 1 0 001 1h18a1 1 0 001-1V4a1 1 0 00-1-1zM3 2a2 2 0 00-2 2v16a2 2 0 002 2h18a2 2 0 002-2V4a2 2 0 00-2-2H3z'
                        clipRule='evenodd'
                    ></path>
                    <rect
                        width='8'
                        height='9'
                        x='12.5'
                        y='11'
                        fillOpacity='0.8'
                        rx='1'
                    ></rect>
                </symbol>
                <symbol id='lbaic-settings-size-md' viewBox='0 0 24 24'>
                    <path
                        fillOpacity='0.4'
                        fillRule='evenodd'
                        d='M21 3H3a1 1 0 00-1 1v16a1 1 0 001 1h18a1 1 0 001-1V4a1 1 0 00-1-1zM3 2a2 2 0 00-2 2v16a2 2 0 002 2h18a2 2 0 002-2V4a2 2 0 00-2-2H3z'
                        clipRule='evenodd'
                    ></path>
                    <rect width='8' height='12' x='13' y='8' rx='1'></rect>
                </symbol>
                <symbol id='lbaic-settings-size-lg' viewBox='0 0 24 24'>
                    <path
                        fillOpacity='0.4'
                        fillRule='evenodd'
                        d='M21 3H3a1 1 0 00-1 1v16a1 1 0 001 1h18a1 1 0 001-1V4a1 1 0 00-1-1zM3 2a2 2 0 00-2 2v16a2 2 0 002 2h18a2 2 0 002-2V4a2 2 0 00-2-2H3z'
                        clipRule='evenodd'
                    ></path>
                    <rect
                        width='8'
                        height='16'
                        x='12.5'
                        y='4'
                        fillOpacity='0.8'
                        rx='1'
                    ></rect>
                </symbol>
                <symbol id='lbaic-settings-size-xl' viewBox='0 0 24 24'>
                    <path
                        fillOpacity='0.4'
                        fillRule='evenodd'
                        d='M21 3H3a1 1 0 00-1 1v16a1 1 0 001 1h18a1 1 0 001-1V4a1 1 0 00-1-1zM3 2a2 2 0 00-2 2v16a2 2 0 002 2h18a2 2 0 002-2V4a2 2 0 00-2-2H3z'
                        clipRule='evenodd'
                    ></path>
                    <rect
                        width='14'
                        height='11'
                        x='7'
                        y='9'
                        fillOpacity='0.8'
                        rx='1'
                    ></rect>
                </symbol>

                <symbol id='lbaic-settings-shape-squircle' viewBox='0 0 70 40'>
                    <path
                        d='M21.534 7.449c5.296-4.593 21.61-4.604 26.73 0 4.65 4.18 4.763 21.209 0 25.216-5.284 4.443-21.597 4.451-26.73 0-4.711-4.086-4.712-21.13 0-25.216'
                    />
                </symbol>
                <symbol id='lbaic-settings-shape-circle' viewBox='0 0 70 40'>
                    <rect width='32' height='32' x='19' y='4' rx='16'></rect>
                </symbol>
                <symbol id='lbaic-settings-shape-drop' viewBox='0 0 70 40'>
                    <path
                        d='M19 20c0-8.837 7.163-16 16-16h14a2 2 0 0 1 2 2v14c0 8.837-7.163 16-16 16s-16-7.163-16-16'
                    ></path>
                </symbol>

                {/*Chatbot Avatars Start*/}
                <symbol id='lbaic-settings-chatbot-avatar-1' viewBox='0 0 16 16'>
                    <path
                        fillRule="evenodd"
                        d="m9.968 1.235-.57-.57a2.275 2.275 0 0 0-3.215 0L.667 6.175c-.89.889-.89 2.33 0 3.218l6.162 6.156a1.538 1.538 0 1 0 2.175-2.175L5.02 9.394a2.273 2.273 0 0 1 0-3.217L7.788 3.41h.002l2.175-2.174zm-1.423 2.93 2.475 2.472a1.62 1.62 0 0 1 0 2.293l-.059.059a1.537 1.537 0 1 0 2.175 2.175l1.775-1.772c.89-.889.89-2.33 0-3.218l-4.19-4.186-2.176 2.176"
                        clipRule="evenodd"
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-chatbot-avatar-2'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <path d="M12 8V4H8"></path>
                    <rect width="16" height="12" x="4" y="8" rx="2"></rect>
                    <path d="M2 14h2M20 14h2M15 13v2M9 13v2"></path>
                </symbol>
                <symbol id='lbaic-settings-chatbot-avatar-3' viewBox='0 0 16 16'>
                    <path
                        d='M8.488 1.016a7.03 7.03 0 0 0-5.44 2.037 7.02 7.02 0 0 0-2.031 5.445C1.274 12.205 4.548 15 8.632 15h3.452a2.92 2.92 0 0 0 2.917-2.917V8.198c0-3.779-2.86-6.934-6.513-7.182m-2.53 4.65a.875.875 0 1 1 0 1.751.875.875 0 0 1 0-1.75m4.787 4.206c-.043.043-1.074 1.045-2.744 1.045S5.299 9.916 5.256 9.872a.583.583 0 1 1 .822-.829c.027.027.746.706 1.923.706 1.176 0 1.895-.68 1.926-.709a.584.584 0 0 1 .818.832m-.703-2.456a.875.875 0 1 1 .001-1.75.875.875 0 0 1 0 1.75'
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-chatbot-avatar-4' viewBox='0 0 16 16'>
                    <path
                        fillRule='evenodd'
                        d='M7.998 2.719a5.84 5.84 0 0 0-5.274 3.318c-.049-.005-.096-.015-.146-.015C1.703 6.022 1 6.726 1 7.6v1.95c0 .875.703 1.579 1.578 1.579.05 0 .097-.01.146-.015q.093.196.201.387c.287.511 1.053.073.758-.433a4.984 4.984 0 0 1 1.113-6.315 4.98 4.98 0 0 1 6.408 0 4.984 4.984 0 0 1 1.113 6.315l-.013.021-.008.022s-.589 1.302-1.744 1.302l-1.462-.014a.75.75 0 0 0-.62-.34h-.942a.76.76 0 0 0-.763.765c0 .26.166.458.545.458h3.242c1.734 0 2.483-1.701 2.518-1.78v-.005a6 6 0 0 0 .199-.384c.05.004.1.015.153.015.874 0 1.578-.704 1.578-1.579V7.6c0-.874-.704-1.578-1.578-1.578-.05 0-.098.008-.148.015a5.8 5.8 0 0 0-1.51-1.95 5.85 5.85 0 0 0-3.767-1.369zM6.095 5.49c-.34-.022-.65.05-.92.336a4.23 4.23 0 0 0-1.17 2.9c0 .911.303 1.931.816 1.968.73.053 1.882-.426 3.179-.426 1.374 0 2.587.538 3.306.41.436-.077.69-1.118.69-1.951 0-1.104-.447-2.14-1.17-2.901-.724-.762-1.723 0-2.826 0-.69 0-1.338-.298-1.905-.336m-.161 1.877a.73.73 0 1 1-.001 1.46.73.73 0 0 1 0-1.46m4.132 0a.73.73 0 1 1 0 1.46.73.73 0 0 1 0-1.46'
                        clipRule='evenodd'
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-chatbot-avatar-5' viewBox='0 0 16 16'>
                    <path
                        d='M8 8c1.99 0 3.61-1.57 3.61-3.5S9.99 1 8 1 4.39 2.57 4.39 4.5 6.01 8 8 8m0-5.25c.995 0 1.805.785 1.805 1.75S8.995 6.25 8 6.25 6.195 5.465 6.195 4.5 7.005 2.75 8 2.75M10.968 14c.072.479-.215 1-.894 1a.894.894 0 0 1-.891-.75c-.086-.57-.594-1-1.182-1-.59 0-1.098.43-1.182 1a.897.897 0 0 1-1.022.74.88.88 0 0 1-.764-.99C5.245 12.575 6.52 11.5 8 11.5s2.756 1.074 2.968 2.5zm3.03.074a.885.885 0 0 1-.901.926.89.89 0 0 1-.9-.824c-.13-2.155-1.973-3.843-4.197-3.843s-4.068 1.688-4.197 3.843c-.029.482-.457.847-.953.822a.885.885 0 0 1-.848-.924c.185-3.08 2.82-5.491 5.998-5.491s5.813 2.412 5.999 5.491'
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-chatbot-avatar-6' viewBox='0 0 16 16'>
                    <path
                        d='M13.25 7.323c.37.062.72-.251.734-.627a14.6 14.6 0 0 0-.053-2.1c-.036-.383-.433-.69-.804-.57-.54-2.305-2.18-3.36-5.128-3.36s-4.587 1.055-5.128 3.36c-.377-.12-.768.187-.804.57a15 15 0 0 0-.052 2.101c.014.375.364.688.734.626.175 1.284.632 2.238 1.392 2.894-1.32.828-2.01 2.252-2.124 4.414a.667.667 0 0 0 1.331.071c.11-2.09.778-3.2 2.216-3.7.683.222 1.491.331 2.435.331q1.415.001 2.444-.335l.002.002c1.434.501 2.094 1.609 2.204 3.702a.667.667 0 0 0 1.332-.07c-.114-2.164-.804-3.587-2.124-4.415.759-.656 1.217-1.61 1.392-2.894M8 10c-2.953 0-4-1.047-4-4s1.047-4 4-4 4 1.047 4 4-1.047 4-4 4m2.667-4c0 1.905-.762 2.667-2.667 2.667S5.333 7.905 5.333 6c0-.667.667-.667.667-.667h4s.667 0 .667.667m.436 7.387c.014.048.152.496.207 1.229a.667.667 0 0 1-1.33.101 6 6 0 0 0-.07-.568 11 11 0 0 0-1.91-.15c-.89 0-1.536.084-1.91.15-.026.149-.053.341-.07.568a.666.666 0 1 1-1.329-.101c.056-.733.192-1.18.208-1.229a.67.67 0 0 1 .448-.44c.04-.011.978-.28 2.654-.28s2.616.269 2.654.28a.67.67 0 0 1 .449.44z'
                    ></path>
                </symbol>
                {/*Chatbot Avatars End*/}

                {/*Chatbot Icons Start*/}
                <symbol id='lbaic-settings-chatbot-icon-1' viewBox='0 0 16 16'>
                    <path
                        d="M13.035 1H2.965C1.88 1 1 1.913 1 3.04v7.26l.001.05H1v4.232c0 .353.396.547.658.321l2.983-2.563h8.394c1.085 0 1.965-.914 1.965-2.04V3.04C15 1.913 14.12 1 13.035 1"
                    ></path>
                    <path
                        fill='#fff'
                        d="M9.63 7.346c0 .17-.132.308-.296.308H4.192v-.68c0-.2.155-.36.347-.36H9.63zM11.709 4.999c0 .174-.133.316-.296.316H4.2v-.7c0-.204.155-.369.346-.369h7.162z"
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-chatbot-icon-2' viewBox='0 0 16 16'>
                    <path
                        d='M12.855 11.05a6.14 6.14 0 0 0 1.412-3.916A6.14 6.14 0 0 0 8.134 1 6.14 6.14 0 0 0 2 7.134a6.14 6.14 0 0 0 8.27 5.751q.03-.01.06-.01.04 0 .08.019L14.445 15l-1.617-3.773a.17.17 0 0 1 .026-.177M6.07 7.82a.688.688 0 1 1 0-1.375.688.688 0 0 1 0 1.375m2.063 0a.688.688 0 1 1 0-1.375.688.688 0 0 1 0 1.375m2.062 0a.688.688 0 1 1 .001-1.375.688.688 0 0 1 0 1.375'
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-chatbot-icon-3' viewBox='0 0 16 16'>
                    <path
                        d='M13.256 11.733c.834-.744 1.307-1.735 1.307-2.764 0-1.094-.512-2.116-1.442-2.88-.904-.742-2.101-1.152-3.371-1.152s-2.467.41-3.371 1.153c-.93.763-1.441 1.785-1.441 2.879 0 1.093.511 2.116 1.44 2.88C7.284 12.59 8.48 13 9.75 13q.255 0 .508-.022l.289.25a5.47 5.47 0 0 0 3.578 1.335h.438v-.932l-.129-.128a5.45 5.45 0 0 1-1.178-1.77m-2.136.833-.579-.501-.193.024a5 5 0 0 1-.598.036c-2.171 0-3.937-1.416-3.937-3.156S7.579 5.813 9.75 5.813s3.938 1.415 3.938 3.156c0 .867-.433 1.676-1.219 2.28l-.252.192.117.33c.238.672.588 1.299 1.036 1.854a4.6 4.6 0 0 1-2.25-1.059'></path>
                    <path
                        d='M2.646 9.681c.41-.518.73-1.1.951-1.723l.116-.328-.252-.193c-.74-.568-1.148-1.331-1.148-2.148 0-1.641 1.668-2.976 3.718-2.976 1.509 0 2.81.722 3.393 1.758a7 7 0 0 1 .978.023 3.8 3.8 0 0 0-1.154-1.557c-.863-.71-2.005-1.1-3.217-1.1-1.211 0-2.353.39-3.216 1.1-.888.73-1.377 1.707-1.377 2.752 0 .979.447 1.922 1.237 2.632a5.2 5.2 0 0 1-1.11 1.66l-.127.128v.916h.437c.809 0 1.607-.188 2.33-.55a4.3 4.3 0 0 1-.138-.92 4.3 4.3 0 0 1-1.421.526'></path>
                </symbol>
                <symbol id='lbaic-settings-chatbot-icon-4' viewBox='0 0 16 16'>
                    <path
                        fillRule='evenodd'
                        d='M1 2.4A1.4 1.4 0 0 1 2.4 1h11.208a1.4 1.4 0 0 1 1.4 1.4v8.4a1.4 1.4 0 0 1-1.4 1.4h-3.485l-1.73 2.592a.467.467 0 0 1-.777 0l-1.729-2.591H2.401A1.4 1.4 0 0 1 1 10.8zm3.736 5.137h.934v-.933h-.934zm2.801 0h.934v-.933h-.934zm3.736 0h-.934v-.933h.934z'
                        clipRule='evenodd'
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-chatbot-icon-5' viewBox='0 0 16 16'>
                    <path
                        fillRule='evenodd'
                        d='M14.336 12.01c-.345.262-.799.484-1.324.668v2a.323.323 0 0 1-.484.277l-2.839-1.66c-.421.029-.85.043-1.277.043-2.37 0-4.729-.442-5.856-1.329-2.05-1.612-2.1-8.177 0-9.723C3.72 1.43 6.1 1 8.473 1c2.37 0 4.733.429 5.863 1.287 2.076 1.575 2.077 8.147 0 9.723m-2.324 1.485-2.083-1.218-.307.02q-.601.041-1.21.041c-1.128 0-2.238-.105-3.183-.31-.97-.208-1.667-.5-2.055-.805-.276-.217-.585-.699-.82-1.483-.228-.758-.351-1.68-.354-2.62s.115-1.856.34-2.6c.232-.772.538-1.23.809-1.428.411-.304 1.133-.588 2.115-.791a16 16 0 0 1 3.052-.3h.158c1.13 0 2.243.102 3.192.3.973.203 1.675.486 2.066.783.273.207.58.675.814 1.453.227.751.347 1.67.347 2.611s-.12 1.86-.347 2.611c-.234.778-.541 1.247-.814 1.454-.234.178-.583.357-1.051.522l-.669.235z'
                        clipRule='evenodd'
                    ></path>
                    <path
                        d='M5.974 7.358a.825.825 0 1 0-1.605-.382.825.825 0 1 0 1.605.382M9.113 7.752a.83.83 0 0 0 0-1.169.824.824 0 0 0-1.166 0 .83.83 0 0 0 0 1.17.824.824 0 0 0 1.166 0M12.527 7.299a.825.825 0 1 0-1.629-.266.825.825 0 1 0 1.629.266'
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-chatbot-icon-6' viewBox='0 0 16 16'>
                    <path
                        d='M8.583 1H3.917A2.92 2.92 0 0 0 1 3.916v7.497a1.252 1.252 0 0 0 1.948 1.043l2.312-1.541h3.323A2.92 2.92 0 0 0 11.5 7.999V3.916A2.92 2.92 0 0 0 8.583 1M15 6.25v7.496a1.252 1.252 0 0 1-1.948 1.044l-2.312-1.542H7.417a2.9 2.9 0 0 1-2.136-.945l.332-.222h2.97A4.09 4.09 0 0 0 12.667 8V3.916c0-.18-.016-.354-.038-.528A2.92 2.92 0 0 1 15 6.249'
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-chatbot-icon-7' viewBox='0 0 16 16'>
                    <path
                        d='M15 10.332v2.917A1.75 1.75 0 0 1 13.25 15h-2.917a4.67 4.67 0 0 1-4.036-2.336 6.4 6.4 0 0 0 1.308-.144 3.5 3.5 0 0 0 2.728 1.313h2.917a.583.583 0 0 0 .583-.583v-2.917a3.5 3.5 0 0 0-1.313-2.728 6.4 6.4 0 0 0 .144-1.308A4.67 4.67 0 0 1 15 10.332M5.747 11.5H3.136A2.14 2.14 0 0 1 1 9.361V6.42C1 3.677 3.23 1.2 5.87 1.013c3.1-.294 5.907 2.518 5.617 5.617-.194 2.731-2.714 4.87-5.74 4.87m4.576-4.952c.214-2.304-1.772-4.431-4.08-4.381-2.179-.022-4.076 1.996-4.076 4.256V9.36c0 .536.434.971.969.971h2.611c2.376 0 4.429-1.698 4.576-3.785M6.25 5.374a.875.875 0 1 0 0 1.75.875.875 0 0 0 0-1.75m-2.333 0a.875.875 0 1 0 0 1.75.875.875 0 0 0 0-1.75m4.666 0a.875.875 0 1 0 .001 1.75.875.875 0 0 0 0-1.75'
                    ></path>
                </symbol>
                {/*Chatbot Icons End*/}

                <symbol id='lbaic-settings-drag-indicator' viewBox='0 0 24 24'>
                    <path
                        d='M8.998 19.998c-.55 0-1.02-.195-1.412-.587a1.926 1.926 0 01-.588-1.413c0-.55.196-1.02.588-1.412a1.926 1.926 0 011.412-.588c.55 0 1.021.196 1.413.588.392.392.587.862.587 1.412 0 .55-.195 1.021-.587 1.413a1.926 1.926 0 01-1.413.587zm6 0c-.55 0-1.02-.195-1.412-.587a1.926 1.926 0 01-.588-1.413c0-.55.196-1.02.588-1.412a1.926 1.926 0 011.412-.588c.55 0 1.021.196 1.413.588.392.392.587.862.587 1.412 0 .55-.195 1.021-.587 1.413a1.926 1.926 0 01-1.413.587zm-6-6c-.55 0-1.02-.195-1.412-.587a1.926 1.926 0 01-.588-1.413c0-.55.196-1.02.588-1.412a1.926 1.926 0 011.412-.588c.55 0 1.021.196 1.413.588.392.392.587.862.587 1.412 0 .55-.195 1.021-.587 1.413a1.926 1.926 0 01-1.413.587zm6 0c-.55 0-1.02-.195-1.412-.587a1.926 1.926 0 01-.588-1.413c0-.55.196-1.02.588-1.412a1.926 1.926 0 011.412-.588c.55 0 1.021.196 1.413.588.392.392.587.862.587 1.412 0 .55-.195 1.021-.587 1.413a1.926 1.926 0 01-1.413.587zm-6-6c-.55 0-1.02-.195-1.412-.587a1.926 1.926 0 01-.588-1.413c0-.55.196-1.02.588-1.412a1.926 1.926 0 011.412-.588c.55 0 1.021.196 1.413.588.392.392.587.862.587 1.412 0 .55-.195 1.021-.587 1.413a1.926 1.926 0 01-1.413.587zm6 0c-.55 0-1.02-.195-1.412-.587a1.926 1.926 0 01-.588-1.413c0-.55.196-1.02.588-1.412a1.926 1.926 0 011.412-.588c.55 0 1.021.196 1.413.588.392.392.587.862.587 1.412 0 .55-.195 1.021-.587 1.413a1.926 1.926 0 01-1.413.587z'
                    ></path>
                </symbol>


                {/*gradient*/}
                <defs>
                    <linearGradient
                        id="lbaic-settings-icon-gradient"
                        x1="4.295"
                        x2="4.295"
                        y1="0"
                        y2="16.018"
                        gradientUnits="userSpaceOnUse"
                    >
                        <stop stopColor="#458CF5"></stop>
                        <stop offset="1" stopColor="#193154"></stop>
                    </linearGradient>
                </defs>
                <symbol id="lbaic-settings-match-case" viewBox="0 0 24 24">
                    <path
                        fillRule="evenodd"
                        d="M12 1c6.075 0 11 4.925 11 11s-4.925 11-11 11S1 18.075 1 12 5.925 1 12 1m0 1c5.523 0 10 4.477 10 10s-4.477 10-10 10S2 17.523 2 12 6.477 2 12 2M8.18 13.465h-.01l-.002.008-.564 1.567a.58.58 0 0 1-.224.294.6.6 0 0 1-.345.103.58.58 0 0 1-.51-.267.56.56 0 0 1-.06-.561l2.43-6.482a.6.6 0 0 1 .234-.302.6.6 0 0 1 .354-.112h.493q.19 0 .363.112a.6.6 0 0 1 .242.302l2.43 6.5a.53.53 0 0 1-.068.551.59.59 0 0 1-.501.26.57.57 0 0 1-.345-.113.63.63 0 0 1-.225-.302l-.546-1.55-.003-.009H8.18m.393-1.12-.006.017h2.343l-.006-.016L9.777 9.14l-.003-.008h-.089l-.003.008zm8.637.016.017.008v-.23q0-.516-.365-.838-.366-.32-.968-.32-.267 0-.524.08a1.5 1.5 0 0 0-.47.24q-.225.173-.42.12a.6.6 0 0 1-.32-.189.48.48 0 0 1-.12-.326q-.001-.187.188-.325.351-.28.789-.412t.894-.132q1.213 0 1.806.57.595.567.595 1.708v2.589a.5.5 0 0 1-.164.378.54.54 0 0 1-.387.155.5.5 0 0 1-.379-.163.54.54 0 0 1-.155-.388v-.101h-.082v-.011l-.011.018a1.6 1.6 0 0 1-.665.611q-.42.21-.927.21-.896 0-1.419-.48-.524-.481-.524-1.268 0-.769.603-1.268.605-.498 1.55-.499.405 0 .791.07.387.071.667.193m.035.905h.012l-.019-.011a2.2 2.2 0 0 0-.593-.222 3 3 0 0 0-.68-.08q-.568 0-.889.25a.8.8 0 0 0-.322.662.73.73 0 0 0 .287.59q.286.232.712.232.622 0 1.057-.426t.435-.995"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-attach-money" viewBox="0 0 9 17">
                    <path
                        d="M4.202 16.019a.86.86 0 0 1-.634-.256.86.86 0 0 1-.256-.634v-1.024a4.6 4.6 0 0 1-1.758-.779Q.798 12.77.331 11.77a.75.75 0 0 1-.011-.656.92.92 0 0 1 .522-.5.78.78 0 0 1 .646.01q.334.145.511.479.378.667.957 1.012t1.424.345q.912 0 1.546-.412.634-.41.634-1.279 0-.779-.49-1.235-.489-.456-2.269-1.034-1.912-.601-2.625-1.435Q.465 6.23.464 5.028q0-1.446.935-2.247.934-.801 1.913-.912v-.98q0-.377.256-.633A.86.86 0 0 1 4.202 0q.378 0 .634.256.255.255.256.634v.979q.845.133 1.468.545t1.024 1.012q.2.29.077.645a.83.83 0 0 1-.5.512.85.85 0 0 1-.645.011 1.6 1.6 0 0 1-.623-.434 2 2 0 0 0-.679-.478q-.39-.167-.968-.167-.979 0-1.49.434-.512.434-.512 1.079 0 .734.668 1.157.667.422 2.313.89 1.536.444 2.325 1.413.79.967.79 2.236 0 1.58-.934 2.402-.935.823-2.314 1.024v.979a.86.86 0 0 1-.256.634.86.86 0 0 1-.634.255"
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-history' viewBox='0 0 24 24'>
                    <path
                        d="M12.834 20C10.9673 20 9.31547 19.4333 7.87843 18.3C6.44139 17.1667 5.50806 15.7185 5.07843 13.9556C5.01917 13.7333 5.06361 13.5296 5.21176 13.3444C5.35991 13.1593 5.55991 13.0519 5.81176 13.0222C6.0488 12.9926 6.26361 13.037 6.45621 13.1556C6.6488 13.2741 6.78213 13.4519 6.85621 13.6889C7.21176 15.0222 7.9451 16.1111 9.05621 16.9556C10.1673 17.8 11.4266 18.2222 12.834 18.2222C14.5673 18.2222 16.0377 17.6185 17.2451 16.4111C18.4525 15.2037 19.0562 13.7333 19.0562 12C19.0562 10.2667 18.4525 8.7963 17.2451 7.58889C16.0377 6.38148 14.5673 5.77778 12.834 5.77778C11.8118 5.77778 10.8562 6.01481 9.96732 6.48889C9.07843 6.96296 8.33028 7.61481 7.72287 8.44444H9.27843C9.53028 8.44444 9.74139 8.52963 9.91176 8.7C10.0821 8.87037 10.1673 9.08148 10.1673 9.33333C10.1673 9.58519 10.0821 9.7963 9.91176 9.96667C9.74139 10.137 9.53028 10.2222 9.27843 10.2222H5.72287C5.47102 10.2222 5.25991 10.137 5.08954 9.96667C4.91917 9.7963 4.83398 9.58519 4.83398 9.33333V5.77778C4.83398 5.52593 4.91917 5.31481 5.08954 5.14444C5.25991 4.97407 5.47102 4.88889 5.72287 4.88889C5.97473 4.88889 6.18584 4.97407 6.35621 5.14444C6.52658 5.31481 6.61176 5.52593 6.61176 5.77778V6.97778C7.36732 6.02963 8.28954 5.2963 9.37843 4.77778C10.4673 4.25926 11.6192 4 12.834 4C13.9451 4 14.9858 4.21111 15.9562 4.63333C16.9266 5.05556 17.771 5.62593 18.4895 6.34444C19.2081 7.06296 19.7784 7.90741 20.2007 8.87778C20.6229 9.84815 20.834 10.8889 20.834 12C20.834 13.1111 20.6229 14.1519 20.2007 15.1222C19.7784 16.0926 19.2081 16.937 18.4895 17.6556C17.771 18.3741 16.9266 18.9444 15.9562 19.3667C14.9858 19.7889 13.9451 20 12.834 20ZM13.7229 11.6444L15.9451 13.8667C16.1081 14.0296 16.1895 14.237 16.1895 14.4889C16.1895 14.7407 16.1081 14.9481 15.9451 15.1111C15.7821 15.2741 15.5747 15.3556 15.3229 15.3556C15.071 15.3556 14.8636 15.2741 14.7007 15.1111L12.2118 12.6222C12.1229 12.5333 12.0562 12.4333 12.0118 12.3222C11.9673 12.2111 11.9451 12.0963 11.9451 11.9778V8.44444C11.9451 8.19259 12.0303 7.98148 12.2007 7.81111C12.371 7.64074 12.5821 7.55556 12.834 7.55556C13.0858 7.55556 13.2969 7.64074 13.4673 7.81111C13.6377 7.98148 13.7229 8.19259 13.7229 8.44444V11.6444Z"
                    />
                </symbol>

                {/*delete when added new history icon*/}
                <symbol id='lbaic-settings-history-active' viewBox='0 0 24 24'>
                    <path
                        d="M12.834 20C10.9673 20 9.31547 19.4333 7.87843 18.3C6.44139 17.1667 5.50806 15.7185 5.07843 13.9556C5.01917 13.7333 5.06361 13.5296 5.21176 13.3444C5.35991 13.1593 5.55991 13.0519 5.81176 13.0222C6.0488 12.9926 6.26361 13.037 6.45621 13.1556C6.6488 13.2741 6.78213 13.4519 6.85621 13.6889C7.21176 15.0222 7.9451 16.1111 9.05621 16.9556C10.1673 17.8 11.4266 18.2222 12.834 18.2222C14.5673 18.2222 16.0377 17.6185 17.2451 16.4111C18.4525 15.2037 19.0562 13.7333 19.0562 12C19.0562 10.2667 18.4525 8.7963 17.2451 7.58889C16.0377 6.38148 14.5673 5.77778 12.834 5.77778C11.8118 5.77778 10.8562 6.01481 9.96732 6.48889C9.07843 6.96296 8.33028 7.61481 7.72287 8.44444H9.27843C9.53028 8.44444 9.74139 8.52963 9.91176 8.7C10.0821 8.87037 10.1673 9.08148 10.1673 9.33333C10.1673 9.58519 10.0821 9.7963 9.91176 9.96667C9.74139 10.137 9.53028 10.2222 9.27843 10.2222H5.72287C5.47102 10.2222 5.25991 10.137 5.08954 9.96667C4.91917 9.7963 4.83398 9.58519 4.83398 9.33333V5.77778C4.83398 5.52593 4.91917 5.31481 5.08954 5.14444C5.25991 4.97407 5.47102 4.88889 5.72287 4.88889C5.97473 4.88889 6.18584 4.97407 6.35621 5.14444C6.52658 5.31481 6.61176 5.52593 6.61176 5.77778V6.97778C7.36732 6.02963 8.28954 5.2963 9.37843 4.77778C10.4673 4.25926 11.6192 4 12.834 4C13.9451 4 14.9858 4.21111 15.9562 4.63333C16.9266 5.05556 17.771 5.62593 18.4895 6.34444C19.2081 7.06296 19.7784 7.90741 20.2007 8.87778C20.6229 9.84815 20.834 10.8889 20.834 12C20.834 13.1111 20.6229 14.1519 20.2007 15.1222C19.7784 16.0926 19.2081 16.937 18.4895 17.6556C17.771 18.3741 16.9266 18.9444 15.9562 19.3667C14.9858 19.7889 13.9451 20 12.834 20ZM13.7229 11.6444L15.9451 13.8667C16.1081 14.0296 16.1895 14.237 16.1895 14.4889C16.1895 14.7407 16.1081 14.9481 15.9451 15.1111C15.7821 15.2741 15.5747 15.3556 15.3229 15.3556C15.071 15.3556 14.8636 15.2741 14.7007 15.1111L12.2118 12.6222C12.1229 12.5333 12.0562 12.4333 12.0118 12.3222C11.9673 12.2111 11.9451 12.0963 11.9451 11.9778V8.44444C11.9451 8.19259 12.0303 7.98148 12.2007 7.81111C12.371 7.64074 12.5821 7.55556 12.834 7.55556C13.0858 7.55556 13.2969 7.64074 13.4673 7.81111C13.6377 7.98148 13.7229 8.19259 13.7229 8.44444V11.6444Z"
                    />
                </symbol>
                <symbol id='lbaic-settings-key-vertical' viewBox='0 0 18 18'>
                    <path
                        d="M8.88867 7.95533C9.37478 7.95533 9.78798 7.77999 10.1283 7.42931C10.4685 7.07864 10.6387 6.65282 10.6387 6.15186C10.6387 5.65089 10.4685 5.22508 10.1283 4.8744C9.78798 4.52373 9.37478 4.34839 8.88867 4.34839C8.40256 4.34839 7.98937 4.52373 7.64909 4.8744C7.30881 5.22508 7.13867 5.65089 7.13867 6.15186C7.13867 6.65282 7.30881 7.07864 7.64909 7.42931C7.98937 7.77999 8.40256 7.95533 8.88867 7.95533ZM8.90326 15.5449C8.82548 15.5449 8.75256 15.5324 8.68451 15.5073C8.61645 15.4823 8.55326 15.4447 8.49492 15.3946L6.99284 14.042C6.93451 13.9919 6.88832 13.9343 6.8543 13.8692C6.82027 13.8041 6.79839 13.7314 6.78867 13.6513C6.77895 13.5711 6.78624 13.4935 6.81055 13.4183C6.83485 13.3432 6.87131 13.2756 6.91992 13.2154L7.72201 12.1634L6.96367 11.3819C6.90534 11.3218 6.86402 11.2567 6.83971 11.1865C6.81541 11.1164 6.80326 11.0413 6.80326 10.9611C6.80326 10.881 6.81541 10.8058 6.83971 10.7357C6.86402 10.6655 6.90534 10.6004 6.96367 10.5403L7.72201 9.75879V9.54839C7.02201 9.29791 6.45812 8.86207 6.03034 8.24088C5.60256 7.61968 5.38867 6.92334 5.38867 6.15186C5.38867 5.14993 5.72895 4.29829 6.40951 3.59694C7.09006 2.8956 7.91645 2.54492 8.88867 2.54492C9.86089 2.54492 10.6873 2.8956 11.3678 3.59694C12.0484 4.29829 12.3887 5.14993 12.3887 6.15186C12.3887 6.96342 12.1651 7.67228 11.7178 8.27845C11.2706 8.88461 10.7164 9.30793 10.0553 9.54839V14.3276C10.0553 14.4077 10.0408 14.4854 10.0116 14.5605C9.98242 14.6357 9.93867 14.7033 9.88034 14.7634L9.28242 15.3796C9.23381 15.4297 9.17791 15.4698 9.11471 15.4998C9.05152 15.5299 8.98103 15.5449 8.90326 15.5449Z"/>
                </symbol>
                <symbol id="lbaic-settings-woocommerce" viewBox="0 0 24 12">
                    <path
                        d="M21.5 5.5h-19a2 2 0 0 0-2 2v8a2 2 0 0 0 2 2H12l4 2-1-2h6.5a2 2 0 0 0 2-2v-8a2 2 0 0 0-2-2"
                    ></path>
                    <path
                        fill="#fff"
                        d="M20.221 9.5c.02 0 .066.003.139.02.17.038.28.098.41.342.155.28.23.642.23 1.108 0 .699-.159 1.32-.487 1.901-.353.63-.61.63-.735.63a.7.7 0 0 1-.138-.02c-.171-.038-.28-.098-.405-.332-.156-.287-.235-.667-.235-1.127 0-.7.157-1.315.481-1.883.364-.639.628-.639.74-.639m0-1.5c-.835 0-1.513.466-2.043 1.397a5.2 5.2 0 0 0-.678 2.625q0 1.075.417 1.843c.313.586.774.94 1.392 1.08q.247.056.47.056c.843 0 1.52-.466 2.043-1.397.452-.8.678-1.675.678-2.634 0-.726-.14-1.331-.418-1.834-.313-.587-.774-.94-1.391-1.08A2 2 0 0 0 20.22 8m-6 1.5c.02 0 .066.003.134.018.167.038.286.104.415.345.155.279.23.641.23 1.107 0 .699-.159 1.32-.487 1.901-.353.63-.61.63-.735.63a.7.7 0 0 1-.138-.02c-.171-.038-.28-.098-.405-.332-.156-.287-.235-.667-.235-1.127 0-.7.157-1.315.481-1.883.364-.639.628-.639.74-.639m0-1.5c-.835 0-1.513.466-2.043 1.397a5.2 5.2 0 0 0-.678 2.625q0 1.075.417 1.843c.313.586.774.94 1.392 1.08q.247.056.47.056c.843 0 1.52-.466 2.043-1.397.452-.8.678-1.675.678-2.634 0-.726-.14-1.331-.418-1.834-.313-.587-.782-.94-1.391-1.08A2 2 0 0 0 14.22 8M9.25 16a.75.75 0 0 1-.562-.252c-1.098-1.24-1.772-2.867-2.17-4.171-.572 1.21-1.344 2.757-2.125 4.059a.75.75 0 0 1-1.367-.189C1.92 11.383 1.523 8.472 1.506 8.35a.75.75 0 0 1 1.487-.2c.004.024.286 2.089 1.017 5.1 1.109-2.104 2.039-4.268 2.05-4.296a.75.75 0 0 1 1.433.194c.004.026.271 1.913 1.123 3.726.36-3.583 1.436-5.42 1.49-5.51a.75.75 0 0 1 1.287.771C11.381 8.157 10 10.558 10 15.251a.75.75 0 0 1-.75.75"
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-customer' viewBox='0 0 24 24'>
                    <path
                        d="M5 20q-.824 0-1.412-.587A1.93 1.93 0 0 1 3 18v-7q0-1.85.712-3.487A9.2 9.2 0 0 1 5.65 4.65a9.2 9.2 0 0 1 2.862-1.937A8.65 8.65 0 0 1 12 2q1.85 0 3.487.713A9.2 9.2 0 0 1 18.35 4.65a9.2 9.2 0 0 1 1.937 2.863A8.6 8.6 0 0 1 21 11v10q0 .825-.587 1.413A1.93 1.93 0 0 1 19 23h-6a.97.97 0 0 1-.713-.287A.97.97 0 0 1 12 22q0-.424.287-.712A.97.97 0 0 1 13 21h6v-1h-2q-.825 0-1.412-.587A1.93 1.93 0 0 1 15 18v-4q0-.825.588-1.412A1.93 1.93 0 0 1 17 12h2v-1q0-2.9-2.05-4.95T12 4 7.05 6.05 5 11v1h2q.824 0 1.412.588T9 14v4q0 .825-.588 1.413A1.93 1.93 0 0 1 7 20zm0-2h2v-4H5zm12 0h2v-4h-2z"
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-booking' viewBox='0 0 24 24'>
                    <path
                        d="m10.95 15.45 3.475-3.475q.3-.3.725-.3t.725.3.3.725q0 .426-.3.725L11.65 17.65q-.3.3-.7.3a.96.96 0 0 1-.7-.3l-2.125-2.125q-.3-.3-.3-.725t.3-.725.725-.3.725.3zM5 22q-.824 0-1.412-.587A1.93 1.93 0 0 1 3 20V6q0-.824.587-1.412A1.93 1.93 0 0 1 5 4h1V3q0-.424.287-.712A.97.97 0 0 1 7 2q.424 0 .713.288Q8 2.576 8 3v1h8V3q0-.424.288-.712A.97.97 0 0 1 17 2q.424 0 .712.288T18 3v1h1q.824 0 1.413.588Q21 5.175 21 6v14q0 .825-.587 1.413A1.93 1.93 0 0 1 19 22zm0-2h14V10H5zM5 8h14V6H5z"
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-lead' viewBox='0 0 24 24'>
                    <path
                        d="M3 20q-.825 0-1.412-.588A1.93 1.93 0 0 1 1.001 18v-.8q0-.85.437-1.563.438-.712 1.163-1.087a14.8 14.8 0 0 1 3.15-1.163 13.8 13.8 0 0 1 4.387-.337q.563.05 1.138.15.35.05.5.387t.025.688a1.32 1.32 0 0 1-.475.612q-.35.263-1 .188a7 7 0 0 0-.675-.063A17 17 0 0 0 9 15a11.6 11.6 0 0 0-2.775.337Q4.85 15.675 3.5 16.35a.97.97 0 0 0-.5.85v.8h7.375q.5 0 .75.312t.25.688-.25.687-.75.313zm6-8q-1.649 0-2.824-1.175T5 8q0-1.65 1.175-2.825T9 4t2.825 1.175T13 8t-1.175 2.825T9 12m10-4q.001 1.65-1.174 2.825T15 12q-.275 0-.7-.063a6 6 0 0 1-.7-.137 6 6 0 0 0 1.037-1.775q.363-.975.363-2.025t-.363-2.025A6 6 0 0 0 13.601 4.2a3 3 0 0 1 .7-.163Q14.65 4 15 4q1.65 0 2.825 1.175T19 8M9 10q.826 0 1.413-.588T11.001 8t-.588-1.413A1.93 1.93 0 0 0 9.001 6q-.825 0-1.413.587A1.93 1.93 0 0 0 7.001 8q0 .825.587 1.412.588.588 1.413.588m8 9q.85 0 1.413-.5.563-.501.588-1.5.024-.85-.563-1.425A1.98 1.98 0 0 0 17.001 15q-.85 0-1.425.575Q15 16.149 15 17q0 .849.575 1.425Q16.15 19 17 19m0 2q-1.649 0-2.824-1.175Q13 18.65 13 17t1.175-2.825T17 13t2.825 1.175T21 17q0 .574-.138 1.087-.137.513-.412.963l1.85 1.85a.95.95 0 0 1 .275.7.95.95 0 0 1-.275.7.95.95 0 0 1-.7.275.95.95 0 0 1-.7-.275l-1.85-1.85q-.45.274-.963.412a4.2 4.2 0 0 1-1.087.138"
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-blank' viewBox='0 0 24 24'>
                    <path
                        d="M8.8 21H5q-.824 0-1.412-.587A1.93 1.93 0 0 1 3 19v-3.8q1.2 0 2.1-.763.9-.762.9-1.937t-.9-1.937A3.15 3.15 0 0 0 3 9.8V6q0-.824.587-1.412A1.93 1.93 0 0 1 5 4h4q0-1.05.725-1.775T11.5 1.5t1.775.725T14 4h4q.824 0 1.413.588Q20 5.175 20 6v4q1.05 0 1.775.725T22.5 12.5t-.725 1.775T20 15v4q0 .824-.587 1.413A1.93 1.93 0 0 1 18 21h-3.8q0-1.25-.787-2.125Q12.625 18 11.5 18t-1.912.875T8.8 21M5 19h2.125q.6-1.65 1.925-2.325T11.5 16t2.45.675T15.875 19H18v-6h2a.48.48 0 0 0 .35-.15.48.48 0 0 0 0-.7A.48.48 0 0 0 20 12h-2V6h-6V4a.48.48 0 0 0-.15-.35.48.48 0 0 0-.7 0A.48.48 0 0 0 11 4v2H5v2.2q1.35.5 2.175 1.675Q8 11.049 8 12.5q0 1.425-.825 2.6A4.67 4.67 0 0 1 5 16.8z"
                    ></path>
                </symbol>

                <symbol id='lbaic-settings-warning' viewBox='0 0 24 24'>
                    <path
                        d="M1 21 12 2l11 19zm11-3q.424 0 .713-.288A.97.97 0 0 0 13 17a.97.97 0 0 0-.287-.712A.97.97 0 0 0 12 16a.97.97 0 0 0-.713.288A.97.97 0 0 0 11 17q0 .424.287.712.288.288.713.288m-1-3h2v-5h-2z"
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-error' viewBox='0 0 24 24'>
                    <path
                        d="M12 17q.424 0 .713-.288A.97.97 0 0 0 13 16a.97.97 0 0 0-.287-.713A.97.97 0 0 0 12 15a.97.97 0 0 0-.713.287A.97.97 0 0 0 11 16q0 .424.287.712.288.288.713.288m-1-4h2V7h-2zm1 9a9.7 9.7 0 0 1-3.9-.788 10.1 10.1 0 0 1-3.175-2.137q-1.35-1.35-2.137-3.175A9.7 9.7 0 0 1 2 12q0-2.075.788-3.9a10.1 10.1 0 0 1 2.137-3.175q1.35-1.35 3.175-2.137A9.7 9.7 0 0 1 12 2q2.075 0 3.9.788a10.1 10.1 0 0 1 3.175 2.137q1.35 1.35 2.137 3.175A9.7 9.7 0 0 1 22 12a9.7 9.7 0 0 1-.788 3.9 10.1 10.1 0 0 1-2.137 3.175q-1.35 1.35-3.175 2.137A9.7 9.7 0 0 1 12 22"
                    ></path>
                </symbol>

                <symbol id='lbaic-settings-drag-indicator' viewBox='0 0 24 24'>
                    <path
                        d='M8.998 19.998c-.55 0-1.02-.195-1.412-.587a1.926 1.926 0 01-.588-1.413c0-.55.196-1.02.588-1.412a1.926 1.926 0 011.412-.588c.55 0 1.021.196 1.413.588.392.392.587.862.587 1.412 0 .55-.195 1.021-.587 1.413a1.926 1.926 0 01-1.413.587zm6 0c-.55 0-1.02-.195-1.412-.587a1.926 1.926 0 01-.588-1.413c0-.55.196-1.02.588-1.412a1.926 1.926 0 011.412-.588c.55 0 1.021.196 1.413.588.392.392.587.862.587 1.412 0 .55-.195 1.021-.587 1.413a1.926 1.926 0 01-1.413.587zm-6-6c-.55 0-1.02-.195-1.412-.587a1.926 1.926 0 01-.588-1.413c0-.55.196-1.02.588-1.412a1.926 1.926 0 011.412-.588c.55 0 1.021.196 1.413.588.392.392.587.862.587 1.412 0 .55-.195 1.021-.587 1.413a1.926 1.926 0 01-1.413.587zm6 0c-.55 0-1.02-.195-1.412-.587a1.926 1.926 0 01-.588-1.413c0-.55.196-1.02.588-1.412a1.926 1.926 0 011.412-.588c.55 0 1.021.196 1.413.588.392.392.587.862.587 1.412 0 .55-.195 1.021-.587 1.413a1.926 1.926 0 01-1.413.587zm-6-6c-.55 0-1.02-.195-1.412-.587a1.926 1.926 0 01-.588-1.413c0-.55.196-1.02.588-1.412a1.926 1.926 0 011.412-.588c.55 0 1.021.196 1.413.588.392.392.587.862.587 1.412 0 .55-.195 1.021-.587 1.413a1.926 1.926 0 01-1.413.587zm6 0c-.55 0-1.02-.195-1.412-.587a1.926 1.926 0 01-.588-1.413c0-.55.196-1.02.588-1.412a1.926 1.926 0 011.412-.588c.55 0 1.021.196 1.413.588.392.392.587.862.587 1.412 0 .55-.195 1.021-.587 1.413a1.926 1.926 0 01-1.413.587z'
                    ></path>
                </symbol>

                <symbol id='lbaic-settings-humble' viewBox='0 0 24 24'>
                    <path
                        d='M5.725 9.75 L9.1 13.125 L5.725 16.5 M3.7 3h16.2a2.7 2.7 0 0 1 2.7 2.7v13.5a2.7 2.7 0 0 1-2.7 2.7H3.7A2.7 2.7 0 0 1 1 19.2V5.7A2.7 2.7 0 0 1 3.7 3'
                    ></path>
                    <rect className='lbaic-settings-cb-pw-icon-details'
                          width="7"
                          height="1.7"
                          rx="0.85"
                          transform="matrix(1 0 0 -1 11 17)"
                    ></rect>
                    <path className='lbaic-settings-cb-pw-icon-details'
                          d='M4.584 8.584a.827.827 0 0 1 1.17 0L9.147 11.98a.827.827 0 1 1-1.169 1.169L4.584 9.753a.827.827 0 0 1 0-1.169'
                    ></path>
                    <path className='lbaic-settings-cb-pw-icon-details'
                          d='M4.682 16.575a.85.85 0 0 1-.02-1.203l3.137-3.249a.85.85 0 1 1 1.224 1.182l-3.138 3.25a.85.85 0 0 1-1.203.02'
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-backward' viewBox="0 0 8 5">
                    <path
                        d="M.176 4.626a.6.6 0 0 0 .85 0L4.005 1.65 6.98 4.626a.601.601 0 0 0 .85-.85L4.43.373a.6.6 0 0 0-.85 0L.175 3.776a.6.6 0 0 0 0 .85"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-forward" viewBox="0 0 8 5">
                    <path
                        d="M.176.373a.6.6 0 0 1 .85 0L4.005 3.35 6.98.373a.601.601 0 0 1 .85.85L4.43 4.626a.6.6 0 0 1-.85 0L.175 1.223a.6.6 0 0 1 0-.85"
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-mood' viewBox='0 0 24 24'>
                    <path
                        d='M15.25 11.5q.52 0 .885-.365.365-.364.365-.885 0-.52-.365-.885A1.2 1.2 0 0 0 15.25 9q-.52 0-.885.365a1.2 1.2 0 0 0-.365.885q0 .52.365.885.364.366.885.365m-5.833 0q.52 0 .885-.365.365-.364.365-.885 0-.52-.365-.885A1.2 1.2 0 0 0 9.417 9q-.522 0-.886.365a1.2 1.2 0 0 0-.364.885q0 .52.364.885.364.366.886.365m2.916 9.167a8.1 8.1 0 0 1-3.25-.657 8.4 8.4 0 0 1-2.645-1.78 8.4 8.4 0 0 1-1.782-2.647A8.1 8.1 0 0 1 4 12.333q0-1.729.656-3.25a8.4 8.4 0 0 1 1.782-2.645 8.4 8.4 0 0 1 2.645-1.782A8.1 8.1 0 0 1 12.333 4q1.73 0 3.25.656a8.4 8.4 0 0 1 2.646 1.782 8.4 8.4 0 0 1 1.781 2.645 8.1 8.1 0 0 1 .657 3.25 8.1 8.1 0 0 1-.657 3.25 8.4 8.4 0 0 1-1.78 2.646 8.4 8.4 0 0 1-2.647 1.781 8.1 8.1 0 0 1-3.25.657m0-3.75q1.209 0 2.23-.584a4.6 4.6 0 0 0 1.645-1.583.5.5 0 0 0-.02-.5.48.48 0 0 0-.438-.25H8.917a.48.48 0 0 0-.438.25.5.5 0 0 0-.02.5 4.6 4.6 0 0 0 1.656 1.583 4.43 4.43 0 0 0 2.218.584'
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-puzzle' viewBox='0 0 24 24'>
                    <path
                        d="M11.4998 2.5C11.9417 2.5 12.2774 2.6409 12.5682 2.93164C12.859 3.22244 12.9998 3.55806 12.9998 4V5H17.9998C18.246 5 18.4434 5.06814 18.6278 5.22363L18.7069 5.2959C18.9113 5.50075 18.9998 5.71748 18.9998 6V11H19.9998C20.4417 11 20.7774 11.1409 21.0682 11.4316C21.359 11.7224 21.4998 12.0581 21.4998 12.5C21.4998 12.9419 21.359 13.2776 21.0682 13.5684C20.7774 13.8591 20.4417 14 19.9998 14H18.9998V19C18.9998 19.2819 18.9113 19.4999 18.7049 19.707L18.6951 19.7168C18.607 19.8078 18.5006 19.8801 18.3836 19.9287C18.2665 19.9774 18.1403 20.0018 18.0135 20H15.0897C14.9522 19.3977 14.6855 18.8444 14.284 18.3545L14.1561 18.2061C13.4511 17.4233 12.5479 17 11.4998 17C10.4519 17 9.5489 17.423 8.84455 18.2061C8.37179 18.7317 8.06184 19.3359 7.90998 20H4.99983C4.71797 20 4.50097 19.9109 4.29475 19.7051L4.28889 19.7002L4.28303 19.6943L4.21858 19.625C4.1575 19.5525 4.10768 19.4707 4.07112 19.3828C4.0225 19.2659 3.99818 19.1403 3.99983 19.0137V16.0859C4.63775 15.9372 5.2243 15.6428 5.74592 15.2012H5.7469C6.56994 14.5034 6.99983 13.5786 6.99983 12.5C6.99983 11.4214 6.5694 10.497 5.74592 9.7998C5.23946 9.36541 4.63972 9.06357 3.99983 8.91211V6C3.99983 5.71814 4.08897 5.50113 4.29475 5.29492L4.30061 5.28906L4.30549 5.2832C4.39367 5.19205 4.49992 5.12002 4.61702 5.07129C4.70468 5.03481 4.79723 5.01233 4.89143 5.00391L4.98713 5H9.99983V4C9.99983 3.55806 10.1416 3.22244 10.4324 2.93164C10.7231 2.64115 11.0582 2.50004 11.4998 2.5Z"
                        strokeWidth="2"/>
                </symbol>
                <symbol id='lbaic-settings-link' viewBox='0 0 24 24'>
                    <path
                        d='M7.876 18Q5.71 18 4.19 16.479T2.668 12.79t1.52-3.687Q5.71 7.583 7.877 7.583h7.709q1.562 0 2.656 1.094 1.095 1.093 1.094 2.656t-1.094 2.656q-1.095 1.094-2.656 1.094H8.293q-.958 0-1.625-.667a2.2 2.2 0 0 1-.667-1.625q0-.958.667-1.625A2.2 2.2 0 0 1 8.293 10.5h6.875q.354 0 .594.24.24.239.24.593t-.24.594a.8.8 0 0 1-.594.24H8.293a.607.607 0 0 0-.625.624.607.607 0 0 0 .625.625h7.292a2.1 2.1 0 0 0 1.479-.614q.604-.594.604-1.469 0-.874-.604-1.48a2.01 2.01 0 0 0-1.48-.603H7.877q-1.48-.021-2.51 1.02-1.032 1.042-1.031 2.521 0 1.459 1.03 2.48 1.032 1.02 2.511 1.062h7.292q.354 0 .594.24t.24.593-.24.594a.8.8 0 0 1-.594.24z'
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-link-active' viewBox='0 0 24 24'>
                    <path
                        d='M7.876 18Q5.71 18 4.19 16.479T2.668 12.79t1.52-3.687Q5.71 7.583 7.877 7.583h7.709q1.562 0 2.656 1.094 1.095 1.093 1.094 2.656t-1.094 2.656q-1.095 1.094-2.656 1.094H8.293q-.958 0-1.625-.667a2.2 2.2 0 0 1-.667-1.625q0-.958.667-1.625A2.2 2.2 0 0 1 8.293 10.5h6.875q.354 0 .594.24.24.239.24.593t-.24.594a.8.8 0 0 1-.594.24H8.293a.607.607 0 0 0-.625.624.607.607 0 0 0 .625.625h7.292a2.1 2.1 0 0 0 1.479-.614q.604-.594.604-1.469 0-.874-.604-1.48a2.01 2.01 0 0 0-1.48-.603H7.877q-1.48-.021-2.51 1.02-1.032 1.042-1.031 2.521 0 1.459 1.03 2.48 1.032 1.02 2.511 1.062h7.292q.354 0 .594.24t.24.593-.24.594a.8.8 0 0 1-.594.24z'
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-prompts-edit' viewBox='0 0 24 24'>
                    <path
                        d="M3 21v-4.25L16.2 3.575q.3-.275.663-.425.362-.15.762-.15t.775.15.65.45L20.425 5q.3.275.438.65a2.17 2.17 0 0 1 0 1.512 1.9 1.9 0 0 1-.438.663L7.25 21zM17.6 7.8 19 6.4 17.6 5l-1.4 1.4z"
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-prompts-delete' viewBox='0 0 24 24'>
                    <path
                        d="M7 21q-.824 0-1.412-.587A1.93 1.93 0 0 1 5 19V6H4V4h5V3h6v1h5v2h-1v13q0 .824-.587 1.413A1.93 1.93 0 0 1 17 21zm2-4h2V8H9zm4 0h2V8h-2z"
                    ></path>
                </symbol>

                <symbol id='lbaic-settings-drag' viewBox="0 0 24 24">
                    <path
                        d="M9 19.615q-.666 0-1.14-.474A1.56 1.56 0 0 1 7.384 18q0-.666.474-1.14A1.56 1.56 0 0 1 9 16.384q.666 0 1.14.474.475.475.475 1.141t-.474 1.14A1.56 1.56 0 0 1 9 19.616m6 0q-.666 0-1.14-.474A1.56 1.56 0 0 1 13.384 18q0-.666.474-1.14A1.56 1.56 0 0 1 15 16.384q.666 0 1.14.474.475.475.475 1.141t-.474 1.14a1.56 1.56 0 0 1-1.141.475m-6-6q-.666 0-1.14-.474A1.56 1.56 0 0 1 7.384 12q0-.666.474-1.14A1.56 1.56 0 0 1 9 10.384q.666 0 1.14.474.475.475.475 1.141t-.474 1.14A1.56 1.56 0 0 1 9 13.616m6 0q-.666 0-1.14-.474A1.56 1.56 0 0 1 13.384 12q0-.666.474-1.14A1.56 1.56 0 0 1 15 10.384q.666 0 1.14.474.475.475.475 1.141t-.474 1.14a1.56 1.56 0 0 1-1.141.475m-6-6q-.666 0-1.14-.474A1.56 1.56 0 0 1 7.384 6q0-.666.474-1.14A1.56 1.56 0 0 1 9 4.384q.666 0 1.14.474.475.475.475 1.141t-.474 1.14A1.56 1.56 0 0 1 9 7.616m6 0q-.666 0-1.14-.474A1.56 1.56 0 0 1 13.384 6q0-.666.474-1.14A1.56 1.56 0 0 1 15 4.384q.666 0 1.14.474.475.475.475 1.141t-.474 1.14A1.56 1.56 0 0 1 15 7.616"
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-prompts-puzzle' viewBox="0 0 20 20">
                    <path
                        d="M7.333 17.5H4.167q-.688 0-1.177-.49a1.6 1.6 0 0 1-.49-1.177v-3.166q1 0 1.75-.636.75-.635.75-1.614t-.75-1.615a2.62 2.62 0 0 0-1.75-.635V5q0-.687.49-1.177.489-.49 1.177-.49H7.5q0-.875.604-1.479a2.01 2.01 0 0 1 1.48-.604q.875 0 1.479.604.603.604.604 1.48H15q.687 0 1.177.489.49.49.49 1.177v3.333q.874 0 1.479.604.604.604.604 1.48 0 .874-.604 1.479a2 2 0 0 1-1.48.604v3.333q0 .688-.489 1.177-.49.49-1.177.49h-3.167q0-1.042-.656-1.77-.656-.73-1.594-.73-.937 0-1.593.73-.657.728-.657 1.77m-3.166-1.667h1.77q.501-1.374 1.605-1.937t2.041-.563 2.042.563 1.604 1.937H15v-5h1.667a.4.4 0 0 0 .291-.125.4.4 0 0 0 .125-.291.4.4 0 0 0-.125-.292.4.4 0 0 0-.291-.125H15V5h-5V3.333a.4.4 0 0 0-.125-.291.4.4 0 0 0-.583 0 .4.4 0 0 0-.125.291V5h-5v1.833q1.125.417 1.812 1.396.688.98.688 2.188 0 1.187-.688 2.166A3.9 3.9 0 0 1 4.167 14z"
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-pinecone' viewBox='0 0 19 20'>
                    <path
                        d="M8.063 17.67c.674 0 1.22.51 1.22 1.14 0 .632-.546 1.143-1.22 1.143s-1.22-.511-1.22-1.142.546-1.142 1.22-1.142m6.77-2.084 1.205.334-.957 3.023a.63.63 0 0 1-.645.42l-.296-.019-.007.005-3.072-.201.085-1.174 2.064.13-1.351-1.823 1.034-.67 1.352 1.826zm-13.125-2.09 1.255.083-.147 1.931 1.945-1.266.718.966-1.948 1.268 1.989.548-.356 1.129-3.246-.895a.59.59 0 0 1-.45-.606zm8.1-1.644 2.264 2.558-1.02.79-1.348-1.521-.437 2.34-1.305-.213.437-2.344-1.814 1-.672-1.068 3.049-1.68a.694.694 0 0 1 .846.138m6.335-1.716 1.131-.576 1.648 2.834a.576.576 0 0 1-.143.742l-.233.189-2.38 1.937-.844-.91 1.599-1.301-2.382-.402.228-1.185 2.38.401zM2.804 7.174l.852.903L2.08 9.378l2.386.39-.22 1.187-2.39-.39 1.026 1.736-1.126.583L.08 10.053a.575.575 0 0 1 .138-.744zm8.067-.932 2.257 2.55-1.02.791L10.76 8.06l-.437 2.341-1.305-.213.436-2.335-1.808.991-.67-1.07 2.776-1.522.003-.01.012.001.259-.14a.694.694 0 0 1 .845.139m2.908-1.255.494-1.113 3.192 1.24c.279.108.44.383.387.66l-.053.277-.545 2.902-1.268-.21.365-1.942-2.118 1.096-.622-1.055 2.122-1.096zM7.698 2.794l.055 1.204-2.11.084 1.591 1.701-.969.793-1.593-1.703-.371 1.945-1.268-.213.608-3.177a.63.63 0 0 1 .606-.496l.299-.012.006-.005zM12.01.227l2.247 2.567-1.025.786-1.334-1.524-.45 2.338-1.303-.22.45-2.343-1.82.996-.669-1.07L11.165.084a.694.694 0 0 1 .847.142"
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-more-arrow' viewBox="0 0 24 12">
                    <path
                        d="M21.18 0 12 7.417 2.82 0 0 2.283 12 12l12-9.717z"
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-emoji' viewBox="0 0 20 20">
                    <path
                        d="M12.917 9.167q.52 0 .885-.365.364-.365.364-.885 0-.522-.364-.886a1.2 1.2 0 0 0-.886-.364q-.52 0-.885.364a1.2 1.2 0 0 0-.365.886q0 .52.365.885.364.364.885.364m-5.834 0q.521 0 .886-.365.364-.365.364-.885 0-.522-.364-.886a1.2 1.2 0 0 0-.886-.364q-.52 0-.885.364a1.2 1.2 0 0 0-.365.886q0 .52.365.885.365.364.885.364M10 18.333a8.1 8.1 0 0 1-3.25-.656 8.4 8.4 0 0 1-2.646-1.781 8.4 8.4 0 0 1-1.781-2.646A8.1 8.1 0 0 1 1.667 10q0-1.73.656-3.25a8.4 8.4 0 0 1 1.781-2.646A8.4 8.4 0 0 1 6.75 2.323 8.1 8.1 0 0 1 10 1.667q1.73 0 3.25.656a8.4 8.4 0 0 1 2.646 1.781 8.4 8.4 0 0 1 1.78 2.646 8.1 8.1 0 0 1 .657 3.25 8.1 8.1 0 0 1-.656 3.25 8.4 8.4 0 0 1-1.781 2.646 8.4 8.4 0 0 1-2.646 1.78 8.1 8.1 0 0 1-3.25.657m0-1.666q2.79 0 4.729-1.938 1.938-1.937 1.938-4.73 0-2.79-1.938-4.728t-4.73-1.938q-2.79 0-4.728 1.938T3.333 10q0 2.79 1.938 4.729Q7.208 16.667 10 16.667m0-2.084q1.208 0 2.229-.583a4.6 4.6 0 0 0 1.646-1.584.5.5 0 0 0-.021-.5.48.48 0 0 0-.437-.25H6.583a.48.48 0 0 0-.437.25.5.5 0 0 0-.021.5A4.6 4.6 0 0 0 7.78 14a4.43 4.43 0 0 0 2.219.583"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-notice-default" viewBox="0 0 18 18">
                    <path
                        d="M8.333 16.667A8.333 8.333 0 1 0 8.333 0a8.333 8.333 0 0 0 0 16.667"
                    ></path>
                    <path
                        fill="#E7F1FF"
                        d="m9.674 6.397-2.52.316-.09.419.495.09c.323.077.387.193.317.516l-.813 3.815c-.212.986.117 1.45.89 1.45.6 0 1.295-.276 1.611-.657l.097-.458c-.22.194-.542.271-.755.271-.302 0-.411-.212-.335-.587zM9.75 4.1a1.1 1.1 0 1 1-2.201 0 1.1 1.1 0 0 1 2.201 0"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-notice-error" viewBox="0 0 18 18">
                    <path
                        d="M9 13.167q.354 0 .594-.24t.24-.594V9a.8.8 0 0 0-.24-.594.8.8 0 0 0-.594-.24.8.8 0 0 0-.593.24.8.8 0 0 0-.24.594v3.333q0 .354.24.594t.593.24M9 6.5q.354 0 .594-.24t.24-.593a.8.8 0 0 0-.24-.594.8.8 0 0 0-.594-.24.8.8 0 0 0-.593.24.8.8 0 0 0-.24.593q0 .355.24.594.24.24.593.24m0 10.833a8.1 8.1 0 0 1-3.25-.656 8.4 8.4 0 0 1-2.646-1.781 8.4 8.4 0 0 1-1.78-2.646A8.1 8.1 0 0 1 .666 9q0-1.73.656-3.25a8.4 8.4 0 0 1 1.781-2.646A8.4 8.4 0 0 1 5.75 1.323 8.1 8.1 0 0 1 9 .667q1.73 0 3.25.656a8.4 8.4 0 0 1 2.646 1.781 8.4 8.4 0 0 1 1.781 2.646A8.1 8.1 0 0 1 17.334 9a8.1 8.1 0 0 1-.657 3.25 8.4 8.4 0 0 1-1.78 2.646 8.4 8.4 0 0 1-2.647 1.78 8.1 8.1 0 0 1-3.25.657"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-notice-warning" viewBox="0 0 18 16">
                    <path
                        d="M1.271 15.5a.811.811 0 0 1-.708-.417.9.9 0 0 1-.115-.406.75.75 0 0 1 .115-.427L8.27.917a.8.8 0 0 1 .323-.313A.86.86 0 0 1 9 .5q.208 0 .406.104a.8.8 0 0 1 .323.313l7.709 13.333a.75.75 0 0 1 .114.427.9.9 0 0 1-.114.406.81.81 0 0 1-.709.417zm7.73-2.5q.353 0 .593-.24t.24-.593a.8.8 0 0 0-.24-.594.8.8 0 0 0-.594-.24.8.8 0 0 0-.594.24.8.8 0 0 0-.24.594q0 .354.24.593.24.24.594.24m0-2.5q.353 0 .593-.24t.24-.593v-2.5a.8.8 0 0 0-.24-.594.8.8 0 0 0-.594-.24.8.8 0 0 0-.594.24.8.8 0 0 0-.24.594v2.5q0 .354.24.593.24.24.594.24"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-notice-success" viewBox="0 0 18 18">
                    <path
                        d="M7.834 10.5 6.042 8.708a.8.8 0 0 0-.583-.229.8.8 0 0 0-.584.23.8.8 0 0 0-.229.582q0 .355.23.584L7.25 12.25a.8.8 0 0 0 .584.25.8.8 0 0 0 .583-.25l4.708-4.708a.8.8 0 0 0 .23-.584.8.8 0 0 0-.23-.583.8.8 0 0 0-.583-.23.8.8 0 0 0-.583.23zM9 17.333a8.1 8.1 0 0 1-3.25-.656 8.4 8.4 0 0 1-2.646-1.781 8.4 8.4 0 0 1-1.78-2.646A8.1 8.1 0 0 1 .666 9q0-1.73.656-3.25a8.4 8.4 0 0 1 1.781-2.646A8.4 8.4 0 0 1 5.75 1.323 8.1 8.1 0 0 1 9 .667q1.73 0 3.25.656a8.4 8.4 0 0 1 2.646 1.781 8.4 8.4 0 0 1 1.781 2.646A8.1 8.1 0 0 1 17.334 9a8.1 8.1 0 0 1-.657 3.25 8.4 8.4 0 0 1-1.78 2.646 8.4 8.4 0 0 1-2.647 1.78 8.1 8.1 0 0 1-3.25.657"
                    ></path>
                </symbol>

                <symbol id="lbaic-settings-notice-close" viewBox="0 0 12 12">
                    <path
                        d="m.166 10.658 1.175 1.175L6 7.175l4.658 4.658 1.175-1.175L7.175 6l4.658-4.659L10.658.166 6 4.825 1.34.166.166 1.341 4.825 6z"
                    ></path>
                </symbol>

                <symbol id="lbaic-settings-tab-templates" viewBox="0 0 24 24">
                    <path
                        d="M9 9v11h7v-3q0-.424.287-.712A.97.97 0 0 1 17 16h3V9zM7 20V8.975q0-.825.6-1.4A2 2 0 0 1 9.025 7H20q.825 0 1.412.588Q22 8.175 22 9v7.175a1.97 1.97 0 0 1-.575 1.4l-3.85 3.85a1.972 1.972 0 0 1-1.4.575H9q-.825 0-1.413-.587A1.93 1.93 0 0 1 7 20M2.025 6.25q-.15-.825.325-1.487.474-.663 1.3-.813L14.5 2.025q.8-.15 1.45.338.65.487.85 1.287l.175.775q.124.5-.15.8-.276.3-.65.35a1.13 1.13 0 0 1-.713-.137Q15.125 5.25 15 4.75L14.825 4 4 5.925l1.5 8.6q.075.425-.15.762a.94.94 0 0 1-.65.413.94.94 0 0 1-.75-.162 1 1 0 0 1-.4-.663z"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-tab-templates-active" viewBox="0 0 24 24">
                    <path
                        d="M7 20V8.975q0-.825.6-1.4A2 2 0 0 1 9.025 7H20q.825 0 1.413.587Q22 8.175 22 9v7.175a1.97 1.97 0 0 1-.575 1.4l-3.85 3.85a1.975 1.975 0 0 1-1.4.575H9q-.825 0-1.412-.588A1.93 1.93 0 0 1 7 20M2.025 6.25q-.15-.825.325-1.488.475-.662 1.3-.812L14.5 2.025q.825-.15 1.488.325.662.474.812 1.3L17.05 5H9Q7.35 5 6.175 6.175T5 9v9.55a2.25 2.25 0 0 1-.687-.6 1.85 1.85 0 0 1-.363-.85zM20 16h-3a.97.97 0 0 0-.712.287A.97.97 0 0 0 16 17v3z"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-settings" viewBox="0 0 24 24">
                    <path
                        d="M24 14.118h-3.078a9 9 0 0 1-1.143 2.724l2.174 2.175-2.965 2.964-2.174-2.174a9 9 0 0 1-2.696 1.115V24H9.882v-3.078a9 9 0 0 1-2.696-1.115l-2.174 2.174-2.993-2.993 2.174-2.174a9 9 0 0 1-1.115-2.696H0V9.925h3.064a9.2 9.2 0 0 1 1.129-2.74L2.019 5.013l2.965-2.965 2.174 2.174a9.1 9.1 0 0 1 2.724-1.143V0h4.236v3.078c.96.226 1.877.607 2.696 1.115l2.174-2.174 2.993 2.993-2.174 2.174c.508.833.904 1.75 1.13 2.739H24zm-12 2.117A4.23 4.23 0 0 0 16.235 12 4.23 4.23 0 0 0 12 7.765 4.23 4.23 0 0 0 7.765 12 4.23 4.23 0 0 0 12 16.235"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-tab-dashboard" viewBox="0 0 24 24" fill="none">
                    <path d="M3 3V19C3 19.5304 3.21071 20.0391 3.58579 20.4142C3.96086 20.7893 4.46957 21 5 21H21"
                          strokeWidth="2" strokeLinecap="round" strokeLinejoin="round"/>
                    <path d="M18 17V9" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round"/>
                    <path d="M13 17V5" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round"/>
                    <path d="M8 17V14" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round"/>
                </symbol>
                <symbol id="lbaic-settings-tab-settings" viewBox="0 0 24 24">
                    <path
                        d="M10.892 21.5q-.51 0-.883-.34a1.4 1.4 0 0 1-.453-.835l-.245-1.871a5.334 5.334 0 0 1-1.579-.896L6 18.294q-.471.208-.947.04a1.37 1.37 0 0 1-.74-.607l-1.127-1.954a1.22 1.22 0 0 1-.151-.932 1.4 1.4 0 0 1 .511-.81l1.498-1.125a5 5 0 0 1-.049-.448 7 7 0 0 1 0-.882q.014-.22.05-.482L3.545 9.97a1.4 1.4 0 0 1-.507-.815 1.25 1.25 0 0 1 .157-.937l1.117-1.925q.264-.43.74-.602A1.23 1.23 0 0 1 6 5.725l1.723.727a6.4 6.4 0 0 1 .772-.524 5 5 0 0 1 .807-.382l.254-1.871q.081-.496.453-.835.372-.34.883-.34h2.216q.51 0 .883.34.373.339.453.835l.244 1.88q.45.165.815.383t.735.514l1.772-.727q.471-.207.947-.035a1.4 1.4 0 0 1 .739.602l1.117 1.935q.264.44.152.932a1.4 1.4 0 0 1-.511.81l-1.537 1.154q.054.243.059.453t.005.424q0 .204-.01.415-.01.21-.069.481l1.508 1.135q.399.32.516.81.116.492-.147.932l-1.133 1.944a1.37 1.37 0 0 1-.744.608q-.48.167-.952-.04l-1.712-.737q-.371.296-.757.524a4.6 4.6 0 0 1-.793.372l-.244 1.881q-.081.496-.453.835-.372.34-.883.34zM11 20h1.966l.359-2.679q.765-.2 1.399-.568.634-.369 1.222-.947l2.485 1.044.985-1.7-2.17-1.635q.125-.387.17-.761a6.3 6.3 0 0 0 0-1.508 4 4 0 0 0-.17-.742l2.189-1.654-.985-1.7-2.513 1.06a5.3 5.3 0 0 0-1.203-.949 5.2 5.2 0 0 0-1.418-.582L13 4h-1.985l-.33 2.67a5.2 5.2 0 0 0-1.414.553q-.648.374-1.237.962L5.55 7.15l-.985 1.7 2.16 1.61a3.7 3.7 0 0 0-.175.74 6.3 6.3 0 0 0 0 1.575q.05.375.165.74l-2.15 1.635.985 1.7 2.475-1.05q.57.585 1.217.958t1.433.573zm1.011-5q1.249 0 2.125-.876A2.9 2.9 0 0 0 15.012 12q0-1.248-.876-2.124A2.9 2.9 0 0 0 12.012 9q-1.264 0-2.132.876A2.9 2.9 0 0 0 9.01 12q0 1.248.869 2.124T12.01 15"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-tab-settings-active" viewBox="0 0 24 24">
                    <path
                        d="M10.892 21.5q-.51 0-.883-.34a1.4 1.4 0 0 1-.453-.835l-.245-1.871a5.334 5.334 0 0 1-1.579-.896L6 18.294q-.471.208-.947.04a1.37 1.37 0 0 1-.74-.607l-1.127-1.954a1.22 1.22 0 0 1-.151-.932 1.4 1.4 0 0 1 .511-.81l1.498-1.125a5 5 0 0 1-.049-.448 7 7 0 0 1 0-.882q.014-.22.05-.482L3.545 9.97a1.4 1.4 0 0 1-.507-.815 1.25 1.25 0 0 1 .157-.937l1.117-1.925q.264-.43.74-.602A1.23 1.23 0 0 1 6 5.725l1.723.727a6.4 6.4 0 0 1 .772-.524 5 5 0 0 1 .807-.382l.254-1.871q.081-.496.453-.835.372-.34.883-.34h2.216q.51 0 .883.34.373.339.453.835l.244 1.88q.45.165.815.383t.735.514l1.772-.727q.471-.207.947-.035a1.4 1.4 0 0 1 .739.602l1.117 1.935q.264.44.152.932a1.4 1.4 0 0 1-.511.81l-1.537 1.154q.054.243.059.453t.005.424q0 .204-.01.415-.01.21-.069.481l1.508 1.135q.399.32.516.81.116.492-.147.932l-1.133 1.944a1.37 1.37 0 0 1-.744.608q-.48.167-.952-.04l-1.712-.737q-.371.296-.757.524a4.6 4.6 0 0 1-.793.372l-.244 1.881q-.081.496-.453.835-.372.34-.883.34zm1.12-6.5q1.248 0 2.124-.876A2.9 2.9 0 0 0 15.012 12q0-1.248-.876-2.124A2.9 2.9 0 0 0 12.012 9q-1.264 0-2.132.876A2.9 2.9 0 0 0 9.01 12q0 1.248.869 2.124T12.01 15"
                    ></path>
                </symbol>
                <symbol
                    id="lbaic-settings-tab-logs"
                    xmlns="http://www.w3.org/2000/svg"
                    viewBox="0 0 24 24"
                    fill="none"
                    strokeWidth="2"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                >
                    <path d="M3 5h1"/>
                    <path d="M3 12h1"/>
                    <path d="M3 19h1"/>
                    <path d="M8 5h1"/>
                    <path d="M8 12h1"/>
                    <path d="M8 19h1"/>
                    <path d="M13 5h8"/>
                    <path d="M13 12h8"/>
                    <path d="M13 19h8"/>
                </symbol>
                <symbol id="lbaic-settings-tab-appearance" viewBox="0 0 24 24">
                    <path
                        d="M6 21q-1.125 0-2.225-.55T2 19q.65 0 1.325-.513Q4 17.975 4 17q0-1.25.875-2.125A2.9 2.9 0 0 1 7 14q1.25 0 2.125.875Q10 15.749 10 17q0 1.65-1.175 2.825T6 21m0-2q.825 0 1.412-.588Q8 17.825 8 17a.97.97 0 0 0-.288-.713A.97.97 0 0 0 7 16a.97.97 0 0 0-.713.287A.97.97 0 0 0 6 17q0 .574-.138 1.05a4.7 4.7 0 0 1-.362.9.7.7 0 0 0 .25.05zm5.75-4L9 12.25l8.95-8.95a.98.98 0 0 1 .687-.288.93.93 0 0 1 .713.288l1.35 1.35q.3.3.3.7t-.3.7z"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-tab-appearance-active" viewBox="0 0 24 24">
                    <path
                        d="M6 21q-1.125 0-2.225-.55T2 19q.65 0 1.325-.513Q4 17.975 4 17q0-1.25.875-2.125A2.9 2.9 0 0 1 7 14q1.25 0 2.125.875Q10 15.749 10 17q0 1.65-1.175 2.825T6 21m5.75-6L9 12.25l8.95-8.95a.98.98 0 0 1 .687-.288.93.93 0 0 1 .713.288l1.35 1.35q.3.3.3.7t-.3.7z"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-tab-ai-settings" viewBox="0 0 24 24">
                    <path
                        fill="none"
                        stroke="#B4BDCE"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="1.3"
                        d="m10 7-.516 1.394c-.676 1.828-1.014 2.742-1.681 3.409s-1.581 1.005-3.409 1.681L3 14l1.394.516c1.828.676 2.742 1.015 3.409 1.681s1.005 1.581 1.681 3.409L10 21l.516-1.394c.676-1.828 1.015-2.742 1.681-3.409s1.581-1.005 3.409-1.681L17 14l-1.394-.516c-1.828-.676-2.742-1.014-3.409-1.681s-1.005-1.581-1.681-3.409zm8-4-.221.597c-.29.784-.435 1.176-.72 1.461-.286.286-.678.431-1.462.72L15 6l.598.221c.783.29 1.175.435 1.46.72.286.286.431.678.72 1.462L18 9l.221-.597c.29-.784.435-1.176.72-1.461.286-.286.678-.431 1.462-.72L21 6l-.598-.221c-.783-.29-1.175-.435-1.46-.72-.286-.286-.431-.678-.72-1.462z"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-tab-ai-settings-active" viewBox="0 0 24 24">
                    <path
                        strokeWidth="0.5"
                        d="M16.6 13.573c-4.48-1.012-5.173-1.706-6.185-6.185a.45.45 0 0 0-.878 0c-1.012 4.48-1.706 5.173-6.186 6.185a.45.45 0 0 0 0 .878c4.48 1.012 5.174 1.706 6.186 6.185a.45.45 0 0 0 .878 0c1.012-4.479 1.706-5.173 6.185-6.185a.45.45 0 0 0 0-.878Z"
                    ></path>
                    <path
                        strokeWidth="0.3"
                        d="M16.958 3.146a.3.3 0 0 1 .277.184l.015.049c.268 1.184.492 1.907.976 2.39.423.424 1.03.649 1.968.877l.423.1a.3.3 0 0 1 .049.57l-.05.015c-1.183.267-1.906.492-2.39.976-.423.423-.648 1.03-.877 1.967l-.099.423a.3.3 0 0 1-.57.05l-.015-.05c-.268-1.184-.492-1.907-.976-2.39-.423-.424-1.03-.649-1.968-.877l-.423-.099a.3.3 0 0 1-.049-.57l.05-.016c1.183-.267 1.906-.492 2.39-.975.423-.424.648-1.03.877-1.968l.099-.423a.3.3 0 0 1 .293-.233Z"
                    ></path>
                </symbol>

                <symbol id="lbaic-settings-tab-knowledge" viewBox="0 0 24 24">
                    <path
                        fill="none"
                        stroke="#B4BDCE"
                        strokeWidth="1.5"
                        d="M17.566 16.595a1.08 1.08 0 0 1-.566.958l-5.042 2.708-.01.005q-.13.071-.25.102a1 1 0 0 1-.505 0 1 1 0 0 1-.249-.102l-.01-.005-5.042-2.708a1.08 1.08 0 0 1-.567-.959V14.35l4.716 2.54a2.89 2.89 0 0 0 2.818-.006l4.707-2.534zm3.994-7.643.03.014c.007.015.01.024.01.043v6.419q0 .027-.002.035l-.002.008-.01.012-.012.01-.008.002-.035.002a.2.2 0 0 1-.043-.004l-.012-.01-.011-.013-.002-.007-.002-.035V8.897zM11.446 3.6a1 1 0 0 1 .502.133l.007.003 8.623 4.682-.504.272-8.118 4.389-.008.003a1.01 1.01 0 0 1-1.004 0l-.007-.003-8.522-4.613-.006-.004c-.003-.013-.009-.03-.009-.055 0-.024.006-.041.009-.054l.006-.003 8.522-4.613.007-.004q.129-.07.25-.102a1 1 0 0 1 .252-.031Z"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-tab-knowledge-active" viewBox="0 0 24 24">
                    <path
                        stroke="#525F6A"
                        strokeWidth="1.5"
                        d="M17.566 16.595a1.08 1.08 0 0 1-.566.958l-5.042 2.708-.01.005q-.13.071-.25.102a1 1 0 0 1-.505 0 1 1 0 0 1-.249-.102l-.01-.005-5.042-2.708a1.08 1.08 0 0 1-.567-.959V14.35l4.716 2.54a2.89 2.89 0 0 0 2.818-.006l4.707-2.534zm3.994-7.643.03.014c.007.015.01.024.01.043v6.419q0 .027-.002.035l-.002.008-.01.012-.012.01-.008.002-.035.002a.2.2 0 0 1-.043-.004l-.012-.01-.011-.013-.002-.007-.002-.035V8.897zM11.446 3.6a1 1 0 0 1 .502.133l.007.003 8.623 4.682-.504.272-8.118 4.389-.008.003a1.01 1.01 0 0 1-1.004 0l-.007-.003-8.522-4.613-.006-.004c-.003-.013-.009-.03-.009-.055 0-.024.006-.041.009-.054l.006-.003 8.522-4.613.007-.004q.129-.07.25-.102a1 1 0 0 1 .252-.031Z"
                    ></path>
                </symbol>
                <symbol
                    viewBox='0 0 24 24'
                    id='lbaic-settings-tab-knowledge-auto-sync'
                    fill="none"
                    strokeWidth="2"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                >
                    <path d="M3 12a9 9 0 0 1 9-9 9.75 9.75 0 0 1 6.74 2.74L21 8"/>
                    <path d="M21 3v5h-5"/>
                    <path d="M21 12a9 9 0 0 1-9 9 9.75 9.75 0 0 1-6.74-2.74L3 16"/>
                    <path d="M8 16H3v5"/>
                </symbol>
                <symbol
                    viewBox='0 0 24 24'
                    id='lbaic-settings-tab-knowledge-sources'
                    fill="none"
                    strokeWidth="2"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                >
                    <path
                        d="M12 8C16.9706 8 21 6.65685 21 5C21 3.34315 16.9706 2 12 2C7.02944 2 3 3.34315 3 5C3 6.65685 7.02944 8 12 8Z"/>
                    <path
                        d="M3 5V19C2.99443 19.4809 3.3358 19.9552 3.99533 20.383C4.65486 20.8107 5.61323 21.1793 6.78963 21.4577C7.96604 21.7361 9.32602 21.9162 10.7549 21.9827C12.1838 22.0493 13.6397 22.0003 15 21.84"/>
                    <path d="M21 5V8"/>
                    <path d="M21 12L18 17H22L19 22"/>
                    <path
                        d="M3 12C3.00145 12.4675 3.33069 12.9285 3.96146 13.3461C4.59222 13.7636 5.50706 14.1263 6.63296 14.4051C7.75887 14.6839 9.06468 14.8711 10.4462 14.9519C11.8277 15.0326 13.2467 15.0045 14.59 14.87"/>
                </symbol>
                <symbol
                    viewBox='0 0 24 24'
                    id='lbaic-settings-tab-knowledge-recommendations'
                    fill="none"
                    strokeWidth="2"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                >
                    <path
                        d="M21 10V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l2-1.14"/>
                    <path d="m7.5 4.27 9 5.15"/>
                    <polyline points="3.29 7 12 12 20.71 7"/>
                    <line x1="12" x2="12" y1="22" y2="12"/>
                    <circle cx="18.5" cy="15.5" r="2.5"/>
                    <path d="M20.27 17.27 22 19"/>
                </symbol>
                <symbol
                    viewBox='0 0 24 24'
                    id='lbaic-settings-tab-knowledge-settings'
                    fill="none"
                    strokeWidth="2"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                >
                    <path
                        d="M9.671 4.136a2.34 2.34 0 0 1 4.659 0 2.34 2.34 0 0 0 3.319 1.915 2.34 2.34 0 0 1 2.33 4.033 2.34 2.34 0 0 0 0 3.831 2.34 2.34 0 0 1-2.33 4.033 2.34 2.34 0 0 0-3.319 1.915 2.34 2.34 0 0 1-4.659 0 2.34 2.34 0 0 0-3.32-1.915 2.34 2.34 0 0 1-2.33-4.033 2.34 2.34 0 0 0 0-3.831A2.34 2.34 0 0 1 6.35 6.051a2.34 2.34 0 0 0 3.319-1.915"/>
                    <circle cx="12" cy="12" r="3"/>
                </symbol>
                <symbol id="lbaic-settings-tab-cl" viewBox="0 0 24 24">
                    <path
                        d="M12 22a9.7 9.7 0 0 1-3.9-.787 10.1 10.1 0 0 1-3.175-2.137A10.1 10.1 0 0 1 2.787 15.9 9.7 9.7 0 0 1 2 12q0-2.075.787-3.9a10.1 10.1 0 0 1 2.138-3.175q1.35-1.35 3.175-2.137A9.7 9.7 0 0 1 12 2q2.074 0 3.9.788a10.1 10.1 0 0 1 3.175 2.137q1.35 1.35 2.137 3.176A9.7 9.7 0 0 1 22 12a9.7 9.7 0 0 1-.788 3.9 10.1 10.1 0 0 1-2.137 3.175q-1.35 1.35-3.175 2.137A9.7 9.7 0 0 1 12 22m0-2q3.35 0 5.675-2.325T20 12.002t-2.325-5.676T12 4 6.325 6.325 4 12.001q0 3.349 2.325 5.675Q8.649 20 12 20m-.025-1a.84.84 0 0 0 .612-.262.84.84 0 0 0 .263-.613v-.375q1.25-.224 2.15-.974t.9-2.226q0-1.05-.6-1.924-.6-.876-2.4-1.525-1.5-.501-2.075-.876-.575-.374-.575-1.025t.462-1.024q.463-.375 1.338-.375.5 0 .875.174.375.176.625.475.25.3.562.413t.588-.012q.374-.15.512-.513a.69.69 0 0 0-.062-.663 3.8 3.8 0 0 0-.988-.975 2.55 2.55 0 0 0-1.262-.45v-.375a.84.84 0 0 0-.263-.612.84.84 0 0 0-.612-.263.84.84 0 0 0-.613.263.84.84 0 0 0-.262.612v.375q-1.251.276-1.95 1.1T8.5 9.2q0 1.176.687 1.9.688.726 2.163 1.25 1.575.576 2.187 1.026.613.45.613 1.175 0 .825-.588 1.212-.587.388-1.412.388-.65 0-1.175-.313-.525-.312-.875-.937a1.03 1.03 0 0 0-.525-.476.88.88 0 0 0-.65 0 .87.87 0 0 0-.513.475.77.77 0 0 0-.012.675q.4.85 1.075 1.388t1.625.738v.424a.84.84 0 0 0 .262.613.84.84 0 0 0 .613.262"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-tab-cl-active" viewBox="0 0 24 24">
                    <path
                        d="M12 22a9.7 9.7 0 0 1-3.9-.787 10.1 10.1 0 0 1-3.175-2.138q-1.35-1.35-2.138-3.175A9.7 9.7 0 0 1 2 12q0-2.075.787-3.9a10.1 10.1 0 0 1 2.138-3.175q1.35-1.35 3.175-2.137A9.7 9.7 0 0 1 12 2q2.074 0 3.9.788a10.1 10.1 0 0 1 3.175 2.137q1.35 1.35 2.137 3.175A9.7 9.7 0 0 1 22 12a9.7 9.7 0 0 1-.788 3.9 10.1 10.1 0 0 1-2.137 3.175q-1.35 1.35-3.175 2.138A9.7 9.7 0 0 1 12 22m-.025-3a.84.84 0 0 0 .612-.262.84.84 0 0 0 .263-.613v-.375q1.25-.225 2.15-.975t.9-2.225q0-1.05-.6-1.925-.6-.874-2.4-1.525-1.5-.5-2.075-.875-.575-.374-.575-1.025t.462-1.025q.464-.375 1.338-.375.5 0 .875.175t.625.475.562.413.588-.013q.375-.15.512-.512a.69.69 0 0 0-.062-.663 3.8 3.8 0 0 0-.988-.975 2.55 2.55 0 0 0-1.262-.45v-.375a.84.84 0 0 0-.263-.612.84.84 0 0 0-.612-.263.84.84 0 0 0-.613.263.84.84 0 0 0-.262.612v.375q-1.251.275-1.95 1.1T8.5 9.2q0 1.176.687 1.9.688.726 2.163 1.25 1.575.575 2.187 1.025.613.45.613 1.175 0 .825-.588 1.213-.587.387-1.412.387-.65 0-1.175-.312T10.1 14.9a1.03 1.03 0 0 0-.525-.475.88.88 0 0 0-.65 0 .87.87 0 0 0-.513.475.77.77 0 0 0-.012.675q.4.85 1.075 1.388t1.625.737v.425a.84.84 0 0 0 .262.613.84.84 0 0 0 .613.262"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-tab-pw" viewBox="0 0 24 24">
                    <path
                        d="M13.412 7.586v-4.16a1 1 0 0 1 .294-.733 1 1 0 0 1 .73-.293h6.144q.435 0 .728.293.292.291.292.734v4.16a1 1 0 0 1-.295.733 1 1 0 0 1-.73.292h-6.144a.99.99 0 0 1-.727-.292 1 1 0 0 1-.292-.734M2.4 11.55V3.417q0-.432.294-.724a1 1 0 0 1 .73-.293h6.145q.435 0 .727.293a.98.98 0 0 1 .292.724v8.132q0 .433-.294.724a1 1 0 0 1-.73.292H3.419a.99.99 0 0 1-.727-.292.98.98 0 0 1-.292-.724m11.012 9.035v-8.132q0-.432.294-.724a1 1 0 0 1 .73-.292h6.144q.435 0 .728.292a.98.98 0 0 1 .292.724v8.132q0 .433-.295.724a1 1 0 0 1-.73.292h-6.144a.99.99 0 0 1-.727-.292.98.98 0 0 1-.292-.724M2.4 20.574v-4.16a1 1 0 0 1 .294-.733 1 1 0 0 1 .73-.292h6.145q.435 0 .727.292.292.293.292.734v4.159q0 .443-.294.734a1 1 0 0 1-.73.292H3.419a.995.995 0 0 1-1.02-1.026m1.694-9.703h4.8V4.095h-4.8zm11.012 9.035h4.8V13.13h-4.8zm0-12.988h4.8V4.095h-4.8zM4.094 19.906h4.8v-2.823h-4.8z"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-tab-pw-active" viewBox="0 0 24 24">
                    <path
                        d="M14.69 8.5a.9.9 0 0 1-.672-.268.93.93 0 0 1-.268-.685V3.62a.927.927 0 0 1 .95-.953h5.694a.9.9 0 0 1 .671.268.93.93 0 0 1 .268.685v3.927a.926.926 0 0 1-.95.953zM3.605 12a.9.9 0 0 1-.671-.268.9.9 0 0 1-.268-.665V3.6q0-.397.272-.665a.93.93 0 0 1 .677-.268H9.31a.9.9 0 0 1 .672.268q.268.269.268.665v7.467A.926.926 0 0 1 9.3 12zm11.083 9.334a.9.9 0 0 1-.671-.269.9.9 0 0 1-.268-.665v-7.467q0-.396.273-.665a.93.93 0 0 1 .676-.268h5.695a.9.9 0 0 1 .671.269q.268.267.268.665V20.4a.927.927 0 0 1-.95.933zm-11.083 0a.9.9 0 0 1-.671-.268.93.93 0 0 1-.268-.686v-3.926a.926.926 0 0 1 .95-.954h5.693a.9.9 0 0 1 .672.268.93.93 0 0 1 .268.686v3.926a.927.927 0 0 1-.949.954z"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-pw" viewBox="0 0 24 24">
                    <path
                        d="M8.501 21.352c-.139 0-.27-.03-.394-.077a1 1 0 0 1-.34-.225.9.9 0 0 1-.225-.325 1 1 0 0 1-.085-.387l-.023-2.05a5.428 5.428 0 0 1-1.74-.58 5 5 0 0 1-.767-.51 4.6 4.6 0 0 1-.666-.628 5.6 5.6 0 0 1-.541-.735 5.09 5.09 0 0 1-.642-1.687A5 5 0 0 1 3 13.252V7.788q0-.496.093-.982.106-.488.294-.952A5.3 5.3 0 0 1 4.509 4.22a5.128 5.128 0 0 1 2.646-1.377c.333-.07.665-.1 1.006-.1h3.582a.94.94 0 0 1 .65.262.89.89 0 0 1 .194.975.9.9 0 0 1-.488.48.9.9 0 0 1-.356.07H8.161c-.224 0-.441.015-.65.062a3 3 0 0 0-.627.185 3 3 0 0 0-.58.302 3.6 3.6 0 0 0-.503.402 3.6 3.6 0 0 0-.418.496 3.6 3.6 0 0 0-.31.565 3.3 3.3 0 0 0-.247 1.245v5.463c0 .217.016.426.062.642q.067.316.193.62a3.1 3.1 0 0 0 .735 1.075 3.3 3.3 0 0 0 1.1.711c.2.086.417.148.634.194q.323.06.657.062a1.03 1.03 0 0 1 .735.294q.151.148.233.333c.054.123.077.255.085.387l.007 1.26 2.306-1.647a3.33 3.33 0 0 1 1.973-.627h2.855q.337-.002.65-.062.326-.058.627-.186.302-.127.58-.301c.178-.117.349-.256.503-.403.155-.155.294-.317.418-.495a3.1 3.1 0 0 0 .495-1.176c.047-.209.062-.418.062-.635v-2.824a.86.86 0 0 1 .271-.627.942.942 0 0 1 .998-.193.8.8 0 0 1 .294.193.865.865 0 0 1 .27.627v2.824a4.952 4.952 0 0 1-.874 2.8 4.7 4.7 0 0 1-.642.767c-.24.233-.503.441-.781.627-.279.186-.58.34-.89.464a5.3 5.3 0 0 1-.967.287c-.333.07-.673.1-1.014.1h-2.259a3.32 3.32 0 0 0-1.965.627L9.12 21.15a1.06 1.06 0 0 1-.619.201"
                    ></path>
                    <path
                        d="M20.549 4.433h-5.024a.892.892 0 0 0 0 1.785h5.024a.892.892 0 1 0 0-1.785"
                    ></path>
                    <path
                        d="M18.95 2.914a.913.913 0 0 0-1.827 0v4.825a.913.913 0 0 0 1.827 0z"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-pw-active" viewBox="0 0 24 24">
                    <path
                        d="M19.12 3.33a.92.92 0 0 0-.909-.93.92.92 0 0 0-.909.93v1.548h-1.59a.9.9 0 0 0-.889.91c0 .501.398.908.889.908h1.59v1.55c0 .514.407.93.91.93a.92.92 0 0 0 .909-.93v-1.55h1.59c.492 0 .889-.407.889-.909a.9.9 0 0 0-.888-.909H19.12zm-6.948.2c.407 0 .683.42.58.814a5.647 5.647 0 0 0 6.905 6.905c.393-.104.814.172.814.58v1.95a4.8 4.8 0 0 1-.85 2.72 4.6 4.6 0 0 1-.626.743 5.4 5.4 0 0 1-.76.609c-.272.18-.565.33-.866.45-.31.12-.618.218-.942.278a5 5 0 0 1-.986.098h-2.199c-.7 0-1.34.203-1.912.609l-2.974 2.119a1.03 1.03 0 0 1-.987.12 1 1 0 0 1-.33-.218.9.9 0 0 1-.22-.316.9.9 0 0 1-.082-.375l-.023-1.991a5.293 5.293 0 0 1-1.694-.564 5 5 0 0 1-.745-.496 4.5 4.5 0 0 1-.648-.609 5.5 5.5 0 0 1-.527-.713 4.928 4.928 0 0 1-.625-1.638 5 5 0 0 1-.075-.872V8.428c0-.323.03-.638.09-.954.068-.315.166-.623.286-.924a5.1 5.1 0 0 1 1.092-1.585q.353-.339.76-.609a5 5 0 0 1 1.815-.729c.324-.068.648-.098.98-.098z"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-tab-utilities" viewBox="0 0 24 24">
                    <path
                        d="M15 15q2.5 0 4.25-1.75T21 9q0-.5-.075-1a3.7 3.7 0 0 0-.275-.95.94.94 0 0 0-.312-.375 1.2 1.2 0 0 0-.413-.175.965.965 0 0 0-.9.275L16.4 9.4l-1.8-1.8 2.625-2.625a.96.96 0 0 0 .275-.9 1.2 1.2 0 0 0-.175-.413.94.94 0 0 0-.375-.312 3.7 3.7 0 0 0-.95-.275A7 7 0 0 0 15 3q-2.5 0-4.25 1.75T9 9q0 .575.1 1.088.1.512.3 1.012l-5.05 5q-.725.725-.725 1.775t.725 1.775 1.775.725 1.775-.75l5-5.025q.5.2 1.012.3.513.1 1.088.1m0-2q-.65 0-1.3-.2a3.5 3.5 0 0 1-1.175-.625L6.45 18.25a.42.42 0 0 1-.338.113.5.5 0 0 1-.337-.138.46.46 0 0 1-.125-.338q0-.212.125-.337l6.075-6.05q-.45-.5-.65-1.162A4.6 4.6 0 0 1 11 9q0-1.5.963-2.612.962-1.113 2.387-1.338L12.5 6.9q-.3.3-.3.7t.3.7l3.2 3.2q.3.3.7.3t.7-.3l1.85-1.85q-.225 1.425-1.337 2.388Q16.5 13 15 13"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-tab-utilities-active" viewBox="0 0 24 24">
                    <path
                        d="M15.116 14.5q2.287 0 3.894-1.605Q20.615 11.289 20.616 9q0-.328-.047-.664a5 5 0 0 0-.13-.652.56.56 0 0 0-.207-.307 1 1 0 0 0-.326-.147.66.66 0 0 0-.366.003.75.75 0 0 0-.323.195l-2.701 2.664L14.023 7.6l2.644-2.663a.75.75 0 0 0 .196-.332.7.7 0 0 0 .003-.376.9.9 0 0 0-.156-.325.6.6 0 0 0-.298-.207q-.316-.105-.643-.15a5 5 0 0 0-.653-.047q-2.289 0-3.895 1.606T9.616 9.001q0 .69.138 1.27t.415 1.099L4.35 17.177a1.76 1.76 0 0 0-.533 1.295q0 .761.533 1.294t1.294.533 1.295-.539l5.807-5.813q.558.258 1.138.406t1.232.148"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-tab-configs" viewBox="0 0 24 24">
                    <path
                        d="M10.5 7q0-.825.587-1.413A1.93 1.93 0 0 1 12.5 5q.824 0 1.412.587.588.588.588 1.413t-.588 1.412A1.93 1.93 0 0 1 12.5 9q-.825 0-1.413-.588A1.93 1.93 0 0 1 10.5 7m-4 0q0-2.5 1.75-4.25T12.5 1t4.25 1.75T18.5 7q0 1.675-.825 3.037a6.2 6.2 0 0 1-2.175 2.162v8.376q0 .2-.075.387-.075.188-.225.337l-2 2q-.15.15-.325.213a1.1 1.1 0 0 1-.375.063q-.201 0-.375-.063a.9.9 0 0 1-.325-.213l-3.175-3.174a1 1 0 0 1-.2-.3 1.4 1.4 0 0 1-.1-.35.8.8 0 0 1 .025-.35.9.9 0 0 1 .175-.326l.975-1.3-1.075-1.424a.944.944 0 0 1-.15-.888.9.9 0 0 1 .15-.288L9.5 13.375V12.2a6.2 6.2 0 0 1-2.175-2.163Q6.5 8.675 6.5 7m2 0q0 1.4.85 2.462a4.03 4.03 0 0 0 2.15 1.412V14l-1.025 1.45L12 17.5l-1.375 1.776L12.5 21.15l1-1v-9.275a4.03 4.03 0 0 0 2.15-1.413Q16.5 8.399 16.5 7q0-1.65-1.175-2.825T12.5 3 9.675 4.175Q8.499 5.35 8.5 7"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-tab-configs-active" viewBox="0 0 24 24">
                    <path
                        d="M12 10q1.25 0 2.125-.875A2.9 2.9 0 0 0 15 7q0-1.25-.875-2.125A2.9 2.9 0 0 0 12 4q-1.25 0-2.125.875A2.9 2.9 0 0 0 9 7q0 1.25.875 2.125A2.9 2.9 0 0 0 12 10m.025 12.625q-.2 0-.375-.063a1.1 1.1 0 0 1-.325-.187l-2.575-2.25a.97.97 0 0 1-.312-1.038q.062-.188.187-.337L10 17l-1.3-1.3a.9.9 0 0 1-.212-.325 1.1 1.1 0 0 1-.063-.376q0-.2.063-.375A.9.9 0 0 1 8.7 14.3L10 13v-.35a5.8 5.8 0 0 1-2.9-2.174A5.86 5.86 0 0 1 6 7q0-2.5 1.75-4.25T12 1t4.25 1.75T18 7q0 2.025-1.15 3.537T14 12.649v7.95q0 .2-.075.388a1 1 0 0 1-.225.338l-1.025 1.024a1 1 0 0 1-.288.2.86.86 0 0 1-.362.076"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-tab-my-moduls" viewBox="0 0 24 24">
                    <path
                        fillRule="evenodd"
                        d="M8.292 2.858a.858.858 0 0 0-1.716 0v1.43H6.29A2 2 0 0 0 4.288 6.29v.286h-1.43a.858.858 0 0 0 0 1.716h1.43v2.86h-1.43a.858.858 0 0 0 0 1.716h1.43v2.86h-1.43a.858.858 0 0 0 0 1.716h1.43v.286c0 1.105.897 2.002 2.002 2.002h.286v1.43a.858.858 0 1 0 1.716 0v-1.43h2.86v1.43a.858.858 0 1 0 1.716 0v-1.43h2.86v1.43a.858.858 0 1 0 1.716 0v-1.43h.286a2 2 0 0 0 2.002-2.002v-.286h1.43a.858.858 0 1 0 0-1.716h-1.43v-2.86h1.43a.858.858 0 0 0 0-1.716h-1.43v-2.86h1.43a.858.858 0 1 0 0-1.716h-1.43V6.29a2 2 0 0 0-2.002-2.002h-.286v-1.43a.858.858 0 0 0-1.716 0v1.43h-2.86v-1.43a.858.858 0 0 0-1.716 0v1.43h-2.86zM6.004 6.29a.286.286 0 0 1 .286-.286h11.44a.286.286 0 0 1 .286.286v11.44a.286.286 0 0 1-.286.286H6.29a.286.286 0 0 1-.286-.286zm5.776 8.87-.314-.884h-2.32l-.314.883a.858.858 0 1 1-1.617-.576L9.16 9.126l.004-.01.004-.012c.174-.448.59-.813 1.138-.813s.963.365 1.138.814l.003.01.005.012 1.945 5.457a.86.86 0 0 1-1.617.575m-1.474-4.136.547 1.536H9.757zm4.278-1.876a.858.858 0 1 1 1.716 0v5.723a.858.858 0 0 1-1.716 0z"
                        clipRule="evenodd"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-tab-my-moduls-active" viewBox="0 0 24 24">
                    <path
                        fillRule="evenodd"
                        d="M8.69 3.258a.858.858 0 0 0-1.715 0v1.43H6.69A2 2 0 0 0 4.688 6.69v.285h-1.43a.858.858 0 1 0 0 1.716h1.43v2.86h-1.43a.858.858 0 1 0 0 1.715h1.43v2.86h-1.43a.858.858 0 0 0 0 1.715h1.43v.286c0 1.105.896 2.002 2.001 2.002h.286v1.43a.858.858 0 1 0 1.716 0v-1.43h2.86v1.43a.858.858 0 0 0 1.715 0v-1.43h2.86v1.43a.858.858 0 0 0 1.715 0v-1.43h.286a2 2 0 0 0 2.002-2.002v-.286h1.43a.858.858 0 0 0 0-1.715h-1.43v-2.86h1.43a.858.858 0 0 0 0-1.715h-1.43V8.69h1.43a.858.858 0 0 0 0-1.716h-1.43V6.69a2 2 0 0 0-2.002-2.002h-.286v-1.43a.858.858 0 1 0-1.716 0v1.43h-2.86v-1.43a.858.858 0 0 0-1.715 0v1.43H8.69zM6.404 6.69a.286.286 0 0 1 .286-.286h11.438a.286.286 0 0 1 .286.286v11.437a.286.286 0 0 1-.286.286H6.689a.286.286 0 0 1-.286-.286z"
                        clipRule="evenodd"
                    ></path>
                    <path d="M5.545 5.546H19.27V19.27H5.545z"></path>
                    <path
                        fill="#fff"
                        fillRule="evenodd"
                        d="m12.178 15.557-.315-.883H9.545l-.315.883a.858.858 0 0 1-1.616-.577L9.56 9.525l.003-.01.005-.012c.174-.449.59-.813 1.137-.813s.963.364 1.138.814l.003.01.005.012 1.944 5.456a.858.858 0 0 1-1.616.575m-1.474-4.135.547 1.536h-1.095zm4.277-1.876a.858.858 0 0 1 1.716 0v5.723a.858.858 0 1 1-1.716 0z"
                        clipRule="evenodd"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-tab-storage" viewBox="0 0 24 24">
                    <path
                        d="M12 21q-3.775 0-6.387-1.163Q3 18.676 3 17V7q0-1.65 2.638-2.825T12 3t6.363 1.175T21 7v10q0 1.676-2.613 2.837Q15.776 21 12 21m0-11.975q2.225 0 4.475-.638Q18.725 7.75 19 7.025q-.274-.725-2.512-1.375a15.87 15.87 0 0 0-8.95-.013Q5.35 6.276 5 7.026q.35.75 2.537 1.375 2.188.625 4.463.625M12 14q1.05 0 2.025-.1t1.862-.287 1.675-.463A10 10 0 0 0 19 12.525v-3a10 10 0 0 1-1.437.625q-.788.275-1.675.463-.888.187-1.863.287T12 11t-2.05-.1a18 18 0 0 1-1.887-.287A13 13 0 0 1 6.4 10.15 9 9 0 0 1 5 9.525v3q.625.35 1.4.625t1.662.463 1.888.287T12 14m0 5q1.15 0 2.338-.175 1.187-.175 2.187-.462t1.675-.65.8-.738v-2.45a10 10 0 0 1-1.437.625q-.788.274-1.675.463-.888.187-1.863.287T12 16t-2.05-.1a18 18 0 0 1-1.887-.287A13 13 0 0 1 6.4 15.15a9 9 0 0 1-1.4-.625V17q.125.375.787.725.663.35 1.663.637t2.2.463T12 19"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-tab-storage-active" viewBox="0 0 24 24">
                    <path
                        d="M12 11q3.75 0 6.375-1.175T21 7t-2.625-2.825T12 3 5.625 4.175 3 7t2.625 2.825T12 11m0 2.5q1.024 0 2.563-.213a16.5 16.5 0 0 0 2.962-.687q1.425-.476 2.45-1.237Q21 10.6 21 9.5V12q0 1.1-1.025 1.863t-2.45 1.237-2.962.687Q13.024 16 12 16t-2.562-.213a16.5 16.5 0 0 1-2.963-.687q-1.425-.476-2.45-1.237Q3 13.1 3 12V9.5q0 1.1 1.025 1.863t2.45 1.237 2.963.688T12 13.5m0 5q1.024 0 2.563-.212a16.5 16.5 0 0 0 2.962-.688q1.425-.476 2.45-1.238T21 14.5V17q0 1.1-1.025 1.863t-2.45 1.237-2.962.688Q13.024 21 12 21t-2.562-.212a16.5 16.5 0 0 1-2.963-.688q-1.425-.476-2.45-1.237Q3 18.099 3 17v-2.5q0 1.1 1.025 1.863t2.45 1.237 2.963.688T12 18.5"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-tab-indexes" viewBox="0 0 20 20">
                    <path
                        stroke="#B4BDCE"
                        fill="none"
                        strokeWidth="1.28"
                        d="M4.667 13.22 8.4 9.486l3.733 1.6 4.8-4.8m.634 0H13.2m3.733-.64v4.374"
                    ></path>
                    <path
                        d="M3.504 3.758v11.936h13.75a.76.76 0 0 1 .533.224.79.79 0 0 1 .224.544.76.76 0 0 1-.224.544.76.76 0 0 1-.534.224H2.747a.76.76 0 0 1-.534-.224.78.78 0 0 1-.224-.544V3.758c0-.202.075-.394.224-.544a.76.76 0 0 1 .534-.224.76.76 0 0 1 .533.224.79.79 0 0 1 .224.544"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-tab-indexes-active" viewBox="0 0 20 20">
                    <rect width="16" height="14.18" x="2" y="3" rx="1"></rect>
                    <path
                        stroke="#fff"
                        strokeWidth="1.28"
                        d="m4 13.166 3.514-3.514 3.513 1.506 4.518-4.518m.596 0h-4.11M15.545 6v4.154"
                    ></path>
                </symbol>
                <symbol
                    viewBox='0 0 24 24'
                    id='lbaic-settings-tab-settings-general'
                    strokeWidth="2"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    fill="none"
                >
                    <path d="M14 17H5"/>
                    <path d="M19 7h-9"/>
                    <circle cx="17" cy="17" r="3"/>
                    <circle cx="7" cy="7" r="3"/>
                </symbol>
                <symbol
                    viewBox='0 0 24 24'
                    id='lbaic-settings-tab-uninstall'
                    strokeWidth="2"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    fill="none"
                >
                    <path
                        d="M19 14a1 1 0 0 0 1-1v-1a2 2 0 0 0-2-2h-3a1 1 0 0 1-1-1V4a2 2 0 0 0-4 0v5a1 1 0 0 1-1 1H6a2 2 0 0 0-2 2v1a1 1 0 0 0 1 1"/>
                    <path d="M19 14H5l-1.973 6.767A1 1 0 0 0 4 22h16a1 1 0 0 0 .973-1.233z"/>
                    <path d="m8 22 1-4"/>
                </symbol>

                <symbol id="lbaic-settings-empty-qas-active" viewBox="0 0 24 24">
                    <path
                        d="M20.727 20.348q-.054.457-.523.608-.468.15-.827-.21l-2.013-2.025h-8.91q-.75 0-1.283-.537a1.77 1.77 0 0 1-.535-1.291v-.274H17q.787 0 1.348-.564t.561-1.356V6.565h.273q.75 0 1.284.537T21 8.392v11.675q0 .123-.082.202a.27.27 0 0 1-.191.079m-16.78-3.793a.97.97 0 0 1-.65-.262Q3 16.032 3 15.578V4.92q0-.792.561-1.356A1.83 1.83 0 0 1 4.91 3h9.727q.788 0 1.349.564t.56 1.356v7.403q0 .792-.56 1.355a1.83 1.83 0 0 1-1.349.564h-8l-2.013 2.025a.94.94 0 0 1-.676.288"
                    ></path>
                </symbol>
                <symbol viewBox='0 0 20 20' id='lbaic-settings-tab-arrow'>
                    <path
                        strokeLinecap="round"
                        strokeWidth="2.4"
                        d="m8 3 2.774 6.103a1.2 1.2 0 0 1 0 .994L8 16.2"
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-schedule'>
                    <path
                        d="M13 11.6V8a.97.97 0 0 0-.287-.713A.97.97 0 0 0 12 7a.97.97 0 0 0-.713.287A.97.97 0 0 0 11 8v3.975q0 .2.075.388.075.187.225.337l3.3 3.3a.95.95 0 0 0 .7.275A.95.95 0 0 0 16 16a.95.95 0 0 0 .275-.7.95.95 0 0 0-.275-.7zM12 22a9.7 9.7 0 0 1-3.9-.788 10.1 10.1 0 0 1-3.175-2.137q-1.35-1.35-2.137-3.175A9.7 9.7 0 0 1 2 12q0-2.075.788-3.9a10.1 10.1 0 0 1 2.137-3.175q1.35-1.35 3.175-2.137A9.7 9.7 0 0 1 12 2q2.075 0 3.9.788a10.1 10.1 0 0 1 3.175 2.137q1.35 1.35 2.137 3.175A9.7 9.7 0 0 1 22 12a9.7 9.7 0 0 1-.788 3.9 10.1 10.1 0 0 1-2.137 3.175q-1.35 1.35-3.175 2.137A9.7 9.7 0 0 1 12 22m0-2q3.325 0 5.663-2.337T20 12t-2.337-5.662T12 4 6.338 6.338 4 12t2.338 5.663T12 20"
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-message'>
                    <path
                        d="m19.8 12.925-15.4 6.5a.99.99 0 0 1-.95-.087Q3 19.05 3 18.5v-13q0-.55.45-.837a.99.99 0 0 1 .95-.088l15.4 6.5q.625.276.625.925 0 .65-.625.925M5 17l11.85-5L5 7v3.5l6 1.5-6 1.5z"
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-message-active'>
                    <path
                        fill="#232323"
                        d="M4.4 19.425a.99.99 0 0 1-.95-.087Q3 19.05 3 18.5V14l8-2-8-2V5.5q0-.55.45-.837a.99.99 0 0 1 .95-.088l15.4 6.5q.625.276.625.925 0 .65-.625.925z"
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-lead-capture' fill="none" stroke="currentColor"
                        strokeWidth="2" strokeLinecap="round" strokeLinejoin="round">
                    <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path>
                    <circle cx="9" cy="7" r="4"></circle>
                    <line x1="19" x2="19" y1="8" y2="14"></line>
                    <line x1="22" x2="16" y1="11" y2="11"></line>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-lead-capture-active' fill="none" stroke="currentColor"
                        strokeWidth="2" strokeLinecap="round" strokeLinejoin="round">
                    <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path>
                    <circle cx="9" cy="7" r="4"></circle>
                    <line x1="19" x2="19" y1="8" y2="14"></line>
                    <line x1="22" x2="16" y1="11" y2="11"></line>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-notification-close'>
                    <path
                        d="m12 14.555-8.943 8.943Q2.555 24 1.779 24q-.775 0-1.277-.502T0 22.221t.502-1.278L9.445 12 .502 3.057Q0 2.555 0 1.779 0 1.004.502.502T1.779 0t1.278.502L12 9.445 20.943.502Q21.445 0 22.22 0q.777 0 1.278.502.502.502.502 1.277 0 .776-.502 1.278L14.555 12l8.943 8.943q.502.502.502 1.277 0 .777-.502 1.278-.502.502-1.277.502-.776 0-1.278-.502z"
                        opacity="0.8"
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-post'>
                    <path
                        d="m21.98 9.095-6.394 6.395v3.375a.82.82 0 0 1-.244.589l-.33.33a.83.83 0 0 1-.601.248.83.83 0 0 1-.617-.255l-3.016-3.017-9.348 6.99a.8.8 0 0 1-.59.25.8.8 0 0 1-.59-.251.8.8 0 0 1-.25-.59q0-.337.251-.588l6.99-9.348-3.017-3.017a.83.83 0 0 1-.256-.616.83.83 0 0 1 .249-.6l.33-.33a.82.82 0 0 1 .589-.244H8.51l6.396-6.396-.59-.59a.8.8 0 0 1-.25-.59q0-.338.25-.59a.8.8 0 0 1 .59-.25q.339 0 .589.251l8.255 8.255q.25.25.25.59a.8.8 0 0 1-.251.59.8.8 0 0 1-.59.25.8.8 0 0 1-.588-.251z"
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-pdf'>
                    <path
                        fillRule="evenodd"
                        d="M6.308 18H5.077v1.5h1.23c.462 0 .77-.3.77-.75s-.308-.75-.77-.75m8-18H2v24h20V7.5zM8.462 18.9c0 1.2-.924 2.1-2.154 2.1H5.077v1.5H3.538v-6h2.77c1.23 0 2.154.9 2.154 2.1zm6.307.75c0 1.5-1.23 2.85-2.923 2.85H9.692v-6h2.154c1.539 0 2.923 1.2 2.923 2.85zM20.462 18h-3.077v1.5h2.307V21h-2.307v1.5h-1.539v-6h4.616zm0-3H3.538V1.5h10.77v6h6.154zm-8.616 3h-.615v3h.615c.923 0 1.539-.6 1.539-1.5s-.77-1.5-1.539-1.5"
                        clipRule="evenodd"
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-txt'>
                    <path
                        d="M15.333 0 22 6v18H2V0zM3.667 1.5V3h10V1.5zM15.333 6h5l-5-4.5zM3.667 4.5V6h10V4.5zM20.333 9V7.5H3.667V9zm0 3v-1.5H3.667V12zm0 3v-1.5H3.667V15zm-6.666 3v-1.5h-10V18z"
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-qas'>
                    <path
                        d="M23.636 23.13q-.072.61-.697.81-.624.202-1.103-.28l-2.684-2.699H7.271a2.33 2.33 0 0 1-1.711-.716 2.35 2.35 0 0 1-.712-1.721v-.366h13.818q1.05 0 1.797-.752a2.47 2.47 0 0 0 .748-1.807V4.753h.364q1 0 1.712.716Q24 6.184 24 7.19v15.566q0 .165-.109.27a.36.36 0 0 1-.255.104M1.576 16.03l2.61-2.624h11.33a.94.94 0 0 0 .696-.274.95.95 0 0 0 .273-.7V2.559a.95.95 0 0 0-.273-.7.94.94 0 0 0-.697-.275H2.545a.94.94 0 0 0-.696.274.95.95 0 0 0-.273.701zm-.313 2.044q-.469 0-.866-.349T0 16.77V2.56Q0 1.502.748.751A2.44 2.44 0 0 1 2.546 0h12.97q1.049 0 1.797.752.748.75.748 1.807v9.872a2.47 2.47 0 0 1-.748 1.807 2.45 2.45 0 0 1-1.798.752H4.85l-2.685 2.7a1.25 1.25 0 0 1-.901.383"
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-qas-active'>
                    <path
                        d="M23.636 23.13q-.072.61-.697.81-.624.202-1.103-.28l-2.684-2.699H7.271a2.33 2.33 0 0 1-1.711-.716 2.35 2.35 0 0 1-.712-1.721v-.366h13.818q1.05 0 1.797-.752a2.47 2.47 0 0 0 .748-1.807V4.753h.364q1 0 1.712.716Q24 6.184 24 7.19v15.566q0 .165-.109.27a.36.36 0 0 1-.255.104M1.263 18.073q-.469 0-.866-.349T0 16.77V2.56Q0 1.502.748.751A2.44 2.44 0 0 1 2.546 0h12.97q1.049 0 1.797.752.748.75.748 1.807v9.872a2.47 2.47 0 0 1-.748 1.807 2.45 2.45 0 0 1-1.798.752H4.85l-2.685 2.7a1.25 1.25 0 0 1-.901.383"
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-tab-qas'>
                    <path
                        d="M22.113 21.691q-.06.508-.582.676-.52.168-.92-.234l-2.239-2.251H8.466q-.834 0-1.428-.597a1.96 1.96 0 0 1-.594-1.436v-.305h11.524a2.04 2.04 0 0 0 1.5-.627 2.06 2.06 0 0 0 .623-1.507V6.364h.303q.834 0 1.428.597t.594 1.436v12.982q0 .137-.091.224a.3.3 0 0 1-.212.088M3.714 15.768 5.89 13.58h9.45q.355 0 .58-.228a.8.8 0 0 0 .228-.585V4.536a.8.8 0 0 0-.227-.585.79.79 0 0 0-.581-.228H4.523a.79.79 0 0 0-.581.228.8.8 0 0 0-.228.585zm-.26 1.705q-.392 0-.723-.29-.33-.292-.331-.796V4.535q0-.88.624-1.508A2.04 2.04 0 0 1 4.523 2.4H15.34a2.04 2.04 0 0 1 1.5.627q.623.627.623 1.508v8.233a2.06 2.06 0 0 1-.624 1.507 2.04 2.04 0 0 1-1.5.627H6.445l-2.24 2.251a1.04 1.04 0 0 1-.75.32"
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-tab-qas-active'>
                    <path
                        d="M22.113 21.691q-.06.508-.582.676-.52.168-.92-.234l-2.239-2.251H8.466q-.834 0-1.428-.597a1.96 1.96 0 0 1-.594-1.436v-.305h11.524a2.04 2.04 0 0 0 1.5-.627 2.06 2.06 0 0 0 .623-1.507V6.364h.303q.834 0 1.428.597t.594 1.436v12.982q0 .137-.091.224a.3.3 0 0 1-.212.088m-18.66-4.218q-.39 0-.722-.29-.33-.292-.331-.796V4.535q0-.88.624-1.508A2.04 2.04 0 0 1 4.523 2.4H15.34a2.04 2.04 0 0 1 1.5.627q.623.627.623 1.508v8.233a2.06 2.06 0 0 1-.624 1.507 2.04 2.04 0 0 1-1.5.627H6.445l-2.24 2.251a1.04 1.04 0 0 1-.75.32"
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-tab-live-agent'>
                    <path
                        d="M12 23v-2h7v-1h-4v-8h4v-1q0-2.9-2.05-4.95T12 4 7.05 6.05 5 11v1h4v8H5q-.824 0-1.412-.587A1.93 1.93 0 0 1 3 18v-7q0-1.85.712-3.487A9.2 9.2 0 0 1 5.65 4.65a9.2 9.2 0 0 1 2.862-1.938A8.65 8.65 0 0 1 12 2q1.85 0 3.488.712A9.2 9.2 0 0 1 18.35 4.65a9.2 9.2 0 0 1 1.938 2.863A8.65 8.65 0 0 1 21 11v10q0 .824-.587 1.413A1.93 1.93 0 0 1 19 23zm-7-5h2v-4H5zm12 0h2v-4h-2z"
                    ></path>
                </symbol>
                <symbol
                    id="lbaic-settings-tab-leads"
                    viewBox="0 0 24 24"
                    strokeWidth="1.5"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                >
                    <path
                        d="M16 20V18.3333C16 17.4493 15.6689 16.6014 15.0795 15.9763C14.4901 15.3512 13.6907 15 12.8571 15H8.14286C7.30932 15 6.50992 15.3512 5.92052 15.9763C5.33112 16.6014 5 17.4493 5 18.3333V20"/>
                    <path
                        d="M16 4C16.5726 4.20101 17.0796 4.65378 17.4416 5.28725C17.8036 5.92072 18 6.69902 18 7.5C18 8.30098 17.8036 9.07928 17.4416 9.71275C17.0796 10.3462 16.5726 10.799 16 11"/>
                    <path
                        d="M20 20V18.2964C19.9996 17.5415 19.8029 16.8082 19.4409 16.2115C19.0789 15.6149 18.5721 15.1887 18 15"/>
                    <path
                        d="M10.5 11C12.433 11 14 9.433 14 7.5C14 5.567 12.433 4 10.5 4C8.567 4 7 5.567 7 7.5C7 9.433 8.567 11 10.5 11Z"/>
                </symbol>
                <symbol
                    id="lbaic-settings-tab-actions"
                    viewBox="0 0 24 24"
                    fill="none"
                    strokeWidth="2"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                >
                    <path
                        d="M4 14a1 1 0 0 1-.78-1.63l9.9-10.2a.5.5 0 0 1 .86.46l-1.92 6.02A1 1 0 0 0 13 10h7a1 1 0 0 1 .78 1.63l-9.9 10.2a.5.5 0 0 1-.86-.46l1.92-6.02A1 1 0 0 0 11 14z"/>
                </symbol>
                <symbol id="lbaic-settings-menu-actions" viewBox="0 0 24 24">
                    <path
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="1.5"
                        d="M5.78 13.6a.76.76 0 0 1-.416-.123.8.8 0 0 1-.288-.332.82.82 0 0 1 .098-.85l7.697-8.157a.38.38 0 0 1 .477-.09c.078.042.139.11.174.194a.4.4 0 0 1 .017.264L12.047 9.32a.82.82 0 0 0 .09.737.8.8 0 0 0 .28.252.76.76 0 0 0 .36.09h5.443c.147 0 .291.042.416.123s.224.195.288.332a.82.82 0 0 1-.098.85l-7.697 8.157a.379.379 0 0 1-.477.09.4.4 0 0 1-.174-.194.4.4 0 0 1-.017-.264l1.492-4.815a.82.82 0 0 0-.09-.737.8.8 0 0 0-.28-.252.76.76 0 0 0-.36-.09z"
                    ></path>
                </symbol>
                <symbol
                    id="lbaic-settings-tab-integrations"
                    viewBox="0 0 24 24"
                    fill="none"
                    strokeWidth="2"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                >
                    <path
                        d="M10 22V7a1 1 0 0 0-1-1H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2v-5a1 1 0 0 0-1-1H2"/>
                    <rect x="14" y="2" width="8" height="8" rx="1"/>
                </symbol>
                <symbol
                    id="lbaic-settings-menu-notifications"
                    xmlns="http://www.w3.org/2000/svg"
                    viewBox="0 0 24 24"
                    fill="none"
                    strokeWidth="1.5"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                >
                    <path
                        d="M10.6144 19.2001C10.7549 19.4433 10.9568 19.6453 11.2001 19.7857C11.4433 19.9261 11.7192 20 12 20C12.2809 20 12.5568 19.9261 12.8 19.7857C13.0432 19.6453 13.2452 19.4433 13.3856 19.2001"/>
                    <path d="M20.0001 8.80002C20.0001 6.96001 19.3601 5.36001 18.4001 4"/>
                    <path
                        d="M5.00961 14.6608C4.9051 14.7754 4.83613 14.9178 4.81109 15.0709C4.78605 15.2239 4.80602 15.3809 4.86857 15.5228C4.93112 15.6647 5.03356 15.7853 5.16341 15.87C5.29327 15.9548 5.44495 15.9999 5.60001 16.0001H18.4001C18.5551 16.0001 18.7068 15.9551 18.8368 15.8705C18.9667 15.786 19.0693 15.6655 19.132 15.5237C19.1947 15.3819 19.2149 15.2249 19.19 15.0719C19.1652 14.9188 19.0964 14.7763 18.9921 14.6616C17.9281 13.5648 16.8001 12.3992 16.8001 8.80002C16.8001 7.52698 16.2943 6.30607 15.3942 5.40589C14.494 4.50571 13.2731 4 12 4C10.727 4 9.50609 4.50571 8.60591 5.40589C7.70573 6.30607 7.20002 7.52698 7.20002 8.80002C7.20002 12.3992 6.07121 13.5648 5.00961 14.6608Z"/>
                    <path d="M5.60001 4C4.64 5.36001 4 6.96001 4 8.80002"/>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-q_a'>
                    <path
                        d="M11.5 0A11.5 11.5 0 1 0 23 11.5 11.51 11.51 0 0 0 11.5 0m-.123 18.849a1.122 1.122 0 1 1 0-2.245 1.122 1.122 0 0 1 0 2.245m4.285-8.213a4.18 4.18 0 0 1-2.48 2.3c-.183.08-.341.208-.46.37a1 1 0 0 0-.201.606v.797a1.122 1.122 0 0 1-2.244 0v-.83a3.23 3.23 0 0 1 .617-1.874c.39-.518.925-.908 1.537-1.122.266-.085.508-.231.707-.426a1.83 1.83 0 0 0 .606-1.414 1.9 1.9 0 0 0-.18-.774 2.24 2.24 0 0 0-.695-.774 2.24 2.24 0 0 0-.999-.404 2.55 2.55 0 0 0-1.615.224c-.488.24-.882.635-1.122 1.122a1.122 1.122 0 0 1-2.042-.931 4.68 4.68 0 0 1 5.116-2.66 4.5 4.5 0 0 1 1.93.786 4.6 4.6 0 0 1 1.402 1.605 4.15 4.15 0 0 1 .09 3.422z"
                    ></path>
                </symbol>
                <symbol viewBox='0 0 24 24' id='lbaic-settings-text'>
                    <path
                        d="M.75 15.429a.68.68 0 0 1-.534-.247A.9.9 0 0 1 0 14.57q0-.364.216-.61a.68.68 0 0 1 .534-.246h9q.319 0 .534.247a.9.9 0 0 1 .216.612.9.9 0 0 1-.216.61.68.68 0 0 1-.534.246zm0-6.858a.68.68 0 0 1-.534-.246A.9.9 0 0 1 0 7.713q0-.365.216-.61a.68.68 0 0 1 .534-.246h15q.318 0 .534.247a.9.9 0 0 1 .216.612.9.9 0 0 1-.216.61.68.68 0 0 1-.534.245zm0-6.857a.68.68 0 0 1-.534-.247A.9.9 0 0 1 0 .856Q0 .49.216.246A.68.68 0 0 1 .75 0h15q.318 0 .534.247a.9.9 0 0 1 .216.611.9.9 0 0 1-.216.61.68.68 0 0 1-.534.246zm11.596 20.901v-1.84q0-.262.084-.508t.28-.47l7.635-8.684q.222-.22.459-.326a1.15 1.15 0 0 1 .978.005q.25.11.452.331l1.388 1.619q.185.254.281.527.097.274.097.547 0 .274-.078.553a1.4 1.4 0 0 1-.3.532l-7.598 8.684q-.196.224-.412.32a1.1 1.1 0 0 1-.445.095h-1.61q-.514 0-.863-.398-.348-.398-.348-.987m8.94-7.16 1.387-1.639-1.387-1.618-1.425 1.629zm-7.613 7.029h1.425L20.3 16.53l-.704-.815-.683-.837-5.239 5.977zm0 0v-1.629l5.239-5.977 1.387 1.652-5.2 5.954z"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-widget-text" viewBox="0 0 24 24">
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="M12 4v16M4 7V5a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v2M9 20h6"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-widget-text-active" viewBox="0 0 24 24">
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="M12 4v16M4 7V5a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v2M9 20h6"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-source-url" viewBox="0 0 24 24">
                    <path
                        stroke="currentColor"
                        fill="none"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        d="M10 13a5 5 0 0 0 7.54.54l3-3a5 5 0 0 0-7.07-7.07l-1.72 1.71M14 11a5 5 0 0 0-7.54-.54l-3 3a5 5 0 0 0 7.07 7.07l1.71-1.71"
                    ></path>
                </symbol>
                <symbol
                    id="lbaic-settings-source-sitemap"
                    viewBox="0 0 24 24"
                    xmlns="http://www.w3.org/2000/svg"
                    strokeWidth="2"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                >
                    <rect x="16" y="16" width="6" height="6" rx="1"/>
                    <rect x="2" y="16" width="6" height="6" rx="1"/>
                    <rect x="9" y="2" width="6" height="6" rx="1"/>
                    <path d="M5 16v-3a1 1 0 0 1 1-1h12a1 1 0 0 1 1 1v3"/>
                    <path d="M12 12V8"/>
                </symbol>
                <symbol id="lbaic-settings-wordpress" viewBox="0 0 24 24">
                    <path
                        fillRule="evenodd"
                        d="M0 12a12 12 0 0 0 6.763 10.8L1.039 7.115A12 12 0 0 0 0 12m20.1-.606c0-1.483-.533-2.51-.989-3.309-.608-.989-1.179-1.826-1.179-2.815 0-1.103.837-2.13 2.016-2.13.053 0 .103.007.155.01A11.96 11.96 0 0 0 12 0C7.807 0 4.12 2.151 1.973 5.408c.282.01.548.015.773.015 1.255 0 3.198-.153 3.198-.153.647-.038.723.913.077.989 0 0-.65.076-1.374.115l4.37 12.998 2.627-7.876-1.87-5.122c-.646-.039-1.259-.115-1.259-.115-.646-.038-.57-1.027.077-.989 0 0 1.981.153 3.16.153 1.255 0 3.198-.153 3.198-.153.648-.038.723.913.077.989 0 0-.651.076-1.373.115l4.336 12.899 1.198-4c.518-1.66.913-2.852.913-3.879m2.43-5.151q.079.572.08 1.233c0 1.218-.227 2.587-.912 4.299l-3.665 10.597A11.99 11.99 0 0 0 24 12c0-2.087-.533-4.048-1.47-5.757m-10.32 6.806-3.6 10.463a12 12 0 0 0 7.375-.192 1 1 0 0 1-.086-.165z"
                        clipRule="evenodd"
                    ></path>
                </symbol>

                <symbol id="lbaic-settings-wordpress-unselected" viewBox="0 0 24 24">
                    <path
                        d="M22.8 12c0-5.965-4.835-10.8-10.8-10.8S1.2 6.035 1.2 12 6.035 22.8 12 22.8 22.8 17.965 22.8 12m1.2 0c0 6.628-5.372 12-12 12-6.627 0-12-5.372-12-12C0 5.373 5.373 0 12 0c6.628 0 12 5.373 12 12"
                    ></path>
                    <path
                        d="m8.824 22.875 3.414-9.82 3.535 9.52 1.768-.957 3.413-9.7c.61-1.558.793-2.815.793-3.893.06-1.976-.793-3.712-2.255-3.892-1.341-.12-2.073 1.138-2.012 1.916.122 1.796 1.95 2.814 1.95 5.27 0 1.796-1.158 4.61-1.95 7.305L13.518 7.007c.67-.06 1.28-.06 1.28-.06.61-.06.549-.958-.061-.898-2.012.18-3.84.12-5.852 0-.61-.06-.67.838-.06.898 0 0 .548 0 1.157.06l1.707 4.61-2.438 7.126L5.289 7.007c.67-.06 1.219-.06 1.219-.06.61-.06.548-.958-.061-.898-1.829.12-3.597.24-4.023-.06l-.549 1.497 5.364 14.55z"
                    ></path>
                </symbol>

                <symbol id="lbaic-settings-page" viewBox="0 0 24 24">
                    <path
                        d="M20.461 0C21.311 0 22 .668 22 1.493v16.513c0 .825-.69 1.493-1.539 1.493H8.151c-.849 0-1.538-.668-1.538-1.493V1.493C6.613.668 7.303 0 8.152 0z"
                    ></path>
                    <path
                        fillRule="evenodd"
                        d="M5.077 18.76c0 1.238 1.034 2.24 2.308 2.24h8.463c.85 0 1.538.676 1.538 1.5 0 .825-.688 1.5-1.538 1.5H3.538C2.689 24 2 23.332 2 22.507V5.994C2 5.169 2.689 4.5 3.539 4.5s1.538.668 1.538 1.493z"
                        clipRule="evenodd"
                    ></path>
                </symbol>

                <symbol id='lbaic-settings-external-link' viewBox='0 0 24 24'>
                    <path
                        id="lbaic-settings-external-arrow"
                        fillRule='evenodd'
                        d='M13.164 6.545c0-.361.293-.654.654-.654h3.637c.361 0 .654.293.654.654v3.637a.654.654 0 1 1-1.309 0V8.126l-3.974 3.973a.655.655 0 0 1-.925-.925L15.874 7.2h-2.056a.655.655 0 0 1-.654-.655'
                        clipRule='evenodd'
                    ></path>
                    <path
                        id="lbaic-external-box"
                        fillRule='evenodd'
                        d='M7.92 7.997a.673.673 0 0 0-.673.674v7.408a.673.673 0 0 0 .674.674h7.408a.674.674 0 0 0 .674-.674v-2.21a.673.673 0 1 1 1.347 0v2.21a2.02 2.02 0 0 1-2.02 2.021H7.92a2.02 2.02 0 0 1-2.02-2.02V8.67a2.02 2.02 0 0 1 2.02-2.02h2.253a.674.674 0 1 1 0 1.347z'
                        clipRule='evenodd'
                    ></path>
                </symbol>
                <symbol id='lbaic-settings-mp-popup-company'
                        width="24"
                        height="24"
                        fill="none"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="1.3"
                        viewBox="0 0 24 24">
                    <path
                        d="M12 10h.01M12 14h.01M12 6h.01M16 10h.01M16 14h.01M16 6h.01M8 10h.01M8 14h.01M8 6h.01M9 22v-3a1 1 0 0 1 1-1h4a1 1 0 0 1 1 1v3"></path>
                    <rect width="16" height="20" x="4" y="2" rx="2"></rect>
                </symbol>
                <symbol id='lbaic-settings-user-2'
                        width="24"
                        height="24"
                        fill="none"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2"
                        viewBox="0 0 24 24">
                    <path d="M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"></path>
                    <circle cx="12" cy="7" r="4"></circle>
                </symbol>
                <symbol id='lbaic-settings-mp-popup-product'
                        width="24"
                        height="24"
                        fill="none"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="1.3"
                        viewBox="0 0 24 24">
                    <path
                        d="M21 8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16Z"></path>
                    <path d="m3.3 7 8.7 5 8.7-5M12 22V12"></path>
                </symbol>
                <symbol
                    id='lbaic-settings-globe'
                    viewBox="0 0 24 24"
                    fill="none"
                    strokeWidth="2"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                >
                    <circle cx="12" cy="12" r="10"></circle>
                    <path d="M12 2a14.5 14.5 0 0 0 0 20 14.5 14.5 0 0 0 0-20"></path>
                    <path d="M2 12h20"></path>
                </symbol>
                <symbol
                    id='lbaic-settings-briefcase'
                    viewBox="0 0 24 24"
                    strokeWidth="2"
                    strokeLinecap="round"
                    strokeLinejoin="round"
                >
                    <path d="M16 20V4a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v16"></path>
                    <rect width="20" height="14" x="2" y="6" rx="2"></rect>
                </symbol>

                <symbol id='lbaic-settings-people' viewBox='0 0 24 24' strokeWidth='2'>
                    <path d="M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"></path>
                    <circle cx="12" cy="7" r="4"></circle>
                </symbol>

                <symbol id='lbaic-settings-more' viewBox='0 0 24 24'
                        stroke='currentColor'
                        strokeLinecap='round'
                        strokeLinejoin='round'
                        strokeWidth='2'>
                    <circle cx="12" cy="12" r="1"></circle>
                    <circle cx="12" cy="5" r="1"></circle>
                    <circle cx="12" cy="19" r="1"></circle>
                </symbol>
                <symbol id='lbaic-settings-time' viewBox='0 0 24 24' strokeWidth='2'>
                    <circle cx="12" cy="12" r="10"></circle>
                    <path d="M12 6v6l4 2"></path>
                </symbol>
                <symbol id='lbaic-settings-comment' viewBox='0 0 24 24' strokeWidth='2'>
                    <path d="M7.9 20A9 9 0 1 0 4 16.1L2 22Z"></path>
                </symbol>
                <symbol id='lbaic-settings-sortable'
                        viewBox='0 0 24 24'
                        fill='none'
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2"
                >
                    <path d="m21 16-4 4-4-4M17 20V4M3 8l4-4 4 4M7 4v16"></path>
                </symbol>
                <symbol id='lbaic-settings-filter'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <path d="M21 4h-7M10 4H3M21 12h-9M8 12H3M21 20h-5M12 20H3M14 2v4M8 10v4M16 18v4"></path>
                </symbol>
                <symbol id='lbaic-settings-refresh-chat'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <path d="M3 12a9 9 0 0 1 9-9 9.75 9.75 0 0 1 6.74 2.74L21 8"></path>
                    <path d="M21 3v5h-5M21 12a9 9 0 0 1-9 9 9.75 9.75 0 0 1-6.74-2.74L3 16"></path>
                    <path d="M8 16H3v5"></path>
                </symbol>
                <symbol id='lbaic-settings-download'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4M7 10l5 5 5-5M12 15V3"></path>
                </symbol>
                <symbol id='lbaic-settings-join-chat'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
                </symbol>

                <symbol id='lbaic-settings-add-file'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <path
                        d="M13.234 20.252 21 12.3M16 6l-8.414 8.586a2 2 0 0 0 0 2.828 2 2 0 0 0 2.828 0l8.414-8.586a4 4 0 0 0 0-5.656 4 4 0 0 0-5.656 0l-8.415 8.585a6 6 0 1 0 8.486 8.486"></path>
                </symbol>
                <symbol id='lbaic-settings-send-message'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <path
                        d="M14.536 21.686a.5.5 0 0 0 .937-.024l6.5-19a.496.496 0 0 0-.635-.635l-19 6.5a.5.5 0 0 0-.024.937l7.93 3.18a2 2 0 0 1 1.112 1.11zM21.854 2.147l-10.94 10.939"></path>
                </symbol>

                <symbol id='lbaic-settings-chatbot-avatar-default'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <path d="M12 8V4H8"></path>
                    <rect width="16" height="12" x="4" y="8" rx="2"></rect>
                    <path d="M2 14h2M20 14h2M15 13v2M9 13v2"></path>
                </symbol>
                <symbol id='lbaic-settings-ticket'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <path
                        d="M2 9a3 3 0 0 1 0 6v2a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-2a3 3 0 0 1 0-6V7a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2ZM13 5v2M13 17v2M13 11v2"></path>
                </symbol>

                <symbol id='lbaic-settings-book'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <path
                        d="M12 7v14M3 18a1 1 0 0 1-1-1V4a1 1 0 0 1 1-1h5a4 4 0 0 1 4 4 4 4 0 0 1 4-4h5a1 1 0 0 1 1 1v13a1 1 0 0 1-1 1h-6a3 3 0 0 0-3 3 3 3 0 0 0-3-3z"></path>
                </symbol>

                <symbol id='lbaic-settings-circle-nested'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <circle cx="12" cy="12" r="10"></circle>
                    <circle cx="12" cy="12" r="6"></circle>
                    <circle cx="12" cy="12" r="2"></circle>
                </symbol>
                <symbol id='lbaic-settings-letter'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <path d="m22 7-8.991 5.727a2 2 0 0 1-2.009 0L2 7"></path>
                    <rect width="20" height="16" x="2" y="4" rx="2"></rect>
                </symbol>
                <symbol id='lbaic-settings-phone'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <path
                        d="M13.832 16.568a1 1 0 0 0 1.213-.303l.355-.465A2 2 0 0 1 17 15h3a2 2 0 0 1 2 2v3a2 2 0 0 1-2 2A18 18 0 0 1 2 4a2 2 0 0 1 2-2h3a2 2 0 0 1 2 2v3a2 2 0 0 1-.8 1.6l-.468.351a1 1 0 0 0-.292 1.233 14 14 0 0 0 6.392 6.384"></path>
                </symbol>
                <symbol id='lbaic-settings-location'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">

                    <path
                        d="M20 10c0 4.993-5.539 10.193-7.399 11.799a1 1 0 0 1-1.202 0C9.539 20.193 4 14.993 4 10a8 8 0 0 1 16 0"></path>
                    <circle cx="12" cy="10" r="3"></circle>
                </symbol>
                <symbol id='lbaic-settings-callendar'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <path d="M8 2v4M16 2v4"></path>
                    <rect width="18" height="18" x="3" y="4" rx="2"></rect>
                    <path d="M3 10h18"></path>
                </symbol>

                <symbol id='lbaic-settings-chats-external-link'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <path d="M15 3h6v6M10 14 21 3M18 13v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h6"></path>
                </symbol>
                <symbol id='lbaic-settings-chats-functionality'
                        fill="currentColor" className="h-4 w-4" viewBox="0 0 24 24">
                    <path
                        d="M21 0H3a3 3 0 0 0-3 3v18a3 3 0 0 0 3 3h18a3 3 0 0 0 3-3V3a3 3 0 0 0-3-3M10.44 18.18A1.44 1.44 0 0 1 9 19.62H4.56a1.44 1.44 0 0 1-1.44-1.44V5.82c0-.795.645-1.44 1.44-1.44H9c.795 0 1.44.645 1.44 1.44zm10.44-6a1.44 1.44 0 0 1-1.44 1.44H15a1.44 1.44 0 0 1-1.44-1.44V5.82c0-.795.645-1.44 1.44-1.44h4.44c.795 0 1.44.645 1.44 1.44z"></path>
                </symbol>
                <symbol id='lbaic-settings-export-json'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <path d="M15 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7Z"></path>
                    <path d="M14 2v4a2 2 0 0 0 2 2h4M10 9H8M16 13H8M16 17H8"></path>
                </symbol>
                <symbol id='lbaic-settings-export-pdf'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <path d="M15 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7Z"></path>
                    <path d="M14 2v4a2 2 0 0 0 2 2h4M12 18v-6M9 15l3 3 3-3"></path>
                </symbol>
                <symbol id='lbaic-settings-mark-read'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <path d="m16 11 2 2 4-4M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path>
                    <circle cx="9" cy="7" r="4"></circle>
                </symbol>
                <symbol id='lbaic-settings-mark-unread'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <path d="m16 8 6 6m0-6-6 6M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path>
                    <circle cx="9" cy="7" r="4"></circle>
                </symbol>
                <symbol id='lbaic-settings-block'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <path d="M4.929 4.929 19.07 19.071"></path>
                    <circle cx="12" cy="12" r="10"></circle>
                </symbol>
                <symbol id='lbaic-settings-chats-copy'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <rect width="14" height="14" x="8" y="8" rx="2" ry="2"></rect>
                    <path d="M4 16c-1.1 0-2-.9-2-2V4c0-1.1.9-2 2-2h10c1.1 0 2 .9 2 2"></path>
                </symbol>

                <symbol id='lbaic-settings-chats-filter'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <path
                        d="M10 20a1 1 0 0 0 .553.895l2 1A1 1 0 0 0 14 21v-7a2 2 0 0 1 .517-1.341L21.74 4.67A1 1 0 0 0 21 3H3a1 1 0 0 0-.742 1.67l7.225 7.989A2 2 0 0 1 10 14z"></path>

                </symbol>

                <symbol id="lbaic-settings-chats-action-submission-error" viewBox="0 0 18 18">
                    <path
                        d="M9 13.167q.354 0 .594-.24t.24-.594V9a.8.8 0 0 0-.24-.594.8.8 0 0 0-.594-.24.8.8 0 0 0-.593.24.8.8 0 0 0-.24.594v3.333q0 .354.24.594t.593.24M9 6.5q.354 0 .594-.24t.24-.593a.8.8 0 0 0-.24-.594.8.8 0 0 0-.594-.24.8.8 0 0 0-.593.24.8.8 0 0 0-.24.593q0 .355.24.594.24.24.593.24m0 10.833a8.1 8.1 0 0 1-3.25-.656 8.4 8.4 0 0 1-2.646-1.781 8.4 8.4 0 0 1-1.78-2.646A8.1 8.1 0 0 1 .666 9q0-1.73.656-3.25a8.4 8.4 0 0 1 1.781-2.646A8.4 8.4 0 0 1 5.75 1.323 8.1 8.1 0 0 1 9 .667q1.73 0 3.25.656a8.4 8.4 0 0 1 2.646 1.781 8.4 8.4 0 0 1 1.781 2.646A8.1 8.1 0 0 1 17.334 9a8.1 8.1 0 0 1-.657 3.25 8.4 8.4 0 0 1-1.78 2.646 8.4 8.4 0 0 1-2.647 1.78 8.1 8.1 0 0 1-3.25.657"
                    ></path>
                </symbol>
                <symbol id="lbaic-settings-chats-action-submission-success" viewBox="0 0 18 18">
                    <path
                        d="M7.834 10.5 6.042 8.708a.8.8 0 0 0-.583-.229.8.8 0 0 0-.584.23.8.8 0 0 0-.229.582q0 .355.23.584L7.25 12.25a.8.8 0 0 0 .584.25.8.8 0 0 0 .583-.25l4.708-4.708a.8.8 0 0 0 .23-.584.8.8 0 0 0-.23-.583.8.8 0 0 0-.583-.23.8.8 0 0 0-.583.23zM9 17.333a8.1 8.1 0 0 1-3.25-.656 8.4 8.4 0 0 1-2.646-1.781 8.4 8.4 0 0 1-1.78-2.646A8.1 8.1 0 0 1 .666 9q0-1.73.656-3.25a8.4 8.4 0 0 1 1.781-2.646A8.4 8.4 0 0 1 5.75 1.323 8.1 8.1 0 0 1 9 .667q1.73 0 3.25.656a8.4 8.4 0 0 1 2.646 1.781 8.4 8.4 0 0 1 1.781 2.646A8.1 8.1 0 0 1 17.334 9a8.1 8.1 0 0 1-.657 3.25 8.4 8.4 0 0 1-1.78 2.646 8.4 8.4 0 0 1-2.647 1.78 8.1 8.1 0 0 1-3.25.657"
                    ></path>
                </symbol>

                <symbol id='lbaic-settings-calendar'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <path d="M8 2v4M16 2v4"></path>
                    <rect width="18" height="18" x="3" y="4" rx="2"></rect>
                    <path d="M3 10h18"></path>
                </symbol>

                {/* Text Formatting Icons */}
                <symbol id='lbaic-settings-bold'
                        viewBox='0 0 24 24'
                        fill="currentColor">
                    <path
                        d="M12.314 19.5c3.16 0 5.118-1.631 5.118-4.235 0-1.96-1.476-3.425-3.486-3.58v-.082a3.264 3.264 0 0 0 2.778-3.21c0-2.265-1.743-3.69-4.52-3.69h-6.44V19.5zM8.861 7.01h2.544c1.445 0 2.276.677 2.276 1.866 0 1.251-.944 1.98-2.595 1.98H8.86zm0 10.182v-4.296h2.595c1.826 0 2.82.738 2.82 2.123 0 1.414-.964 2.173-2.748 2.173z"
                    ></path>
                </symbol>

                <symbol id='lbaic-settings-italic'
                        viewBox='0 0 24 24'
                        fill="currentColor">
                    <path
                        d="m11.987 17.51 2.309-10.828c.184-.893.369-1.065 2.02-1.21l.165-.78h-5.664l-.165.78c1.59.143 1.692.317 1.508 1.21L9.856 17.51c-.185.893-.37 1.065-2.02 1.21l-.164.78h5.66l.166-.78c-1.59-.143-1.695-.317-1.51-1.21"
                    ></path>
                </symbol>

                <symbol id='lbaic-settings-list-ordered'
                        viewBox='0 0 24 24'
                        fill="currentColor">
                    <path
                        fillRule="evenodd"
                        d="M7.5 17.25a.75.75 0 0 1 .75-.75h13.5a.75.75 0 1 1 0 1.5H8.25a.75.75 0 0 1-.75-.75m0-6a.75.75 0 0 1 .75-.75h13.5a.75.75 0 1 1 0 1.5H8.25a.75.75 0 0 1-.75-.75m0-6a.75.75 0 0 1 .75-.75h13.5a.75.75 0 1 1 0 1.5H8.25a.75.75 0 0 1-.75-.75"
                        clipRule="evenodd"
                    ></path>
                    <path
                        d="M2.57 17.799v-.712H3c.325 0 .545-.205.545-.475 0-.277-.237-.465-.542-.465-.335 0-.55.228-.56.465h-.885c.024-.7.56-1.18 1.48-1.18.882-.004 1.43.436 1.435 1.054a.89.89 0 0 1-.738.891v.05a.92.92 0 0 1 .853.946c.005.8-.752 1.2-1.576 1.2-.984 0-1.5-.555-1.512-1.191h.873c.012.267.279.459.633.463.381 0 .636-.217.633-.524-.003-.293-.232-.523-.621-.523h-.45zm-.006-7.049h-.907v-.053c0-.611.443-1.266 1.438-1.266.874 0 1.44.49 1.44 1.135 0 .583-.386.925-.715 1.271l-.805.858v.046h1.581v.76H1.715v-.592l1.435-1.485c.207-.213.44-.457.44-.762 0-.27-.221-.48-.514-.48a.493.493 0 0 0-.513.506zM3.846 7.5h-.953V4.388h-.046l-.897.63v-.85l.944-.665h.952z"
                    ></path>
                </symbol>

                <symbol id='lbaic-settings-list-unordered'
                        viewBox='0 0 24 24'
                        fill="currentColor">
                    <path
                        fillRule="evenodd"
                        d="M7.5 17.25a.75.75 0 0 1 .75-.75h13.5a.75.75 0 1 1 0 1.5H8.25a.75.75 0 0 1-.75-.75m0-6a.75.75 0 0 1 .75-.75h13.5a.75.75 0 1 1 0 1.5H8.25a.75.75 0 0 1-.75-.75m0-6a.75.75 0 0 1 .75-.75h13.5a.75.75 0 1 1 0 1.5H8.25a.75.75 0 0 1-.75-.75M3 6.75a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3m0 6a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3m0 6a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3"
                        clipRule="evenodd"
                    ></path>
                </symbol>

                <symbol id='lbaic-settings-link-icon'
                        viewBox='0 0 24 24'
                        fill="currentColor">
                    <path
                        d="M9.531 8.25H6a4.5 4.5 0 0 0 0 9h4.5a4.5 4.5 0 0 0 4.245-6H13.5q-.194 0-.375.046A3 3 0 0 1 10.5 15.75H6a3 3 0 0 1 0-6h2.303a6 6 0 0 1 1.228-1.5"
                    ></path>
                    <path
                        d="M13.5 8.25a4.5 4.5 0 0 0-4.245 6h1.647a3 3 0 0 1 2.598-4.5H18a3 3 0 0 1 0 6h-2.302a6 6 0 0 1-1.23 1.5H18a4.5 4.5 0 0 0 0-9z"
                    ></path>
                </symbol>

                <symbol id='lbaic-settings-emoji-icon'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeLinecap="round"
                        strokeLinejoin="round"
                        strokeWidth="2">
                    <circle cx="12" cy="12" r="10"/>
                    <path d="M8 14s1.5 2 4 2 4-2 4-2M9 9h.01M15 9h.01"/>
                </symbol>

                <symbol id='lbaic-settings-underline'
                        viewBox='0 0 16 16'
                        fill="currentColor">
                    <path
                        d="M5.313 3.136h-1.23V9.54c0 2.105 1.47 3.623 3.917 3.623s3.917-1.518 3.917-3.623V3.136h-1.23v6.323c0 1.49-.978 2.57-2.687 2.57-1.709 0-2.687-1.08-2.687-2.57V3.136zM12.5 15h-9v-1h9v1z"/>
                </symbol>

                <symbol id='lbaic-settings-code'
                        viewBox='0 0 24 24'
                        fill="currentColor">
                    <path
                        d="M8 17.6 2.7 12.3a1 1 0 0 1-.287-.7q-.013-.424.287-.7L8 5.6q.3-.3.713-.3t.712.3q.3.3.3.713t-.3.712L4.85 11.6l4.575 4.575q.3.3.3.713t-.3.712q-.3.3-.712.3t-.713-.3m8 0q-.3-.3-.3-.712t.3-.713L20.575 11.6 16 7.025q-.3-.3-.3-.712t.3-.713q.3-.3.713-.3t.712.3l5.3 5.3q.3.275.287.7a1 1 0 0 1-.287.7L16.425 17.6q-.3.3-.712.3t-.713-.3"/>
                </symbol>

                <symbol id='lbaic-settings-undo'
                        viewBox='0 0 24 24'
                        fill="currentColor">
                    <path
                        d="M7 19v-2h7.1q1.575 0 2.738-1.137Q18 14.725 18 13.15t-1.163-2.713A3.74 3.74 0 0 0 14.1 9.3H7.8l2.6 2.6L9 13.3l-5-5 5-5 1.4 1.4-2.6 2.6h6.3q2.425 0 4.163 1.712Q20 10.725 20 13.15t-1.737 4.438T14.1 19z"/>
                </symbol>

                <symbol id='lbaic-settings-redo'
                        viewBox='0 0 24 24'
                        fill="currentColor">
                    <path
                        d="M9.9 19q-2.425 0-4.162-1.712Q4 15.575 4 13.15t1.738-4.438T9.9 7h6.3l-2.6-2.6L15 3l5 5-5 5-1.4-1.4 2.6-2.6H9.9q-1.575 0-2.737 1.138Q6 11.275 6 12.85t1.162 2.713A3.74 3.74 0 0 0 9.9 16.7H17v2z"/>
                </symbol>

                <symbol id='lbaic-settings-align-left'
                        viewBox='0 0 24 24'
                        fill="currentColor">
                    <path
                        d="M3 21q-.424 0-.712-.288A.97.97 0 0 1 2 20q0-.424.288-.712A.97.97 0 0 1 3 19h18q.424 0 .712.288.287.287.288.712 0 .424-.288.712A.97.97 0 0 1 21 21zm0-4q-.424 0-.712-.288A.97.97 0 0 1 2 16q0-.424.288-.712A.97.97 0 0 1 3 15h12q.424 0 .712.288.287.287.288.712 0 .424-.288.712A.97.97 0 0 1 15 17zm0-4q-.424 0-.712-.288A.97.97 0 0 1 2 12q0-.424.288-.712A.97.97 0 0 1 3 11h18q.424 0 .712.288.287.287.288.712 0 .424-.288.712A.97.97 0 0 1 21 13zm0-4q-.424 0-.712-.288A.97.97 0 0 1 2 8q0-.424.288-.712A.97.97 0 0 1 3 7h12q.424 0 .712.288Q16 7.575 16 8t-.288.712A.97.97 0 0 1 15 9zm0-4q-.424 0-.712-.288A.97.97 0 0 1 2 4q0-.424.288-.712A.97.97 0 0 1 3 3h18q.424 0 .712.288Q22 3.575 22 4t-.288.712A.97.97 0 0 1 21 5z"/>
                </symbol>

                <symbol id='lbaic-settings-align-center'
                        viewBox='0 0 24 24'
                        fill="currentColor">
                    <path
                        d="M3 21q-.424 0-.712-.288A.97.97 0 0 1 2 20q0-.424.288-.712A.97.97 0 0 1 3 19h18q.424 0 .712.288.287.287.288.712 0 .424-.288.712A.97.97 0 0 1 21 21zm4-4q-.424 0-.712-.288A.97.97 0 0 1 6 16q0-.424.288-.712A.97.97 0 0 1 7 15h10q.424 0 .712.288.287.287.288.712 0 .424-.288.712A.97.97 0 0 1 17 17zm-4-4q-.424 0-.712-.288A.97.97 0 0 1 2 12q0-.424.288-.712A.97.97 0 0 1 3 11h18q.424 0 .712.288.287.287.288.712 0 .424-.288.712A.97.97 0 0 1 21 13zm4-4q-.424 0-.712-.288A.97.97 0 0 1 6 8q0-.424.288-.712A.97.97 0 0 1 7 7h10q.424 0 .712.288Q18 7.575 18 8t-.288.712A.97.97 0 0 1 17 9zm-4-4q-.424 0-.712-.288A.97.97 0 0 1 2 4q0-.424.288-.712A.97.97 0 0 1 3 3h18q.424 0 .712.288Q22 3.575 22 4t-.288.712A.97.97 0 0 1 21 5z"/>
                </symbol>

                <symbol id='lbaic-settings-align-right'
                        viewBox='0 0 24 24'
                        fill="currentColor">
                    <path
                        d="M3 21q-.424 0-.712-.288A.97.97 0 0 1 2 20q0-.424.288-.712A.97.97 0 0 1 3 19h18q.424 0 .712.288.287.287.288.712 0 .424-.288.712A.97.97 0 0 1 21 21zm6-4q-.424 0-.712-.288A.97.97 0 0 1 8 16q0-.424.288-.712A.97.97 0 0 1 9 15h12q.424 0 .712.288.287.287.288.712 0 .424-.288.712A.97.97 0 0 1 21 17zm-6-4q-.424 0-.712-.288A.97.97 0 0 1 2 12q0-.424.288-.712A.97.97 0 0 1 3 11h18q.424 0 .712.288.287.287.288.712 0 .424-.288.712A.97.97 0 0 1 21 13zm6-4q-.424 0-.712-.288A.97.97 0 0 1 8 8q0-.424.288-.712A.97.97 0 0 1 9 7h12q.424 0 .712.288Q22 7.575 22 8t-.288.712A.97.97 0 0 1 21 9zm-6-4q-.424 0-.712-.288A.97.97 0 0 1 2 4q0-.424.288-.712A.97.97 0 0 1 3 3h18q.424 0 .712.288Q22 3.575 22 4t-.288.712A.97.97 0 0 1 21 5z"/>
                </symbol>

                <symbol id='lbaic-settings-align-justify'
                        viewBox='0 0 24 24'
                        fill="currentColor">
                    <path
                        d="M3 21q-.424 0-.712-.288A.97.97 0 0 1 2 20q0-.424.288-.712A.97.97 0 0 1 3 19h18q.424 0 .712.288.287.287.288.712 0 .424-.288.712A.97.97 0 0 1 21 21zm0-4q-.424 0-.712-.288A.97.97 0 0 1 2 16q0-.424.288-.712A.97.97 0 0 1 3 15h18q.424 0 .712.288.287.287.288.712 0 .424-.288.712A.97.97 0 0 1 21 17zm0-4q-.424 0-.712-.288A.97.97 0 0 1 2 12q0-.424.288-.712A.97.97 0 0 1 3 11h18q.424 0 .712.288.287.287.288.712 0 .424-.288.712A.97.97 0 0 1 21 13zm0-4q-.424 0-.712-.288A.97.97 0 0 1 2 8q0-.424.288-.712A.97.97 0 0 1 3 7h18q.424 0 .712.288Q22 7.575 22 8t-.288.712A.97.97 0 0 1 21 9zm0-4q-.424 0-.712-.288A.97.97 0 0 1 2 4q0-.424.288-.712A.97.97 0 0 1 3 3h18q.424 0 .712.288Q22 3.575 22 4t-.288.712A.97.97 0 0 1 21 5z"/>
                </symbol>

                <symbol id='lbaic-settings-quote'
                        viewBox='0 0 24 24'
                        fill="currentColor">
                    <path d="M6 17h3l2-4V7H5v6h3zm8 0h3l2-4V7h-6v6h3z"/>
                </symbol>

                <symbol id='lbaic-settings-code-block'
                        viewBox='0 0 24 24'
                        fill="currentColor">
                    <path
                        d="M5 21q-.824 0-1.412-.587A1.93 1.93 0 0 1 3 19V5q0-.824.588-1.412A1.93 1.93 0 0 1 5 3h14q.824 0 1.413.588Q21 4.175 21 5v14q0 .824-.587 1.413A1.93 1.93 0 0 1 19 21zm3.4-4.575 2.6-2.6-2.6-2.6L9.825 9.8l4.025 4.025-4.025 4.025zM12 17h4v-2h-4z"/>
                </symbol>

                <symbol id='lbaic-settings-indent-increase'
                        viewBox='0 0 24 24'
                        fill="currentColor">
                    <path
                        d="M3 21q-.424 0-.712-.288A.97.97 0 0 1 2 20q0-.424.288-.712A.97.97 0 0 1 3 19h18q.424 0 .712.288.287.287.288.712 0 .424-.288.712A.97.97 0 0 1 21 21zm8-4q-.424 0-.712-.288A.97.97 0 0 1 10 16q0-.424.288-.712A.97.97 0 0 1 11 15h10q.424 0 .712.288.287.287.288.712 0 .424-.288.712A.97.97 0 0 1 21 17zm0-4q-.424 0-.712-.288A.97.97 0 0 1 10 12q0-.424.288-.712A.97.97 0 0 1 11 11h10q.424 0 .712.288.287.287.288.712 0 .424-.288.712A.97.97 0 0 1 21 13zm0-4q-.424 0-.712-.288A.97.97 0 0 1 10 8q0-.424.288-.712A.97.97 0 0 1 11 7h10q.424 0 .712.288Q22 7.575 22 8t-.288.712A.97.97 0 0 1 21 9zM3 17.8V6.2l4.6 5.8zM3 5q-.424 0-.712-.288A.97.97 0 0 1 2 4q0-.424.288-.712A.97.97 0 0 1 3 3h18q.424 0 .712.288Q22 3.575 22 4t-.288.712A.97.97 0 0 1 21 5z"/>
                </symbol>

                <symbol id='lbaic-settings-indent-decrease'
                        viewBox='0 0 24 24'
                        fill="currentColor">
                    <path
                        d="M3 21q-.424 0-.712-.288A.97.97 0 0 1 2 20q0-.424.288-.712A.97.97 0 0 1 3 19h18q.424 0 .712.288.287.287.288.712 0 .424-.288.712A.97.97 0 0 1 21 21zm8-4q-.424 0-.712-.288A.97.97 0 0 1 10 16q0-.424.288-.712A.97.97 0 0 1 11 15h10q.424 0 .712.288.287.287.288.712 0 .424-.288.712A.97.97 0 0 1 21 17zm0-4q-.424 0-.712-.288A.97.97 0 0 1 10 12q0-.424.288-.712A.97.97 0 0 1 11 11h10q.424 0 .712.288.287.287.288.712 0 .424-.288.712A.97.97 0 0 1 21 13zm0-4q-.424 0-.712-.288A.97.97 0 0 1 10 8q0-.424.288-.712A.97.97 0 0 1 11 7h10q.424 0 .712.288Q22 7.575 22 8t-.288.712A.97.97 0 0 1 21 9zM3 17.8 7.6 12 3 6.2zM3 5q-.424 0-.712-.288A.97.97 0 0 1 2 4q0-.424.288-.712A.97.97 0 0 1 3 3h18q.424 0 .712.288Q22 3.575 22 4t-.288.712A.97.97 0 0 1 21 5z"/>
                </symbol>

                <symbol id='lbaic-settings-horizontal-rule'
                        viewBox='0 0 24 24'
                        fill="currentColor">
                    <path
                        d="M4 13q-.424 0-.712-.288A.97.97 0 0 1 3 12q0-.424.288-.712A.97.97 0 0 1 4 11h16q.424 0 .712.288.287.287.288.712 0 .424-.288.712A.97.97 0 0 1 20 13z"/>
                </symbol>

                <symbol id='lbaic-settings-clear-formatting'
                        viewBox='0 0 24 24'
                        fill="currentColor">
                    <path
                        d="m16.475 22.2-6.6-6.6L8.3 19h-2.6l2.25-6.175L2 6.875 3.4 5.475l19.075 19.075zM11 6.5V4h10v2.5h-4l-1.575 4.3-1.825-1.825L14.5 6.5z"/>
                </symbol>

                <symbol id='lbaic-settings-heading'
                        viewBox='0 0 24 24'
                        fill="currentColor">
                    <path
                        fillRule="evenodd"
                        d="M3 18.75a.75.75 0 0 1 .75-.75h10.5a.75.75 0 1 1 0 1.5H3.75a.75.75 0 0 1-.75-.75m0-4.5a.75.75 0 0 1 .75-.75h16.5a.75.75 0 1 1 0 1.5H3.75a.75.75 0 0 1-.75-.75m0-4.5A.75.75 0 0 1 3.75 9h16.5a.75.75 0 1 1 0 1.5H3.75A.75.75 0 0 1 3 9.75m6-4.5a.75.75 0 0 1 .75-.75h10.5a.75.75 0 1 1 0 1.5H9.75A.75.75 0 0 1 9 5.25"
                        clipRule="evenodd"
                    ></path>
                </symbol>

                <symbol id='lbaic-settings-paragraph'
                        viewBox='0 0 16 16'
                        fill="currentColor">
                    <path
                        fillRule="evenodd"
                        d="M2 12.5a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5zm0-3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5zm0-3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5zm4-3a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5z"
                    ></path>
                </symbol>

                <symbol id='lbaic-settings-h1'
                        viewBox='0 0 16 16'
                        fill="currentColor">
                    <path
                        d="M8.637 13V3.669H7.379V7.62H2.758V3.67H1.5V13h1.258V8.728h4.62V13h1.259zm5.329 0V3.669h-1.244L10.5 5.316v1.265l2.16-1.565h.062V13h1.244z"
                    ></path>
                </symbol>

                <symbol id='lbaic-settings-h2'
                        viewBox='0 0 16 16'
                        fill="currentColor">
                    <path
                        d="M7.638 13V3.669H6.38V7.62H1.759V3.67H.5V13h1.258V8.728h4.62V13h1.259zm3.022-6.733v-.048c0-.889.63-1.668 1.716-1.668.957 0 1.675.608 1.675 1.572 0 .855-.554 1.504-1.067 2.085l-3.513 3.999V13H15.5v-1.094h-4.245v-.075l2.481-2.844c.875-.998 1.586-1.784 1.586-2.953 0-1.463-1.155-2.556-2.919-2.556-1.941 0-2.966 1.326-2.966 2.74v.049h1.223z"
                    ></path>
                </symbol>

                <symbol id='lbaic-settings-h3'
                        viewBox='0 0 16 16'
                        fill="currentColor">
                    <path
                        d="M7.637 13V3.669H6.379V7.62H1.758V3.67H.5V13h1.258V8.728h4.62V13h1.259zm3.625-4.272h1.018c1.142 0 1.935.67 1.949 1.674.013 1.005-.78 1.737-2.01 1.73-1.08-.007-1.853-.588-1.935-1.32H9.108c.069 1.327 1.224 2.386 3.083 2.386 1.935 0 3.343-1.155 3.309-2.789-.027-1.51-1.251-2.16-2.037-2.249v-.068c.704-.123 1.764-.91 1.723-2.229-.035-1.353-1.176-2.4-2.954-2.385-1.873.006-2.857 1.162-2.898 2.358h1.196c.062-.69.711-1.299 1.696-1.299.998 0 1.695.622 1.695 1.525.007.922-.718 1.592-1.695 1.592h-.964v1.074z"
                    ></path>
                </symbol>

                <symbol id='lbaic-settings-chevron-down'
                        viewBox='0 0 24 24'
                        fill="currentColor">
                    <path d="m12 15.4-6-6L7.4 8l4.6 4.6L16.6 8 18 9.4z"/>
                </symbol>

                {/* Dashboard Icons */}
                <symbol id='lbaic-settings-dashboard-conversations'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round">
                    <path
                        d="M22 17a2 2 0 0 1-2 2H6.828a2 2 0 0 0-1.414.586l-2.202 2.202A.71.71 0 0 1 2 21.286V5a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2z"></path>
                </symbol>

                <symbol id='lbaic-settings-dashboard-new_visitors'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round">
                    <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path>
                    <path d="M16 3.128a4 4 0 0 1 0 7.744"></path>
                    <path d="M22 21v-2a4 4 0 0 0-3-3.87"></path>
                    <circle cx="9" cy="7" r="4"></circle>
                </symbol>

                <symbol id='lbaic-settings-dashboard-returning_visitors'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round">
                    <path d="m16 11 2 2 4-4"></path>
                    <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path>
                    <circle cx="9" cy="7" r="4"></circle>
                </symbol>

                <symbol id='lbaic-settings-dashboard-ai_resolution'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round">
                    <circle cx="12" cy="12" r="10"></circle>
                    <path d="m9 12 2 2 4-4"></path>
                </symbol>

                <symbol id='lbaic-settings-dashboard-leads_captured'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round">
                    <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path>
                    <circle cx="9" cy="7" r="4"></circle>
                    <line x1="19" x2="19" y1="8" y2="14"></line>
                    <line x1="22" x2="16" y1="11" y2="11"></line>
                </symbol>

                <symbol id='lbaic-settings-ticket'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round">
                    <path
                        d="M2 9a3 3 0 0 1 0 6v2a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-2a3 3 0 0 1 0-6V7a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2Z"></path>
                    <path d="M13 5v2"></path>
                    <path d="M13 17v2"></path>
                    <path d="M13 11v2"></path>
                </symbol>

                <symbol id='lbaic-settings-mail'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round">
                    <path d="m22 7-8.991 5.727a2 2 0 0 1-2.009 0L2 7"></path>
                    <rect x="2" y="4" width="20" height="16" rx="2"></rect>
                </symbol>

                <symbol id='lbaic-settings-trending-up'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round">
                    <path d="M16 7h6v6"></path>
                    <path d="m22 7-8.5 8.5-5-5L2 17"></path>
                </symbol>

                <symbol id='lbaic-settings-trending-down'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round">
                    <path d="M16 17h6v-6"></path>
                    <path d="m22 17-8.5-8.5-5 5L2 7"></path>
                </symbol>

                <symbol id='lbaic-settings-eye'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round">
                    <path
                        d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"></path>
                    <circle cx="12" cy="12" r="3"></circle>
                </symbol>

                <symbol id='lbaic-settings-eye-off'
                        viewBox='0 0 24 24'
                        fill="none"
                        stroke="currentColor"
                        strokeWidth="2"
                        strokeLinecap="round"
                        strokeLinejoin="round">
                    <path
                        d="M10.733 5.076a10.744 10.744 0 0 1 11.205 6.575 1 1 0 0 1 0 .696 10.747 10.747 0 0 1-1.444 2.49"></path>
                    <path d="M14.084 14.158a3 3 0 0 1-4.242-4.242"></path>
                    <path
                        d="M17.479 17.499a10.75 10.75 0 0 1-15.417-5.151 1 1 0 0 1 0-.696 10.75 10.75 0 0 1 4.446-5.143"></path>
                    <path d="m2 2 20 20"></path>
                </symbol>

                {/*Devices*/}
                <symbol
                    id="lbaic-settings-device-windows"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <path
                        d="M9.54857 3.79048L2.40571 4.86193C2.17238 4.89717 2 5.09718 2 5.3329V11.0473C2 11.3107 2.21333 11.5235 2.47619 11.5235H9.61905C9.8819 11.5235 10.0952 11.3107 10.0952 11.0473V4.26144C10.0952 4.12287 10.0348 3.99143 9.92952 3.90048C9.82476 3.81048 9.68524 3.77143 9.54857 3.79048ZM21.8343 2.11472C21.7295 2.02472 21.5905 1.98567 21.4529 2.00472L11.4529 3.50475C11.22 3.53999 11.0476 3.74 11.0476 3.97572V11.0473C11.0476 11.3107 11.261 11.5235 11.5238 11.5235H21.5238C21.7867 11.5235 22 11.3107 22 11.0473V2.47568C22 2.33711 21.9395 2.20567 21.8343 2.11472ZM9.61905 12.4759H2.47619C2.21333 12.4759 2 12.6888 2 12.9521V18.6666C2 18.9023 2.17238 19.1023 2.40571 19.1375L9.54857 20.209C9.57238 20.2123 9.59571 20.2142 9.61905 20.2142C9.73238 20.2142 9.84286 20.1738 9.92952 20.099C10.0348 20.008 10.0952 19.8766 10.0952 19.738V12.9521C10.0952 12.6888 9.8819 12.4759 9.61905 12.4759ZM21.5238 12.4759H11.5238C11.261 12.4759 11.0476 12.6888 11.0476 12.9521V20.0238C11.0476 20.2595 11.22 20.4595 11.4533 20.4947L21.4533 21.9948C21.4767 21.9981 21.5005 22 21.5238 22C21.6371 22 21.7476 21.9595 21.8343 21.8848C21.9395 21.7938 22 21.6624 22 21.5238V12.9521C22 12.6888 21.7867 12.4759 21.5238 12.4759Z"
                        fill="#0078D4"/>
                </symbol>
                <symbol
                    id="lbaic-settings-device-android"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <path
                        d="M5.25 14.9761C5.25 15.5949 4.74375 16.1011 4.125 16.1011C3.50625 16.1011 3 15.5949 3 14.9761V9.91364C3 9.29489 3.50625 8.78864 4.125 8.78864C4.74375 8.78864 5.25 9.29489 5.25 9.91364V14.9761Z"
                        fill="#7CB342"/>
                    <path
                        d="M21 14.9761C21 15.5949 20.4938 16.1011 19.875 16.1011C19.2562 16.1011 18.75 15.5949 18.75 14.9761V9.91364C18.75 9.29489 19.2562 8.78864 19.875 8.78864C20.4938 8.78864 21 9.29489 21 9.91364V14.9761Z"
                        fill="#7CB342"/>
                    <path
                        d="M10.875 21.1636C10.875 21.7824 10.3688 22.2886 9.75 22.2886C9.13125 22.2886 8.625 21.7824 8.625 21.1636V16.1011C8.625 15.4824 9.13125 14.9761 9.75 14.9761C10.3688 14.9761 10.875 15.4824 10.875 16.1011V21.1636Z"
                        fill="#7CB342"/>
                    <path
                        d="M15.375 21.1636C15.375 21.7824 14.8688 22.2886 14.25 22.2886C13.6312 22.2886 13.125 21.7824 13.125 21.1636V16.1011C13.125 15.4824 13.6312 14.9761 14.25 14.9761C14.8688 14.9761 15.375 15.4824 15.375 16.1011V21.1636Z"
                        fill="#7CB342"/>
                    <path
                        d="M6.375 8.78864V17.2261C6.375 17.8449 6.88125 18.3511 7.5 18.3511H16.5C17.1188 18.3511 17.625 17.8449 17.625 17.2261V8.78864H6.375Z"
                        fill="#7CB342"/>
                    <path
                        d="M12 3.16364C8.625 3.16364 6.54375 5.18864 6.375 7.66364H17.625C17.4562 5.18864 15.375 3.16364 12 3.16364ZM9.75 6.31364C9.4125 6.31364 9.1875 6.08864 9.1875 5.75114C9.1875 5.41364 9.4125 5.18864 9.75 5.18864C10.0875 5.18864 10.3125 5.41364 10.3125 5.75114C10.3125 6.03239 10.0875 6.31364 9.75 6.31364ZM14.25 6.31364C13.9125 6.31364 13.6875 6.08864 13.6875 5.75114C13.6875 5.41364 13.9125 5.18864 14.25 5.18864C14.5875 5.18864 14.8125 5.41364 14.8125 5.75114C14.8125 6.03239 14.5875 6.31364 14.25 6.31364Z"
                        fill="#7CB342"/>
                    <path
                        d="M14.4188 4.56992C14.3063 4.56992 14.1938 4.51367 14.0813 4.45742C13.8 4.28867 13.7438 3.95117 13.9125 3.66992L14.8688 2.26367C15.0375 1.98242 15.375 1.92617 15.6563 2.09492C15.9375 2.26367 15.9938 2.60117 15.825 2.88242L14.8688 4.28867C14.8125 4.45742 14.6438 4.56992 14.4188 4.56992Z"
                        fill="#7CB342"/>
                    <path
                        d="M9.35625 4.34492C9.1875 4.34492 8.9625 4.23242 8.90625 4.06367L8.175 2.88242C8.00625 2.60117 8.0625 2.26367 8.34375 2.09492C8.625 1.92617 8.9625 1.98242 9.13125 2.26367L9.8625 3.44492C10.0313 3.72617 9.975 4.06367 9.69375 4.23242C9.58125 4.28867 9.46875 4.34492 9.35625 4.34492Z"
                        fill="#7CB342"/>
                </symbol>
                <symbol
                    id="lbaic-settings-device-linux"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <path
                        d="M12.2523 2C11.7894 2 11.3248 2.09219 10.9051 2.32187C10.4591 2.56484 10.0934 2.95391 9.86883 3.41328C9.64352 3.87266 9.55556 4.36328 9.54167 4.90391C9.5162 5.93047 9.56482 7.00703 9.6412 7.98281C9.66127 8.27969 9.6983 8.45313 9.66049 8.75859C9.53549 9.40703 8.97531 9.84297 8.67593 10.4125C8.34645 11.0406 8.20756 11.7508 7.95911 12.4164C7.73148 13.025 7.41204 13.5961 7.19676 14.2094C6.89506 15.0664 6.80478 16.0086 7.00386 16.8961C7.15586 17.5727 7.47299 18.207 7.90046 18.75C7.83873 18.8625 7.77855 18.9773 7.71528 19.0891C7.51698 19.4352 7.27469 19.7641 7.16204 20.1477C7.10571 20.3391 7.08333 20.5438 7.1196 20.7406C7.15586 20.9375 7.25463 21.1258 7.40895 21.2508C7.51003 21.332 7.63272 21.3852 7.75849 21.4148C7.88426 21.4437 8.01466 21.4508 8.14429 21.4484C8.6358 21.4375 9.11265 21.2867 9.58796 21.1602C9.87037 21.0852 10.1543 21.0187 10.439 20.9586C11.4529 20.7484 12.5841 20.8328 13.5247 20.9703C13.8434 21.0195 14.1597 21.0828 14.473 21.1602C14.9637 21.2805 15.4522 21.4336 15.9568 21.4484C16.0895 21.4523 16.2238 21.4461 16.3534 21.4172C16.483 21.3875 16.6088 21.3344 16.7122 21.2508C16.8673 21.1258 16.966 20.9367 17.0023 20.7398C17.0386 20.543 17.0162 20.3375 16.9591 20.1453C16.8449 19.7609 16.6003 19.4336 16.3981 19.0891C16.3179 18.9523 16.2438 18.8133 16.1644 18.6766C16.7739 17.9836 17.2647 17.182 17.5486 16.3016C17.858 15.3406 17.9151 14.3055 17.7847 13.3031C17.6543 12.3008 17.3403 11.3289 16.9275 10.4086C16.4089 9.25547 15.973 8.83828 15.6566 7.825C15.3156 6.72969 15.5972 5.43359 15.3434 4.44062C15.2531 4.10312 15.1088 3.78047 14.9228 3.48516C14.7052 3.13906 14.429 2.82969 14.1011 2.58906C13.5779 2.20469 12.9205 2 12.2523 2Z"
                        fill="#020204"/>
                    <path
                        d="M10.4144 7.7812C10.3449 7.86948 10.3002 7.97573 10.2724 8.0851C10.2454 8.19448 10.2353 8.30776 10.2307 8.42104C10.2222 8.64682 10.2361 8.87651 10.1767 9.09448C10.1134 9.32729 9.97223 9.52964 9.83411 9.72573C9.59414 10.0664 9.35186 10.4164 9.2338 10.8171C9.16204 11.0593 9.13812 11.3164 9.16359 11.5687C8.89584 11.9671 8.66359 12.3914 8.47068 12.8328C8.17902 13.5023 7.97917 14.2148 7.90896 14.9429C7.82254 15.8343 7.93519 16.7515 8.28318 17.5749C8.53396 18.171 8.90896 18.7156 9.39275 19.1406C9.63812 19.3562 9.91127 19.5398 10.2029 19.6851C11.2145 20.189 12.4645 20.1898 13.4591 19.6531C13.9792 19.3726 14.4182 18.9624 14.8411 18.5476C15.0957 18.2976 15.3495 18.0414 15.544 17.7414C15.9182 17.1624 16.0486 16.4593 16.1296 15.7726C16.2708 14.5726 16.2755 13.3039 15.7554 12.2156C15.5764 11.8406 15.338 11.4953 15.0517 11.196C14.9761 10.6726 14.8256 10.1593 14.6073 9.67885C14.4491 9.3312 14.257 9.00073 14.1103 8.64917C14.0502 8.50464 13.9977 8.3562 13.9313 8.21479C13.8642 8.07339 13.7824 7.93745 13.6698 7.82885C13.5556 7.71792 13.4128 7.63901 13.2624 7.58901C13.1119 7.53823 12.9529 7.51557 12.7948 7.50776C12.4776 7.49135 12.1605 7.53354 11.8434 7.52026C11.5911 7.51011 11.3395 7.46557 11.0872 7.48042C10.9614 7.48823 10.8357 7.51089 10.7184 7.55932C10.6011 7.60698 10.4931 7.6812 10.4144 7.7812Z"
                        fill="#FDFDFB"/>
                    <mask id="mask0_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="6" y="2"
                          width="12" height="20">
                        <path
                            d="M12.2523 2C11.7894 2 11.3248 2.09219 10.9051 2.32187C10.4591 2.56484 10.0934 2.95391 9.86883 3.41328C9.64352 3.87266 9.55556 4.36328 9.54167 4.90391C9.5162 5.93047 9.56482 7.00703 9.6412 7.98281C9.66127 8.27969 9.6983 8.45313 9.66049 8.75859C9.53549 9.40703 8.97531 9.84297 8.67593 10.4125C8.34645 11.0406 8.20756 11.7508 7.95911 12.4164C7.73148 13.025 7.41204 13.5961 7.19676 14.2094C6.89506 15.0664 6.80478 16.0086 7.00386 16.8961C7.15586 17.5727 7.47299 18.207 7.90046 18.75C7.83873 18.8625 7.77855 18.9773 7.71528 19.0891C7.51698 19.4352 7.27469 19.7641 7.16204 20.1477C7.10571 20.3391 7.08333 20.5438 7.1196 20.7406C7.15586 20.9375 7.25463 21.1258 7.40895 21.2508C7.51003 21.332 7.63272 21.3852 7.75849 21.4148C7.88426 21.4437 8.01466 21.4508 8.14429 21.4484C8.6358 21.4375 9.11265 21.2867 9.58796 21.1602C9.87037 21.0852 10.1543 21.0187 10.439 20.9586C11.4529 20.7484 12.5841 20.8328 13.5247 20.9703C13.8434 21.0195 14.1597 21.0828 14.473 21.1602C14.9637 21.2805 15.4522 21.4336 15.9568 21.4484C16.0895 21.4523 16.2238 21.4461 16.3534 21.4172C16.483 21.3875 16.6088 21.3344 16.7122 21.2508C16.8673 21.1258 16.966 20.9367 17.0023 20.7398C17.0386 20.543 17.0162 20.3375 16.9591 20.1453C16.8449 19.7609 16.6003 19.4336 16.3981 19.0891C16.3179 18.9523 16.2438 18.8133 16.1644 18.6766C16.7739 17.9836 17.2647 17.182 17.5486 16.3016C17.858 15.3406 17.9151 14.3055 17.7847 13.3031C17.6543 12.3008 17.3403 11.3289 16.9275 10.4086C16.4089 9.25547 15.973 8.83828 15.6566 7.825C15.3156 6.72969 15.5972 5.43359 15.3434 4.44062C15.2531 4.10312 15.1088 3.78047 14.9228 3.48516C14.7052 3.13906 14.429 2.82969 14.1011 2.58906C13.5779 2.20469 12.9205 2 12.2523 2Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask0_2246_1150)">
                        <g opacity="0.25" filter="url(#filter0_f_2246_1150)">
                            <path
                                d="M9.29861 10.9984C9.36574 11.1007 9.25617 11.4547 10.831 11.2281C10.831 11.2281 10.554 11.2586 10.2816 11.3226C9.85802 11.4664 9.48919 11.6265 9.2037 11.839C8.92207 12.05 8.71527 12.3242 8.45679 12.5593C8.45679 12.5593 8.87577 11.7843 8.97994 11.5507C9.08487 11.3172 8.96296 11.3281 9.04552 10.9843C9.12808 10.6406 9.33024 10.3101 9.33024 10.3101C9.33024 10.3101 9.16512 10.7961 9.29861 10.9984Z"
                                fill="url(#paint0_radial_2246_1150)"/>
                        </g>
                    </g>
                    <mask id="mask1_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="6" y="2"
                          width="12" height="20">
                        <path
                            d="M12.2523 2C11.7894 2 11.3248 2.09219 10.9051 2.32187C10.4591 2.56484 10.0934 2.95391 9.86883 3.41328C9.64352 3.87266 9.55556 4.36328 9.54167 4.90391C9.5162 5.93047 9.56482 7.00703 9.6412 7.98281C9.66127 8.27969 9.6983 8.45313 9.66049 8.75859C9.53549 9.40703 8.97531 9.84297 8.67593 10.4125C8.34645 11.0406 8.20756 11.7508 7.95911 12.4164C7.73148 13.025 7.41204 13.5961 7.19676 14.2094C6.89506 15.0664 6.80478 16.0086 7.00386 16.8961C7.15586 17.5727 7.47299 18.207 7.90046 18.75C7.83873 18.8625 7.77855 18.9773 7.71528 19.0891C7.51698 19.4352 7.27469 19.7641 7.16204 20.1477C7.10571 20.3391 7.08333 20.5438 7.1196 20.7406C7.15586 20.9375 7.25463 21.1258 7.40895 21.2508C7.51003 21.332 7.63272 21.3852 7.75849 21.4148C7.88426 21.4437 8.01466 21.4508 8.14429 21.4484C8.6358 21.4375 9.11265 21.2867 9.58796 21.1602C9.87037 21.0852 10.1543 21.0187 10.439 20.9586C11.4529 20.7484 12.5841 20.8328 13.5247 20.9703C13.8434 21.0195 14.1597 21.0828 14.473 21.1602C14.9637 21.2805 15.4522 21.4336 15.9568 21.4484C16.0895 21.4523 16.2238 21.4461 16.3534 21.4172C16.483 21.3875 16.6088 21.3344 16.7122 21.2508C16.8673 21.1258 16.966 20.9367 17.0023 20.7398C17.0386 20.543 17.0162 20.3375 16.9591 20.1453C16.8449 19.7609 16.6003 19.4336 16.3981 19.0891C16.3179 18.9523 16.2438 18.8133 16.1644 18.6766C16.7739 17.9836 17.2647 17.182 17.5486 16.3016C17.858 15.3406 17.9151 14.3055 17.7847 13.3031C17.6543 12.3008 17.3403 11.3289 16.9275 10.4086C16.4089 9.25547 15.973 8.83828 15.6566 7.825C15.3156 6.72969 15.5972 5.43359 15.3434 4.44062C15.2531 4.10312 15.1088 3.78047 14.9228 3.48516C14.7052 3.13906 14.429 2.82969 14.1011 2.58906C13.5779 2.20469 12.9205 2 12.2523 2Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask1_2246_1150)">
                        <g opacity="0.42" filter="url(#filter1_f_2246_1150)">
                            <path
                                d="M14.3611 10.9055C14.0401 11.132 13.8519 11.1055 13.463 11.1492C13.0733 11.1938 12.0201 11.1774 12.0201 11.1774C12.0201 11.1774 12.1721 11.175 12.5108 11.2383C12.8488 11.3024 13.5378 11.3633 13.9259 11.5125C14.3148 11.6625 14.456 11.7055 14.6921 11.8563C15.0278 12.0711 15.2747 12.4078 15.5957 12.6438C15.5957 12.6438 15.6111 12.3313 15.4815 12.0977C15.3519 11.8641 15.0031 11.4961 14.9005 11.1524C14.7986 10.8086 14.7492 10.1336 14.7492 10.1336C14.7492 10.1336 14.6813 10.6797 14.3611 10.9055Z"
                                fill="url(#paint1_radial_2246_1150)"/>
                        </g>
                    </g>
                    <mask id="mask2_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="6" y="2"
                          width="12" height="20">
                        <path
                            d="M12.2523 2C11.7894 2 11.3248 2.09219 10.9051 2.32187C10.4591 2.56484 10.0934 2.95391 9.86883 3.41328C9.64352 3.87266 9.55556 4.36328 9.54167 4.90391C9.5162 5.93047 9.56482 7.00703 9.6412 7.98281C9.66127 8.27969 9.6983 8.45313 9.66049 8.75859C9.53549 9.40703 8.97531 9.84297 8.67593 10.4125C8.34645 11.0406 8.20756 11.7508 7.95911 12.4164C7.73148 13.025 7.41204 13.5961 7.19676 14.2094C6.89506 15.0664 6.80478 16.0086 7.00386 16.8961C7.15586 17.5727 7.47299 18.207 7.90046 18.75C7.83873 18.8625 7.77855 18.9773 7.71528 19.0891C7.51698 19.4352 7.27469 19.7641 7.16204 20.1477C7.10571 20.3391 7.08333 20.5438 7.1196 20.7406C7.15586 20.9375 7.25463 21.1258 7.40895 21.2508C7.51003 21.332 7.63272 21.3852 7.75849 21.4148C7.88426 21.4437 8.01466 21.4508 8.14429 21.4484C8.6358 21.4375 9.11265 21.2867 9.58796 21.1602C9.87037 21.0852 10.1543 21.0187 10.439 20.9586C11.4529 20.7484 12.5841 20.8328 13.5247 20.9703C13.8434 21.0195 14.1597 21.0828 14.473 21.1602C14.9637 21.2805 15.4522 21.4336 15.9568 21.4484C16.0895 21.4523 16.2238 21.4461 16.3534 21.4172C16.483 21.3875 16.6088 21.3344 16.7122 21.2508C16.8673 21.1258 16.966 20.9367 17.0023 20.7398C17.0386 20.543 17.0162 20.3375 16.9591 20.1453C16.8449 19.7609 16.6003 19.4336 16.3981 19.0891C16.3179 18.9523 16.2438 18.8133 16.1644 18.6766C16.7739 17.9836 17.2647 17.182 17.5486 16.3016C17.858 15.3406 17.9151 14.3055 17.7847 13.3031C17.6543 12.3008 17.3403 11.3289 16.9275 10.4086C16.4089 9.25547 15.973 8.83828 15.6566 7.825C15.3156 6.72969 15.5972 5.43359 15.3434 4.44062C15.2531 4.10312 15.1088 3.78047 14.9228 3.48516C14.7052 3.13906 14.429 2.82969 14.1011 2.58906C13.5779 2.20469 12.9205 2 12.2523 2Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask2_2246_1150)">
                        <g opacity="0.2" filter="url(#filter2_f_2246_1150)">
                            <path
                                d="M11.3434 10.4227C11.331 10.5203 11.3156 10.618 11.2971 10.7149C11.2878 10.7625 11.277 10.8102 11.26 10.8555C11.2423 10.9008 11.2168 10.9445 11.1813 10.9766C11.1497 11.0055 11.1119 11.025 11.0733 11.043C10.9236 11.1117 10.7639 11.1578 10.6011 11.1789C10.6659 11.1836 10.7307 11.1899 10.7963 11.1969C10.8372 11.2016 10.8781 11.2063 10.9174 11.2164C10.9576 11.2274 10.9969 11.243 11.0301 11.2672C11.0664 11.2945 11.0949 11.3313 11.1165 11.3719C11.1589 11.4516 11.1728 11.5438 11.1805 11.6352C11.1906 11.7508 11.1914 11.868 11.1829 11.9836C11.1906 11.9063 11.2068 11.8289 11.2307 11.7555C11.2747 11.6211 11.3441 11.4961 11.4383 11.3922C11.4761 11.3516 11.517 11.3133 11.5617 11.2813C11.6998 11.1828 11.8758 11.1399 12.0432 11.1633C11.8727 11.1703 11.7006 11.1164 11.5648 11.0125C11.4954 10.9594 11.4352 10.8938 11.3935 10.8172C11.3287 10.6984 11.3102 10.5539 11.3434 10.4227Z"
                                fill="url(#paint2_radial_2246_1150)"/>
                        </g>
                    </g>
                    <mask id="mask3_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="6" y="2"
                          width="12" height="20">
                        <path
                            d="M12.2523 2C11.7894 2 11.3248 2.09219 10.9051 2.32187C10.4591 2.56484 10.0934 2.95391 9.86883 3.41328C9.64352 3.87266 9.55556 4.36328 9.54167 4.90391C9.5162 5.93047 9.56482 7.00703 9.6412 7.98281C9.66127 8.27969 9.6983 8.45313 9.66049 8.75859C9.53549 9.40703 8.97531 9.84297 8.67593 10.4125C8.34645 11.0406 8.20756 11.7508 7.95911 12.4164C7.73148 13.025 7.41204 13.5961 7.19676 14.2094C6.89506 15.0664 6.80478 16.0086 7.00386 16.8961C7.15586 17.5727 7.47299 18.207 7.90046 18.75C7.83873 18.8625 7.77855 18.9773 7.71528 19.0891C7.51698 19.4352 7.27469 19.7641 7.16204 20.1477C7.10571 20.3391 7.08333 20.5438 7.1196 20.7406C7.15586 20.9375 7.25463 21.1258 7.40895 21.2508C7.51003 21.332 7.63272 21.3852 7.75849 21.4148C7.88426 21.4437 8.01466 21.4508 8.14429 21.4484C8.6358 21.4375 9.11265 21.2867 9.58796 21.1602C9.87037 21.0852 10.1543 21.0187 10.439 20.9586C11.4529 20.7484 12.5841 20.8328 13.5247 20.9703C13.8434 21.0195 14.1597 21.0828 14.473 21.1602C14.9637 21.2805 15.4522 21.4336 15.9568 21.4484C16.0895 21.4523 16.2238 21.4461 16.3534 21.4172C16.483 21.3875 16.6088 21.3344 16.7122 21.2508C16.8673 21.1258 16.966 20.9367 17.0023 20.7398C17.0386 20.543 17.0162 20.3375 16.9591 20.1453C16.8449 19.7609 16.6003 19.4336 16.3981 19.0891C16.3179 18.9523 16.2438 18.8133 16.1644 18.6766C16.7739 17.9836 17.2647 17.182 17.5486 16.3016C17.858 15.3406 17.9151 14.3055 17.7847 13.3031C17.6543 12.3008 17.3403 11.3289 16.9275 10.4086C16.4089 9.25547 15.973 8.83828 15.6566 7.825C15.3156 6.72969 15.5972 5.43359 15.3434 4.44062C15.2531 4.10312 15.1088 3.78047 14.9228 3.48516C14.7052 3.13906 14.429 2.82969 14.1011 2.58906C13.5779 2.20469 12.9205 2 12.2523 2Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask3_2246_1150)">
                        <g opacity="0.11" filter="url(#filter3_f_2246_1150)">
                            <path
                                d="M10.9329 12.7141C10.8511 13.0289 10.7948 13.3508 10.7654 13.6758C10.723 14.1344 10.733 14.5961 10.7083 15.0562C10.6883 15.4461 10.6427 15.8406 10.7099 16.2258C10.7415 16.4094 10.7986 16.5883 10.8796 16.7555C10.892 16.6914 10.902 16.6273 10.9074 16.5625C10.936 16.25 10.8843 15.9367 10.8665 15.6242C10.8356 15.0758 10.9105 14.5273 10.9414 13.9789C10.9645 13.5578 10.9622 13.1351 10.9329 12.7141Z"
                                fill="black"/>
                        </g>
                    </g>
                    <mask id="mask4_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="6" y="2"
                          width="12" height="20">
                        <path
                            d="M12.2523 2C11.7894 2 11.3248 2.09219 10.9051 2.32187C10.4591 2.56484 10.0934 2.95391 9.86883 3.41328C9.64352 3.87266 9.55556 4.36328 9.54167 4.90391C9.5162 5.93047 9.56482 7.00703 9.6412 7.98281C9.66127 8.27969 9.6983 8.45313 9.66049 8.75859C9.53549 9.40703 8.97531 9.84297 8.67593 10.4125C8.34645 11.0406 8.20756 11.7508 7.95911 12.4164C7.73148 13.025 7.41204 13.5961 7.19676 14.2094C6.89506 15.0664 6.80478 16.0086 7.00386 16.8961C7.15586 17.5727 7.47299 18.207 7.90046 18.75C7.83873 18.8625 7.77855 18.9773 7.71528 19.0891C7.51698 19.4352 7.27469 19.7641 7.16204 20.1477C7.10571 20.3391 7.08333 20.5438 7.1196 20.7406C7.15586 20.9375 7.25463 21.1258 7.40895 21.2508C7.51003 21.332 7.63272 21.3852 7.75849 21.4148C7.88426 21.4437 8.01466 21.4508 8.14429 21.4484C8.6358 21.4375 9.11265 21.2867 9.58796 21.1602C9.87037 21.0852 10.1543 21.0187 10.439 20.9586C11.4529 20.7484 12.5841 20.8328 13.5247 20.9703C13.8434 21.0195 14.1597 21.0828 14.473 21.1602C14.9637 21.2805 15.4522 21.4336 15.9568 21.4484C16.0895 21.4523 16.2238 21.4461 16.3534 21.4172C16.483 21.3875 16.6088 21.3344 16.7122 21.2508C16.8673 21.1258 16.966 20.9367 17.0023 20.7398C17.0386 20.543 17.0162 20.3375 16.9591 20.1453C16.8449 19.7609 16.6003 19.4336 16.3981 19.0891C16.3179 18.9523 16.2438 18.8133 16.1644 18.6766C16.7739 17.9836 17.2647 17.182 17.5486 16.3016C17.858 15.3406 17.9151 14.3055 17.7847 13.3031C17.6543 12.3008 17.3403 11.3289 16.9275 10.4086C16.4089 9.25547 15.973 8.83828 15.6566 7.825C15.3156 6.72969 15.5972 5.43359 15.3434 4.44062C15.2531 4.10312 15.1088 3.78047 14.9228 3.48516C14.7052 3.13906 14.429 2.82969 14.1011 2.58906C13.5779 2.20469 12.9205 2 12.2523 2Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask4_2246_1150)">
                        <g opacity="0.75" filter="url(#filter4_f_2246_1150)">
                            <path
                                d="M16.3519 12.2523C16.4313 12.2398 16.9182 12.6594 16.8519 12.8156C16.7855 12.9711 16.6597 12.8773 16.5702 12.8781C16.4807 12.8797 16.2361 12.9922 16.1952 12.9211C16.1536 12.85 16.3032 12.6844 16.3812 12.5453C16.4445 12.4336 16.2732 12.2648 16.3519 12.2523Z"
                                fill="#7C7C7C"/>
                        </g>
                    </g>
                    <mask id="mask5_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="6" y="2"
                          width="12" height="20">
                        <path
                            d="M12.2523 2C11.7894 2 11.3248 2.09219 10.9051 2.32187C10.4591 2.56484 10.0934 2.95391 9.86883 3.41328C9.64352 3.87266 9.55556 4.36328 9.54167 4.90391C9.5162 5.93047 9.56482 7.00703 9.6412 7.98281C9.66127 8.27969 9.6983 8.45313 9.66049 8.75859C9.53549 9.40703 8.97531 9.84297 8.67593 10.4125C8.34645 11.0406 8.20756 11.7508 7.95911 12.4164C7.73148 13.025 7.41204 13.5961 7.19676 14.2094C6.89506 15.0664 6.80478 16.0086 7.00386 16.8961C7.15586 17.5727 7.47299 18.207 7.90046 18.75C7.83873 18.8625 7.77855 18.9773 7.71528 19.0891C7.51698 19.4352 7.27469 19.7641 7.16204 20.1477C7.10571 20.3391 7.08333 20.5438 7.1196 20.7406C7.15586 20.9375 7.25463 21.1258 7.40895 21.2508C7.51003 21.332 7.63272 21.3852 7.75849 21.4148C7.88426 21.4437 8.01466 21.4508 8.14429 21.4484C8.6358 21.4375 9.11265 21.2867 9.58796 21.1602C9.87037 21.0852 10.1543 21.0187 10.439 20.9586C11.4529 20.7484 12.5841 20.8328 13.5247 20.9703C13.8434 21.0195 14.1597 21.0828 14.473 21.1602C14.9637 21.2805 15.4522 21.4336 15.9568 21.4484C16.0895 21.4523 16.2238 21.4461 16.3534 21.4172C16.483 21.3875 16.6088 21.3344 16.7122 21.2508C16.8673 21.1258 16.966 20.9367 17.0023 20.7398C17.0386 20.543 17.0162 20.3375 16.9591 20.1453C16.8449 19.7609 16.6003 19.4336 16.3981 19.0891C16.3179 18.9523 16.2438 18.8133 16.1644 18.6766C16.7739 17.9836 17.2647 17.182 17.5486 16.3016C17.858 15.3406 17.9151 14.3055 17.7847 13.3031C17.6543 12.3008 17.3403 11.3289 16.9275 10.4086C16.4089 9.25547 15.973 8.83828 15.6566 7.825C15.3156 6.72969 15.5972 5.43359 15.3434 4.44062C15.2531 4.10312 15.1088 3.78047 14.9228 3.48516C14.7052 3.13906 14.429 2.82969 14.1011 2.58906C13.5779 2.20469 12.9205 2 12.2523 2Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask5_2246_1150)">
                        <g filter="url(#filter5_f_2246_1150)">
                            <path
                                d="M13.3765 2.86877C13.206 2.99064 13.2801 3.14299 13.3534 3.29533C13.4267 3.44846 13.1921 3.8883 13.1898 3.90705C13.1875 3.9258 13.6512 3.68439 13.7778 3.52658C13.9275 3.34142 14.3048 3.77814 14.2839 3.71174C14.2847 3.59299 13.5471 2.74767 13.3765 2.86877Z"
                                fill="#7C7C7C"/>
                        </g>
                    </g>
                    <mask id="mask6_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="6" y="2"
                          width="12" height="20">
                        <path
                            d="M12.2523 2C11.7894 2 11.3248 2.09219 10.9051 2.32187C10.4591 2.56484 10.0934 2.95391 9.86883 3.41328C9.64352 3.87266 9.55556 4.36328 9.54167 4.90391C9.5162 5.93047 9.56482 7.00703 9.6412 7.98281C9.66127 8.27969 9.6983 8.45313 9.66049 8.75859C9.53549 9.40703 8.97531 9.84297 8.67593 10.4125C8.34645 11.0406 8.20756 11.7508 7.95911 12.4164C7.73148 13.025 7.41204 13.5961 7.19676 14.2094C6.89506 15.0664 6.80478 16.0086 7.00386 16.8961C7.15586 17.5727 7.47299 18.207 7.90046 18.75C7.83873 18.8625 7.77855 18.9773 7.71528 19.0891C7.51698 19.4352 7.27469 19.7641 7.16204 20.1477C7.10571 20.3391 7.08333 20.5438 7.1196 20.7406C7.15586 20.9375 7.25463 21.1258 7.40895 21.2508C7.51003 21.332 7.63272 21.3852 7.75849 21.4148C7.88426 21.4437 8.01466 21.4508 8.14429 21.4484C8.6358 21.4375 9.11265 21.2867 9.58796 21.1602C9.87037 21.0852 10.1543 21.0187 10.439 20.9586C11.4529 20.7484 12.5841 20.8328 13.5247 20.9703C13.8434 21.0195 14.1597 21.0828 14.473 21.1602C14.9637 21.2805 15.4522 21.4336 15.9568 21.4484C16.0895 21.4523 16.2238 21.4461 16.3534 21.4172C16.483 21.3875 16.6088 21.3344 16.7122 21.2508C16.8673 21.1258 16.966 20.9367 17.0023 20.7398C17.0386 20.543 17.0162 20.3375 16.9591 20.1453C16.8449 19.7609 16.6003 19.4336 16.3981 19.0891C16.3179 18.9523 16.2438 18.8133 16.1644 18.6766C16.7739 17.9836 17.2647 17.182 17.5486 16.3016C17.858 15.3406 17.9151 14.3055 17.7847 13.3031C17.6543 12.3008 17.3403 11.3289 16.9275 10.4086C16.4089 9.25547 15.973 8.83828 15.6566 7.825C15.3156 6.72969 15.5972 5.43359 15.3434 4.44062C15.2531 4.10312 15.1088 3.78047 14.9228 3.48516C14.7052 3.13906 14.429 2.82969 14.1011 2.58906C13.5779 2.20469 12.9205 2 12.2523 2Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask6_2246_1150)">
                        <g filter="url(#filter6_f_2246_1150)">
                            <path
                                d="M14.669 7.98674C14.5255 8.11955 14.7369 8.31877 14.8364 8.55237C14.8989 8.69768 15.071 8.90315 15.2377 8.87034C15.3634 8.84534 15.4406 8.66252 15.429 8.5344C15.4059 8.28596 15.1991 8.22737 15.0486 8.14221C14.9298 8.07502 14.7701 7.89377 14.669 7.98674Z"
                                fill="#838384"/>
                        </g>
                    </g>
                    <path
                        d="M8.93673 9.88358C8.46605 10.4242 7.98225 10.9484 7.71682 11.5336C7.58488 11.8305 7.52315 12.1531 7.43287 12.4656C7.33102 12.8203 7.19213 13.1641 7.03627 13.4984C6.89198 13.807 6.73303 14.1086 6.57485 14.4094C6.45911 14.6289 6.34182 14.8523 6.3017 15.0976C6.27006 15.2914 6.28781 15.4914 6.33719 15.6812C6.3858 15.8711 6.46374 16.0523 6.55247 16.2266C6.92901 16.9726 7.4946 17.6148 8.16435 18.107C8.46837 18.3297 8.79321 18.5226 9.13503 18.6812C9.32022 18.7664 9.51466 18.843 9.71837 18.8461C9.82022 18.8484 9.92284 18.8312 10.0162 18.7898C10.1088 18.7484 10.1921 18.682 10.2477 18.5953C10.3156 18.4891 10.3387 18.357 10.3248 18.2312C10.311 18.1055 10.2623 17.9851 10.1975 17.8773C10.0386 17.6133 9.78781 17.4219 9.5463 17.2328C9.02469 16.8242 8.52083 16.3922 8.03781 15.9375C7.90201 15.8086 7.76543 15.6766 7.67053 15.5141C7.57793 15.3562 7.52778 15.1766 7.49383 14.9961C7.40046 14.5016 7.42438 13.9812 7.59028 13.5062C7.65586 13.3203 7.74151 13.143 7.82485 12.9648C7.96837 12.6562 8.10417 12.3414 8.29321 12.0586C8.52855 11.7062 8.84337 11.4078 9.03472 11.0297C9.19676 10.7101 9.26235 10.3516 9.32485 9.99843C9.37423 9.72186 9.46759 9.45155 9.51543 9.17499C9.42207 9.35468 9.12114 9.64921 8.93673 9.88358Z"
                        fill="#020204"/>
                    <mask id="mask7_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="6" y="9"
                          width="5" height="10">
                        <path
                            d="M8.93673 9.88358C8.46605 10.4242 7.98225 10.9484 7.71682 11.5336C7.58488 11.8305 7.52315 12.1531 7.43287 12.4656C7.33102 12.8203 7.19213 13.1641 7.03627 13.4984C6.89198 13.807 6.73303 14.1086 6.57485 14.4094C6.45911 14.6289 6.34182 14.8523 6.3017 15.0976C6.27006 15.2914 6.28781 15.4914 6.33719 15.6812C6.3858 15.8711 6.46374 16.0523 6.55247 16.2266C6.92901 16.9726 7.4946 17.6148 8.16435 18.107C8.46837 18.3297 8.79321 18.5226 9.13503 18.6812C9.32022 18.7664 9.51466 18.843 9.71837 18.8461C9.82022 18.8484 9.92284 18.8312 10.0162 18.7898C10.1088 18.7484 10.1921 18.682 10.2477 18.5953C10.3156 18.4891 10.3387 18.357 10.3248 18.2312C10.311 18.1055 10.2623 17.9851 10.1975 17.8773C10.0386 17.6133 9.78781 17.4219 9.5463 17.2328C9.02469 16.8242 8.52083 16.3922 8.03781 15.9375C7.90201 15.8086 7.76543 15.6766 7.67053 15.5141C7.57793 15.3562 7.52778 15.1766 7.49383 14.9961C7.40046 14.5016 7.42438 13.9812 7.59028 13.5062C7.65586 13.3203 7.74151 13.143 7.82485 12.9648C7.96837 12.6562 8.10417 12.3414 8.29321 12.0586C8.52855 11.7062 8.84337 11.4078 9.03472 11.0297C9.19676 10.7101 9.26235 10.3516 9.32485 9.99843C9.37423 9.72186 9.46759 9.45155 9.51543 9.17499C9.42207 9.35468 9.12114 9.64921 8.93673 9.88358Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask7_2246_1150)">
                        <g opacity="0.95" filter="url(#filter7_f_2246_1150)">
                            <path
                                d="M8.39507 11.8516C8.24075 11.9953 8.10726 12.1617 7.99924 12.3445C7.82177 12.6445 7.7176 12.982 7.58797 13.3063C7.49229 13.5477 7.38041 13.7906 7.36729 14.0508C7.36035 14.1844 7.37964 14.318 7.38427 14.4516C7.3889 14.5852 7.37655 14.7242 7.31173 14.8406C7.25772 14.9383 7.16744 15.0148 7.06328 15.0523C7.20448 15.1 7.32948 15.1922 7.41822 15.3125C7.49229 15.4141 7.54013 15.532 7.60417 15.6391C7.65664 15.7266 7.72069 15.8078 7.80016 15.8711C7.87886 15.9352 7.97377 15.9805 8.07331 15.993C8.21143 16.0109 8.35494 15.9648 8.4568 15.8695C8.32871 14.6547 8.44599 13.4148 8.79939 12.2469C8.82177 12.1734 8.84491 12.0992 8.85109 12.0227C8.85649 11.9453 8.84183 11.8641 8.79553 11.8031C8.77161 11.7703 8.73843 11.7445 8.70062 11.7281C8.66359 11.7125 8.62192 11.7063 8.5818 11.7117C8.54167 11.7164 8.50232 11.732 8.46991 11.7563C8.43751 11.7813 8.41127 11.8141 8.39507 11.8516Z"
                                fill="#7C7C7C"/>
                        </g>
                    </g>
                    <path
                        d="M16.5586 11.9313C16.963 12.261 17.2199 12.7586 17.2994 13.2781C17.3611 13.6828 17.321 14.0992 17.2307 14.4985C17.1404 14.8985 17.0015 15.2844 16.8627 15.6703C16.8079 15.8235 16.7523 15.9789 16.7307 16.1406C16.7083 16.3031 16.7222 16.4742 16.7994 16.618C16.8881 16.7828 17.0532 16.8961 17.2307 16.9492C17.4059 17.0024 17.5949 17.0008 17.7724 16.9563C17.9499 16.9117 18.2485 16.8539 18.3928 16.7399C18.7593 16.4516 18.8465 15.9508 18.9336 15.5117C19.0239 15.0531 18.9799 14.5727 18.9005 14.1094C18.7917 13.4774 18.6088 12.8602 18.3765 12.2641C18.2053 11.825 17.9861 11.4063 17.7253 11.0172C17.4691 10.6352 17.1065 10.3375 16.838 9.96408C16.7446 9.8344 16.6327 9.70002 16.5417 9.56877C16.3441 9.28596 16.3889 9.33908 16.2662 9.15549C16.1775 9.02268 16.037 8.97737 15.8897 8.91955C15.7415 8.86174 15.5764 8.84455 15.4236 8.88752C15.223 8.94455 15.0586 9.10549 14.9715 9.2969C14.8843 9.48908 14.8688 9.7094 14.9028 9.91799C14.9468 10.1867 15.0679 10.4367 15.2053 10.6711C15.3596 10.936 15.5386 11.1914 15.7724 11.3883C16.0162 11.5938 16.311 11.7297 16.5586 11.9313Z"
                        fill="#020204"/>
                    <mask id="mask8_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="14" y="8"
                          width="5" height="9">
                        <path
                            d="M16.5586 11.9313C16.963 12.261 17.2199 12.7586 17.2994 13.2781C17.3611 13.6828 17.321 14.0992 17.2307 14.4985C17.1404 14.8985 17.0015 15.2844 16.8627 15.6703C16.8079 15.8235 16.7523 15.9789 16.7307 16.1406C16.7083 16.3031 16.7222 16.4742 16.7994 16.618C16.8881 16.7828 17.0532 16.8961 17.2307 16.9492C17.4059 17.0024 17.5949 17.0008 17.7724 16.9563C17.9499 16.9117 18.2485 16.8539 18.3928 16.7399C18.7593 16.4516 18.8465 15.9508 18.9336 15.5117C19.0239 15.0531 18.9799 14.5727 18.9005 14.1094C18.7917 13.4774 18.6088 12.8602 18.3765 12.2641C18.2053 11.825 17.9861 11.4063 17.7253 11.0172C17.4691 10.6352 17.1065 10.3375 16.838 9.96408C16.7446 9.8344 16.6327 9.70002 16.5417 9.56877C16.3441 9.28596 16.3889 9.33908 16.2662 9.15549C16.1775 9.02268 16.037 8.97737 15.8897 8.91955C15.7415 8.86174 15.5764 8.84455 15.4236 8.88752C15.223 8.94455 15.0586 9.10549 14.9715 9.2969C14.8843 9.48908 14.8688 9.7094 14.9028 9.91799C14.9468 10.1867 15.0679 10.4367 15.2053 10.6711C15.3596 10.936 15.5386 11.1914 15.7724 11.3883C16.0162 11.5938 16.311 11.7297 16.5586 11.9313Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask8_2246_1150)">
                        <g filter="url(#filter8_f_2246_1150)">
                            <path
                                d="M15.6065 11.2961C15.6389 11.3274 15.6728 11.3594 15.7076 11.3891C15.956 11.5946 16.088 11.825 16.3403 12.0266C16.7523 12.3563 17.1697 12.925 17.2508 13.4446C17.314 13.85 17.2307 14.0704 17.1289 14.5477C17.027 15.0258 16.7384 15.7024 16.5818 16.1633C16.5201 16.3469 16.7083 16.2711 16.6836 16.4649C16.6713 16.5602 16.6697 16.6563 16.6813 16.7516C16.6829 16.7336 16.6836 16.7141 16.686 16.6961C16.716 16.4321 16.7955 16.1782 16.8827 15.929C17.0501 15.45 17.2423 14.9797 17.375 14.4875C17.5077 13.9961 17.4931 13.6422 17.4236 13.2196C17.3364 12.6875 17.0309 12.1969 16.5988 11.8727C16.2924 11.6438 15.9321 11.4969 15.6065 11.2961Z"
                                fill="#838384"/>
                        </g>
                    </g>
                    <path
                        d="M6.69907 15.6977C6.80556 15.6531 6.92515 15.6445 7.03781 15.6656C7.15123 15.6867 7.25849 15.7367 7.35339 15.8016C7.54398 15.9328 7.68518 16.1235 7.82022 16.3125C8.13117 16.7453 8.42978 17.1875 8.70139 17.6469C8.9213 18.0203 9.12269 18.4055 9.37731 18.7547C9.54321 18.9836 9.72994 19.1953 9.8966 19.4227C10.0633 19.6508 10.2106 19.8977 10.2847 20.1711C10.3812 20.5266 10.3434 20.918 10.1767 21.2453C10.0594 21.4758 9.87886 21.6735 9.65972 21.807C9.44059 21.9406 9.20988 22 8.9537 22C8.54707 22 8.14969 21.7789 7.7716 21.6266C7.00154 21.3156 6.16512 21.2188 5.37114 20.9766C5.12731 20.9024 4.88735 20.8141 4.64198 20.7461C4.53241 20.7156 4.42207 20.6891 4.31867 20.6414C4.21528 20.5945 4.11883 20.5234 4.06173 20.425C4.01775 20.3484 4 20.2586 4 20.1703C4 20.0813 4.0216 19.9938 4.0517 19.9109C4.11111 19.7445 4.20756 19.5938 4.27238 19.4289C4.37809 19.1602 4.39738 18.8641 4.38272 18.575C4.36883 18.2867 4.32253 18 4.30324 17.7117C4.29398 17.5828 4.2909 17.4524 4.31559 17.325C4.33951 17.1985 4.39352 17.0742 4.48534 16.9852C4.57022 16.9024 4.6821 16.8531 4.79784 16.8289C4.91281 16.8047 5.03164 16.8039 5.14892 16.8063C5.2662 16.8086 5.38426 16.8156 5.50154 16.8055C5.61883 16.7961 5.73688 16.7695 5.83873 16.7102C5.93596 16.6539 6.01543 16.5703 6.08102 16.4789C6.1466 16.3875 6.19985 16.2875 6.25463 16.1883C6.30864 16.0899 6.36497 15.9914 6.43673 15.9039C6.50772 15.8164 6.59568 15.7406 6.69907 15.6977Z"
                        fill="url(#paint3_linear_2246_1150)"/>
                    <mask id="mask9_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="4" y="15"
                          width="7" height="7">
                        <path
                            d="M6.69907 15.6977C6.80556 15.6531 6.92515 15.6445 7.03781 15.6656C7.15123 15.6867 7.25849 15.7367 7.35339 15.8016C7.54398 15.9328 7.68518 16.1235 7.82022 16.3125C8.13117 16.7453 8.42978 17.1875 8.70139 17.6469C8.9213 18.0203 9.12269 18.4055 9.37731 18.7547C9.54321 18.9836 9.72994 19.1953 9.8966 19.4227C10.0633 19.6508 10.2106 19.8977 10.2847 20.1711C10.3812 20.5266 10.3434 20.918 10.1767 21.2453C10.0594 21.4758 9.87886 21.6735 9.65972 21.807C9.44059 21.9406 9.20988 22 8.9537 22C8.54707 22 8.14969 21.7789 7.7716 21.6266C7.00154 21.3156 6.16512 21.2188 5.37114 20.9766C5.12731 20.9024 4.88735 20.8141 4.64198 20.7461C4.53241 20.7156 4.42207 20.6891 4.31867 20.6414C4.21528 20.5945 4.11883 20.5234 4.06173 20.425C4.01775 20.3484 4 20.2586 4 20.1703C4 20.0813 4.0216 19.9938 4.0517 19.9109C4.11111 19.7445 4.20756 19.5938 4.27238 19.4289C4.37809 19.1602 4.39738 18.8641 4.38272 18.575C4.36883 18.2867 4.32253 18 4.30324 17.7117C4.29398 17.5828 4.2909 17.4524 4.31559 17.325C4.33951 17.1985 4.39352 17.0742 4.48534 16.9852C4.57022 16.9024 4.6821 16.8531 4.79784 16.8289C4.91281 16.8047 5.03164 16.8039 5.14892 16.8063C5.2662 16.8086 5.38426 16.8156 5.50154 16.8055C5.61883 16.7961 5.73688 16.7695 5.83873 16.7102C5.93596 16.6539 6.01543 16.5703 6.08102 16.4789C6.1466 16.3875 6.19985 16.2875 6.25463 16.1883C6.30864 16.0899 6.36497 15.9914 6.43673 15.9039C6.50772 15.8164 6.59568 15.7406 6.69907 15.6977Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask9_2246_1150)">
                        <g filter="url(#filter9_f_2246_1150)">
                            <path
                                d="M6.86727 15.8828C6.96372 15.8437 7.07329 15.8391 7.17437 15.8625C7.27622 15.8859 7.37113 15.9359 7.45292 16.0008C7.61805 16.1297 7.73224 16.3109 7.84258 16.4898C8.10647 16.9226 8.36419 17.3609 8.60801 17.807C8.7932 18.1437 8.96912 18.4867 9.19598 18.7953C9.34644 19 9.51851 19.1883 9.67206 19.3906C9.82561 19.593 9.96218 19.8133 10.0301 20.0594C10.118 20.3758 10.0826 20.7266 9.93132 21.0172C9.82175 21.2266 9.65508 21.4047 9.45292 21.5234C9.25153 21.6422 9.01542 21.7016 8.7824 21.6906C8.41048 21.6734 8.07021 21.4851 7.7199 21.3578C7.04783 21.1109 6.32021 21.0773 5.63039 20.8851C5.38348 20.8172 5.14274 20.7266 4.89505 20.6633C4.78471 20.6351 4.67283 20.6117 4.56866 20.5672C4.4645 20.5226 4.3665 20.4539 4.3094 20.3547C4.26774 20.2805 4.25076 20.1937 4.25308 20.1086C4.25616 20.0234 4.277 19.9391 4.30709 19.8594C4.36727 19.7 4.46141 19.5562 4.52159 19.3969C4.61342 19.1562 4.62499 18.8914 4.60801 18.6344C4.59104 18.3773 4.54629 18.1219 4.53085 17.8648C4.52468 17.7492 4.52314 17.6328 4.54629 17.5203C4.56943 17.407 4.61804 17.2976 4.69906 17.2164C4.78703 17.1281 4.9074 17.0805 5.03008 17.0609C5.152 17.0422 5.27622 17.0508 5.39891 17.0617C5.52237 17.0726 5.64582 17.0867 5.76928 17.0797C5.89274 17.0719 6.01774 17.0414 6.11959 16.9711C6.21218 16.9078 6.28163 16.8148 6.33487 16.7156C6.38811 16.6164 6.42592 16.5094 6.46681 16.4047C6.50693 16.2992 6.55092 16.1945 6.61419 16.1008C6.67746 16.0078 6.76311 15.9258 6.86727 15.8828Z"
                                fill="#D99A03"/>
                        </g>
                    </g>
                    <mask id="mask10_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="4" y="15"
                          width="7" height="7">
                        <path
                            d="M6.69907 15.6977C6.80556 15.6531 6.92515 15.6445 7.03781 15.6656C7.15123 15.6867 7.25849 15.7367 7.35339 15.8016C7.54398 15.9328 7.68518 16.1235 7.82022 16.3125C8.13117 16.7453 8.42978 17.1875 8.70139 17.6469C8.9213 18.0203 9.12269 18.4055 9.37731 18.7547C9.54321 18.9836 9.72994 19.1953 9.8966 19.4227C10.0633 19.6508 10.2106 19.8977 10.2847 20.1711C10.3812 20.5266 10.3434 20.918 10.1767 21.2453C10.0594 21.4758 9.87886 21.6735 9.65972 21.807C9.44059 21.9406 9.20988 22 8.9537 22C8.54707 22 8.14969 21.7789 7.7716 21.6266C7.00154 21.3156 6.16512 21.2188 5.37114 20.9766C5.12731 20.9024 4.88735 20.8141 4.64198 20.7461C4.53241 20.7156 4.42207 20.6891 4.31867 20.6414C4.21528 20.5945 4.11883 20.5234 4.06173 20.425C4.01775 20.3484 4 20.2586 4 20.1703C4 20.0813 4.0216 19.9938 4.0517 19.9109C4.11111 19.7445 4.20756 19.5938 4.27238 19.4289C4.37809 19.1602 4.39738 18.8641 4.38272 18.575C4.36883 18.2867 4.32253 18 4.30324 17.7117C4.29398 17.5828 4.2909 17.4524 4.31559 17.325C4.33951 17.1985 4.39352 17.0742 4.48534 16.9852C4.57022 16.9024 4.6821 16.8531 4.79784 16.8289C4.91281 16.8047 5.03164 16.8039 5.14892 16.8063C5.2662 16.8086 5.38426 16.8156 5.50154 16.8055C5.61883 16.7961 5.73688 16.7695 5.83873 16.7102C5.93596 16.6539 6.01543 16.5703 6.08102 16.4789C6.1466 16.3875 6.19985 16.2875 6.25463 16.1883C6.30864 16.0899 6.36497 15.9914 6.43673 15.9039C6.50772 15.8164 6.59568 15.7406 6.69907 15.6977Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask10_2246_1150)">
                        <g filter="url(#filter10_f_2246_1150)">
                            <path
                                d="M6.77701 15.6382C6.87115 15.5914 6.98149 15.582 7.08411 15.6031C7.18673 15.6242 7.28241 15.675 7.36343 15.7414C7.5247 15.8742 7.62809 16.064 7.72377 16.25C7.94291 16.6765 8.14815 17.1125 8.4105 17.5148C8.60186 17.8062 8.82176 18.0773 9.01467 18.3679C9.27624 18.7609 9.4892 19.1937 9.57717 19.657C9.63581 19.9695 9.63426 20.3062 9.48612 20.5867C9.38812 20.7718 9.22994 20.9234 9.04244 21.0179C8.85572 21.1132 8.64044 21.1515 8.43133 21.1328C8.10186 21.1039 7.80325 20.9398 7.49306 20.825C6.94291 20.6226 6.348 20.5734 5.78164 20.4203C5.54322 20.3562 5.30865 20.2726 5.06714 20.2218C4.95988 20.1992 4.85109 20.1828 4.74923 20.1437C4.64738 20.1046 4.55093 20.0398 4.49846 19.9445C4.4622 19.8773 4.44985 19.7992 4.45525 19.7226C4.46065 19.6468 4.48303 19.5726 4.51235 19.5015C4.57176 19.3609 4.65896 19.2312 4.70448 19.0859C4.77238 18.8711 4.7446 18.639 4.69368 18.4195C4.64352 18.2007 4.57022 17.9859 4.54785 17.7625C4.53781 17.6632 4.53781 17.5617 4.56096 17.464C4.58334 17.3664 4.62886 17.2726 4.70062 17.2031C4.79322 17.1132 4.92285 17.0679 5.05247 17.0554C5.18133 17.0429 5.31096 17.0601 5.43905 17.0789C5.56714 17.0976 5.69676 17.1179 5.82562 17.1117C5.95525 17.1062 6.0872 17.0718 6.18828 16.9914C6.28859 16.9117 6.35186 16.7937 6.38812 16.6718C6.42439 16.5492 6.43596 16.4218 6.45062 16.2953C6.46528 16.1687 6.4838 16.0406 6.53241 15.9226C6.58102 15.8046 6.66281 15.6961 6.77701 15.6382Z"
                                fill="#F5BD0C"/>
                        </g>
                    </g>
                    <mask id="mask11_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="4" y="15"
                          width="7" height="7">
                        <path
                            d="M6.69907 15.6977C6.80556 15.6531 6.92515 15.6445 7.03781 15.6656C7.15123 15.6867 7.25849 15.7367 7.35339 15.8016C7.54398 15.9328 7.68518 16.1235 7.82022 16.3125C8.13117 16.7453 8.42978 17.1875 8.70139 17.6469C8.9213 18.0203 9.12269 18.4055 9.37731 18.7547C9.54321 18.9836 9.72994 19.1953 9.8966 19.4227C10.0633 19.6508 10.2106 19.8977 10.2847 20.1711C10.3812 20.5266 10.3434 20.918 10.1767 21.2453C10.0594 21.4758 9.87886 21.6735 9.65972 21.807C9.44059 21.9406 9.20988 22 8.9537 22C8.54707 22 8.14969 21.7789 7.7716 21.6266C7.00154 21.3156 6.16512 21.2188 5.37114 20.9766C5.12731 20.9024 4.88735 20.8141 4.64198 20.7461C4.53241 20.7156 4.42207 20.6891 4.31867 20.6414C4.21528 20.5945 4.11883 20.5234 4.06173 20.425C4.01775 20.3484 4 20.2586 4 20.1703C4 20.0813 4.0216 19.9938 4.0517 19.9109C4.11111 19.7445 4.20756 19.5938 4.27238 19.4289C4.37809 19.1602 4.39738 18.8641 4.38272 18.575C4.36883 18.2867 4.32253 18 4.30324 17.7117C4.29398 17.5828 4.2909 17.4524 4.31559 17.325C4.33951 17.1985 4.39352 17.0742 4.48534 16.9852C4.57022 16.9024 4.6821 16.8531 4.79784 16.8289C4.91281 16.8047 5.03164 16.8039 5.14892 16.8063C5.2662 16.8086 5.38426 16.8156 5.50154 16.8055C5.61883 16.7961 5.73688 16.7695 5.83873 16.7102C5.93596 16.6539 6.01543 16.5703 6.08102 16.4789C6.1466 16.3875 6.19985 16.2875 6.25463 16.1883C6.30864 16.0899 6.36497 15.9914 6.43673 15.9039C6.50772 15.8164 6.59568 15.7406 6.69907 15.6977Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask11_2246_1150)">
                        <g filter="url(#filter11_f_2246_1150)">
                            <path
                                d="M7.95062 16.7039C8.12423 17.021 8.22994 17.3851 8.40201 17.7054C8.56019 18 8.73997 18.3031 8.90047 18.5742C8.97223 18.6953 9.13889 18.8812 9.3071 19.1695C9.45988 19.4304 9.6142 19.7953 9.70062 19.9179C9.65124 19.7742 9.54939 19.389 9.42747 19.1148C9.31405 18.8585 9.18133 18.7125 9.10031 18.5742C8.93982 18.3031 8.76621 18.0585 8.60109 17.8C8.37346 17.4429 8.19985 17.0437 7.95062 16.7039Z"
                                fill="url(#paint4_linear_2246_1150)"/>
                        </g>
                    </g>
                    <mask id="mask12_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="6" y="2"
                          width="12" height="20">
                        <path
                            d="M12.2523 2C11.7894 2 11.3248 2.09219 10.9051 2.32187C10.4591 2.56484 10.0934 2.95391 9.86883 3.41328C9.64352 3.87266 9.55556 4.36328 9.54167 4.90391C9.5162 5.93047 9.56482 7.00703 9.6412 7.98281C9.66127 8.27969 9.6983 8.45313 9.66049 8.75859C9.53549 9.40703 8.97531 9.84297 8.67593 10.4125C8.34645 11.0406 8.20756 11.7508 7.95911 12.4164C7.73148 13.025 7.41204 13.5961 7.19676 14.2094C6.89506 15.0664 6.80478 16.0086 7.00386 16.8961C7.15586 17.5727 7.47299 18.207 7.90046 18.75C7.83873 18.8625 7.77855 18.9773 7.71528 19.0891C7.51698 19.4352 7.27469 19.7641 7.16204 20.1477C7.10571 20.3391 7.08333 20.5438 7.1196 20.7406C7.15586 20.9375 7.25463 21.1258 7.40895 21.2508C7.51003 21.332 7.63272 21.3852 7.75849 21.4148C7.88426 21.4437 8.01466 21.4508 8.14429 21.4484C8.6358 21.4375 9.11265 21.2867 9.58796 21.1602C9.87037 21.0852 10.1543 21.0187 10.439 20.9586C11.4529 20.7484 12.5841 20.8328 13.5247 20.9703C13.8434 21.0195 14.1597 21.0828 14.473 21.1602C14.9637 21.2805 15.4522 21.4336 15.9568 21.4484C16.0895 21.4523 16.2238 21.4461 16.3534 21.4172C16.483 21.3875 16.6088 21.3344 16.7122 21.2508C16.8673 21.1258 16.966 20.9367 17.0023 20.7398C17.0386 20.543 17.0162 20.3375 16.9591 20.1453C16.8449 19.7609 16.6003 19.4336 16.3981 19.0891C16.3179 18.9523 16.2438 18.8133 16.1644 18.6766C16.7739 17.9836 17.2647 17.182 17.5486 16.3016C17.858 15.3406 17.9151 14.3055 17.7847 13.3031C17.6543 12.3008 17.3403 11.3289 16.9275 10.4086C16.4089 9.25547 15.973 8.83828 15.6566 7.825C15.3156 6.72969 15.5972 5.43359 15.3434 4.44062C15.2531 4.10312 15.1088 3.78047 14.9228 3.48516C14.7052 3.13906 14.429 2.82969 14.1011 2.58906C13.5779 2.20469 12.9205 2 12.2523 2Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask12_2246_1150)">
                        <g opacity="0.2" filter="url(#filter12_f_2246_1150)">
                            <path
                                d="M19.3318 18.8446C19.3009 18.9485 19.2531 19.0493 19.1921 19.1415C19.0571 19.3438 18.8603 19.4969 18.6644 19.6375C18.3303 19.8774 17.9815 20.0977 17.6698 20.3704C17.4614 20.5532 17.2708 20.7586 17.0949 20.9743C16.9445 21.1586 16.8025 21.3524 16.6304 21.5164C16.4568 21.6821 16.2531 21.8165 16.0332 21.8891C15.7654 21.9774 15.483 21.9735 15.2253 21.9063C15.0448 21.8594 14.8681 21.7782 14.7562 21.6305C14.6443 21.4829 14.608 21.2836 14.5949 21.0883C14.5718 20.743 14.6127 20.3907 14.6497 20.0399C14.6806 19.7485 14.7091 19.4571 14.7207 19.1664C14.7415 18.6375 14.7068 18.1141 14.6366 17.6C14.6242 17.5133 14.6119 17.4266 14.6188 17.3383C14.6258 17.2493 14.6551 17.1571 14.7168 17.0883C14.7739 17.025 14.8534 16.9875 14.9321 16.9696C15.0108 16.9508 15.0911 16.95 15.1705 16.9477C15.358 16.943 15.5455 16.9313 15.7299 16.9485C15.8465 16.9586 15.9607 16.9805 16.0764 16.9915C16.2701 17.0102 16.4715 17.0008 16.6659 16.943C16.875 16.8805 17.0741 16.7641 17.287 16.7321C17.3742 16.7188 17.4614 16.7204 17.5463 16.7329C17.6327 16.7446 17.7191 16.7688 17.7855 16.8227C17.8364 16.8633 17.8735 16.9188 17.902 16.9782C17.9452 17.0672 17.9715 17.1649 17.9869 17.2657C18 17.3547 18.0054 17.4461 18.0278 17.5321C18.0648 17.6735 18.1497 17.7938 18.2508 17.8915C18.3526 17.9891 18.4707 18.0665 18.5895 18.143C18.7076 18.2188 18.8264 18.2938 18.9522 18.3563C19.0116 18.386 19.0725 18.4125 19.1289 18.4461C19.186 18.4805 19.2384 18.5219 19.2762 18.5766C19.3272 18.6508 19.3472 18.7485 19.3318 18.8446Z"
                                fill="url(#paint5_linear_2246_1150)"/>
                        </g>
                    </g>
                    <path
                        d="M20.4715 19.4156C20.2971 19.625 20.0548 19.7633 19.8133 19.8883C19.402 20.1 18.9753 20.2867 18.5887 20.5422C18.3295 20.7133 18.0903 20.9141 17.8665 21.1305C17.6752 21.3156 17.4938 21.5133 17.2793 21.6703C17.0625 21.8289 16.8125 21.9438 16.5478 21.9836C16.4745 21.9945 16.4012 22 16.3272 22C16.0772 22 15.8272 21.9391 15.5972 21.8375C15.3889 21.7461 15.1883 21.6141 15.0679 21.4188C14.9475 21.2219 14.9198 20.982 14.9198 20.75C14.919 20.3414 14.9938 19.9367 15.064 19.5336C15.1227 19.1984 15.1782 18.8633 15.2145 18.525C15.2801 17.9109 15.2793 17.2898 15.2361 16.6727C15.2284 16.5695 15.2199 16.4656 15.2353 16.3633C15.2508 16.2609 15.2924 16.1586 15.3696 16.0914C15.4414 16.0289 15.537 16.0008 15.632 15.9961C15.7261 15.9906 15.8202 16.0055 15.9136 16.0195C16.1335 16.0523 16.3557 16.0773 16.571 16.1352C16.7068 16.1711 16.8395 16.2195 16.9745 16.257C17.2014 16.3188 17.4383 16.3484 17.6705 16.3211C17.9213 16.2914 18.1651 16.1961 18.4174 16.2023C18.5208 16.2047 18.6235 16.2242 18.7222 16.2563C18.8225 16.2883 18.9221 16.3344 18.9961 16.4109C19.0525 16.4688 19.0918 16.5414 19.1211 16.6172C19.1651 16.7297 19.189 16.85 19.1991 16.9703C19.2076 17.0773 19.206 17.1859 19.2261 17.2914C19.2593 17.4641 19.3495 17.6227 19.4607 17.7578C19.5725 17.8938 19.706 18.0086 19.8395 18.1219C19.973 18.2352 20.1065 18.3477 20.25 18.4469C20.3171 18.4938 20.3866 18.5375 20.4506 18.5883C20.5147 18.6398 20.5733 18.6992 20.6134 18.7711C20.6482 18.8344 20.6667 18.9055 20.6667 18.9781C20.6667 19.0188 20.6613 19.0594 20.6489 19.1C20.6142 19.2117 20.5502 19.3203 20.4715 19.4156Z"
                        fill="url(#paint6_linear_2246_1150)"/>
                    <mask id="mask13_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="14" y="15"
                          width="7" height="7">
                        <path
                            d="M20.4715 19.4156C20.2971 19.625 20.0548 19.7633 19.8133 19.8883C19.402 20.1 18.9753 20.2867 18.5887 20.5422C18.3295 20.7133 18.0903 20.9141 17.8665 21.1305C17.6752 21.3156 17.4938 21.5133 17.2793 21.6703C17.0625 21.8289 16.8125 21.9438 16.5478 21.9836C16.4745 21.9945 16.4012 22 16.3272 22C16.0772 22 15.8272 21.9391 15.5972 21.8375C15.3889 21.7461 15.1883 21.6141 15.0679 21.4188C14.9475 21.2219 14.9198 20.982 14.9198 20.75C14.919 20.3414 14.9938 19.9367 15.064 19.5336C15.1227 19.1984 15.1782 18.8633 15.2145 18.525C15.2801 17.9109 15.2793 17.2898 15.2361 16.6727C15.2284 16.5695 15.2199 16.4656 15.2353 16.3633C15.2508 16.2609 15.2924 16.1586 15.3696 16.0914C15.4414 16.0289 15.537 16.0008 15.632 15.9961C15.7261 15.9906 15.8202 16.0055 15.9136 16.0195C16.1335 16.0523 16.3557 16.0773 16.571 16.1352C16.7068 16.1711 16.8395 16.2195 16.9745 16.257C17.2014 16.3188 17.4383 16.3484 17.6705 16.3211C17.9213 16.2914 18.1651 16.1961 18.4174 16.2023C18.5208 16.2047 18.6235 16.2242 18.7222 16.2563C18.8225 16.2883 18.9221 16.3344 18.9961 16.4109C19.0525 16.4688 19.0918 16.5414 19.1211 16.6172C19.1651 16.7297 19.189 16.85 19.1991 16.9703C19.2076 17.0773 19.206 17.1859 19.2261 17.2914C19.2593 17.4641 19.3495 17.6227 19.4607 17.7578C19.5725 17.8938 19.706 18.0086 19.8395 18.1219C19.973 18.2352 20.1065 18.3477 20.25 18.4469C20.3171 18.4938 20.3866 18.5375 20.4506 18.5883C20.5147 18.6398 20.5733 18.6992 20.6134 18.7711C20.6482 18.8344 20.6667 18.9055 20.6667 18.9781C20.6667 19.0188 20.6613 19.0594 20.6489 19.1C20.6142 19.2117 20.5502 19.3203 20.4715 19.4156Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask13_2246_1150)">
                        <g filter="url(#filter13_f_2246_1150)">
                            <path
                                d="M20.4514 18.8844C20.4105 18.9883 20.3526 19.086 20.2801 19.1711C20.1204 19.3602 19.8997 19.4844 19.6798 19.5961C19.3033 19.7868 18.9144 19.954 18.561 20.1836C18.3249 20.3375 18.1057 20.518 17.9012 20.7133C17.7269 20.8797 17.561 21.0579 17.365 21.1985C17.1667 21.3415 16.9383 21.4438 16.6975 21.4797C16.4043 21.5235 16.1019 21.4672 15.8295 21.3493C15.6397 21.2665 15.456 21.1493 15.3457 20.9719C15.2361 20.7954 15.2107 20.5797 15.2107 20.3711C15.2091 20.0032 15.2778 19.6391 15.3426 19.2774C15.3966 18.9766 15.4475 18.675 15.4799 18.3711C15.5386 17.818 15.5363 17.2602 15.4992 16.7055C15.4931 16.6125 15.4861 16.5188 15.5 16.4266C15.5139 16.3344 15.5517 16.243 15.6212 16.1821C15.6867 16.125 15.7747 16.1 15.8611 16.0961C15.9468 16.0915 16.0324 16.1055 16.1181 16.118C16.3195 16.1477 16.5216 16.1704 16.7184 16.2219C16.8426 16.2547 16.9637 16.2985 17.0872 16.3313C17.294 16.3875 17.5108 16.4141 17.723 16.3891C17.9522 16.3625 18.1744 16.2766 18.4043 16.2821C18.4992 16.2844 18.5926 16.3024 18.6829 16.3305C18.7747 16.3594 18.8658 16.4008 18.9337 16.4696C18.9846 16.5219 19.0193 16.5875 19.0479 16.6555C19.0887 16.7563 19.1165 16.8641 19.1181 16.9735C19.1204 17.0875 19.0965 17.2016 19.1111 17.3149C19.1235 17.4063 19.162 17.493 19.2114 17.5711C19.26 17.6493 19.3195 17.7204 19.3789 17.7907C19.4931 17.9274 19.6073 18.0665 19.7508 18.1711C19.9136 18.2907 20.1073 18.361 20.2755 18.4719C20.3256 18.5055 20.3742 18.543 20.4097 18.5922C20.4699 18.675 20.4853 18.7875 20.4514 18.8844Z"
                                fill="#CD8907"/>
                        </g>
                    </g>
                    <mask id="mask14_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="14" y="15"
                          width="7" height="7">
                        <path
                            d="M20.4715 19.4156C20.2971 19.625 20.0548 19.7633 19.8133 19.8883C19.402 20.1 18.9753 20.2867 18.5887 20.5422C18.3295 20.7133 18.0903 20.9141 17.8665 21.1305C17.6752 21.3156 17.4938 21.5133 17.2793 21.6703C17.0625 21.8289 16.8125 21.9438 16.5478 21.9836C16.4745 21.9945 16.4012 22 16.3272 22C16.0772 22 15.8272 21.9391 15.5972 21.8375C15.3889 21.7461 15.1883 21.6141 15.0679 21.4188C14.9475 21.2219 14.9198 20.982 14.9198 20.75C14.919 20.3414 14.9938 19.9367 15.064 19.5336C15.1227 19.1984 15.1782 18.8633 15.2145 18.525C15.2801 17.9109 15.2793 17.2898 15.2361 16.6727C15.2284 16.5695 15.2199 16.4656 15.2353 16.3633C15.2508 16.2609 15.2924 16.1586 15.3696 16.0914C15.4414 16.0289 15.537 16.0008 15.632 15.9961C15.7261 15.9906 15.8202 16.0055 15.9136 16.0195C16.1335 16.0523 16.3557 16.0773 16.571 16.1352C16.7068 16.1711 16.8395 16.2195 16.9745 16.257C17.2014 16.3188 17.4383 16.3484 17.6705 16.3211C17.9213 16.2914 18.1651 16.1961 18.4174 16.2023C18.5208 16.2047 18.6235 16.2242 18.7222 16.2563C18.8225 16.2883 18.9221 16.3344 18.9961 16.4109C19.0525 16.4688 19.0918 16.5414 19.1211 16.6172C19.1651 16.7297 19.189 16.85 19.1991 16.9703C19.2076 17.0773 19.206 17.1859 19.2261 17.2914C19.2593 17.4641 19.3495 17.6227 19.4607 17.7578C19.5725 17.8938 19.706 18.0086 19.8395 18.1219C19.973 18.2352 20.1065 18.3477 20.25 18.4469C20.3171 18.4938 20.3866 18.5375 20.4506 18.5883C20.5147 18.6398 20.5733 18.6992 20.6134 18.7711C20.6482 18.8344 20.6667 18.9055 20.6667 18.9781C20.6667 19.0188 20.6613 19.0594 20.6489 19.1C20.6142 19.2117 20.5502 19.3203 20.4715 19.4156Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask14_2246_1150)">
                        <g filter="url(#filter14_f_2246_1150)">
                            <path
                                d="M20.4282 18.7664C20.3819 18.8719 20.3225 18.9696 20.2523 19.0563C20.0887 19.2579 19.8673 19.3961 19.635 19.4852C19.2515 19.6321 18.8333 19.6516 18.4576 19.8188C18.2284 19.9204 18.0216 20.0735 17.8125 20.2188C17.6443 20.3352 17.4715 20.4485 17.2863 20.5297C17.0764 20.6227 16.8542 20.6743 16.6304 20.711C16.4884 20.7336 16.3441 20.7508 16.2006 20.743C16.0571 20.7352 15.9136 20.7008 15.7863 20.6266C15.6906 20.5704 15.6042 20.4899 15.5525 20.3844C15.4961 20.268 15.4861 20.1313 15.4869 19.9985C15.4907 19.6469 15.5656 19.2985 15.5633 18.9461C15.561 18.6391 15.5008 18.3368 15.4838 18.0305C15.4506 17.4414 15.5756 16.843 15.4653 16.2657C15.4483 16.1727 15.4244 16.0805 15.4252 15.986C15.4259 15.9391 15.4329 15.8914 15.4491 15.8477C15.4661 15.8047 15.4923 15.7649 15.527 15.7368C15.5571 15.7141 15.5918 15.7 15.6281 15.693C15.6636 15.6868 15.7006 15.6883 15.7369 15.6938C15.8086 15.7055 15.8773 15.7336 15.9475 15.7547C16.1482 15.8157 16.3603 15.8141 16.5648 15.8602C16.6929 15.8883 16.8164 15.936 16.9437 15.9704C17.1559 16.0297 17.3781 16.0547 17.5965 16.029C17.831 16.0008 18.0602 15.9149 18.2963 15.9211C18.3935 15.9235 18.4892 15.9414 18.5826 15.9696C18.6759 15.9977 18.7693 16.0375 18.8403 16.1102C18.8904 16.1625 18.9275 16.2289 18.9568 16.2977C19.0008 16.3985 19.0309 16.5079 19.0301 16.6188C19.0293 16.6766 19.0208 16.7336 19.0154 16.7914C19.0108 16.8493 19.0093 16.9079 19.0224 16.9633C19.0363 17.0196 19.0648 17.0704 19.0972 17.1164C19.1296 17.1625 19.1667 17.2039 19.2006 17.2493C19.2948 17.375 19.3627 17.5219 19.436 17.6633C19.5093 17.8047 19.5918 17.9446 19.7083 18.0469C19.8665 18.1852 20.071 18.2407 20.2477 18.3508C20.2994 18.3829 20.3488 18.4204 20.385 18.4719C20.4144 18.5125 20.4336 18.5618 20.4414 18.6133C20.4483 18.6641 20.4437 18.718 20.4282 18.7664Z"
                                fill="#F5C021"/>
                        </g>
                    </g>
                    <mask id="mask15_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="14" y="15"
                          width="7" height="7">
                        <path
                            d="M20.4715 19.4156C20.2971 19.625 20.0548 19.7633 19.8133 19.8883C19.402 20.1 18.9753 20.2867 18.5887 20.5422C18.3295 20.7133 18.0903 20.9141 17.8665 21.1305C17.6752 21.3156 17.4938 21.5133 17.2793 21.6703C17.0625 21.8289 16.8125 21.9438 16.5478 21.9836C16.4745 21.9945 16.4012 22 16.3272 22C16.0772 22 15.8272 21.9391 15.5972 21.8375C15.3889 21.7461 15.1883 21.6141 15.0679 21.4188C14.9475 21.2219 14.9198 20.982 14.9198 20.75C14.919 20.3414 14.9938 19.9367 15.064 19.5336C15.1227 19.1984 15.1782 18.8633 15.2145 18.525C15.2801 17.9109 15.2793 17.2898 15.2361 16.6727C15.2284 16.5695 15.2199 16.4656 15.2353 16.3633C15.2508 16.2609 15.2924 16.1586 15.3696 16.0914C15.4414 16.0289 15.537 16.0008 15.632 15.9961C15.7261 15.9906 15.8202 16.0055 15.9136 16.0195C16.1335 16.0523 16.3557 16.0773 16.571 16.1352C16.7068 16.1711 16.8395 16.2195 16.9745 16.257C17.2014 16.3188 17.4383 16.3484 17.6705 16.3211C17.9213 16.2914 18.1651 16.1961 18.4174 16.2023C18.5208 16.2047 18.6235 16.2242 18.7222 16.2563C18.8225 16.2883 18.9221 16.3344 18.9961 16.4109C19.0525 16.4688 19.0918 16.5414 19.1211 16.6172C19.1651 16.7297 19.189 16.85 19.1991 16.9703C19.2076 17.0773 19.206 17.1859 19.2261 17.2914C19.2593 17.4641 19.3495 17.6227 19.4607 17.7578C19.5725 17.8938 19.706 18.0086 19.8395 18.1219C19.973 18.2352 20.1065 18.3477 20.25 18.4469C20.3171 18.4938 20.3866 18.5375 20.4506 18.5883C20.5147 18.6398 20.5733 18.6992 20.6134 18.7711C20.6482 18.8344 20.6667 18.9055 20.6667 18.9781C20.6667 19.0188 20.6613 19.0594 20.6489 19.1C20.6142 19.2117 20.5502 19.3203 20.4715 19.4156Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask15_2246_1150)">
                        <g filter="url(#filter15_f_2246_1150)">
                            <path
                                d="M15.4259 16.186C15.6435 16.1266 15.8287 16.2938 15.9869 16.4196C16.0887 16.5078 16.2369 16.486 16.3619 16.4899C16.5694 16.4828 16.7755 16.525 16.983 16.4992C17.392 16.4641 17.7924 16.3625 18.2029 16.3453C18.3989 16.3328 18.6196 16.3211 18.7886 16.4367C18.8573 16.4852 18.9583 16.6891 19.0255 16.6125C18.9977 16.3985 18.8411 16.1914 18.6312 16.1344C18.4661 16.1078 18.2994 16.1539 18.1327 16.1391C17.6397 16.1274 17.1489 16.0344 16.6543 16.061C16.3102 16.0641 15.9668 16.0477 15.6227 16.0344C15.4877 16.0063 15.4398 16.1274 15.3665 16.1742C15.3858 16.1891 15.3928 16.1938 15.4259 16.186Z"
                                fill="url(#paint7_linear_2246_1150)"/>
                        </g>
                    </g>
                    <mask id="mask16_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="14" y="15"
                          width="7" height="7">
                        <path
                            d="M20.4715 19.4156C20.2971 19.625 20.0548 19.7633 19.8133 19.8883C19.402 20.1 18.9753 20.2867 18.5887 20.5422C18.3295 20.7133 18.0903 20.9141 17.8665 21.1305C17.6752 21.3156 17.4938 21.5133 17.2793 21.6703C17.0625 21.8289 16.8125 21.9438 16.5478 21.9836C16.4745 21.9945 16.4012 22 16.3272 22C16.0772 22 15.8272 21.9391 15.5972 21.8375C15.3889 21.7461 15.1883 21.6141 15.0679 21.4188C14.9475 21.2219 14.9198 20.982 14.9198 20.75C14.919 20.3414 14.9938 19.9367 15.064 19.5336C15.1227 19.1984 15.1782 18.8633 15.2145 18.525C15.2801 17.9109 15.2793 17.2898 15.2361 16.6727C15.2284 16.5695 15.2199 16.4656 15.2353 16.3633C15.2508 16.2609 15.2924 16.1586 15.3696 16.0914C15.4414 16.0289 15.537 16.0008 15.632 15.9961C15.7261 15.9906 15.8202 16.0055 15.9136 16.0195C16.1335 16.0523 16.3557 16.0773 16.571 16.1352C16.7068 16.1711 16.8395 16.2195 16.9745 16.257C17.2014 16.3188 17.4383 16.3484 17.6705 16.3211C17.9213 16.2914 18.1651 16.1961 18.4174 16.2023C18.5208 16.2047 18.6235 16.2242 18.7222 16.2563C18.8225 16.2883 18.9221 16.3344 18.9961 16.4109C19.0525 16.4688 19.0918 16.5414 19.1211 16.6172C19.1651 16.7297 19.189 16.85 19.1991 16.9703C19.2076 17.0773 19.206 17.1859 19.2261 17.2914C19.2593 17.4641 19.3495 17.6227 19.4607 17.7578C19.5725 17.8938 19.706 18.0086 19.8395 18.1219C19.973 18.2352 20.1065 18.3477 20.25 18.4469C20.3171 18.4938 20.3866 18.5375 20.4506 18.5883C20.5147 18.6398 20.5733 18.6992 20.6134 18.7711C20.6482 18.8344 20.6667 18.9055 20.6667 18.9781C20.6667 19.0188 20.6613 19.0594 20.6489 19.1C20.6142 19.2117 20.5502 19.3203 20.4715 19.4156Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask16_2246_1150)">
                        <g opacity="0.35" filter="url(#filter16_f_2246_1150)">
                            <path
                                d="M18.3125 16.6571C18.2755 16.5828 18.2076 16.5274 18.1312 16.4953C18.0556 16.4633 17.9722 16.4524 17.8897 16.4532C17.7253 16.4547 17.5617 16.4977 17.3974 16.4836C17.2593 16.4711 17.1281 16.4188 16.9931 16.3852C16.8534 16.3508 16.7053 16.3375 16.5671 16.3758C16.419 16.4164 16.2886 16.5172 16.2068 16.6485C16.1343 16.7641 16.1003 16.9008 16.0895 17.0375C16.0787 17.1742 16.0903 17.311 16.1042 17.4477C16.1134 17.5461 16.125 17.6446 16.1482 17.7407C16.1721 17.8367 16.2083 17.9305 16.2654 18.011C16.348 18.1266 16.4707 18.2094 16.6026 18.2586C16.8187 18.3391 17.0641 18.3352 17.2762 18.2469C17.6528 18.0813 17.9715 17.7844 18.1651 17.4188C18.2354 17.2875 18.2894 17.1477 18.3241 17.0039C18.338 16.9461 18.3488 16.8875 18.3488 16.8282C18.3496 16.7696 18.3395 16.7094 18.3125 16.6571Z"
                                fill="url(#paint8_radial_2246_1150)"/>
                        </g>
                    </g>
                    <mask id="mask17_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="14" y="15"
                          width="7" height="7">
                        <path
                            d="M20.4715 19.4156C20.2971 19.625 20.0548 19.7633 19.8133 19.8883C19.402 20.1 18.9753 20.2867 18.5887 20.5422C18.3295 20.7133 18.0903 20.9141 17.8665 21.1305C17.6752 21.3156 17.4938 21.5133 17.2793 21.6703C17.0625 21.8289 16.8125 21.9438 16.5478 21.9836C16.4745 21.9945 16.4012 22 16.3272 22C16.0772 22 15.8272 21.9391 15.5972 21.8375C15.3889 21.7461 15.1883 21.6141 15.0679 21.4188C14.9475 21.2219 14.9198 20.982 14.9198 20.75C14.919 20.3414 14.9938 19.9367 15.064 19.5336C15.1227 19.1984 15.1782 18.8633 15.2145 18.525C15.2801 17.9109 15.2793 17.2898 15.2361 16.6727C15.2284 16.5695 15.2199 16.4656 15.2353 16.3633C15.2508 16.2609 15.2924 16.1586 15.3696 16.0914C15.4414 16.0289 15.537 16.0008 15.632 15.9961C15.7261 15.9906 15.8202 16.0055 15.9136 16.0195C16.1335 16.0523 16.3557 16.0773 16.571 16.1352C16.7068 16.1711 16.8395 16.2195 16.9745 16.257C17.2014 16.3188 17.4383 16.3484 17.6705 16.3211C17.9213 16.2914 18.1651 16.1961 18.4174 16.2023C18.5208 16.2047 18.6235 16.2242 18.7222 16.2563C18.8225 16.2883 18.9221 16.3344 18.9961 16.4109C19.0525 16.4688 19.0918 16.5414 19.1211 16.6172C19.1651 16.7297 19.189 16.85 19.1991 16.9703C19.2076 17.0773 19.206 17.1859 19.2261 17.2914C19.2593 17.4641 19.3495 17.6227 19.4607 17.7578C19.5725 17.8938 19.706 18.0086 19.8395 18.1219C19.973 18.2352 20.1065 18.3477 20.25 18.4469C20.3171 18.4938 20.3866 18.5375 20.4506 18.5883C20.5147 18.6398 20.5733 18.6992 20.6134 18.7711C20.6482 18.8344 20.6667 18.9055 20.6667 18.9781C20.6667 19.0188 20.6613 19.0594 20.6489 19.1C20.6142 19.2117 20.5502 19.3203 20.4715 19.4156Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask17_2246_1150)">
                        <g opacity="0.35" filter="url(#filter17_f_2246_1150)">
                            <path
                                d="M18.3125 16.4445C18.2755 16.3906 18.2076 16.3508 18.1312 16.3273C18.0556 16.3039 17.9722 16.2969 17.8897 16.2969C17.7253 16.2984 17.5617 16.3297 17.3974 16.3187C17.2593 16.3102 17.1281 16.2719 16.9931 16.2484C16.8534 16.2234 16.7053 16.2133 16.5671 16.2414C16.419 16.2703 16.2886 16.343 16.2068 16.4383C16.1343 16.5219 16.1003 16.6211 16.0895 16.7195C16.0787 16.818 16.0903 16.9172 16.1042 17.0156C16.1134 17.0867 16.125 17.1586 16.1482 17.2281C16.1721 17.2977 16.2083 17.3656 16.2654 17.4234C16.348 17.507 16.4707 17.5664 16.6026 17.6023C16.8187 17.6609 17.0641 17.6578 17.2762 17.5937C17.6528 17.4742 17.9715 17.2594 18.1651 16.9953C18.2354 16.9 18.2894 16.7992 18.3241 16.6953C18.338 16.6531 18.3488 16.6109 18.3488 16.5687C18.3496 16.5258 18.3395 16.482 18.3125 16.4445Z"
                                fill="url(#paint9_radial_2246_1150)"/>
                        </g>
                    </g>
                    <path
                        d="M18.6258 15.9625C18.5988 15.8883 18.5509 15.8227 18.4931 15.7695C18.4352 15.7164 18.3665 15.6758 18.2948 15.6445C18.1512 15.5828 17.9946 15.5594 17.8403 15.5305C17.696 15.5031 17.5517 15.4695 17.4066 15.4445C17.2554 15.4187 17.0995 15.4016 16.9499 15.4359C16.8194 15.4656 16.6983 15.5344 16.5995 15.6258C16.5008 15.7172 16.4236 15.8312 16.3681 15.9547C16.2701 16.1727 16.2392 16.4172 16.2577 16.6555C16.2716 16.8328 16.3164 17.0156 16.4313 17.1492C16.5247 17.2578 16.6566 17.3258 16.7924 17.3664C17.027 17.4367 17.2824 17.4328 17.5147 17.3562C17.8982 17.2258 18.2377 16.9672 18.4676 16.6305C18.5432 16.5188 18.608 16.3977 18.6374 16.2664C18.6597 16.1664 18.6605 16.0586 18.6258 15.9625Z"
                        fill="#020204"/>
                    <mask id="mask18_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="16" y="15"
                          width="3" height="3">
                        <path
                            d="M18.6258 15.9625C18.5988 15.8883 18.5509 15.8227 18.4931 15.7695C18.4352 15.7164 18.3665 15.6758 18.2948 15.6445C18.1512 15.5828 17.9946 15.5594 17.8403 15.5305C17.696 15.5031 17.5517 15.4695 17.4066 15.4445C17.2554 15.4187 17.0995 15.4016 16.9499 15.4359C16.8194 15.4656 16.6983 15.5344 16.5995 15.6258C16.5008 15.7172 16.4236 15.8312 16.3681 15.9547C16.2701 16.1727 16.2392 16.4172 16.2577 16.6555C16.2716 16.8328 16.3164 17.0156 16.4313 17.1492C16.5247 17.2578 16.6566 17.3258 16.7924 17.3664C17.027 17.4367 17.2824 17.4328 17.5147 17.3562C17.8982 17.2258 18.2377 16.9672 18.4676 16.6305C18.5432 16.5188 18.608 16.3977 18.6374 16.2664C18.6597 16.1664 18.6605 16.0586 18.6258 15.9625Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask18_2246_1150)">
                        <g filter="url(#filter18_f_2246_1150)">
                            <path
                                d="M17.0316 15.3649C16.9954 15.3672 16.9599 15.3711 16.9236 15.3782C16.6929 15.4196 16.4815 15.5672 16.3627 15.7711C16.2785 15.9157 16.2407 16.086 16.2523 16.2532C16.2577 16.136 16.2878 16.0211 16.3441 15.9188C16.439 15.7446 16.6119 15.6133 16.8056 15.5774C16.9244 15.5555 17.0471 15.5688 17.1667 15.5836C17.2824 15.5985 17.3981 15.6141 17.5116 15.6383C17.6875 15.6774 17.8611 15.7368 18.0085 15.8407C18.0424 15.8649 18.0748 15.8922 18.1019 15.925C18.1289 15.9571 18.1497 15.9946 18.1582 16.036C18.1698 16.0969 18.1528 16.161 18.1227 16.2149C18.0926 16.2696 18.0517 16.3164 18.0085 16.3602C17.973 16.3961 17.936 16.4297 17.8981 16.4633C18.0687 16.4297 18.2407 16.3829 18.3827 16.2829C18.4421 16.2399 18.4969 16.1891 18.5324 16.125C18.5679 16.0602 18.5826 15.9821 18.5656 15.9102C18.5532 15.8618 18.527 15.8172 18.4946 15.7797C18.4622 15.7422 18.4228 15.7118 18.3827 15.6829C18.2045 15.5563 17.9961 15.4758 17.7801 15.4493C17.6412 15.4235 17.5015 15.4016 17.3619 15.3844C17.2531 15.3704 17.1412 15.3586 17.0316 15.3649V15.3649Z"
                                fill="url(#paint10_radial_2246_1150)"/>
                        </g>
                    </g>
                    <mask id="mask19_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="16" y="15"
                          width="3" height="3">
                        <path
                            d="M18.6258 15.9625C18.5988 15.8883 18.5509 15.8227 18.4931 15.7695C18.4352 15.7164 18.3665 15.6758 18.2948 15.6445C18.1512 15.5828 17.9946 15.5594 17.8403 15.5305C17.696 15.5031 17.5517 15.4695 17.4066 15.4445C17.2554 15.4187 17.0995 15.4016 16.9499 15.4359C16.8194 15.4656 16.6983 15.5344 16.5995 15.6258C16.5008 15.7172 16.4236 15.8312 16.3681 15.9547C16.2701 16.1727 16.2392 16.4172 16.2577 16.6555C16.2716 16.8328 16.3164 17.0156 16.4313 17.1492C16.5247 17.2578 16.6566 17.3258 16.7924 17.3664C17.027 17.4367 17.2824 17.4328 17.5147 17.3562C17.8982 17.2258 18.2377 16.9672 18.4676 16.6305C18.5432 16.5188 18.608 16.3977 18.6374 16.2664C18.6597 16.1664 18.6605 16.0586 18.6258 15.9625Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask19_2246_1150)">
                        <g filter="url(#filter19_f_2246_1150)">
                            <path
                                d="M17.0316 15.3649C16.9954 15.3672 16.9599 15.3711 16.9236 15.3782C16.6929 15.4196 16.4815 15.5672 16.3627 15.7711C16.2785 15.9157 16.2407 16.086 16.2523 16.2532C16.2577 16.136 16.2878 16.0211 16.3441 15.9188C16.439 15.7446 16.6119 15.6133 16.8056 15.5774C16.9244 15.5555 17.0471 15.5688 17.1667 15.5836C17.2824 15.5985 17.3981 15.6141 17.5116 15.6383C17.6875 15.6774 17.8611 15.7368 18.0085 15.8407C18.0424 15.8649 18.0748 15.8922 18.1019 15.925C18.1289 15.9571 18.1497 15.9946 18.1582 16.036C18.1698 16.0969 18.1528 16.161 18.1227 16.2149C18.0926 16.2696 18.0517 16.3164 18.0085 16.3602C17.973 16.3961 17.936 16.4297 17.8981 16.4633C18.0687 16.4297 18.2407 16.3829 18.3827 16.2829C18.4421 16.2399 18.4969 16.1891 18.5324 16.125C18.5679 16.0602 18.5826 15.9821 18.5656 15.9102C18.5532 15.8618 18.527 15.8172 18.4946 15.7797C18.4622 15.7422 18.4228 15.7118 18.3827 15.6829C18.2045 15.5563 17.9961 15.4758 17.7801 15.4493C17.6412 15.4235 17.5015 15.4016 17.3619 15.3844C17.2531 15.3704 17.1412 15.3586 17.0316 15.3649V15.3649Z"
                                fill="url(#paint11_linear_2246_1150)"/>
                        </g>
                    </g>
                    <path
                        d="M10.5162 4.9906C10.3981 4.99685 10.2847 5.05232 10.1983 5.13435C10.1111 5.21638 10.0501 5.32419 10.0123 5.43747C9.9375 5.6656 9.95447 5.91247 9.97145 6.15232C9.98688 6.36872 10.0031 6.58982 10.0833 6.79138C10.1235 6.89294 10.1798 6.98747 10.2546 7.0656C10.3295 7.14294 10.4244 7.2031 10.5285 7.22888C10.6258 7.25388 10.7307 7.24919 10.8264 7.21872C10.9228 7.18747 11.01 7.13201 11.0826 7.06091C11.1875 6.95701 11.2577 6.82107 11.2986 6.6781C11.3395 6.53513 11.3511 6.38513 11.3488 6.23591C11.3457 6.04997 11.3218 5.86326 11.2647 5.68669C11.2068 5.51013 11.115 5.34294 10.9869 5.20935C10.9251 5.14451 10.8542 5.08826 10.7747 5.04841C10.6944 5.00857 10.6049 4.98591 10.5162 4.9906Z"
                        fill="url(#paint12_radial_2246_1150)"/>
                    <path
                        d="M10.2307 5.9836C10.206 6.13517 10.2052 6.29376 10.2562 6.43751C10.2901 6.53282 10.3464 6.61954 10.4143 6.69376C10.4583 6.7422 10.5093 6.78595 10.5679 6.81485C10.6273 6.84376 10.6952 6.85548 10.7593 6.83985C10.8179 6.82501 10.8688 6.78673 10.9066 6.73907C10.9444 6.69142 10.9699 6.63439 10.9877 6.57579C11.0409 6.40314 11.0324 6.21485 10.9792 6.0422C10.9414 5.91642 10.8773 5.79532 10.7785 5.71095C10.7307 5.67032 10.6752 5.63829 10.615 5.62423C10.5548 5.60939 10.4892 5.61329 10.4329 5.63907C10.3704 5.66798 10.3218 5.72267 10.2901 5.78439C10.2585 5.8461 10.2423 5.91485 10.2307 5.9836Z"
                        fill="#020204"/>
                    <mask id="mask20_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="10" y="5"
                          width="2" height="2">
                        <path
                            d="M10.2307 5.9836C10.206 6.13517 10.2052 6.29376 10.2562 6.43751C10.2901 6.53282 10.3464 6.61954 10.4143 6.69376C10.4583 6.7422 10.5093 6.78595 10.5679 6.81485C10.6273 6.84376 10.6952 6.85548 10.7593 6.83985C10.8179 6.82501 10.8688 6.78673 10.9066 6.73907C10.9444 6.69142 10.9699 6.63439 10.9877 6.57579C11.0409 6.40314 11.0324 6.21485 10.9792 6.0422C10.9414 5.91642 10.8773 5.79532 10.7785 5.71095C10.7307 5.67032 10.6752 5.63829 10.615 5.62423C10.5548 5.60939 10.4892 5.61329 10.4329 5.63907C10.3704 5.66798 10.3218 5.72267 10.2901 5.78439C10.2585 5.8461 10.2423 5.91485 10.2307 5.9836Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask20_2246_1150)">
                        <g filter="url(#filter20_f_2246_1150)">
                            <path
                                d="M10.5463 5.87422C10.5625 5.91719 10.6165 5.93281 10.6466 5.96719C10.6752 6 10.7052 6.03516 10.7215 6.07656C10.7515 6.15547 10.6914 6.27266 10.7546 6.32891C10.7739 6.34609 10.814 6.34687 10.8333 6.32891C10.9097 6.25859 10.8927 6.11719 10.8627 6.01719C10.8349 5.92734 10.7677 5.84141 10.6844 5.79844C10.6458 5.77812 10.588 5.76172 10.5548 5.78984C10.534 5.80859 10.5363 5.84766 10.5463 5.87422Z"
                                fill="url(#paint13_linear_2246_1150)"/>
                        </g>
                    </g>
                    <mask id="mask21_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="9" y="4"
                          width="3" height="4">
                        <path
                            d="M10.5162 4.9906C10.3981 4.99685 10.2847 5.05232 10.1983 5.13435C10.1111 5.21638 10.0501 5.32419 10.0123 5.43747C9.9375 5.6656 9.95447 5.91247 9.97145 6.15232C9.98688 6.36872 10.0031 6.58982 10.0833 6.79138C10.1235 6.89294 10.1798 6.98747 10.2546 7.0656C10.3295 7.14294 10.4244 7.2031 10.5285 7.22888C10.6258 7.25388 10.7307 7.24919 10.8264 7.21872C10.9228 7.18747 11.01 7.13201 11.0826 7.06091C11.1875 6.95701 11.2577 6.82107 11.2986 6.6781C11.3395 6.53513 11.3511 6.38513 11.3488 6.23591C11.3457 6.04997 11.3218 5.86326 11.2647 5.68669C11.2068 5.51013 11.115 5.34294 10.9869 5.20935C10.9251 5.14451 10.8542 5.08826 10.7747 5.04841C10.6944 5.00857 10.6049 4.98591 10.5162 4.9906Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask21_2246_1150)">
                        <path
                            d="M10.2608 5.47346C10.4398 5.36565 10.6566 5.34065 10.8642 5.36018C11.071 5.38049 11.2708 5.44143 11.4714 5.4969C11.6188 5.53752 11.7677 5.57502 11.9059 5.64065C12.0432 5.70627 12.1713 5.80315 12.2477 5.93752C12.26 5.95862 12.2701 5.98127 12.2832 6.00237C12.2963 6.02346 12.3117 6.04299 12.331 6.05783C12.3503 6.07268 12.375 6.08283 12.3989 6.08127C12.4113 6.08049 12.4236 6.07737 12.4336 6.07112C12.4444 6.06487 12.4537 6.05549 12.4591 6.04455C12.4653 6.03205 12.4676 6.01721 12.4668 6.00315C12.466 5.98908 12.463 5.97502 12.4591 5.96096C12.4089 5.7758 12.2901 5.61877 12.2006 5.44924C12.1466 5.34768 12.1018 5.24143 12.0478 5.13987C11.8603 4.79221 11.5525 4.51955 11.2029 4.34221C10.8534 4.16487 10.463 4.07971 10.0725 4.05705C9.62036 4.02971 9.16743 4.0844 8.72144 4.16408C8.52777 4.19846 8.33101 4.23908 8.16049 4.33674C8.07484 4.38518 7.99613 4.44768 7.93518 4.5258C7.87345 4.60315 7.83024 4.69612 7.81558 4.79455C7.80246 4.88987 7.81635 4.98752 7.84953 5.07737C7.88194 5.16721 7.93286 5.24924 7.99305 5.32346C8.11188 5.47268 8.26543 5.5883 8.40663 5.71643C8.54783 5.84377 8.67823 5.98518 8.83641 6.09065C8.91512 6.14377 9.00076 6.18752 9.09181 6.2133C9.18286 6.23908 9.28009 6.24612 9.37268 6.22658C9.46836 6.20705 9.55786 6.1594 9.6358 6.09846C9.71373 6.0383 9.78086 5.96565 9.8449 5.89065C9.97299 5.73987 10.0926 5.57502 10.2608 5.47346Z"
                            fill="url(#paint14_radial_2246_1150)"/>
                    </g>
                    <g filter="url(#filter21_f_2246_1150)">
                        <path
                            d="M11.0038 4.857C11.1705 5.01482 11.294 5.21013 11.3781 5.41638C11.341 5.18904 11.2832 5.00544 11.1366 4.857C11.0471 4.77185 10.9444 4.69685 10.8295 4.6445C10.7276 4.59841 10.6157 4.5695 10.5509 4.56872C10.4869 4.56716 10.4714 4.56872 10.4583 4.5695C10.4444 4.57029 10.4344 4.57029 10.4761 4.57575C10.5177 4.58044 10.6111 4.60622 10.7114 4.65154C10.8117 4.69685 10.9136 4.77185 11.0038 4.857Z"
                            fill="url(#paint15_linear_2246_1150)"/>
                    </g>
                    <path
                        d="M12.6119 4.99058C12.4275 5.11949 12.2724 5.29839 12.1968 5.51245C12.1011 5.78199 12.1373 6.08355 12.2299 6.35386C12.3241 6.6312 12.4822 6.89527 12.7207 7.06167C12.8395 7.14527 12.9776 7.2023 13.1211 7.21949C13.2654 7.23667 13.4143 7.21245 13.5432 7.14527C13.6991 7.06245 13.8187 6.91792 13.8927 6.7562C13.9668 6.5937 13.9985 6.4148 14.0085 6.23589C14.0208 6.00933 13.9992 5.77808 13.9251 5.56324C13.8449 5.32964 13.6998 5.11402 13.4946 4.97964C13.3927 4.91245 13.2762 4.86636 13.1551 4.84917C13.0339 4.83199 12.9089 4.84527 12.7947 4.8898C12.7299 4.91558 12.6697 4.95074 12.6119 4.99058Z"
                        fill="url(#paint16_radial_2246_1150)"/>
                    <path
                        d="M13.0386 5.5562C12.9691 5.56088 12.9012 5.5851 12.8418 5.6226C12.7832 5.6601 12.733 5.71088 12.6937 5.76948C12.6142 5.88588 12.5795 6.02807 12.5741 6.16948C12.5702 6.27495 12.5818 6.38198 12.6165 6.48198C12.6512 6.58198 12.7091 6.67495 12.7901 6.74213C12.8727 6.81167 12.9769 6.85307 13.0841 6.85854C13.1914 6.86323 13.2994 6.83198 13.3873 6.77026C13.4576 6.72104 13.5139 6.65307 13.554 6.57651C13.5941 6.50073 13.6188 6.41635 13.6296 6.33042C13.6489 6.17963 13.6273 6.02182 13.5579 5.88588C13.4892 5.74995 13.3719 5.63823 13.2307 5.58588C13.169 5.56323 13.1034 5.55151 13.0386 5.5562Z"
                        fill="#020204"/>
                    <mask id="mask22_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="12" y="5"
                          width="2" height="2">
                        <path
                            d="M13.0386 5.5562C12.9691 5.56088 12.9012 5.5851 12.8418 5.6226C12.7832 5.6601 12.733 5.71088 12.6937 5.76948C12.6142 5.88588 12.5795 6.02807 12.5741 6.16948C12.5702 6.27495 12.5818 6.38198 12.6165 6.48198C12.6512 6.58198 12.7091 6.67495 12.7901 6.74213C12.8727 6.81167 12.9769 6.85307 13.0841 6.85854C13.1914 6.86323 13.2994 6.83198 13.3873 6.77026C13.4576 6.72104 13.5139 6.65307 13.554 6.57651C13.5941 6.50073 13.6188 6.41635 13.6296 6.33042C13.6489 6.17963 13.6273 6.02182 13.5579 5.88588C13.4892 5.74995 13.3719 5.63823 13.2307 5.58588C13.169 5.56323 13.1034 5.55151 13.0386 5.5562Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask22_2246_1150)">
                        <g filter="url(#filter22_f_2246_1150)">
                            <path
                                d="M13.4684 6.16876C13.5455 6.09064 13.4136 5.88361 13.3102 5.79845C13.2353 5.73751 13.0185 5.67267 13.0278 5.73986C13.037 5.80626 13.135 5.8922 13.1999 5.95782C13.2809 6.03829 13.4313 6.20626 13.4684 6.16876Z"
                                fill="url(#paint17_linear_2246_1150)"/>
                        </g>
                    </g>
                    <mask id="mask23_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="12" y="4"
                          width="3" height="4">
                        <path
                            d="M12.6119 4.99058C12.4275 5.11949 12.2724 5.29839 12.1968 5.51245C12.1011 5.78199 12.1373 6.08355 12.2299 6.35386C12.3241 6.6312 12.4822 6.89527 12.7207 7.06167C12.8395 7.14527 12.9776 7.2023 13.1211 7.21949C13.2654 7.23667 13.4143 7.21245 13.5432 7.14527C13.6991 7.06245 13.8187 6.91792 13.8927 6.7562C13.9668 6.5937 13.9985 6.4148 14.0085 6.23589C14.0208 6.00933 13.9992 5.77808 13.9251 5.56324C13.8449 5.32964 13.6998 5.11402 13.4946 4.97964C13.3927 4.91245 13.2762 4.86636 13.1551 4.84917C13.0339 4.83199 12.9089 4.84527 12.7947 4.8898C12.7299 4.91558 12.6697 4.95074 12.6119 4.99058Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask23_2246_1150)">
                        <path
                            d="M11.9136 5.67266C12.0725 5.53906 12.2569 5.4375 12.4537 5.37578C12.8588 5.24922 13.3179 5.29922 13.6759 5.52969C13.7994 5.60859 13.9097 5.70703 14.0247 5.79922C14.1389 5.89062 14.2608 5.97656 14.3989 6.02578C14.4738 6.05234 14.5532 6.06797 14.6319 6.05937C14.7029 6.05234 14.7716 6.025 14.8302 5.98437C14.8889 5.94297 14.9383 5.88828 14.9753 5.82656C15.0494 5.70312 15.0733 5.55312 15.0602 5.40937C15.0347 5.12109 14.8742 4.86719 14.74 4.61172C14.6975 4.53203 14.6574 4.45078 14.6065 4.37656C14.4514 4.14766 14.2029 3.99687 13.9429 3.90859C13.6829 3.82031 13.4082 3.78828 13.1358 3.75391C13.0139 3.73828 12.8912 3.72187 12.7701 3.73672C12.6304 3.75391 12.4992 3.81094 12.3627 3.84609C12.2978 3.86328 12.2322 3.875 12.1682 3.89375C12.1042 3.9125 12.0409 3.93828 11.9884 3.98047C11.9128 4.04219 11.865 4.13516 11.8441 4.23125C11.8233 4.32812 11.8279 4.42812 11.8434 4.52578C11.8735 4.72109 11.946 4.91094 11.939 5.10859C11.9344 5.24375 11.892 5.37734 11.8974 5.5125C11.8989 5.55234 11.9066 5.63359 11.9136 5.67266Z"
                            fill="url(#paint18_linear_2246_1150)"/>
                    </g>
                    <g filter="url(#filter23_f_2246_1150)">
                        <path
                            d="M13.2539 4.43591C13.2222 4.47654 13.1937 4.52029 13.1713 4.56873C13.314 4.59998 13.4498 4.65935 13.5718 4.74138C13.8079 4.89998 13.9869 5.13123 14.1127 5.38904C14.142 5.35623 14.1682 5.32107 14.1914 5.28201C14.0648 5.01326 13.8827 4.77029 13.6389 4.60623C13.5216 4.5281 13.3912 4.46794 13.2539 4.43591Z"
                            fill="url(#paint19_linear_2246_1150)"/>
                    </g>
                    <mask id="mask24_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="6" y="2"
                          width="12" height="20">
                        <path
                            d="M12.2523 2C11.7894 2 11.3248 2.09219 10.9051 2.32187C10.4591 2.56484 10.0934 2.95391 9.86883 3.41328C9.64352 3.87266 9.55556 4.36328 9.54167 4.90391C9.5162 5.93047 9.56482 7.00703 9.6412 7.98281C9.66127 8.27969 9.6983 8.45313 9.66049 8.75859C9.53549 9.40703 8.97531 9.84297 8.67593 10.4125C8.34645 11.0406 8.20756 11.7508 7.95911 12.4164C7.73148 13.025 7.41204 13.5961 7.19676 14.2094C6.89506 15.0664 6.80478 16.0086 7.00386 16.8961C7.15586 17.5727 7.47299 18.207 7.90046 18.75C7.83873 18.8625 7.77855 18.9773 7.71528 19.0891C7.51698 19.4352 7.27469 19.7641 7.16204 20.1477C7.10571 20.3391 7.08333 20.5438 7.1196 20.7406C7.15586 20.9375 7.25463 21.1258 7.40895 21.2508C7.51003 21.332 7.63272 21.3852 7.75849 21.4148C7.88426 21.4437 8.01466 21.4508 8.14429 21.4484C8.6358 21.4375 9.11265 21.2867 9.58796 21.1602C9.87037 21.0852 10.1543 21.0187 10.439 20.9586C11.4529 20.7484 12.5841 20.8328 13.5247 20.9703C13.8434 21.0195 14.1597 21.0828 14.473 21.1602C14.9637 21.2805 15.4522 21.4336 15.9568 21.4484C16.0895 21.4523 16.2238 21.4461 16.3534 21.4172C16.483 21.3875 16.6088 21.3344 16.7122 21.2508C16.8673 21.1258 16.966 20.9367 17.0023 20.7398C17.0386 20.543 17.0162 20.3375 16.9591 20.1453C16.8449 19.7609 16.6003 19.4336 16.3981 19.0891C16.3179 18.9523 16.2438 18.8133 16.1644 18.6766C16.7739 17.9836 17.2647 17.182 17.5486 16.3016C17.858 15.3406 17.9151 14.3055 17.7847 13.3031C17.6543 12.3008 17.3403 11.3289 16.9275 10.4086C16.4089 9.25547 15.973 8.83828 15.6566 7.825C15.3156 6.72969 15.5972 5.43359 15.3434 4.44062C15.2531 4.10312 15.1088 3.78047 14.9228 3.48516C14.7052 3.13906 14.429 2.82969 14.1011 2.58906C13.5779 2.20469 12.9205 2 12.2523 2Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask24_2246_1150)">
                        <g filter="url(#filter24_f_2246_1150)">
                            <path
                                d="M10.2593 8.97891C10.3727 9.31172 10.6003 9.59531 10.8704 9.81641C10.9599 9.89063 11.0548 9.9586 11.1605 10.0063C11.2654 10.0547 11.3819 10.082 11.4969 10.0719C11.6096 10.0625 11.7168 10.0172 11.8156 9.96094C11.9144 9.90469 12.0054 9.83672 12.1011 9.77578C12.2647 9.67031 12.4398 9.58516 12.6103 9.49141C12.8148 9.37813 13.0139 9.24922 13.186 9.08985C13.2654 9.01719 13.3387 8.9375 13.4259 8.875C13.5131 8.81172 13.6181 8.76641 13.7245 8.77422C13.8048 8.77969 13.8796 8.81406 13.9583 8.83125C13.9977 8.83985 14.0378 8.84375 14.0779 8.8375C14.1173 8.83125 14.1559 8.81485 14.1836 8.78516C14.2176 8.74922 14.233 8.69766 14.2307 8.64766C14.2292 8.59844 14.2122 8.55 14.189 8.50625C14.1435 8.41797 14.0741 8.34219 14.0432 8.24766C14.0154 8.16328 14.0208 8.07266 14.0231 7.98438C14.0255 7.89531 14.0239 7.80313 13.9838 7.72422C13.9529 7.66485 13.9012 7.61719 13.8426 7.58594C13.784 7.55391 13.7176 7.5375 13.6512 7.53125C13.5185 7.51875 13.3858 7.54531 13.2523 7.55235C13.0764 7.5625 12.8989 7.54063 12.7222 7.55078C12.5023 7.56485 12.2863 7.62891 12.0656 7.62969C11.814 7.63047 11.5625 7.54688 11.314 7.58672C11.2068 7.60391 11.1049 7.64297 11.0031 7.67735C10.9005 7.7125 10.7948 7.74297 10.6867 7.74141C10.564 7.73906 10.4452 7.6961 10.3225 7.6875C10.2616 7.68281 10.1991 7.6875 10.1412 7.70938C10.0841 7.73125 10.0324 7.7711 10.0039 7.82656C9.98766 7.85781 9.97994 7.89375 9.9784 7.92891C9.97685 7.96485 9.98148 8 9.98997 8.03516C10.0069 8.10391 10.0386 8.16875 10.064 8.23438C10.1566 8.47422 10.1767 8.73594 10.2593 8.97891Z"
                                fill="black" fillOpacity="0.258824"/>
                        </g>
                    </g>
                    <mask id="mask25_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="6" y="2"
                          width="12" height="20">
                        <path
                            d="M12.2523 2C11.7894 2 11.3248 2.09219 10.9051 2.32187C10.4591 2.56484 10.0934 2.95391 9.86883 3.41328C9.64352 3.87266 9.55556 4.36328 9.54167 4.90391C9.5162 5.93047 9.56482 7.00703 9.6412 7.98281C9.66127 8.27969 9.6983 8.45313 9.66049 8.75859C9.53549 9.40703 8.97531 9.84297 8.67593 10.4125C8.34645 11.0406 8.20756 11.7508 7.95911 12.4164C7.73148 13.025 7.41204 13.5961 7.19676 14.2094C6.89506 15.0664 6.80478 16.0086 7.00386 16.8961C7.15586 17.5727 7.47299 18.207 7.90046 18.75C7.83873 18.8625 7.77855 18.9773 7.71528 19.0891C7.51698 19.4352 7.27469 19.7641 7.16204 20.1477C7.10571 20.3391 7.08333 20.5438 7.1196 20.7406C7.15586 20.9375 7.25463 21.1258 7.40895 21.2508C7.51003 21.332 7.63272 21.3852 7.75849 21.4148C7.88426 21.4437 8.01466 21.4508 8.14429 21.4484C8.6358 21.4375 9.11265 21.2867 9.58796 21.1602C9.87037 21.0852 10.1543 21.0187 10.439 20.9586C11.4529 20.7484 12.5841 20.8328 13.5247 20.9703C13.8434 21.0195 14.1597 21.0828 14.473 21.1602C14.9637 21.2805 15.4522 21.4336 15.9568 21.4484C16.0895 21.4523 16.2238 21.4461 16.3534 21.4172C16.483 21.3875 16.6088 21.3344 16.7122 21.2508C16.8673 21.1258 16.966 20.9367 17.0023 20.7398C17.0386 20.543 17.0162 20.3375 16.9591 20.1453C16.8449 19.7609 16.6003 19.4336 16.3981 19.0891C16.3179 18.9523 16.2438 18.8133 16.1644 18.6766C16.7739 17.9836 17.2647 17.182 17.5486 16.3016C17.858 15.3406 17.9151 14.3055 17.7847 13.3031C17.6543 12.3008 17.3403 11.3289 16.9275 10.4086C16.4089 9.25547 15.973 8.83828 15.6566 7.825C15.3156 6.72969 15.5972 5.43359 15.3434 4.44062C15.2531 4.10312 15.1088 3.78047 14.9228 3.48516C14.7052 3.13906 14.429 2.82969 14.1011 2.58906C13.5779 2.20469 12.9205 2 12.2523 2Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask25_2246_1150)">
                        <g opacity="0.3" filter="url(#filter25_f_2246_1150)">
                            <path
                                d="M9.94368 8.03127C10.1636 8.16877 10.3611 8.3383 10.527 8.53049C10.6806 8.70939 10.811 8.91252 11.0124 9.04455C11.1536 9.1383 11.3241 9.19064 11.4969 9.20705C11.6999 9.2258 11.9051 9.19533 12.1011 9.14143C12.2824 9.09221 12.4576 9.02189 12.6181 8.92971C12.9244 8.75393 13.1798 8.49611 13.517 8.38049C13.5903 8.35471 13.6667 8.33674 13.7377 8.30549C13.8086 8.27502 13.8758 8.22814 13.9097 8.16252C13.9421 8.09846 13.9406 8.0258 13.9514 7.95627C13.963 7.88127 13.9884 7.8094 14.0023 7.73518C14.0162 7.66096 14.0178 7.58205 13.9838 7.51408C13.9553 7.45783 13.9036 7.4133 13.8441 7.38439C13.7847 7.35627 13.7176 7.34377 13.6505 7.34064C13.5178 7.33439 13.3858 7.36643 13.2523 7.37736C13.0764 7.39221 12.8989 7.37111 12.7222 7.37658C12.5023 7.38283 12.2855 7.42893 12.0656 7.43908C11.8148 7.45002 11.5648 7.41252 11.3141 7.40471C11.2053 7.4008 11.0957 7.40236 10.9892 7.42033C10.882 7.43752 10.777 7.47111 10.6867 7.52736C10.5988 7.58127 10.527 7.65549 10.4468 7.71877C10.4066 7.7508 10.3634 7.77971 10.3171 7.80236C10.2701 7.82424 10.2184 7.83986 10.1659 7.84221C10.1389 7.84299 10.1111 7.84143 10.0849 7.84533C10.0394 7.85158 9.99769 7.8758 9.97146 7.91018C9.94522 7.94533 9.93519 7.98986 9.94368 8.03127Z"
                                fill="black"/>
                        </g>
                    </g>
                    <path
                        d="M11.0725 6.57263C11.1906 6.43904 11.2708 6.27576 11.3835 6.13826C11.4398 6.06951 11.5054 6.00623 11.5818 5.9617C11.6582 5.91717 11.7477 5.89217 11.8356 5.89998C11.9336 5.90857 12.0255 5.95779 12.0972 6.02576C12.169 6.09373 12.2222 6.17967 12.2647 6.26951C12.3055 6.35623 12.338 6.44763 12.3966 6.52263C12.4591 6.60232 12.5463 6.65623 12.6258 6.71951C12.6651 6.75076 12.7037 6.78435 12.7346 6.8242C12.7662 6.86404 12.7901 6.91013 12.8009 6.96013C12.811 7.01092 12.8055 7.06404 12.7886 7.11248C12.7708 7.16092 12.7415 7.20467 12.7045 7.2406C12.6312 7.31248 12.5309 7.35154 12.4298 7.3656C12.2276 7.39451 12.0231 7.33357 11.8187 7.33904C11.6126 7.34529 11.4105 7.41873 11.2037 7.4117C11.1011 7.40779 10.9961 7.38201 10.9113 7.32263C10.8688 7.29217 10.8318 7.25388 10.8048 7.20935C10.7785 7.16482 10.7623 7.11326 10.76 7.06092C10.7585 7.01092 10.7701 6.96092 10.7901 6.9156C10.8094 6.86951 10.8372 6.8281 10.868 6.78904C10.9305 6.7117 11.0069 6.64763 11.0725 6.57263Z"
                        fill="url(#paint20_radial_2246_1150)"/>
                    <path
                        d="M9.95216 7.86328C9.95679 7.88359 9.96374 7.90234 9.97377 7.92031C9.99152 7.95 10.0178 7.97421 10.0455 7.99453C10.0733 8.01562 10.1034 8.03281 10.1327 8.05078C10.2878 8.15 10.4144 8.28828 10.527 8.43515C10.6775 8.63203 10.811 8.85 11.0123 8.99296C11.1543 9.09453 11.3241 9.15156 11.4969 9.16953C11.6998 9.18984 11.9051 9.15703 12.1011 9.09843C12.2824 9.04453 12.4576 8.96875 12.6181 8.86796C12.9244 8.67734 13.1798 8.39765 13.517 8.27187C13.5903 8.24453 13.6667 8.225 13.7377 8.1914C13.8086 8.15703 13.8758 8.10703 13.9097 8.03515C13.9421 7.9664 13.9406 7.88671 13.9514 7.81093C13.963 7.73046 13.9884 7.65234 14.0023 7.57187C14.0162 7.4914 14.0178 7.40546 13.9838 7.33125C13.9553 7.27031 13.9036 7.22187 13.8441 7.1914C13.7847 7.16015 13.7176 7.14609 13.6505 7.14296C13.5178 7.13671 13.3858 7.17109 13.2523 7.18359C13.0764 7.2 12.8989 7.17656 12.7222 7.18203C12.5023 7.18906 12.2855 7.23906 12.0656 7.25C11.8148 7.26171 11.5648 7.22265 11.314 7.2125C11.2053 7.20781 11.0957 7.20937 10.9884 7.22812C10.8812 7.24609 10.7762 7.28359 10.6867 7.34609C10.5995 7.40703 10.5301 7.48984 10.4498 7.56015C10.4097 7.59531 10.3665 7.62734 10.3187 7.65078C10.2716 7.67421 10.2191 7.68906 10.1659 7.6875C10.1389 7.68671 10.1103 7.68281 10.0849 7.69062C10.0687 7.69609 10.054 7.70625 10.0417 7.71796C10.0293 7.73046 10.0193 7.74453 10.01 7.75859C9.98766 7.7914 9.96837 7.82656 9.95216 7.86328Z"
                        fill="url(#paint21_radial_2246_1150)"/>
                    <mask id="mask26_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="9" y="7"
                          width="6" height="3">
                        <path
                            d="M9.95216 7.86328C9.95679 7.88359 9.96374 7.90234 9.97377 7.92031C9.99152 7.95 10.0178 7.97421 10.0455 7.99453C10.0733 8.01562 10.1034 8.03281 10.1327 8.05078C10.2878 8.15 10.4144 8.28828 10.527 8.43515C10.6775 8.63203 10.811 8.85 11.0123 8.99296C11.1543 9.09453 11.3241 9.15156 11.4969 9.16953C11.6998 9.18984 11.9051 9.15703 12.1011 9.09843C12.2824 9.04453 12.4576 8.96875 12.6181 8.86796C12.9244 8.67734 13.1798 8.39765 13.517 8.27187C13.5903 8.24453 13.6667 8.225 13.7377 8.1914C13.8086 8.15703 13.8758 8.10703 13.9097 8.03515C13.9421 7.9664 13.9406 7.88671 13.9514 7.81093C13.963 7.73046 13.9884 7.65234 14.0023 7.57187C14.0162 7.4914 14.0178 7.40546 13.9838 7.33125C13.9553 7.27031 13.9036 7.22187 13.8441 7.1914C13.7847 7.16015 13.7176 7.14609 13.6505 7.14296C13.5178 7.13671 13.3858 7.17109 13.2523 7.18359C13.0764 7.2 12.8989 7.17656 12.7222 7.18203C12.5023 7.18906 12.2855 7.23906 12.0656 7.25C11.8148 7.26171 11.5648 7.22265 11.314 7.2125C11.2053 7.20781 11.0957 7.20937 10.9884 7.22812C10.8812 7.24609 10.7762 7.28359 10.6867 7.34609C10.5995 7.40703 10.5301 7.48984 10.4498 7.56015C10.4097 7.59531 10.3665 7.62734 10.3187 7.65078C10.2716 7.67421 10.2191 7.68906 10.1659 7.6875C10.1389 7.68671 10.1103 7.68281 10.0849 7.69062C10.0687 7.69609 10.054 7.70625 10.0417 7.71796C10.0293 7.73046 10.0193 7.74453 10.01 7.75859C9.98766 7.7914 9.96837 7.82656 9.95216 7.86328Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask26_2246_1150)">
                        <g filter="url(#filter26_f_2246_1150)">
                            <path
                                d="M10.9367 8.13747C10.9113 8.24451 10.9267 8.36169 10.9799 8.45857C11.0324 8.55544 11.1219 8.63044 11.2261 8.6656C11.3573 8.71013 11.5054 8.68826 11.6281 8.62341C11.6998 8.58591 11.7647 8.53279 11.8056 8.46247C11.8264 8.4281 11.8411 8.38904 11.8465 8.34841C11.8511 8.30857 11.848 8.26638 11.8341 8.2281C11.8187 8.18669 11.7909 8.14997 11.7577 8.12107C11.7238 8.09216 11.6844 8.07107 11.642 8.05701C11.5586 8.02888 11.4282 8.00544 11.3403 8.00388C11.1844 8.00076 10.9622 8.03044 10.9367 8.13747Z"
                                fill="#D9B30D"/>
                        </g>
                    </g>
                    <mask id="mask27_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="9" y="7"
                          width="6" height="3">
                        <path
                            d="M9.95216 7.86328C9.95679 7.88359 9.96374 7.90234 9.97377 7.92031C9.99152 7.95 10.0178 7.97421 10.0455 7.99453C10.0733 8.01562 10.1034 8.03281 10.1327 8.05078C10.2878 8.15 10.4144 8.28828 10.527 8.43515C10.6775 8.63203 10.811 8.85 11.0123 8.99296C11.1543 9.09453 11.3241 9.15156 11.4969 9.16953C11.6998 9.18984 11.9051 9.15703 12.1011 9.09843C12.2824 9.04453 12.4576 8.96875 12.6181 8.86796C12.9244 8.67734 13.1798 8.39765 13.517 8.27187C13.5903 8.24453 13.6667 8.225 13.7377 8.1914C13.8086 8.15703 13.8758 8.10703 13.9097 8.03515C13.9421 7.9664 13.9406 7.88671 13.9514 7.81093C13.963 7.73046 13.9884 7.65234 14.0023 7.57187C14.0162 7.4914 14.0178 7.40546 13.9838 7.33125C13.9553 7.27031 13.9036 7.22187 13.8441 7.1914C13.7847 7.16015 13.7176 7.14609 13.6505 7.14296C13.5178 7.13671 13.3858 7.17109 13.2523 7.18359C13.0764 7.2 12.8989 7.17656 12.7222 7.18203C12.5023 7.18906 12.2855 7.23906 12.0656 7.25C11.8148 7.26171 11.5648 7.22265 11.314 7.2125C11.2053 7.20781 11.0957 7.20937 10.9884 7.22812C10.8812 7.24609 10.7762 7.28359 10.6867 7.34609C10.5995 7.40703 10.5301 7.48984 10.4498 7.56015C10.4097 7.59531 10.3665 7.62734 10.3187 7.65078C10.2716 7.67421 10.2191 7.68906 10.1659 7.6875C10.1389 7.68671 10.1103 7.68281 10.0849 7.69062C10.0687 7.69609 10.054 7.70625 10.0417 7.71796C10.0293 7.73046 10.0193 7.74453 10.01 7.75859C9.98766 7.7914 9.96837 7.82656 9.95216 7.86328Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask27_2246_1150)">
                        <g filter="url(#filter27_f_2246_1150)">
                            <path
                                d="M10.5054 7.30153C10.4159 7.35466 10.3302 7.41325 10.2461 7.47341C10.2022 7.50544 10.1574 7.53903 10.1343 7.58825C10.1181 7.62262 10.1142 7.66169 10.1134 7.69997C10.1134 7.73903 10.1157 7.77731 10.1103 7.81559C10.1073 7.84137 10.1003 7.86716 10.0995 7.89294C10.0988 7.90622 10.0995 7.9195 10.1026 7.932C10.1065 7.9445 10.1127 7.957 10.1211 7.96637C10.1327 7.97887 10.1481 7.98669 10.1644 7.99137C10.1806 7.99606 10.1968 7.99841 10.2137 8.00231C10.2917 8.02106 10.3596 8.0695 10.419 8.12419C10.4784 8.17809 10.5324 8.23981 10.5949 8.29059C10.7631 8.42966 10.9861 8.48747 11.2037 8.49059C11.4213 8.4945 11.6366 8.44841 11.8488 8.39997C12.0154 8.36169 12.1821 8.32262 12.3418 8.26247C12.5887 8.17028 12.8171 8.03122 13.0147 7.857C13.1049 7.77809 13.189 7.69137 13.2901 7.62731C13.3789 7.57028 13.4784 7.53278 13.5694 7.47887C13.5779 7.47419 13.5856 7.46872 13.5926 7.46325C13.6003 7.457 13.6065 7.44919 13.6111 7.44137C13.6181 7.42653 13.6181 7.40856 13.6134 7.39294C13.6088 7.37731 13.5995 7.36325 13.5895 7.34997C13.5779 7.33591 13.5656 7.32341 13.5517 7.31091C13.4568 7.22887 13.3287 7.19919 13.2037 7.18903C13.0795 7.17966 12.9537 7.18669 12.831 7.16559C12.7153 7.14606 12.6057 7.10231 12.4938 7.06637C12.3765 7.02809 12.2569 6.99841 12.1358 6.97809C11.8495 6.93044 11.5556 6.93981 11.2724 6.99919C11.0031 7.05622 10.7423 7.15934 10.5054 7.30153Z"
                                fill="#604405"/>
                        </g>
                    </g>
                    <path
                        d="M10.4769 6.99606C10.3488 7.08356 10.233 7.19059 10.135 7.31169C10.0795 7.38122 10.0286 7.457 10.0008 7.54138C9.9784 7.60856 9.97068 7.67888 9.95679 7.74841C9.95139 7.77419 9.94522 7.79997 9.94599 7.82653C9.94599 7.83903 9.94753 7.85231 9.95139 7.86559C9.95525 7.87809 9.96219 7.88981 9.97068 7.89919C9.98611 7.91481 10.0069 7.92341 10.0278 7.92809C10.0494 7.932 10.071 7.93278 10.0926 7.93513C10.189 7.94684 10.2778 7.99372 10.358 8.04997C10.4383 8.10544 10.5123 8.17106 10.5949 8.22341C10.7762 8.33981 10.9931 8.39138 11.2083 8.39997C11.4228 8.40856 11.6373 8.37575 11.8488 8.33278C12.0162 8.29919 12.1829 8.25856 12.3418 8.19528C12.5856 8.09763 12.8056 7.94841 13.0147 7.78981C13.1103 7.71794 13.2045 7.64372 13.2901 7.56013C13.3187 7.53122 13.3472 7.50231 13.3781 7.47575C13.409 7.44997 13.4437 7.42731 13.4823 7.41481C13.5409 7.39606 13.6042 7.40153 13.6651 7.41169C13.7106 7.4195 13.7562 7.42966 13.8025 7.42809C13.8256 7.42653 13.8488 7.42263 13.8704 7.41403C13.892 7.40544 13.912 7.39216 13.9267 7.37341C13.946 7.34997 13.956 7.31872 13.956 7.28825C13.956 7.257 13.9468 7.22653 13.9313 7.19997C13.9005 7.14684 13.8472 7.11091 13.7917 7.08591C13.7153 7.05153 13.6327 7.03513 13.5517 7.01481C13.3025 6.95388 13.0602 6.86403 12.831 6.74841C12.7168 6.69138 12.6057 6.62809 12.4938 6.56716C12.3781 6.50466 12.2608 6.4445 12.1358 6.40544C11.8549 6.3195 11.5494 6.34763 11.2724 6.44528C10.9653 6.55309 10.6875 6.74528 10.4769 6.99606Z"
                        fill="url(#paint22_linear_2246_1150)"/>
                    <mask id="mask28_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="9" y="6"
                          width="5" height="3">
                        <path
                            d="M10.4769 6.99606C10.3488 7.08356 10.233 7.19059 10.135 7.31169C10.0795 7.38122 10.0286 7.457 10.0008 7.54138C9.9784 7.60856 9.97068 7.67888 9.95679 7.74841C9.95139 7.77419 9.94522 7.79997 9.94599 7.82653C9.94599 7.83903 9.94753 7.85231 9.95139 7.86559C9.95525 7.87809 9.96219 7.88981 9.97068 7.89919C9.98611 7.91481 10.0069 7.92341 10.0278 7.92809C10.0494 7.932 10.071 7.93278 10.0926 7.93513C10.189 7.94684 10.2778 7.99372 10.358 8.04997C10.4383 8.10544 10.5123 8.17106 10.5949 8.22341C10.7762 8.33981 10.9931 8.39138 11.2083 8.39997C11.4228 8.40856 11.6373 8.37575 11.8488 8.33278C12.0162 8.29919 12.1829 8.25856 12.3418 8.19528C12.5856 8.09763 12.8056 7.94841 13.0147 7.78981C13.1103 7.71794 13.2045 7.64372 13.2901 7.56013C13.3187 7.53122 13.3472 7.50231 13.3781 7.47575C13.409 7.44997 13.4437 7.42731 13.4823 7.41481C13.5409 7.39606 13.6042 7.40153 13.6651 7.41169C13.7106 7.4195 13.7562 7.42966 13.8025 7.42809C13.8256 7.42653 13.8488 7.42263 13.8704 7.41403C13.892 7.40544 13.912 7.39216 13.9267 7.37341C13.946 7.34997 13.956 7.31872 13.956 7.28825C13.956 7.257 13.9468 7.22653 13.9313 7.19997C13.9005 7.14684 13.8472 7.11091 13.7917 7.08591C13.7153 7.05153 13.6327 7.03513 13.5517 7.01481C13.3025 6.95388 13.0602 6.86403 12.831 6.74841C12.7168 6.69138 12.6057 6.62809 12.4938 6.56716C12.3781 6.50466 12.2608 6.4445 12.1358 6.40544C11.8549 6.3195 11.5494 6.34763 11.2724 6.44528C10.9653 6.55309 10.6875 6.74528 10.4769 6.99606Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask28_2246_1150)">
                        <g filter="url(#filter28_f_2246_1150)">
                            <path
                                d="M12.4452 7.05853C12.4298 7.03978 12.4082 7.02572 12.385 7.01869C12.3619 7.01166 12.3372 7.01166 12.3133 7.01556C12.2654 7.02416 12.2222 7.04994 12.1821 7.07806C12.0687 7.15697 11.9684 7.25463 11.8804 7.36244C11.7647 7.50541 11.669 7.67025 11.6366 7.85228C11.6312 7.88275 11.6281 7.91478 11.6312 7.94525C11.635 7.9765 11.6466 8.00697 11.669 8.02884C11.6875 8.04838 11.7137 8.0601 11.74 8.064C11.767 8.06791 11.7947 8.064 11.8202 8.05541C11.8711 8.03822 11.9136 8.0015 11.9545 7.96556C12.1759 7.764 12.3765 7.52338 12.4568 7.23275C12.4645 7.20385 12.4714 7.17416 12.4714 7.14369C12.4714 7.11322 12.4637 7.08275 12.4452 7.05853Z"
                                fill="#F6DA4A"/>
                        </g>
                    </g>
                    <g opacity="0.8" filter="url(#filter29_f_2246_1150)">
                        <path
                            d="M11.1543 6.61408C11.0949 6.59454 10.9977 6.70001 11.0293 6.75392C11.0378 6.76876 11.0648 6.78751 11.0833 6.77736C11.1103 6.76251 11.1327 6.70783 11.162 6.68673C11.1813 6.67267 11.1775 6.62111 11.1543 6.61408Z"
                            fill="url(#paint23_radial_2246_1150)"/>
                    </g>
                    <g opacity="0.8" filter="url(#filter30_f_2246_1150)">
                        <path
                            d="M11.9136 6.64213C11.929 6.69213 12.0085 6.68353 12.0548 6.70775C12.0949 6.72884 12.1273 6.77494 12.1728 6.7765C12.2161 6.77728 12.284 6.76088 12.2894 6.71713C12.2963 6.6601 12.2137 6.62338 12.1605 6.60228C12.0918 6.57572 12.0039 6.56166 11.9398 6.59759C11.9252 6.60619 11.909 6.62572 11.9136 6.64213Z"
                            fill="url(#paint24_radial_2246_1150)"/>
                    </g>
                    <mask id="mask29_2246_1150" style={{maskType: "luminance"}} maskUnits="userSpaceOnUse" x="9" y="6"
                          width="6" height="4">
                        <path
                            d="M9.95216 7.86328C9.95679 7.88359 9.96374 7.90234 9.97377 7.92031C9.99152 7.95 10.0178 7.97421 10.0455 7.99453C10.0733 8.01562 10.1034 8.03281 10.1327 8.05078C10.2878 8.15 10.4144 8.28828 10.527 8.43515C10.6775 8.63203 10.811 8.85 11.0123 8.99296C11.1543 9.09453 11.3241 9.15156 11.4969 9.16953C11.6998 9.18984 11.9051 9.15703 12.1011 9.09843C12.2824 9.04453 12.4576 8.96875 12.6181 8.86796C12.9244 8.67734 13.1798 8.39765 13.517 8.27187C13.5903 8.24453 13.6667 8.225 13.7377 8.1914C13.8086 8.15703 13.8758 8.10703 13.9097 8.03515C13.9421 7.9664 13.9406 7.88671 13.9514 7.81093C13.963 7.73046 13.9884 7.65234 14.0023 7.57187C14.0162 7.4914 14.0178 7.40546 13.9838 7.33125C13.9553 7.27031 13.9036 7.22187 13.8441 7.1914C13.7847 7.16015 13.7176 7.14609 13.6505 7.14296C13.5178 7.13671 13.3858 7.17109 13.2523 7.18359C13.0764 7.2 12.8989 7.17656 12.7222 7.18203C12.5023 7.18906 12.2855 7.23906 12.0656 7.25C11.8148 7.26171 11.5648 7.22265 11.314 7.2125C11.2053 7.20781 11.0957 7.20937 10.9884 7.22812C10.8812 7.24609 10.7762 7.28359 10.6867 7.34609C10.5995 7.40703 10.5301 7.48984 10.4498 7.56015C10.4097 7.59531 10.3665 7.62734 10.3187 7.65078C10.2716 7.67421 10.2191 7.68906 10.1659 7.6875C10.1389 7.68671 10.1103 7.68281 10.0849 7.69062C10.0687 7.69609 10.054 7.70625 10.0417 7.71796C10.0293 7.73046 10.0193 7.74453 10.01 7.75859C9.98766 7.7914 9.96837 7.82656 9.95216 7.86328Z"
                            fill="white"/>
                        <path
                            d="M10.4769 6.99606C10.3488 7.08356 10.233 7.19059 10.135 7.31169C10.0795 7.38122 10.0286 7.457 10.0008 7.54138C9.9784 7.60856 9.97068 7.67888 9.95679 7.74841C9.95139 7.77419 9.94522 7.79997 9.94599 7.82653C9.94599 7.83903 9.94753 7.85231 9.95139 7.86559C9.95525 7.87809 9.96219 7.88981 9.97068 7.89919C9.98611 7.91481 10.0069 7.92341 10.0278 7.92809C10.0494 7.932 10.071 7.93278 10.0926 7.93513C10.189 7.94684 10.2778 7.99372 10.358 8.04997C10.4383 8.10544 10.5123 8.17106 10.5949 8.22341C10.7762 8.33981 10.9931 8.39138 11.2083 8.39997C11.4228 8.40856 11.6373 8.37575 11.8488 8.33278C12.0162 8.29919 12.1829 8.25856 12.3418 8.19528C12.5856 8.09763 12.8056 7.94841 13.0147 7.78981C13.1103 7.71794 13.2045 7.64372 13.2901 7.56013C13.3187 7.53122 13.3472 7.50231 13.3781 7.47575C13.409 7.44997 13.4437 7.42731 13.4823 7.41481C13.5409 7.39606 13.6042 7.40153 13.6651 7.41169C13.7106 7.4195 13.7562 7.42966 13.8025 7.42809C13.8256 7.42653 13.8488 7.42263 13.8704 7.41403C13.892 7.40544 13.912 7.39216 13.9267 7.37341C13.946 7.34997 13.956 7.31872 13.956 7.28825C13.956 7.257 13.9468 7.22653 13.9313 7.19997C13.9005 7.14684 13.8472 7.11091 13.7917 7.08591C13.7153 7.05153 13.6327 7.03513 13.5517 7.01481C13.3025 6.95388 13.0602 6.86403 12.831 6.74841C12.7168 6.69138 12.6057 6.62809 12.4938 6.56716C12.3781 6.50466 12.2608 6.4445 12.1358 6.40544C11.8549 6.3195 11.5494 6.34763 11.2724 6.44528C10.9653 6.55309 10.6875 6.74528 10.4769 6.99606Z"
                            fill="white"/>
                    </mask>
                    <g mask="url(#mask29_2246_1150)">
                        <g filter="url(#filter31_f_2246_1150)">
                            <path
                                d="M13.9745 7.40234C13.9674 7.4655 13.9405 7.526 13.8998 7.57054C13.8592 7.61508 13.8081 7.64001 13.7577 7.63984C13.7074 7.63987 13.6619 7.61489 13.6313 7.57036C13.6006 7.52584 13.5873 7.46541 13.5941 7.40234C13.5976 7.37102 13.606 7.33999 13.6187 7.31105C13.6315 7.28211 13.6485 7.25581 13.6686 7.23368C13.6888 7.21154 13.7117 7.194 13.7361 7.18205C13.7605 7.17011 13.786 7.16399 13.811 7.16406C13.8359 7.16403 13.86 7.17018 13.8817 7.18214C13.9034 7.1941 13.9224 7.21165 13.9376 7.23378C13.9528 7.25592 13.9639 7.28219 13.9702 7.31112C13.9766 7.34004 13.978 7.37104 13.9745 7.40234Z"
                                fill="url(#paint25_linear_2246_1150)"/>
                        </g>
                    </g>
                    <defs>
                        <filter id="filter0_f_2246_1150" x="7.17679" y="9.03012" width="4.93422" height="4.80921"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="0.64" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter1_f_2246_1150" x="10.0601" y="8.17361" width="7.49619" height="6.43013"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="0.98" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter2_f_2246_1150" x="9.24107" y="9.06267" width="4.16212" height="4.28091"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="0.68" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter3_f_2246_1150" x="8.17455" y="10.2141" width="5.28246" height="9.04138"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="1.25" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter4_f_2246_1150" x="12.628" y="8.69208" width="7.79001" height="7.81257"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="1.78" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter5_f_2246_1150" x="9.7298" y="-0.603066" width="8.01497" height="7.97115"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="1.73" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter6_f_2246_1150" x="13.0605" y="6.40075" width="3.92963" height="4.03309"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="0.78" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter7_f_2246_1150" x="5.10328" y="9.74978" width="5.70888" height="8.20699"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="0.98" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter8_f_2246_1150" x="13.2265" y="8.91614" width="6.62917" height="10.2154"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="1.19" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter9_f_2246_1150" x="-2.50713" y="9.08827" width="19.3446" height="19.3636"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="3.38" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter10_f_2246_1150" x="0.254041" y="11.3924" width="13.5592" height="13.945"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="2.1" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter11_f_2246_1150" x="7.31062" y="16.0639" width="3.03" height="4.49405"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="0.32" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter12_f_2246_1150" x="10.6882" y="12.8228" width="12.5487" height="13.0333"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="1.95" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter13_f_2246_1150" x="6.97063" y="7.85522" width="21.7385" height="21.8793"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="4.12" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter14_f_2246_1150" x="9.18514" y="9.44897" width="17.4994" height="17.536"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="3.12" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter15_f_2246_1150" x="14.5465" y="15.2102" width="5.29895" height="2.2393"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="0.41" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter16_f_2246_1150" x="11.1853" y="11.4526" width="12.0635" height="11.7636"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="2.45" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter17_f_2246_1150" x="13.8453" y="13.9845" width="6.74355" height="5.89968"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="1.12" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter18_f_2246_1150" x="14.4903" y="13.6032" width="5.84237" height="4.62016"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="0.88" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter19_f_2246_1150" x="14.4903" y="13.6032" width="5.84237" height="4.62016"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="0.88" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter20_f_2246_1150" x="9.65885" y="4.89484" width="2.10921" height="2.32726"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="0.44" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter21_f_2246_1150" x="10.2063" y="4.32805" width="1.41181" height="1.32833"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="0.12" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter22_f_2246_1150" x="12.1275" y="4.81136" width="2.26402" height="2.26277"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="0.45" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter23_f_2246_1150" x="12.9113" y="4.17591" width="1.54007" height="1.47312"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="0.13" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter24_f_2246_1150" x="6.4781" y="4.02795" width="11.2528" height="9.54602"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="1.75" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter25_f_2246_1150" x="8.34073" y="5.73984" width="7.27085" height="5.07274"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="0.8" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter26_f_2246_1150" x="9.38474" y="6.46366" width="4.00372" height="3.7653"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="0.77" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter27_f_2246_1150" x="8.79926" y="5.64769" width="6.11739" height="4.14315"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="0.65" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter28_f_2246_1150" x="10.1699" y="5.55294" width="3.76151" height="3.97255"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="0.73" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter29_f_2246_1150" x="10.8231" y="6.41169" width="0.551245" height="0.568579"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="0.1" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter30_f_2246_1150" x="11.7128" y="6.37599" width="0.776984" height="0.600562"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="0.1" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <filter id="filter31_f_2246_1150" x="13.1324" y="6.70406" width="1.30402" height="1.39577"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="0.23" result="effect1_foregroundBlur_2246_1150"/>
                        </filter>
                        <radialGradient id="paint0_radial_2246_1150" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
                                        gradientTransform="translate(8.72068 11.4679) scale(1.46605 1.40625)">
                            <stop/>
                            <stop offset="1" stopOpacity="0.25"/>
                        </radialGradient>
                        <radialGradient id="paint1_radial_2246_1150" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
                                        gradientTransform="translate(13.7022 12.2813) scale(1.82099 1.40625)">
                            <stop/>
                            <stop offset="1" stopOpacity="0.25"/>
                        </radialGradient>
                        <radialGradient id="paint2_radial_2246_1150" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
                                        gradientTransform="translate(11.2693 11.9586) scale(0.72145 0.78125)">
                            <stop/>
                            <stop offset="1" stopOpacity="0.25"/>
                        </radialGradient>
                        <linearGradient id="paint3_linear_2246_1150" x1="5.78858" y1="17.0789" x2="9.02072" y2="22.435"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#B98309"/>
                            <stop offset="1" stopColor="#382605"/>
                        </linearGradient>
                        <linearGradient id="paint4_linear_2246_1150" x1="8.97454" y1="18.471" x2="9.99249" y2="20.3653"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#EBC40C"/>
                            <stop offset="1" stopColor="#EBC40C" stopOpacity="0"/>
                        </linearGradient>
                        <linearGradient id="paint5_linear_2246_1150" x1="15.3372" y1="18.5594" x2="15.5957" y2="20.4156"
                                        gradientUnits="userSpaceOnUse">
                            <stop/>
                            <stop offset="1" stopOpacity="0"/>
                        </linearGradient>
                        <linearGradient id="paint6_linear_2246_1150" x1="15.6898" y1="21.7672" x2="18.9452" y2="16.5549"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#3E2A06"/>
                            <stop offset="1" stopColor="#AD780A"/>
                        </linearGradient>
                        <linearGradient id="paint7_linear_2246_1150" x1="16.5625" y1="16.1149" x2="16.466" y2="16.9716"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#F3CD0C"/>
                            <stop offset="1" stopColor="#F3CD0C" stopOpacity="0"/>
                        </linearGradient>
                        <radialGradient id="paint8_radial_2246_1150" cx="0" cy="0" r="1"
                                        gradientTransform="matrix(1.46529 0.39753 -0.412193 1.55756 17.0949 17.1977)"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#110800"/>
                            <stop offset="0.59" stopColor="#A65A00" stopOpacity="0.8"/>
                            <stop offset="1" stopColor="#FF921E" stopOpacity="0"/>
                        </radialGradient>
                        <radialGradient id="paint9_radial_2246_1150" cx="0" cy="0" r="1"
                                        gradientTransform="matrix(1.52179 -0.065118 0.0484147 1.1599 17.0949 16.8352)"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#110800"/>
                            <stop offset="0.59" stopColor="#A65A00" stopOpacity="0.8"/>
                            <stop offset="1" stopColor="#FF921E" stopOpacity="0"/>
                        </radialGradient>
                        <radialGradient id="paint10_radial_2246_1150" cx="0" cy="0" r="1"
                                        gradientTransform="matrix(0.491788 0.216508 -0.0987643 0.229981 18.2477 15.7985)"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#7C7C7C"/>
                            <stop offset="1" stopColor="#7C7C7C" stopOpacity="0.33"/>
                        </radialGradient>
                        <linearGradient id="paint11_linear_2246_1150" x1="16.7847" y1="15.561" x2="16.9838" y2="15.5526"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#7C7C7C"/>
                            <stop offset="1" stopColor="#7C7C7C" stopOpacity="0.33"/>
                        </linearGradient>
                        <radialGradient id="paint12_radial_2246_1150" cx="0" cy="0" r="1"
                                        gradientTransform="matrix(0.79008 -0.00837743 0.0126696 1.22493 10.6736 6.01638)"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#FEFEFC"/>
                            <stop offset="0.75" stopColor="#FEFEFC"/>
                            <stop offset="1" stopColor="#D4D4D4"/>
                        </radialGradient>
                        <linearGradient id="paint13_linear_2246_1150" x1="10.5039" y1="5.64375" x2="10.8994"
                                        y2="6.34191" gradientUnits="userSpaceOnUse">
                            <stop stopColor="#757574" stopOpacity="0"/>
                            <stop offset="0.25" stopColor="#757574"/>
                            <stop offset="0.5" stopColor="#757574"/>
                            <stop offset="1" stopColor="#757574" stopOpacity="0"/>
                        </linearGradient>
                        <radialGradient id="paint14_radial_2246_1150" cx="0" cy="0" r="1"
                                        gradientTransform="matrix(0.475846 -0.0793286 0.072332 0.444792 10.5501 5.41721)"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#C8C8C8"/>
                            <stop offset="1" stopColor="#797978"/>
                        </radialGradient>
                        <linearGradient id="paint15_linear_2246_1150" x1="10.4498" y1="4.53982" x2="11.3008" y2="5.398"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#646464" stopOpacity="0"/>
                            <stop offset="0.31" stopColor="#646464" stopOpacity="0.58"/>
                            <stop offset="0.47" stopColor="#646464"/>
                            <stop offset="0.73" stopColor="#646464" stopOpacity="0.26"/>
                            <stop offset="1" stopColor="#646464" stopOpacity="0"/>
                        </linearGradient>
                        <radialGradient id="paint16_radial_2246_1150" cx="0" cy="0" r="1"
                                        gradientTransform="matrix(1.05195 -0.0334721 0.0380031 1.2244 13.1096 6.01636)"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#FEFEFC"/>
                            <stop offset="0.75" stopColor="#FEFEFC"/>
                            <stop offset="1" stopColor="#D4D4D4"/>
                        </radialGradient>
                        <linearGradient id="paint17_linear_2246_1150" x1="13.0949" y1="5.69142" x2="13.5482"
                                        y2="6.22181" gradientUnits="userSpaceOnUse">
                            <stop stopColor="#949494" stopOpacity="0.39"/>
                            <stop offset="0.5" stopColor="#949494"/>
                            <stop offset="1" stopColor="#949494" stopOpacity="0.39"/>
                        </linearGradient>
                        <linearGradient id="paint18_linear_2246_1150" x1="12.7114" y1="4.83047" x2="14.1417"
                                        y2="5.65716" gradientUnits="userSpaceOnUse">
                            <stop stopColor="#747474"/>
                            <stop offset="0.13" stopColor="#8C8C8C"/>
                            <stop offset="0.25" stopColor="#A4A4A4"/>
                            <stop offset="0.5" stopColor="#D4D4D4"/>
                            <stop offset="0.62" stopColor="#D4D4D4"/>
                            <stop offset="1" stopColor="#7C7C7C"/>
                        </linearGradient>
                        <linearGradient id="paint19_linear_2246_1150" x1="13.1944" y1="4.4656" x2="14.1515" y2="5.35842"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#646464" stopOpacity="0"/>
                            <stop offset="0.31" stopColor="#646464" stopOpacity="0.58"/>
                            <stop offset="0.47" stopColor="#646464"/>
                            <stop offset="0.73" stopColor="#646464" stopOpacity="0.26"/>
                            <stop offset="1" stopColor="#646464" stopOpacity="0"/>
                        </linearGradient>
                        <radialGradient id="paint20_radial_2246_1150" cx="0" cy="0" r="1"
                                        gradientTransform="matrix(0.714132 -0.525333 0.470772 0.656062 11.5339 6.69685)"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#020204"/>
                            <stop offset="0.73" stopColor="#020204"/>
                            <stop offset="1" stopColor="#5C5C5C"/>
                        </radialGradient>
                        <radialGradient id="paint21_radial_2246_1150" cx="0" cy="0" r="1"
                                        gradientTransform="matrix(1.93684 -0.808286 0.560726 1.37743 12.4699 7.5164)"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#D2940A"/>
                            <stop offset="0.75" stopColor="#D89C08"/>
                            <stop offset="0.87" stopColor="#B67E07"/>
                            <stop offset="1" stopColor="#946106"/>
                        </radialGradient>
                        <linearGradient id="paint22_linear_2246_1150" x1="10.0255" y1="7.41091" x2="13.7816"
                                        y2="7.38195" gradientUnits="userSpaceOnUse">
                            <stop stopColor="#AD780A"/>
                            <stop offset="0.12" stopColor="#D89E08"/>
                            <stop offset="0.25" stopColor="#EDB80B"/>
                            <stop offset="0.39" stopColor="#EBC80D"/>
                            <stop offset="0.53" stopColor="#F5D838"/>
                            <stop offset="0.77" stopColor="#F6D811"/>
                            <stop offset="1" stopColor="#F5CD31"/>
                        </linearGradient>
                        <radialGradient id="paint23_radial_2246_1150" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
                                        gradientTransform="translate(11.1073 6.67814) scale(0.101852 0.110937)">
                            <stop stopColor="#3A2903"/>
                            <stop offset="0.55" stopColor="#735208"/>
                            <stop offset="1" stopColor="#AC8C04"/>
                        </radialGradient>
                        <radialGradient id="paint24_radial_2246_1150" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
                                        gradientTransform="translate(12.0749 6.664) scale(0.214506 0.126563)">
                            <stop stopColor="#3A2903"/>
                            <stop offset="0.55" stopColor="#735208"/>
                            <stop offset="1" stopColor="#AC8C04"/>
                        </radialGradient>
                        <linearGradient id="paint25_linear_2246_1150" x1="13.7793" y1="7.27266" x2="13.7793"
                                        y2="7.55391" gradientUnits="userSpaceOnUse">
                            <stop stopColor="#F5CE2D"/>
                            <stop offset="1" stopColor="#D79B08"/>
                        </linearGradient>
                    </defs>

                </symbol>
                <symbol
                    id="lbaic-settings-device-ios"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <path
                        d="M19.638 8.81868C19.5192 8.90869 17.4224 10.0628 17.4224 12.6291C17.4224 15.5974 20.0905 16.6475 20.1704 16.6735C20.1581 16.7375 19.7465 18.1116 18.7636 19.5118C17.8872 20.7439 16.9719 21.974 15.5794 21.974C14.187 21.974 13.8286 21.1839 12.2212 21.1839C10.6547 21.1839 10.0977 22 8.82404 22C7.55036 22 6.66166 20.8599 5.63985 19.4597C4.45628 17.8156 3.5 15.2613 3.5 12.8371C3.5 8.94869 6.0883 6.88649 8.63565 6.88649C9.98918 6.88649 11.1175 7.75458 11.9673 7.75458C12.7761 7.75458 14.0375 6.83448 15.5774 6.83448C16.161 6.83448 18.2578 6.88649 19.638 8.81868ZM14.8463 5.18832C15.4832 4.45024 15.9337 3.42614 15.9337 2.40204C15.9337 2.26003 15.9214 2.11601 15.8948 2C14.8586 2.038 13.6259 2.67407 12.8826 3.51615C12.299 4.16422 11.7543 5.18832 11.7543 6.22642C11.7543 6.38244 11.7809 6.53845 11.7932 6.58846C11.8587 6.60046 11.9652 6.61446 12.0717 6.61446C13.0014 6.61446 14.1706 6.0064 14.8463 5.18832Z"
                        fill="black"/>
                </symbol>
                <symbol
                    id="lbaic-settings-device-macos"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <mask id="mask0_2251_300" style={{maskType: 'luminance'}} maskUnits="userSpaceOnUse" x="0" y="2"
                          width="24" height="20">
                        <path d="M0.900002 2H23.1857V22H0.900002V2Z" fill="white"/>
                    </mask>
                    <g mask="url(#mask0_2251_300)">
                        <path
                            d="M20.932 21.9886H3.15372C1.90914 21.9886 0.900002 20.9794 0.900002 19.7348V4.26513C0.900002 3.02056 1.90914 2.01141 3.15372 2.01141H20.9326C22.1766 2.01141 23.1857 3.02056 23.1857 4.26513V19.7354C23.1857 20.9794 22.1766 21.9886 20.932 21.9886Z"
                            fill="#E1E1E1"/>
                    </g>
                    <mask id="mask1_2251_300" style={{maskType: 'luminance'}} maskUnits="userSpaceOnUse" x="0" y="2"
                          width="24" height="20">
                        <path d="M0.900002 2H23.1857V22H0.900002V2Z" fill="white"/>
                    </mask>
                    <g mask="url(#mask1_2251_300)">
                        <path
                            d="M20.324 2.02289H13.0829C13.0623 2.02289 13.0434 2.03603 13.0366 2.05489C12.4594 3.60517 12.0006 5.21089 11.6657 6.8286C11.3491 8.41717 11.1497 10.04 11.0794 11.6629C11.0783 11.6909 11.1006 11.7143 11.1291 11.7143H13.3114C13.54 11.7143 13.7629 11.8115 13.9171 11.9829C14.0714 12.1543 14.1457 12.3829 14.1229 12.6115C13.9646 14.2732 13.9629 15.9572 14.1343 17.6195C14.1371 17.6486 14.164 17.6697 14.1926 17.664C15.5109 17.4126 17.2011 16.8275 18.78 15.5023C19.0257 15.3023 19.3857 15.3366 19.5857 15.5766C19.7914 15.8166 19.7571 16.1766 19.5171 16.3823C17.724 17.8812 15.8023 18.5292 14.3286 18.8023C14.3029 18.8069 14.2863 18.8315 14.2903 18.8572C14.448 19.9035 14.6766 20.944 14.9646 21.9629C14.9703 21.9852 14.9897 22 15.012 22H20.2817C21.5697 22 22.6143 20.9555 22.6143 19.6669V4.31317C22.6143 3.04803 21.5891 2.02289 20.324 2.02289ZM17.5571 8.8286C17.5571 9.14289 17.3 9.40003 16.9857 9.40003C16.6714 9.40003 16.4143 9.14289 16.4143 8.8286V6.97146C16.4143 6.65717 16.6714 6.40003 16.9857 6.40003C17.3 6.40003 17.5571 6.65717 17.5571 6.97146V8.8286Z"
                            fill="#E1E1E1"/>
                    </g>
                    <mask id="mask2_2251_300" style={{maskType: 'luminance'}} maskUnits="userSpaceOnUse" x="0" y="2"
                          width="24" height="20">
                        <path d="M0.900002 2H23.1857V22H0.900002V2Z" fill="white"/>
                    </mask>
                    <g mask="url(#mask2_2251_300)">
                        <path
                            d="M16.4143 8.82854V6.97139C16.4143 6.65711 16.6714 6.39996 16.9857 6.39996C17.3 6.39996 17.5571 6.65711 17.5571 6.97139V8.82854C17.5571 9.14282 17.3 9.39996 16.9857 9.39996C16.6714 9.39996 16.4143 9.14282 16.4143 8.82854Z"
                            fill="#00B7F9"/>
                    </g>
                    <mask id="mask3_2251_300" style={{maskType: 'luminance'}} maskUnits="userSpaceOnUse" x="0" y="2"
                          width="24" height="20">
                        <path d="M0.900002 2H23.1857V22H0.900002V2Z" fill="white"/>
                    </mask>
                    <g mask="url(#mask3_2251_300)">
                        <path
                            d="M19.5171 16.3829C17.7057 17.8972 15.7629 18.5429 14.2829 18.8115C14.4429 19.8857 14.6771 20.9543 14.9743 22H3.18743C1.924 22 0.900002 20.976 0.900002 19.7126V4.31603C0.900002 3.04975 1.92686 2.02289 3.19314 2.02289H13.0486C12.4657 3.58289 12.0029 5.20003 11.6657 6.8286C11.3457 8.43432 11.1457 10.0743 11.0771 11.7143H13.3114C13.54 11.7143 13.7629 11.8115 13.9171 11.9829C14.0714 12.1543 14.1457 12.3829 14.1229 12.6115C13.9629 14.2915 13.9629 15.9943 14.14 17.6743C15.4657 17.4286 17.18 16.8457 18.78 15.5029C19.0257 15.3029 19.3857 15.3372 19.5857 15.5772C19.7914 15.8172 19.7571 16.1772 19.5171 16.3829Z"
                            fill="#00B7F9"/>
                    </g>
                    <mask id="mask4_2251_300" style={{maskType: 'luminance'}} maskUnits="userSpaceOnUse" x="0" y="2"
                          width="24" height="20">
                        <path d="M0.900002 2H23.1857V22H0.900002V2Z" fill="white"/>
                    </mask>
                    <g mask="url(#mask4_2251_300)">
                        <path
                            d="M14.9743 22C14.6771 20.9543 14.4429 19.8857 14.2829 18.8114C14.2314 18.4743 14.1857 18.1314 14.1514 17.7943C14.1457 17.7543 14.1457 17.7143 14.14 17.6743C13.9629 15.9943 13.9629 14.2914 14.1229 12.6114C14.1457 12.3828 14.0714 12.1543 13.9171 11.9828C13.7629 11.8114 13.54 11.7143 13.3114 11.7143H11.0771C11.1457 10.0743 11.3457 8.43426 11.6657 6.82855C12.0029 5.19997 12.4657 3.58283 13.0486 2.02283C13.0943 1.90283 13.14 1.78855 13.1857 1.66855L12.1229 1.2514C12.0257 1.50855 11.9286 1.76569 11.8371 2.02283C11.2943 3.51426 10.86 5.0514 10.5457 6.60569C10.1857 8.38283 9.98001 10.2 9.92286 12.0171C9.91715 12.24 9.99715 12.4514 10.1571 12.6114C10.3057 12.7657 10.5229 12.8571 10.7457 12.8571H12.9514C12.8143 14.5085 12.8314 16.1771 13.0029 17.8228C13.0086 17.8514 13.0086 17.8857 13.0143 17.9143C13.0543 18.2628 13.0943 18.6114 13.1514 18.9543C13.3 19.9828 13.5171 21 13.7857 22C13.9343 22.5428 14.0943 23.0743 14.2771 23.6057L15.3629 23.2343C15.22 22.8285 15.0943 22.4114 14.9743 22Z"
                            fill="#00A0D1"/>
                    </g>
                    <mask id="mask5_2251_300" style={{maskType: 'luminance'}} maskUnits="userSpaceOnUse" x="0" y="2"
                          width="24" height="20">
                        <path d="M0.900002 2H23.1857V22H0.900002V2Z" fill="white"/>
                    </mask>
                    <g mask="url(#mask5_2251_300)">
                        <path
                            d="M19.5171 16.3829C17.7057 17.8971 15.7629 18.5429 14.2829 18.8114C13.8657 18.8857 13.4829 18.9314 13.1514 18.9543C12.8314 18.9829 12.5571 18.9886 12.3457 18.9886C8.68285 18.9886 6.11142 17.1657 5.17428 16.3829C4.92857 16.1771 4.9 15.8171 5.1 15.5771C5.30571 15.3371 5.66571 15.3029 5.90571 15.5029C6.74571 16.2114 9.05428 17.8457 12.3457 17.8457C12.5229 17.8457 12.7457 17.84 13.0029 17.8229C13.3286 17.8 13.7114 17.7543 14.14 17.6743C15.4657 17.4286 17.18 16.8457 18.78 15.5029C19.0257 15.3029 19.3857 15.3371 19.5857 15.5771C19.7914 15.8171 19.7571 16.1771 19.5171 16.3829Z"
                            fill="#37474F"/>
                    </g>
                    <mask id="mask6_2251_300" style={{maskType: 'luminance'}} maskUnits="userSpaceOnUse" x="0" y="2"
                          width="24" height="20">
                        <path d="M0.900002 2H23.1857V22H0.900002V2Z" fill="white"/>
                    </mask>
                    <g mask="url(#mask6_2251_300)">
                        <path
                            d="M7.08629 9.40004C6.77029 9.40004 6.51486 9.14404 6.51486 8.82861V6.97261C6.51486 6.65718 6.77029 6.40118 7.08629 6.40118C7.40229 6.40118 7.65772 6.65718 7.65772 6.97261V8.82861C7.65772 9.14404 7.40229 9.40004 7.08629 9.40004Z"
                            fill="#37474F"/>
                    </g>
                    <mask id="mask7_2251_300" style={{maskType: 'luminance'}} maskUnits="userSpaceOnUse" x="0" y="2"
                          width="24" height="20">
                        <path d="M0.900002 2H23.1857V22H0.900002V2Z" fill="white"/>
                    </mask>
                    <g mask="url(#mask7_2251_300)">
                        <path
                            d="M17.5571 6.97139V8.82854C17.5571 9.14282 17.3 9.39996 16.9857 9.39996C16.6714 9.39996 16.4143 9.14282 16.4143 8.82854V6.97139C16.4143 6.65711 16.6714 6.39996 16.9857 6.39996C17.3 6.39996 17.5571 6.65711 17.5571 6.97139Z"
                            fill="#37474F"/>
                    </g>
                </symbol>
                <symbol
                    id="lbaic-settings-device-unknown"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <path
                        d="M18 8V6C18 5.46957 17.7893 4.96086 17.4142 4.58579C17.0391 4.21071 16.5304 4 16 4H4C3.46957 4 2.96086 4.21071 2.58579 4.58579C2.21071 4.96086 2 5.46957 2 6V13C2 13.5304 2.21071 14.0391 2.58579 14.4142C2.96086 14.7893 3.46957 15 4 15H12"
                        stroke="black" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round"/>
                    <path d="M10 19V15.04V18.19" stroke="black" strokeWidth="2" strokeLinecap="round"
                          strokeLinejoin="round"/>
                    <path d="M7 19H12" stroke="black" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round"/>
                    <path
                        d="M20 12H18C16.8954 12 16 12.8954 16 14V20C16 21.1046 16.8954 22 18 22H20C21.1046 22 22 21.1046 22 20V14C22 12.8954 21.1046 12 20 12Z"
                        stroke="black" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round"/>
                </symbol>

                {/*Browsers*/}
                <symbol
                    id="lbaic-settings-browser-chrome"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <path
                        d="M12 16.9978C14.7614 16.9978 17 14.7592 17 11.9978C17 9.23638 14.7614 6.9978 12 6.9978C9.23857 6.9978 7 9.23638 7 11.9978C7 14.7592 9.23857 16.9978 12 16.9978Z"
                        fill="white"/>
                    <path
                        d="M12 7.00002H20.6588C19.7814 5.47976 18.5192 4.21731 16.9991 3.3396C15.479 2.4619 13.7546 1.99988 11.9993 2C10.244 2.00012 8.51971 2.46238 6.99974 3.3403C5.47977 4.21822 4.21774 5.48085 3.34053 7.00122L7.66994 14.5L7.67382 14.499C7.2334 13.7395 7.00099 12.8774 7 11.9995C6.99901 11.1215 7.22949 10.2588 7.6682 9.49839C8.10691 8.73793 8.73834 8.10657 9.49885 7.66794C10.2594 7.22932 11.1221 6.99893 12 7.00002Z"
                        fill="url(#paint0_linear_2246_1356)"/>
                    <path
                        d="M12 15.9583C14.1861 15.9583 15.9583 14.1861 15.9583 12C15.9583 9.81389 14.1861 8.04169 12 8.04169C9.81386 8.04169 8.04166 9.81389 8.04166 12C8.04166 14.1861 9.81386 15.9583 12 15.9583Z"
                        fill="#1A73E8"/>
                    <path
                        d="M16.3297 14.5012L12.0003 22C13.7556 22.0002 15.48 21.5383 17.0001 20.6607C18.5203 19.7831 19.7826 18.5208 20.6601 17.0006C21.5376 15.4804 21.9995 13.756 21.9991 12.0007C21.9988 10.2454 21.5364 8.52115 20.6583 7.00128H11.9995L11.9985 7.00516C12.8764 7.00346 13.7393 7.23325 14.5001 7.67136C15.2609 8.10946 15.8928 8.7404 16.332 9.50056C16.7712 10.2607 17.0023 11.1233 17.0019 12.0012C17.0015 12.8791 16.7696 13.7414 16.3297 14.5012Z"
                        fill="url(#paint1_linear_2246_1356)"/>
                    <path
                        d="M7.67025 14.5013L3.34083 7.0025C2.46297 8.5225 2.00077 10.2468 2.0007 12.0021C2.00064 13.7574 2.46271 15.4818 3.34046 17.0019C4.21821 18.5219 5.4807 19.7841 7.00098 20.6615C8.52126 21.5388 10.2457 22.0005 12.001 22L16.3305 14.5012L16.3277 14.4984C15.8901 15.2595 15.2597 15.8919 14.4999 16.3317C13.7401 16.7715 12.8777 17.0033 11.9998 17.0036C11.1219 17.0038 10.2594 16.7727 9.49926 16.3334C8.73914 15.8941 8.10827 15.2621 7.67025 14.5013Z"
                        fill="url(#paint2_linear_2246_1356)"/>
                    <defs>
                        <linearGradient id="paint0_linear_2246_1356" x1="3.34053" y1="8.25001" x2="20.6588" y2="8.25001"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#D93025"/>
                            <stop offset="1" stopColor="#EA4335"/>
                        </linearGradient>
                        <linearGradient id="paint1_linear_2246_1356" x1="10.6341" y1="21.8663" x2="19.2933" y2="6.8682"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#FCC934"/>
                            <stop offset="1" stopColor="#FBBC04"/>
                        </linearGradient>
                        <linearGradient id="paint2_linear_2246_1356" x1="13.0825" y1="21.3756" x2="4.42337" y2="6.3775"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#1E8E3E"/>
                            <stop offset="1" stopColor="#34A853"/>
                        </linearGradient>
                    </defs>
                </symbol>
                <symbol
                    id="lbaic-settings-browser-firefox"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <path
                        d="M20.9579 8.70774C20.5367 7.69467 19.6837 6.60096 19.0139 6.25528C19.559 7.32403 19.8745 8.39613 19.9951 9.19625C19.9951 9.19782 19.9957 9.20173 19.997 9.21238C18.9012 6.4812 17.0432 5.37991 15.526 2.98201C15.4494 2.86076 15.3726 2.73918 15.2977 2.61104C15.2596 2.54559 15.224 2.47872 15.191 2.41055C15.128 2.28885 15.0794 2.16021 15.0462 2.02725C15.0464 2.02095 15.0443 2.0148 15.0402 2.00999C15.0361 2.00519 15.0304 2.00208 15.0241 2.00128C15.0182 1.99957 15.0119 1.99957 15.0059 2.00128C15.0046 2.00176 15.0026 2.00333 15.0011 2.0039C14.999 2.00475 14.9963 2.00668 14.994 2.00793C14.9951 2.00648 14.9974 2.00321 14.998 2.00245C12.5638 3.42809 11.738 6.0654 11.6621 7.38488C10.69 7.4517 9.7606 7.80985 8.99505 8.41262C8.9149 8.34492 8.83111 8.28165 8.74405 8.2231C8.52317 7.45036 8.51379 6.63248 8.71687 5.85487C7.72138 6.30814 6.94711 7.02463 6.3842 7.6573H6.37973C5.99557 7.17072 6.02267 5.56564 6.04457 5.23052C6.03997 5.20975 5.75799 5.37689 5.72106 5.40209C5.38207 5.64406 5.06516 5.91554 4.77404 6.21338C4.44276 6.54933 4.14007 6.91233 3.86912 7.29859C3.86912 7.29907 3.86884 7.29963 3.86867 7.30012C3.86867 7.29959 3.86896 7.29907 3.86912 7.29859C3.24599 8.18163 2.80404 9.17941 2.56883 10.2343C2.5642 10.2553 2.56029 10.2771 2.55577 10.2982C2.53754 10.3835 2.4719 10.8103 2.46041 10.9031C2.45952 10.9102 2.45912 10.9171 2.45827 10.9242C2.3734 11.3654 2.32084 11.8123 2.30101 12.2612C2.30101 12.2777 2.3 12.2941 2.3 12.3106C2.30016 17.662 6.63888 22 11.9907 22C16.7836 22 20.7633 18.5206 21.5424 13.9504C21.5588 13.8263 21.5719 13.7017 21.5864 13.5765C21.779 11.9148 21.565 10.1683 20.9579 8.70774ZM9.78872 16.2922C9.83405 16.3138 9.87663 16.3375 9.92316 16.3583C9.9251 16.3596 9.92776 16.3611 9.92973 16.3623C9.88237 16.3397 9.83536 16.3163 9.78872 16.2922ZM19.9978 9.21476L19.9965 9.20536C19.997 9.20879 19.9976 9.21238 19.9981 9.21581L19.9978 9.21476Z"
                        fill="url(#paint0_linear_2246_1364)"/>
                    <path
                        d="M20.9579 8.70777C20.5367 7.69471 19.6837 6.601 19.0139 6.25531C19.559 7.32406 19.8745 8.39616 19.9951 9.19628C19.9951 9.19394 19.9955 9.19822 19.9966 9.2054C19.997 9.20882 19.9976 9.21241 19.9982 9.21584C20.9125 11.6945 20.4144 14.215 19.6966 15.7552C18.5862 18.1382 15.8976 20.5806 11.6895 20.4615C7.14291 20.3327 3.1375 16.9592 2.3898 12.5407C2.25355 11.8439 2.3898 11.4902 2.45835 10.9244C2.37484 11.3606 2.34302 11.4865 2.30109 12.2614C2.30109 12.2779 2.30008 12.2943 2.30008 12.3109C2.30016 17.662 6.63888 22 11.9907 22C16.7836 22 20.7633 18.5207 21.5424 13.9504C21.5588 13.8264 21.5719 13.7017 21.5864 13.5766C21.779 11.9149 21.565 10.1683 20.9579 8.70777Z"
                        fill="url(#paint1_radial_2246_1364)"/>
                    <path
                        d="M20.9579 8.70777C20.5367 7.69471 19.6837 6.601 19.0139 6.25531C19.559 7.32406 19.8745 8.39616 19.9951 9.19628C19.9951 9.19394 19.9955 9.19822 19.9966 9.2054C19.997 9.20882 19.9976 9.21241 19.9982 9.21584C20.9125 11.6945 20.4144 14.215 19.6966 15.7552C18.5862 18.1382 15.8976 20.5806 11.6895 20.4615C7.14291 20.3327 3.1375 16.9592 2.3898 12.5407C2.25355 11.8439 2.3898 11.4902 2.45835 10.9244C2.37484 11.3606 2.34302 11.4865 2.30109 12.2614C2.30109 12.2779 2.30008 12.2943 2.30008 12.3109C2.30016 17.662 6.63888 22 11.9907 22C16.7836 22 20.7633 18.5207 21.5424 13.9504C21.5588 13.8264 21.5719 13.7017 21.5864 13.5766C21.779 11.9149 21.565 10.1683 20.9579 8.70777Z"
                        fill="url(#paint2_radial_2246_1364)"/>
                    <path
                        d="M16.2486 9.84677C16.2698 9.86161 16.289 9.87636 16.3089 9.89112C16.0656 9.45949 15.7628 9.06431 15.4093 8.71725C12.397 5.70531 14.6194 2.18651 14.9942 2.0078C14.9953 2.00635 14.9975 2.00309 14.9982 2.00232C12.5639 3.42797 11.7381 6.06527 11.6622 7.38475C11.7751 7.37692 11.8877 7.36745 12.0026 7.36745C13.8192 7.36745 15.4014 8.36624 16.2486 9.84677Z"
                        fill="url(#paint3_radial_2246_1364)"/>
                    <path
                        d="M12.0087 10.4481C11.9929 10.6891 11.1412 11.5204 10.8434 11.5204C8.0878 11.5204 7.6405 13.1871 7.6405 13.1871C7.76256 14.5908 8.73974 15.7466 9.92321 16.3582C9.9772 16.3861 10.0318 16.4113 10.0865 16.4363C10.1803 16.4778 10.2752 16.5166 10.3712 16.5526C10.7769 16.6963 11.202 16.7783 11.6321 16.7958C16.4619 17.0223 17.3977 11.0219 13.9121 9.27935C14.8047 9.12411 15.7313 9.4831 16.2487 9.84657C15.4014 8.36616 13.8193 7.36737 12.0027 7.36737C11.8878 7.36737 11.7753 7.37685 11.6623 7.38467C10.6902 7.4515 9.76085 7.80964 8.9953 8.41241C9.14305 8.53741 9.30982 8.70451 9.66119 9.05064C10.3185 9.6985 12.0051 10.3694 12.0087 10.4481Z"
                        fill="url(#paint4_radial_2246_1364)"/>
                    <path
                        d="M12.0087 10.4481C11.9929 10.6891 11.1412 11.5204 10.8434 11.5204C8.0878 11.5204 7.6405 13.1871 7.6405 13.1871C7.76256 14.5908 8.73974 15.7466 9.92321 16.3582C9.9772 16.3861 10.0318 16.4113 10.0865 16.4363C10.1803 16.4778 10.2752 16.5166 10.3712 16.5526C10.7769 16.6963 11.202 16.7783 11.6321 16.7958C16.4619 17.0223 17.3977 11.0219 13.9121 9.27935C14.8047 9.12411 15.7313 9.4831 16.2487 9.84657C15.4014 8.36616 13.8193 7.36737 12.0027 7.36737C11.8878 7.36737 11.7753 7.37685 11.6623 7.38467C10.6902 7.4515 9.76085 7.80964 8.9953 8.41241C9.14305 8.53741 9.30982 8.70451 9.66119 9.05064C10.3185 9.6985 12.0051 10.3694 12.0087 10.4481Z"
                        fill="url(#paint5_radial_2246_1364)"/>
                    <path
                        d="M8.54327 8.09014C8.61076 8.13368 8.67772 8.17804 8.74412 8.22321C8.52325 7.45046 8.51386 6.63259 8.71694 5.85498C7.72146 6.30825 6.94718 7.02474 6.38428 7.6574C6.43085 7.65607 7.83646 7.63079 8.54327 8.09014Z"
                        fill="url(#paint6_radial_2246_1364)"/>
                    <path
                        d="M2.38979 12.5407C3.1375 16.9592 7.1429 20.3327 11.6895 20.4614C15.8976 20.5806 18.5861 18.1381 19.6966 15.7552C20.4143 14.2148 20.9125 11.6947 19.9982 9.21583L19.9978 9.21478L19.9966 9.20538C19.9955 9.19821 19.9949 9.19393 19.9951 9.19627C19.9951 9.19784 19.9957 9.20175 19.997 9.2124C20.3407 11.4568 19.199 13.6311 17.4143 15.1013L17.4089 15.1139C13.9313 17.9455 10.6035 16.8223 9.92972 16.3625C9.88236 16.3397 9.83532 16.3163 9.78859 16.2922C7.76109 15.3233 6.92351 13.4762 7.10311 11.8921C5.39113 11.8921 4.80738 10.4482 4.80738 10.4482C4.80738 10.4482 6.34444 9.35224 8.3702 10.3054C10.2464 11.1882 12.0084 10.4482 12.0086 10.4482C12.005 10.3695 10.3184 9.69857 9.66093 9.05075C9.3096 8.70462 9.14279 8.53772 8.99504 8.41252C8.91489 8.34482 8.8311 8.28155 8.74404 8.223C8.67756 8.17794 8.6106 8.13359 8.54319 8.08994C7.83641 7.63058 6.43077 7.65587 6.38419 7.65708H6.37972C5.99556 7.1705 6.02266 5.56542 6.04456 5.2303C6.03996 5.20953 5.75798 5.37667 5.72105 5.40187C5.38206 5.64384 5.06515 5.91532 4.77403 6.21316C4.44274 6.54919 4.14005 6.91226 3.86911 7.29861C3.86911 7.29909 3.86883 7.29966 3.86867 7.30014C3.86867 7.29961 3.86895 7.29909 3.86911 7.29861C3.24598 8.18165 2.80404 9.17943 2.56883 10.2343C2.56419 10.2553 2.22003 11.7602 2.38979 12.5407Z"
                        fill="url(#paint7_radial_2246_1364)"/>
                    <path
                        d="M15.4092 8.71718C15.7628 9.06424 16.0656 9.45942 16.3088 9.89105C16.3622 9.93113 16.412 9.97109 16.4543 10.0101C18.6512 12.0343 17.5001 14.8972 17.4143 15.1012C19.199 13.6311 20.3407 11.4567 19.997 9.21234C18.9012 6.4812 17.0432 5.37991 15.526 2.98201C15.4494 2.86076 15.3726 2.73918 15.2977 2.61104C15.2596 2.54559 15.224 2.47872 15.191 2.41055C15.128 2.28885 15.0794 2.16021 15.0461 2.02725C15.0464 2.02095 15.0442 2.0148 15.0402 2.00999C15.0361 2.00519 15.0304 2.00208 15.0241 2.00128C15.0182 1.99957 15.0119 1.99957 15.0059 2.00128C15.0046 2.00176 15.0026 2.00333 15.0011 2.0039C14.999 2.00475 14.9963 2.00668 14.994 2.00793C14.6194 2.18648 12.3969 5.70528 15.4092 8.71718Z"
                        fill="url(#paint8_radial_2246_1364)"/>
                    <path
                        d="M16.4543 10.0101C16.412 9.97106 16.3622 9.9311 16.3089 9.89102C16.2891 9.87618 16.2698 9.86142 16.2486 9.84666C15.7312 9.4832 14.8047 9.1242 13.9121 9.27944C17.3976 11.0219 16.4619 17.0224 11.632 16.7959C11.2019 16.7784 10.7769 16.6964 10.3711 16.5527C10.2751 16.5166 10.1802 16.4778 10.0865 16.4364C10.0318 16.4114 9.97715 16.3862 9.92316 16.3583C9.92509 16.3597 9.92775 16.3611 9.92973 16.3624C10.6035 16.822 13.9313 17.9453 17.4089 15.1137L17.4143 15.1011C17.5001 14.8973 18.6512 12.0343 16.4543 10.0101Z"
                        fill="url(#paint9_radial_2246_1364)"/>
                    <path
                        d="M7.64045 13.1872C7.64045 13.1872 8.08775 11.5204 10.8434 11.5204C11.1413 11.5204 11.9929 10.6892 12.0087 10.4481C12.0244 10.2071 10.2466 11.1881 8.37025 10.3054C6.34448 9.35221 4.80742 10.4481 4.80742 10.4481C4.80742 10.4481 5.39117 11.8921 7.10315 11.8921C6.92359 13.4762 7.76117 15.3235 9.78864 16.2922C9.83396 16.3139 9.87654 16.3375 9.92307 16.3583C8.73968 15.7467 7.7625 14.5908 7.64045 13.1872Z"
                        fill="url(#paint10_radial_2246_1364)"/>
                    <path
                        d="M20.9579 8.70774C20.5367 7.69467 19.6837 6.60096 19.0138 6.25528C19.559 7.32403 19.8745 8.39613 19.9951 9.19625C19.9951 9.19782 19.9957 9.20173 19.997 9.21238C18.9012 6.4812 17.0432 5.37991 15.526 2.98201C15.4494 2.86076 15.3726 2.73918 15.2977 2.61104C15.2596 2.54559 15.224 2.47872 15.191 2.41055C15.128 2.28885 15.0794 2.16021 15.0461 2.02725C15.0464 2.02095 15.0442 2.0148 15.0402 2.00999C15.0361 2.00519 15.0304 2.00208 15.0241 2.00128C15.0182 1.99957 15.0119 1.99957 15.0059 2.00128C15.0046 2.00176 15.0026 2.00333 15.0011 2.0039C14.999 2.00475 14.9963 2.00668 14.994 2.00793C14.9951 2.00648 14.9974 2.00321 14.998 2.00245C12.5638 3.42809 11.738 6.0654 11.6621 7.38488C11.775 7.37705 11.8875 7.36758 12.0025 7.36758C13.8191 7.36758 15.4013 8.36637 16.2484 9.84677C15.731 9.48331 14.8045 9.12431 13.9119 9.27956C17.3974 11.0221 16.4617 17.0226 11.6318 16.796C11.2017 16.7785 10.7767 16.6965 10.3709 16.5528C10.2749 16.5167 10.18 16.4779 10.0863 16.4365C10.0316 16.4115 9.97694 16.3863 9.92295 16.3584C9.92488 16.3598 9.92755 16.3613 9.92952 16.3625C9.88216 16.3397 9.83512 16.3163 9.78839 16.2922C9.83371 16.3138 9.8763 16.3375 9.92283 16.3583C8.73936 15.7467 7.76218 14.5908 7.64012 13.1872C7.64012 13.1872 8.08742 11.5204 10.843 11.5204C11.1409 11.5204 11.9926 10.6892 12.0084 10.4481C12.0048 10.3694 10.3182 9.69855 9.66065 9.05072C9.30932 8.70459 9.1425 8.5377 8.99476 8.4125C8.91461 8.3448 8.83082 8.28153 8.74375 8.22298C8.52288 7.45023 8.51349 6.63236 8.71658 5.85475C7.72109 6.30802 6.94682 7.02451 6.38391 7.65717H6.37944C5.99528 7.1706 6.02238 5.56552 6.04427 5.2304C6.03968 5.20963 5.7577 5.37677 5.72077 5.40197C5.38178 5.64393 5.06487 5.91542 4.77375 6.21326C4.44256 6.54926 4.13997 6.9123 3.86911 7.29859C3.86911 7.29907 3.86883 7.29963 3.86867 7.30012C3.86867 7.29959 3.86895 7.29907 3.86911 7.29859C3.24598 8.18163 2.80404 9.17941 2.56883 10.2343C2.56419 10.2553 2.56028 10.2771 2.55576 10.2982C2.53754 10.3835 2.45552 10.8165 2.44407 10.9094C2.44491 10.9023 2.44318 10.9165 2.44407 10.9094C2.36927 11.3567 2.32155 11.8082 2.30116 12.2614C2.30116 12.2779 2.30016 12.2943 2.30016 12.3109C2.30016 17.662 6.63887 22 11.9907 22C16.7836 22 20.7632 18.5206 21.5424 13.9504C21.5588 13.8263 21.5719 13.7017 21.5864 13.5765C21.779 11.9148 21.565 10.1683 20.9579 8.70774ZM19.9966 9.20536C19.997 9.20879 19.9976 9.21238 19.9982 9.21581L19.9978 9.21476L19.9966 9.20536Z"
                        fill="url(#paint11_linear_2246_1364)"/>
                    <defs>
                        <linearGradient id="paint0_linear_2246_1364" x1="1691.03" y1="312" x2="135.027" y2="1812.98"
                                        gradientUnits="userSpaceOnUse">
                            <stop offset="0.05" stopColor="#FFF44F"/>
                            <stop offset="0.37" stopColor="#FF980E"/>
                            <stop offset="0.53" stopColor="#FF3647"/>
                            <stop offset="0.7" stopColor="#E31587"/>
                        </linearGradient>
                        <radialGradient id="paint1_radial_2246_1364" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
                                        gradientTransform="translate(1355.48 -196.846) scale(1981.95 2015.32)">
                            <stop offset="0.13" stopColor="#FFBD4F"/>
                            <stop offset="0.28" stopColor="#FF980E"/>
                            <stop offset="0.47" stopColor="#FF3750"/>
                            <stop offset="0.78" stopColor="#EB0878"/>
                            <stop offset="0.86" stopColor="#E50080"/>
                        </radialGradient>
                        <radialGradient id="paint2_radial_2246_1364" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
                                        gradientTransform="translate(779.869 636.043) scale(2031.49 2015.32)">
                            <stop offset="0.3" stopColor="#960E18"/>
                            <stop offset="0.35" stopColor="#B11927" stopOpacity="0.74"/>
                            <stop offset="0.43" stopColor="#DB293D" stopOpacity="0.34"/>
                            <stop offset="0.5" stopColor="#F5334B" stopOpacity="0.09"/>
                            <stop offset="0.53" stopColor="#FF3750" stopOpacity="0"/>
                        </radialGradient>
                        <radialGradient id="paint3_radial_2246_1364" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
                                        gradientTransform="translate(234.7 -92.6634) scale(650.527 1104.43)">
                            <stop offset="0.13" stopColor="#FFF44F"/>
                            <stop offset="0.53" stopColor="#FF980E"/>
                        </radialGradient>
                        <radialGradient id="paint4_radial_2246_1364" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
                                        gradientTransform="translate(203.563 1046.22) scale(860.82 943.469)">
                            <stop offset="0.35" stopColor="#3A8EE6"/>
                            <stop offset="0.67" stopColor="#9059FF"/>
                            <stop offset="1" stopColor="#C139E6"/>
                        </radialGradient>
                        <radialGradient id="paint5_radial_2246_1364" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
                                        gradientTransform="translate(409.906 318.712) scale(457.095 556.647)">
                            <stop offset="0.21" stopColor="#9059FF" stopOpacity="0"/>
                            <stop offset="0.97" stopColor="#6E008B" stopOpacity="0.6"/>
                        </radialGradient>
                        <radialGradient id="paint6_radial_2246_1364" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
                                        gradientTransform="translate(501.951 -230.968) scale(684.354 686.787)">
                            <stop offset="0.1" stopColor="#FFE226"/>
                            <stop offset="0.79" stopColor="#FF7139"/>
                        </radialGradient>
                        <radialGradient id="paint7_radial_2246_1364" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
                                        gradientTransform="translate(1527.06 -619.493) scale(3267.26 2742.68)">
                            <stop offset="0.11" stopColor="#FFF44F"/>
                            <stop offset="0.46" stopColor="#FF980E"/>
                            <stop offset="0.72" stopColor="#FF3647"/>
                            <stop offset="0.9" stopColor="#E31587"/>
                        </radialGradient>
                        <radialGradient id="paint8_radial_2246_1364" cx="0" cy="0" r="1"
                                        gradientTransform="matrix(226.22 1011.6 -4544.67 224.502 255.718 42.4135)"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#FFF44F"/>
                            <stop offset="0.3" stopColor="#FF980E"/>
                            <stop offset="0.57" stopColor="#FF3647"/>
                            <stop offset="0.74" stopColor="#E31587"/>
                        </radialGradient>
                        <radialGradient id="paint9_radial_2246_1364" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
                                        gradientTransform="translate(158.64 -319.3) scale(1875.88 1842.93)">
                            <stop offset="0.14" stopColor="#FFF44F"/>
                            <stop offset="0.48" stopColor="#FF980E"/>
                            <stop offset="0.66" stopColor="#FF3647"/>
                            <stop offset="0.9" stopColor="#E31587"/>
                        </radialGradient>
                        <radialGradient id="paint10_radial_2246_1364" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
                                        gradientTransform="translate(1151.98 -278.192) scale(2254.75 2017.14)">
                            <stop offset="0.09" stopColor="#FFF44F"/>
                            <stop offset="0.63" stopColor="#FF980E"/>
                        </radialGradient>
                        <linearGradient id="paint11_linear_2246_1364" x1="1550.69" y1="282" x2="306.431" y2="1641.49"
                                        gradientUnits="userSpaceOnUse">
                            <stop offset="0.17" stopColor="#FFF44F" stopOpacity="0.8"/>
                            <stop offset="0.6" stopColor="#FFF44F" stopOpacity="0"/>
                        </linearGradient>
                    </defs>
                </symbol>
                <symbol
                    id="lbaic-settings-browser-safari"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <path
                        d="M21.8962 11.9526C21.8962 13.2596 21.6402 14.5538 21.1428 15.7613C20.6454 16.9688 19.9163 18.0659 18.9971 18.9901C18.078 19.9143 16.9869 20.6474 15.786 21.1476C14.5851 21.6477 13.298 21.9051 11.9981 21.9051C9.37297 21.9051 6.85535 20.8566 4.99909 18.9901C3.14284 17.1236 2.10001 14.5922 2.10001 11.9526C2.10001 9.31299 3.14284 6.78151 4.99909 4.91504C6.85535 3.04857 9.37297 2 11.9981 2C13.298 2 14.5851 2.25743 15.786 2.7576C16.9869 3.25776 18.078 3.99086 18.9971 4.91504C19.9163 5.83923 20.6454 6.93639 21.1428 8.14389C21.6402 9.35139 21.8962 10.6456 21.8962 11.9526Z"
                        fill="url(#paint0_linear_2246_1378)" stroke="#CDCDCD" strokeWidth="0.351543"
                        strokeLinecap="round" strokeLinejoin="round"/>
                    <path
                        d="M21.1206 11.9525C21.1206 14.3853 20.1595 16.7184 18.4487 18.4386C16.7379 20.1588 14.4176 21.1252 11.9981 21.1252C9.57868 21.1252 7.25833 20.1588 5.54753 18.4386C3.83673 16.7184 2.87561 14.3853 2.87561 11.9525C2.87561 9.51979 3.83673 7.18668 5.54753 5.46647C7.25833 3.74625 9.57868 2.77985 11.9981 2.77985C14.4176 2.77985 16.7379 3.74625 18.4487 5.46647C20.1595 7.18668 21.1206 9.51979 21.1206 11.9525Z"
                        fill="url(#paint1_radial_2246_1378)"/>
                    <path
                        d="M11.9981 3.25818C11.9244 3.25818 11.8651 3.31782 11.8651 3.39191V4.93449C11.8651 5.00858 11.9244 5.06822 11.9981 5.06822C12.0718 5.06822 12.1311 5.00858 12.1311 4.93449V3.39191C12.1311 3.31782 12.0718 3.25818 11.9981 3.25818ZM11.128 3.31347C11.1192 3.31252 11.1101 3.31252 11.101 3.31359C11.0277 3.32127 10.9748 3.38679 10.9825 3.46048L11.0495 4.10582C11.0572 4.17952 11.1223 4.23265 11.1956 4.22496C11.2689 4.21727 11.3218 4.15175 11.3141 4.07806L11.2471 3.43272C11.2404 3.36824 11.1897 3.3195 11.128 3.31347ZM12.8743 3.31411C12.8126 3.32008 12.7619 3.36882 12.7551 3.4333L12.6876 4.07859C12.6799 4.15227 12.7328 4.21785 12.8061 4.22559C12.8793 4.23335 12.9445 4.18026 12.9522 4.10658L13.0197 3.46123C13.0274 3.38755 12.9746 3.32203 12.9013 3.31428C12.8921 3.31333 12.8831 3.31332 12.8743 3.31411ZM10.2342 3.4438C10.2254 3.44387 10.2164 3.44476 10.2074 3.44666C10.1353 3.46201 10.0895 3.53273 10.1048 3.60521L10.4225 5.11431C10.4378 5.1868 10.5081 5.2328 10.5802 5.21746C10.6523 5.20211 10.698 5.13144 10.6828 5.05896L10.365 3.54981C10.3517 3.48638 10.2962 3.44332 10.2342 3.4438ZM13.7681 3.44507C13.7061 3.44444 13.6506 3.48763 13.6372 3.55104L13.3184 5.05996C13.3031 5.13244 13.3488 5.20318 13.4208 5.21857C13.4929 5.23398 13.5633 5.18801 13.5786 5.11554L13.8974 3.60662C13.9127 3.53415 13.867 3.46341 13.7949 3.44801C13.7859 3.44611 13.7769 3.44507 13.7681 3.44507ZM9.38121 3.68564C9.36399 3.68405 9.34621 3.68596 9.32869 3.6918C9.25861 3.71471 9.2205 3.78982 9.24328 3.86028L9.44269 4.47741C9.46547 4.54787 9.54023 4.58619 9.61031 4.56329C9.68039 4.54038 9.71843 4.46522 9.69566 4.39475L9.49625 3.77763C9.47919 3.72478 9.43287 3.69006 9.38121 3.68564ZM14.6162 3.68596C14.5646 3.69037 14.5183 3.72511 14.5012 3.77796L14.3017 4.39502C14.2789 4.46548 14.317 4.54066 14.387 4.56356C14.4571 4.58647 14.5319 4.54818 14.5547 4.47774L14.7542 3.86061C14.777 3.79015 14.7389 3.71498 14.6688 3.69208C14.6513 3.68636 14.6335 3.6845 14.6162 3.68596ZM8.53768 3.99602C8.5204 3.99634 8.50291 4.00015 8.48608 4.00768C8.41879 4.03777 8.38865 4.11648 8.41858 4.18418L9.04168 5.59377C9.0716 5.66147 9.14988 5.69175 9.21721 5.66165C9.28451 5.63156 9.31471 5.55285 9.28478 5.48515L8.66162 4.07556C8.63918 4.02477 8.58952 3.99501 8.53768 3.99602ZM15.4693 4.00075C15.4175 3.9998 15.3678 4.02938 15.3453 4.08011L14.7203 5.48884C14.6902 5.55651 14.7202 5.63527 14.7875 5.66546C14.8548 5.69564 14.9332 5.66548 14.9632 5.59782L15.5882 4.18909C15.6182 4.12142 15.5882 4.04266 15.5209 4.01247C15.5041 4.00494 15.4866 4.00113 15.4693 4.00075ZM7.75472 4.41257C7.72919 4.41067 7.70288 4.41638 7.67895 4.4303C7.61513 4.46735 7.59343 4.54882 7.63027 4.61298L7.95293 5.17492C7.98977 5.23909 8.07079 5.26091 8.13461 5.22387C8.19842 5.18682 8.22013 5.10536 8.18329 5.04119L7.86062 4.47925C7.83759 4.43914 7.79728 4.41556 7.75472 4.41257ZM16.2415 4.41257C16.199 4.41543 16.1587 4.43913 16.1357 4.47924L15.813 5.04118C15.7761 5.10535 15.7979 5.18681 15.8617 5.22386C15.9255 5.2609 16.0065 5.23908 16.0434 5.17491L16.366 4.61297C16.4029 4.54881 16.3812 4.46734 16.3174 4.43029C16.2934 4.41641 16.2671 4.41079 16.2415 4.41257ZM6.99443 4.88938C6.96883 4.89033 6.9432 4.89859 6.92083 4.91489C6.86119 4.9584 6.84801 5.0417 6.89129 5.10167L7.7921 6.35029C7.83537 6.41026 7.91827 6.42352 7.97791 6.38002C8.03756 6.33652 8.05074 6.25322 8.00746 6.19325L7.10659 4.94463C7.07954 4.90715 7.03706 4.88792 6.99443 4.88938ZM17.0114 4.89618C16.9687 4.89459 16.9262 4.91381 16.8991 4.95124L15.9966 6.19865C15.9533 6.25856 15.9663 6.34189 16.0259 6.38548C16.0855 6.42907 16.1684 6.41595 16.2117 6.35606L17.1142 5.10866C17.1576 5.04874 17.1445 4.96541 17.0849 4.92182C17.0626 4.90549 17.0369 4.8971 17.0114 4.89618ZM6.31484 5.46245C6.28089 5.46055 6.24624 5.47195 6.21886 5.49674C6.16409 5.54631 6.15969 5.63052 6.209 5.68559L6.64078 6.16788C6.69008 6.22295 6.77384 6.22738 6.8286 6.1778C6.88337 6.12823 6.88777 6.04395 6.83846 5.98888L6.40674 5.50665C6.38209 5.4791 6.34879 5.46425 6.31484 5.46245ZM17.6824 5.4634C17.6484 5.46531 17.6151 5.48008 17.5905 5.50762L17.1587 5.98979C17.1094 6.04485 17.1138 6.12913 17.1685 6.1787C17.2233 6.22828 17.3071 6.22384 17.3564 6.16879L17.7882 5.68662C17.8375 5.63155 17.8331 5.54728 17.7783 5.49771C17.7509 5.47292 17.7163 5.46162 17.6824 5.4634ZM5.66349 6.09155C5.62954 6.09346 5.5963 6.10823 5.57165 6.13576C5.52235 6.19083 5.52676 6.27505 5.58151 6.32462L6.72169 7.35667C6.77646 7.40625 6.86021 7.40181 6.90951 7.34676C6.95881 7.2917 6.95446 7.20748 6.89968 7.1579L5.75945 6.12585C5.73205 6.10107 5.69745 6.08975 5.66349 6.09155ZM18.3369 6.09606C18.3029 6.09415 18.2683 6.10553 18.2409 6.13029L17.1 7.16154C17.0452 7.21107 17.0407 7.29529 17.0899 7.35039C17.1392 7.40549 17.223 7.40997 17.2778 7.36043L18.4187 6.32918C18.4735 6.27965 18.478 6.19543 18.4287 6.14033C18.4041 6.11278 18.3708 6.09788 18.3369 6.09606ZM5.12185 6.79186C5.07921 6.79027 5.03669 6.80958 5.00963 6.84703C4.96631 6.90697 4.97945 6.99026 5.03908 7.03381L5.56115 7.41521C5.62076 7.45876 5.70359 7.44562 5.7469 7.38566C5.79022 7.32572 5.77711 7.24238 5.71751 7.19883L5.19544 6.81743C5.1731 6.8011 5.14743 6.79278 5.12185 6.79186ZM18.878 6.79672C18.8524 6.79767 18.8268 6.8059 18.8044 6.82223L18.2821 7.20329C18.2225 7.2468 18.2093 7.33015 18.2526 7.39012C18.2958 7.45009 18.3787 7.4633 18.4383 7.4198L18.9607 7.03874C19.0203 6.99523 19.0335 6.91193 18.9902 6.85197C18.9631 6.81448 18.9207 6.79525 18.878 6.79672ZM4.61567 7.53886C4.57311 7.54172 4.53285 7.56542 4.50982 7.60552C4.47298 7.66968 4.49469 7.75115 4.5585 7.7882L5.88708 8.55949C5.95089 8.59653 6.03191 8.5747 6.06875 8.51054C6.1056 8.44638 6.08389 8.36491 6.02008 8.32786L4.6915 7.55657C4.66758 7.54269 4.64121 7.53708 4.61567 7.53886ZM19.3806 7.53886C19.3551 7.53695 19.3287 7.54267 19.3048 7.55659L17.9762 8.32788C17.9124 8.36492 17.8907 8.44639 17.9275 8.51055C17.9643 8.57472 18.0454 8.59654 18.1092 8.5595L19.4378 7.78821C19.5016 7.75117 19.5233 7.6697 19.4865 7.60553C19.4635 7.56543 19.4231 7.54185 19.3806 7.53886ZM4.23297 8.33508C4.18114 8.33381 4.13144 8.36364 4.10892 8.41438C4.07891 8.48205 4.1089 8.56082 4.1762 8.591L4.7656 8.85535C4.8329 8.88553 4.91124 8.85537 4.94126 8.78771C4.97128 8.72004 4.94122 8.64127 4.87393 8.61109L4.28458 8.34674C4.26777 8.33918 4.25025 8.33543 4.23297 8.33508ZM19.7659 8.34058C19.7486 8.34089 19.731 8.34471 19.7142 8.35224L19.1247 8.61612C19.0574 8.64627 19.0273 8.72499 19.0572 8.79268C19.0872 8.86037 19.1656 8.89063 19.2329 8.8605L19.8224 8.59655C19.8897 8.56643 19.9198 8.48768 19.8898 8.41999C19.8673 8.36923 19.8177 8.33954 19.7659 8.34058ZM3.89189 9.16727C3.84023 9.17163 3.79391 9.20632 3.77679 9.25916C3.75398 9.32961 3.79196 9.4048 3.86204 9.42775L5.32069 9.90566C5.39074 9.9286 5.46553 9.89038 5.48836 9.81995C5.51117 9.7495 5.47319 9.67431 5.40312 9.65135L3.94447 9.17345C3.92696 9.1677 3.9091 9.16581 3.89189 9.16727ZM20.1063 9.17299C20.0891 9.1714 20.0713 9.17331 20.0538 9.17916L18.5948 9.65603C18.5247 9.67893 18.4867 9.7541 18.5094 9.82456C18.5322 9.89502 18.607 9.93329 18.6771 9.91039L20.136 9.43352C20.2061 9.41061 20.2442 9.33544 20.2214 9.26498C20.2043 9.21214 20.158 9.1774 20.1063 9.17299ZM3.67938 10.0408C3.61742 10.0402 3.56185 10.0835 3.54845 10.1469C3.53312 10.2193 3.57885 10.2901 3.65091 10.3055L4.28217 10.4404C4.35424 10.4558 4.42458 10.4098 4.43991 10.3373C4.45523 10.2649 4.40951 10.1941 4.33744 10.1787L3.70625 10.0438C3.69724 10.0419 3.68823 10.0408 3.67938 10.0408ZM20.3172 10.0421C20.3083 10.0422 20.2994 10.0434 20.2904 10.045L19.6591 10.1798C19.587 10.1952 19.5413 10.2659 19.5566 10.3384C19.572 10.4108 19.6423 10.4568 19.7144 10.4414L20.3456 10.3066C20.4177 10.2912 20.4634 10.2205 20.4481 10.148C20.4347 10.0846 20.3791 10.0416 20.3172 10.0421ZM3.51854 10.9195C3.45686 10.9255 3.40609 10.9741 3.39932 11.0386C3.39158 11.1123 3.44429 11.1779 3.51756 11.1857L5.0432 11.3479C5.11648 11.3557 5.18172 11.3026 5.18947 11.2289C5.19721 11.1552 5.14444 11.0896 5.07116 11.0819L3.54552 10.9197C3.53636 10.9187 3.52736 10.9187 3.51854 10.9195ZM20.4791 10.9311C20.4703 10.9301 20.4613 10.9301 20.4521 10.9312L18.9263 11.0913C18.853 11.099 18.8002 11.1645 18.8078 11.2382C18.8155 11.3119 18.8806 11.365 18.9539 11.3573L20.4797 11.1972C20.553 11.1895 20.6058 11.124 20.5982 11.0503C20.5915 10.9858 20.5408 10.9371 20.4791 10.9311ZM3.49271 11.819C3.41902 11.819 3.35971 11.8787 3.35971 11.9528C3.35971 12.0268 3.41902 12.0865 3.49271 12.0865H4.13803C4.21171 12.0865 4.27109 12.0268 4.27109 11.9528C4.27109 11.8787 4.21171 11.819 4.13803 11.819H3.49271ZM19.8582 11.819C19.7845 11.819 19.7252 11.8787 19.7252 11.9528C19.7252 12.0268 19.7845 12.0865 19.8582 12.0865H20.5035C20.5772 12.0865 20.6365 12.0268 20.6365 11.9528C20.6365 11.8787 20.5772 11.819 20.5035 11.819H19.8582ZM5.06938 12.5481C5.06056 12.5471 5.05156 12.5471 5.0424 12.5482L3.51653 12.7083C3.44324 12.716 3.39041 12.7815 3.39805 12.8552C3.4057 12.9289 3.47085 12.982 3.54414 12.9743L5.07001 12.8142C5.14329 12.8065 5.19612 12.741 5.18848 12.6673C5.18178 12.6028 5.13105 12.5541 5.06938 12.5481ZM18.9261 12.5575C18.8644 12.5635 18.8136 12.6121 18.8068 12.6766C18.7991 12.7503 18.8518 12.8159 18.9251 12.8237L20.4507 12.9859C20.524 12.9936 20.5893 12.9406 20.597 12.8669C20.6047 12.7932 20.552 12.7276 20.4787 12.7198L18.9531 12.5576C18.9439 12.5567 18.9349 12.5567 18.9261 12.5575ZM4.3088 13.461C4.29995 13.4611 4.29095 13.4619 4.28194 13.4638L3.65069 13.5987C3.57861 13.6141 3.53292 13.6848 3.54822 13.7573C3.56355 13.8298 3.63389 13.8757 3.70597 13.8603L4.33722 13.7255C4.4093 13.7101 4.45499 13.6394 4.43968 13.5669C4.42628 13.5035 4.37076 13.4605 4.3088 13.461ZM19.6873 13.4623C19.6253 13.4616 19.5698 13.5048 19.5564 13.5682C19.5411 13.6407 19.5867 13.7114 19.6588 13.7268L20.2901 13.8617C20.3621 13.8771 20.4325 13.8312 20.4478 13.7588C20.4631 13.6863 20.4174 13.6155 20.3453 13.6001L19.7141 13.4652C19.7051 13.4633 19.6961 13.4623 19.6873 13.4623ZM5.37177 13.989C5.35455 13.9874 5.33677 13.9893 5.31925 13.9952L3.86026 14.472C3.79018 14.4949 3.75212 14.5701 3.7749 14.6406C3.79768 14.711 3.87244 14.7493 3.94252 14.7264L5.40145 14.2495C5.47153 14.2266 5.50965 14.1514 5.48687 14.081C5.46977 14.0281 5.42343 13.9934 5.37177 13.989ZM18.623 13.9937C18.5714 13.9981 18.5251 14.0328 18.508 14.0856C18.4851 14.1561 18.5231 14.2313 18.5932 14.2542L20.0518 14.7321C20.1219 14.7551 20.1967 14.7168 20.2195 14.6464C20.2424 14.576 20.2044 14.5008 20.1343 14.4778L18.6756 13.9999C18.6581 13.9942 18.6403 13.9923 18.623 13.9937ZM4.81503 15.0335C4.79775 15.0338 4.78025 15.0375 4.76342 15.0451L4.17385 15.309C4.10653 15.3391 4.07649 15.4179 4.10646 15.4856C4.13644 15.5532 4.21474 15.5835 4.28205 15.5533L4.87163 15.2894C4.93894 15.2593 4.96899 15.1806 4.93902 15.1129C4.91655 15.0621 4.86686 15.0324 4.81503 15.0335ZM19.1791 15.0385C19.1273 15.0373 19.0776 15.0671 19.0551 15.1179C19.025 15.1855 19.055 15.2643 19.1223 15.2945L19.7117 15.5588C19.779 15.589 19.8573 15.5588 19.8873 15.4912C19.9173 15.4235 19.8874 15.3447 19.8201 15.3146L19.2307 15.0502C19.2139 15.0426 19.1964 15.0389 19.1791 15.0385ZM5.9629 15.3283C5.93737 15.3264 5.91101 15.3322 5.88708 15.3461L4.5585 16.1174C4.49469 16.1544 4.47298 16.2359 4.50982 16.3C4.54667 16.3642 4.62769 16.386 4.6915 16.349L6.02008 15.5778C6.08389 15.5407 6.10559 15.4592 6.06875 15.395C6.04572 15.3549 6.00546 15.3313 5.9629 15.3283ZM18.0334 15.3283C17.9908 15.3312 17.9505 15.3549 17.9275 15.395C17.8907 15.4592 17.9124 15.5407 17.9762 15.5777L19.3048 16.349C19.3686 16.386 19.4496 16.3642 19.4865 16.3C19.5233 16.2359 19.5016 16.1544 19.4378 16.1174L18.1092 15.3461C18.0853 15.3322 18.0589 15.3266 18.0334 15.3283ZM5.63152 16.4602C5.60593 16.4612 5.5803 16.4694 5.55793 16.4858L5.03563 16.8668C4.97599 16.9103 4.96279 16.9936 5.00605 17.0536C5.04933 17.1136 5.13217 17.1268 5.19181 17.0833L5.71417 16.7023C5.77381 16.6588 5.787 16.5755 5.74374 16.5155C5.71669 16.478 5.67416 16.4587 5.63152 16.4602ZM18.3616 16.4647C18.3189 16.4631 18.2764 16.4824 18.2494 16.5199C18.206 16.5798 18.2192 16.6632 18.2788 16.7067L18.8009 17.0881C18.8605 17.1317 18.9433 17.1185 18.9866 17.0585C19.0299 16.9986 19.0168 16.9153 18.9572 16.8717L18.4352 16.4903C18.4128 16.474 18.3872 16.4656 18.3616 16.4647ZM6.81447 16.5109C6.78052 16.509 6.74589 16.5204 6.71849 16.5451L5.57756 17.5764C5.52277 17.6259 5.51831 17.7101 5.56758 17.7652C5.61684 17.8203 5.7006 17.8248 5.7554 17.7753L6.89633 16.744C6.95112 16.6945 6.95558 16.6103 6.90631 16.5552C6.8817 16.5276 6.84842 16.5127 6.81447 16.5109ZM17.1786 16.5146C17.1447 16.5165 17.1114 16.5312 17.0867 16.5588C17.0374 16.6138 17.0418 16.6981 17.0966 16.7476L18.2368 17.7797C18.2915 17.8293 18.3754 17.8248 18.4247 17.7698C18.474 17.7147 18.4695 17.6305 18.4148 17.5809L17.2745 16.5489C17.2472 16.5241 17.2126 16.5128 17.1786 16.5146ZM7.89685 17.4943C7.85421 17.4927 7.81166 17.5119 7.78457 17.5493L6.88209 18.7967C6.83874 18.8567 6.85179 18.94 6.91135 18.9836C6.97093 19.0272 7.05381 19.014 7.09716 18.9541L7.99964 17.7067C8.04298 17.6468 8.02994 17.5635 7.97038 17.5199C7.94804 17.5036 7.92243 17.4952 7.89685 17.4943ZM16.092 17.4999C16.0664 17.5008 16.0408 17.5091 16.0184 17.5254C15.9588 17.5689 15.9456 17.6522 15.9888 17.7122L16.8897 18.9608C16.9329 19.0207 17.0158 19.034 17.0754 18.9905C17.135 18.947 17.1482 18.8637 17.105 18.8037L16.2042 17.5551C16.1771 17.5176 16.1346 17.4984 16.092 17.4999ZM6.73181 17.6925C6.69786 17.6944 6.66456 17.7092 6.63991 17.7367L6.20813 18.2189C6.15882 18.274 6.16318 18.3583 6.21795 18.4078C6.27271 18.4574 6.35647 18.453 6.40577 18.3979L6.83761 17.9157C6.88692 17.8607 6.8825 17.7764 6.82775 17.7268C6.80035 17.702 6.76576 17.6907 6.73181 17.6925ZM17.2636 17.6932C17.2297 17.6913 17.1951 17.7027 17.1677 17.7275C17.113 17.777 17.1086 17.8612 17.1578 17.9163L17.5896 18.3986C17.6389 18.4537 17.7226 18.4581 17.7774 18.4085C17.8321 18.3589 17.8366 18.2747 17.7872 18.2196L17.3555 17.7374C17.3309 17.7098 17.2976 17.695 17.2636 17.6932ZM9.15711 18.2281C9.10528 18.2268 9.05564 18.2567 9.03313 18.3074L8.40807 19.7161C8.37805 19.7838 8.40805 19.8626 8.47535 19.8928C8.54264 19.9229 8.62098 19.8928 8.651 19.8251L9.27605 18.4164C9.30607 18.3487 9.27607 18.2699 9.20877 18.2398C9.19196 18.2322 9.17439 18.2284 9.15711 18.2281ZM14.8307 18.232C14.8134 18.2323 14.7959 18.236 14.779 18.2436C14.7117 18.2737 14.6816 18.3524 14.7115 18.4201L15.3346 19.8297C15.3646 19.8973 15.4429 19.9276 15.5102 19.8975C15.5775 19.8675 15.6077 19.7887 15.5777 19.721L14.9546 18.3114C14.9322 18.2607 14.8825 18.231 14.8307 18.232ZM8.05878 18.6636C8.01622 18.6665 7.97595 18.6902 7.95293 18.7303L7.63027 19.2923C7.59343 19.3564 7.61513 19.4379 7.67895 19.4749C7.74276 19.512 7.82378 19.4902 7.86062 19.426L8.18329 18.864C8.22013 18.7999 8.19842 18.7184 8.13461 18.6814C8.11069 18.6675 8.08431 18.6619 8.05878 18.6636ZM15.9375 18.6636C15.9119 18.6617 15.8856 18.6675 15.8617 18.6814C15.7979 18.7184 15.7762 18.7999 15.813 18.8641L16.1357 19.426C16.1725 19.4902 16.2536 19.512 16.3174 19.4749C16.3812 19.4379 16.4029 19.3564 16.366 19.2923L16.0434 18.7303C16.0203 18.6902 15.98 18.6666 15.9375 18.6636ZM10.5486 18.6838C10.4866 18.6832 10.4311 18.7263 10.4177 18.7898L10.0989 20.2987C10.0836 20.3712 10.1293 20.4419 10.2014 20.4573C10.2735 20.4727 10.3438 20.4267 10.3591 20.3543L10.6779 18.8453C10.6933 18.7729 10.6475 18.7021 10.5755 18.6867C10.5665 18.6848 10.5575 18.6838 10.5486 18.6838ZM13.4429 18.6847C13.4341 18.6848 13.4252 18.6857 13.4161 18.6876C13.3441 18.703 13.2983 18.7736 13.3136 18.8461L13.6313 20.3553C13.6466 20.4277 13.7169 20.4737 13.789 20.4584C13.8611 20.4431 13.9068 20.3723 13.8916 20.2998L13.5738 18.7908C13.5604 18.7274 13.5049 18.6843 13.4429 18.6847ZM11.9981 18.8369C11.9244 18.8369 11.8651 18.8966 11.8651 18.9707V20.5133C11.8651 20.5873 11.9244 20.647 11.9981 20.647C12.0718 20.647 12.1311 20.5873 12.1311 20.5133V18.9707C12.1311 18.8966 12.0718 18.8369 11.9981 18.8369ZM9.55669 19.3354C9.50504 19.3398 9.45868 19.3746 9.4416 19.4274L9.24213 20.0445C9.21934 20.115 9.25742 20.1902 9.32748 20.2131C9.39756 20.236 9.47232 20.1976 9.4951 20.1272L9.69457 19.5101C9.71735 19.4397 9.67928 19.3645 9.60921 19.3416C9.59171 19.3359 9.57391 19.3339 9.55669 19.3354ZM14.4385 19.3357C14.4213 19.3341 14.4035 19.336 14.386 19.3419C14.3159 19.3648 14.2778 19.4399 14.3006 19.5104L14.5 20.1275C14.5228 20.198 14.5975 20.2362 14.6676 20.2133C14.7377 20.1904 14.7758 20.1153 14.753 20.0449L14.5536 19.4277C14.5365 19.3749 14.4902 19.3401 14.4385 19.3357ZM11.1633 19.6794C11.1016 19.6854 11.0508 19.7341 11.044 19.7986L10.9766 20.4439C10.9689 20.5176 11.0217 20.5831 11.095 20.5909C11.1682 20.5986 11.2335 20.5455 11.2412 20.4718L11.3086 19.8266C11.3163 19.7529 11.2635 19.6873 11.1903 19.6795C11.1811 19.6786 11.1721 19.6786 11.1633 19.6794ZM12.8276 19.6801C12.8188 19.6791 12.8098 19.6791 12.8006 19.6802C12.7273 19.6879 12.6745 19.7534 12.6821 19.8271L12.7492 20.4725C12.7568 20.5462 12.822 20.5992 12.8953 20.5915C12.9685 20.5839 13.0214 20.5183 13.0137 20.4447L12.9467 19.7993C12.94 19.7348 12.8893 19.6861 12.8276 19.6801Z"
                        fill="#F4F2F3"/>
                    <g opacity="0.409" filter="url(#filter0_f_2246_1378)">
                        <path d="M18.2317 6.60321L10.9549 10.8543L6.35403 18.1372L13.0848 13.1244L18.2317 6.60321Z"
                              fill="black"/>
                    </g>
                    <path d="M13.041 13.0507L10.9552 10.8544L18.3542 5.84973L13.041 13.0507Z" fill="#FF5150"/>
                    <path d="M13.041 13.0507L10.9552 10.8544L5.642 18.0554L13.041 13.0507Z" fill="#F1F1F1"/>
                    <path opacity="0.243" d="M5.642 18.0554L13.041 13.0507L18.3542 5.84973L5.642 18.0554Z"
                          fill="black"/>
                    <defs>
                        <filter id="filter0_f_2246_1378" x="3.8092" y="4.05837" width="16.9673" height="16.6237"
                                filterUnits="userSpaceOnUse" colorInterpolationFilters="sRGB">
                            <feFlood floodOpacity="0" result="BackgroundImageFix"/>
                            <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/>
                            <feGaussianBlur stdDeviation="1.27242" result="effect1_foregroundBlur_2246_1378"/>
                        </filter>
                        <linearGradient id="paint0_linear_2246_1378" x1="11.9978" y1="21.9049" x2="11.9978" y2="1.99995"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#BDBDBD"/>
                            <stop offset="1" stopColor="white"/>
                        </linearGradient>
                        <radialGradient id="paint1_radial_2246_1378" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
                                        gradientTransform="translate(12.0392 10.615) scale(9.89808 9.95254)">
                            <stop stopColor="#06C2E7"/>
                            <stop offset="0.25" stopColor="#0DB8EC"/>
                            <stop offset="0.5" stopColor="#12AEF1"/>
                            <stop offset="0.75" stopColor="#1F86F9"/>
                            <stop offset="1" stopColor="#107DDD"/>
                        </radialGradient>
                    </defs>
                </symbol>
                <symbol
                    id="lbaic-settings-browser-microsoft-edge"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <g clipPath="url(#clip0_2246_1388)">
                        <path
                            d="M21.6656 17.8594C21.3438 18.0266 21.0119 18.1738 20.6719 18.3C19.5952 18.7007 18.4551 18.904 17.3063 18.9C12.8719 18.9 9.00938 15.8531 9.00938 11.9344C9.01514 11.4096 9.16063 10.8959 9.43086 10.4461C9.70109 9.99623 10.0863 9.62652 10.5469 9.375C6.53438 9.54375 5.50313 13.725 5.50313 16.1719C5.50313 23.1094 11.8875 23.8031 13.2656 23.8031C14.0063 23.8031 15.1219 23.5875 15.7969 23.3719L15.9188 23.3344C18.5019 22.4417 20.7041 20.6958 22.1625 18.3844C22.2049 18.3141 22.2231 18.232 22.2143 18.1504C22.2055 18.0688 22.1702 17.9924 22.1138 17.9328C22.0574 17.8733 21.9831 17.8338 21.9021 17.8205C21.8212 17.8073 21.7381 17.8209 21.6656 17.8594Z"
                            fill="url(#paint0_linear_2246_1388)"/>
                        <path opacity="0.35"
                              d="M21.6656 17.8594C21.3438 18.0266 21.0119 18.1738 20.6719 18.3C19.5952 18.7007 18.4551 18.904 17.3063 18.9C12.8719 18.9 9.00938 15.8531 9.00938 11.9344C9.01514 11.4096 9.16063 10.8959 9.43086 10.4461C9.70109 9.99623 10.0863 9.62652 10.5469 9.375C6.53438 9.54375 5.50313 13.725 5.50313 16.1719C5.50313 23.1094 11.8875 23.8031 13.2656 23.8031C14.0063 23.8031 15.1219 23.5875 15.7969 23.3719L15.9188 23.3344C18.5019 22.4417 20.7041 20.6958 22.1625 18.3844C22.2049 18.3141 22.2231 18.232 22.2143 18.1504C22.2055 18.0688 22.1702 17.9924 22.1138 17.9328C22.0574 17.8733 21.9831 17.8338 21.9021 17.8205C21.8212 17.8073 21.7381 17.8209 21.6656 17.8594Z"
                              fill="url(#paint1_radial_2246_1388)"/>
                        <path
                            d="M9.90938 22.6219C9.07489 22.1036 8.35155 21.4249 7.78125 20.625C7.13001 19.7336 6.68173 18.7105 6.46787 17.6275C6.25401 16.5445 6.27975 15.4278 6.54329 14.3558C6.80683 13.2837 7.30178 12.2824 7.9934 11.4219C8.68503 10.5615 9.55658 9.86286 10.5469 9.37502C10.8469 9.2344 11.3438 8.99065 12.0094 9.00002C12.4778 9.00365 12.939 9.11555 13.3569 9.32697C13.7749 9.53839 14.1383 9.84361 14.4188 10.2188C14.796 10.726 15.0027 11.3398 15.0094 11.9719C15.0094 11.9531 17.3063 4.5094 7.50938 4.5094C3.39375 4.5094 0.00937849 8.4094 0.00937849 11.8407C-0.00699164 13.6532 0.380514 15.4466 1.14375 17.0907C2.3937 19.7522 4.57738 21.8622 7.28028 23.0201C9.98319 24.178 13.0172 24.3032 15.8063 23.3719C14.8291 23.6805 13.7966 23.7733 12.7801 23.6438C11.7636 23.5143 10.7873 23.1656 9.91875 22.6219H9.90938Z"
                            fill="url(#paint2_linear_2246_1388)"/>
                        <path opacity="0.41"
                              d="M9.90938 22.6219C9.07489 22.1036 8.35155 21.4249 7.78125 20.625C7.13001 19.7336 6.68173 18.7105 6.46787 17.6275C6.25401 16.5445 6.27975 15.4278 6.54329 14.3558C6.80683 13.2837 7.30178 12.2824 7.9934 11.4219C8.68503 10.5615 9.55658 9.86286 10.5469 9.37502C10.8469 9.2344 11.3438 8.99065 12.0094 9.00002C12.4778 9.00365 12.939 9.11555 13.3569 9.32697C13.7749 9.53839 14.1383 9.84361 14.4188 10.2188C14.796 10.726 15.0027 11.3398 15.0094 11.9719C15.0094 11.9531 17.3063 4.5094 7.50938 4.5094C3.39375 4.5094 0.00937849 8.4094 0.00937849 11.8407C-0.00699164 13.6532 0.380514 15.4466 1.14375 17.0907C2.3937 19.7522 4.57738 21.8622 7.28028 23.0201C9.98319 24.178 13.0172 24.3032 15.8063 23.3719C14.8291 23.6805 13.7966 23.7733 12.7801 23.6438C11.7636 23.5143 10.7873 23.1656 9.91875 22.6219H9.90938Z"
                              fill="url(#paint3_radial_2246_1388)"/>
                        <path
                            d="M14.2875 13.95C14.2031 14.0438 13.9688 14.1844 13.9688 14.475C13.9688 14.7187 14.1281 14.9625 14.4187 15.1594C15.7594 16.0969 18.3 15.9656 18.3094 15.9656C19.3088 15.965 20.2898 15.6963 21.15 15.1875C22.0161 14.6809 22.7347 13.9568 23.2346 13.0869C23.7345 12.2169 23.9984 11.2315 24 10.2281C24.0281 8.12812 23.25 6.73125 22.9406 6.1125C20.9437 2.23125 16.6594 5.87477e-08 12 5.87477e-08C8.84643 -0.000311772 5.81948 1.24078 3.57383 3.45485C1.32818 5.66892 0.0443471 8.67799 0 11.8312C0.046875 8.40937 3.45 5.64375 7.5 5.64375C7.82812 5.64375 9.70312 5.67187 11.4375 6.58125C12.656 7.18674 13.665 8.14353 14.3344 9.32812C14.9062 10.3219 15.0094 11.5875 15.0094 12.0938C15.0094 12.6 14.7562 13.3406 14.2781 13.9594L14.2875 13.95Z"
                            fill="url(#paint4_radial_2246_1388)"/>
                        <path
                            d="M14.2875 13.95C14.2031 14.0438 13.9688 14.1844 13.9688 14.475C13.9688 14.7187 14.1281 14.9625 14.4187 15.1594C15.7594 16.0969 18.3 15.9656 18.3094 15.9656C19.3088 15.965 20.2898 15.6963 21.15 15.1875C22.0161 14.6809 22.7347 13.9568 23.2346 13.0869C23.7345 12.2169 23.9984 11.2315 24 10.2281C24.0281 8.12812 23.25 6.73125 22.9406 6.1125C20.9437 2.23125 16.6594 5.87477e-08 12 5.87477e-08C8.84643 -0.000311772 5.81948 1.24078 3.57383 3.45485C1.32818 5.66892 0.0443471 8.67799 0 11.8312C0.046875 8.40937 3.45 5.64375 7.5 5.64375C7.82812 5.64375 9.70312 5.67187 11.4375 6.58125C12.656 7.18674 13.665 8.14353 14.3344 9.32812C14.9062 10.3219 15.0094 11.5875 15.0094 12.0938C15.0094 12.6 14.7562 13.3406 14.2781 13.9594L14.2875 13.95Z"
                            fill="url(#paint5_radial_2246_1388)"/>
                    </g>
                    <defs>
                        <linearGradient id="paint0_linear_2246_1388" x1="5.50313" y1="16.5937" x2="22.2281" y2="16.5937"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#0C59A4"/>
                            <stop offset="1" stopColor="#114A8B"/>
                        </linearGradient>
                        <radialGradient id="paint1_radial_2246_1388" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
                                        gradientTransform="translate(14.7375 16.7198) scale(8.94375 8.49656)">
                            <stop offset="0.7" stopOpacity="0"/>
                            <stop offset="0.9" stopOpacity="0.5"/>
                            <stop offset="1"/>
                        </radialGradient>
                        <linearGradient id="paint2_linear_2246_1388" x1="14.3156" y1="9.33752" x2="3.88125" y2="20.7094"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#1B9DE2"/>
                            <stop offset="0.2" stopColor="#1595DF"/>
                            <stop offset="0.7" stopColor="#0680D7"/>
                            <stop offset="1" stopColor="#0078D4"/>
                        </linearGradient>
                        <radialGradient id="paint3_radial_2246_1388" cx="0" cy="0" r="1"
                                        gradientTransform="matrix(2.01375 -13.2908 -10.74 -1.611 6.61454 18.6504)"
                                        gradientUnits="userSpaceOnUse">
                            <stop offset="0.8" stopOpacity="0"/>
                            <stop offset="0.9" stopOpacity="0.5"/>
                            <stop offset="1"/>
                        </radialGradient>
                        <radialGradient id="paint4_radial_2246_1388" cx="0" cy="0" r="1"
                                        gradientTransform="matrix(-0.759 18.975 40.4168 1.518 2.42719 4.43587)"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#35C1F1"/>
                            <stop offset="0.1" stopColor="#34C1ED"/>
                            <stop offset="0.2" stopColor="#2FC2DF"/>
                            <stop offset="0.3" stopColor="#2BC3D2"/>
                            <stop offset="0.7" stopColor="#36C752"/>
                        </radialGradient>
                        <radialGradient id="paint5_radial_2246_1388" cx="0" cy="0" r="1"
                                        gradientTransform="matrix(2.55413 8.757 7.11506 -2.09803 22.5056 7.24687)"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#66EB6E"/>
                            <stop offset="1" stopColor="#66EB6E" stopOpacity="0"/>
                        </radialGradient>
                        <clipPath id="clip0_2246_1388">
                            <rect width="24" height="24" fill="white"/>
                        </clipPath>
                    </defs>
                </symbol>
                <symbol
                    id="lbaic-settings-browser-opera"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <path
                        d="M11.9998 2.00044C6.47706 2.00044 2 6.47751 2 12.0002C2 17.3631 6.22201 21.74 11.5235 21.9883C11.6817 21.9958 11.8402 22 11.9999 22C14.5601 22 16.895 21.0373 18.6642 19.4552C17.492 20.2326 16.1216 20.6798 14.657 20.6798C12.2756 20.6798 10.1429 19.4985 8.70851 17.6355C7.60277 16.3303 6.8866 14.4009 6.83781 12.2356V11.7647C6.88657 9.59944 7.60273 7.66966 8.70822 6.36474C10.1428 4.50177 12.2755 3.3204 14.6567 3.3204C16.1216 3.3204 17.4923 3.76769 18.6646 4.54555C16.9041 2.97066 14.5833 2.00995 12.0374 2.0005C12.0247 2.0005 12.0122 2 11.9995 2L11.9998 2.00044Z"
                        fill="url(#paint0_linear_2246_1395)"/>
                    <path
                        d="M8.70837 6.36536C9.62604 5.28202 10.8112 4.62875 12.1059 4.62875C15.0172 4.62875 17.3767 7.92931 17.3767 12.0007C17.3767 16.0721 15.017 19.3726 12.1059 19.3726C10.8112 19.3726 9.62604 18.7196 8.70861 17.6363C10.143 19.4992 12.2755 20.6806 14.6571 20.6806C16.1218 20.6806 17.4922 20.2333 18.6643 19.4559C20.7111 17.6248 21.9999 14.9634 21.9999 12.0008C21.9999 9.03851 20.7113 6.37717 18.665 4.54627C17.4926 3.7684 16.1219 3.32112 14.6571 3.32112C12.2758 3.32112 10.1427 4.50239 8.70837 6.36536Z"
                        fill="url(#paint1_linear_2246_1395)"/>
                    <defs>
                        <linearGradient id="paint0_linear_2246_1395" x1="10.3325" y1="2.32641" x2="10.3325" y2="21.7093"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#FF1B2D"/>
                            <stop offset="0.3" stopColor="#FF1B2D"/>
                            <stop offset="0.614" stopColor="#FF1B2D"/>
                            <stop offset="1" stopColor="#A70014"/>
                        </linearGradient>
                        <linearGradient id="paint1_linear_2246_1395" x1="15.3539" y1="3.46907" x2="15.3539" y2="20.6122"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="#9C0000"/>
                            <stop offset="0.7" stopColor="#FF4B4B"/>
                            <stop offset="1" stopColor="#FF4B4B"/>
                        </linearGradient>
                    </defs>
                </symbol>
                <symbol
                    id="lbaic-settings-browser-brave"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <path
                        d="M20.5703 8.44531L19.9453 6.76562L20.375 5.78906C20.4141 5.67188 20.4141 5.51562 20.2969 5.4375L19.125 4.26562C18.8748 4.01421 18.5597 3.83724 18.2149 3.75447C17.87 3.6717 17.5089 3.68638 17.1719 3.79687L16.8594 3.91406L15.0625 2L8.96875 2.03906L7.17188 3.99219L6.85938 3.875C6.23438 3.60156 5.45312 3.79687 4.94531 4.30469L3.77344 5.51562C3.69531 5.59375 3.69531 5.71094 3.73437 5.78906L4.16406 6.80469L3.53906 8.48438L5.72656 16.8828C5.93784 17.6746 6.42206 18.3664 7.09375 18.8359C7.09375 18.8359 9.28125 20.3984 11.4688 21.8047C11.6641 21.9219 11.8594 22 12.0547 22C12.2651 21.9948 12.4692 21.9268 12.6406 21.8047L17.0156 18.8359C17.6759 18.3551 18.157 17.6678 18.3828 16.8828L20.1797 10.0078L20.5703 8.44531Z"
                        fill="#FF5000"/>
                    <path opacity="0.15"
                          d="M5.80469 17.1563L3.5 8.60159L4.16406 6.9219L3.69531 5.6719L4.82812 4.57815C5.17969 4.26565 5.92188 4.14846 6.23438 4.34378L7.99219 5.3594L10.2578 5.86721L12.0156 5.12503L12.1719 20.2813C12.1328 22.4688 12.2891 22.2344 10.6875 21.2188L6.70312 18.5235C6.27344 18.1328 5.96094 17.6641 5.80469 17.1563Z"
                          fill="url(#paint0_linear_2251_285)"/>
                    <path
                        d="M12.5625 14.3828C12.4062 14.3047 12.25 14.2656 12.2109 14.2656H11.9766C11.9375 14.2656 11.7812 14.3047 11.625 14.3828L11.0781 14.6172L10.4531 14.8906L9.47656 15.3984C9.32031 15.4766 9.32031 15.6328 9.4375 15.75L10.2969 16.375L11.0781 17C11.2344 17.1172 11.4297 17.3125 11.5859 17.4297L11.8203 17.625C11.8927 17.682 11.9821 17.713 12.0742 17.713C12.1663 17.713 12.2558 17.682 12.3281 17.625L12.5625 17.4297C12.7187 17.3125 12.9141 17.1172 13.0703 17L13.3047 16.8047L13.8516 16.375L14.7109 15.75C14.8672 15.6328 14.8672 15.4766 14.6719 15.3984L13.6953 14.8906L13.0703 14.6172L12.5625 14.3828ZM18.6562 8.83594L18.6953 8.75781C18.6953 8.64062 18.6953 8.48437 18.6562 8.40625C18.6562 8.32812 18.4219 7.97656 18.3437 7.82031L17.7969 7L17.4062 6.45312L16.6641 5.51562C16.5469 5.35937 16.4297 5.24219 16.4297 5.24219L16.0781 5.32031L14.9453 5.55469L14.4375 5.63281C14.3203 5.63281 14.125 5.63281 13.9297 5.55469L13.0312 5.24219C12.8359 5.20312 12.5625 5.08594 12.3672 5.04688H11.8203C11.625 5.08594 11.3516 5.16406 11.1562 5.24219L10.2578 5.55469L9.75 5.63281C9.67187 5.63281 9.4375 5.55469 9.24218 5.55469L8.10937 5.32031L7.75781 5.24219C7.75781 5.24219 7.64062 5.35937 7.52343 5.51562L6.78125 6.41406C6.66406 6.57031 6.46875 6.80469 6.39062 6.96094L5.84375 7.78125C5.74233 7.91768 5.65095 8.06129 5.57031 8.21094C5.53125 8.28906 5.49218 8.64062 5.49218 8.71875L5.53125 8.79687L5.57031 8.95312C5.6875 9.10937 5.88281 9.34375 6 9.46094L7.95312 11.5312C8.07031 11.6484 8.10937 11.9219 8.07031 12.0781L7.75781 12.8203C7.67968 12.9766 7.67968 13.2891 7.75781 13.4453L7.83593 13.6406C7.95312 13.9141 8.10937 14.1875 8.34375 14.3828L8.65625 14.6172C8.8125 14.7344 9.04687 14.7734 9.20312 14.6953L10.2969 14.1875C10.4931 14.0935 10.6768 13.9754 10.8437 13.8359L11.7031 13.0547C11.8594 12.9375 11.8594 12.7031 11.7031 12.5469L9.71093 11.2188C9.55468 11.1016 9.51562 10.9062 9.59375 10.75L10.375 9.30469C10.4531 9.14844 10.4922 8.875 10.4141 8.71875C10.3359 8.5625 10.1406 8.40625 9.98437 8.32812L7.5625 7.42969C7.40625 7.35156 7.40625 7.3125 7.60156 7.27344L9.00781 7.15625C9.20312 7.15625 9.47656 7.15625 9.67187 7.23437L10.9219 7.58594C11.1172 7.625 11.2344 7.82031 11.1953 8.01562L10.7266 10.6328C10.6875 10.8281 10.6875 11.0234 10.6875 11.0625C10.7266 11.1406 10.8828 11.2188 11.0391 11.2578L11.7812 11.4141C11.9766 11.4531 12.25 11.4531 12.4453 11.4141L13.1094 11.2578C13.3047 11.2188 13.4609 11.1406 13.4609 11.0625C13.4609 10.9844 13.4609 10.7891 13.4219 10.6328L12.9531 7.97656C12.9141 7.78125 13.0312 7.58594 13.2266 7.54687L14.4375 7.19531C14.6328 7.15625 14.9062 7.11719 15.1016 7.11719L16.5078 7.23437C16.7031 7.23437 16.7031 7.3125 16.5469 7.39062L14.125 8.28906C13.9687 8.36719 13.7734 8.52344 13.6953 8.67969C13.6172 8.83594 13.6562 9.07031 13.7344 9.26562L14.5156 10.7109C14.5937 10.8672 14.5547 11.1016 14.3984 11.1797L12.4453 12.5859C12.2891 12.7422 12.3281 12.9766 12.4453 13.0937L13.3047 13.875C13.4778 14.0058 13.6607 14.1234 13.8516 14.2266L14.9453 14.7344C15.1016 14.8125 15.375 14.7734 15.4922 14.6562L15.8047 14.4219C16.0391 14.2266 16.2344 13.9922 16.3125 13.6797L16.3906 13.4844C16.4687 13.3281 16.4297 13.0156 16.3906 12.8594L16.0781 12.1172C16 11.9609 16.0391 11.6875 16.1953 11.5703L18.1484 9.5C18.2656 9.38281 18.4609 9.14844 18.5781 8.99219C18.6172 8.99219 18.6172 8.99219 18.6562 8.83594Z"
                        fill="white"/>
                    <path opacity="0.07"
                          d="M17.0156 18.7969L13.6562 21.1016C12.7187 21.6094 12.25 22.1172 12.1719 21.8828C12.0937 21.6875 12.1719 21.1407 12.1328 20.2422L12.0937 5.39847C12.0937 5.24222 12.2109 5.00785 12.3672 5.04691L14.0859 5.55472L16.5469 5.1641L18.2266 3.99222C18.4219 3.87504 18.6562 3.87504 18.8125 4.03129L20.2578 5.43754C20.375 5.59379 20.4141 5.86722 20.3359 6.02347L19.9453 6.76566L20.6094 8.52347L18.3047 17.1563C17.9531 18.1719 17.4453 18.4453 17.0156 18.7969Z"
                          fill="black"/>
                    <defs>
                        <linearGradient id="paint0_linear_2251_285" x1="3.66797" y1="12.9883" x2="12.2617" y2="12.9883"
                                        gradientUnits="userSpaceOnUse">
                            <stop stopColor="white"/>
                            <stop offset="0.2" stopColor="white"/>
                            <stop offset="1" stopColor="white" stopOpacity="0.7"/>
                        </linearGradient>
                    </defs>
                </symbol>
                <symbol
                    id="lbaic-settings-browser-yandex"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <path d="M22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22C17.5228 22 22 17.5228 22 12Z" fill="white"/>
                    <path d="M21.8438 12C21.8438 6.56345 17.4366 2.15625 12 2.15625C6.56345 2.15625 2.15625 6.56345 2.15625 12C2.15625 17.4366 6.56345 21.8438 12 21.8438C17.4366 21.8438 21.8438 17.4366 21.8438 12Z" stroke="black" strokeOpacity="0.1"/>
                    <path fillRule="evenodd" clipRule="evenodd" d="M18.5293 8.07016C18.5 7.99385 18.4492 7.90103 18.383 7.80053C18.2508 7.59835 18.0511 7.35035 17.8298 7.11632V7.11507C17.5933 6.87722 17.3516 6.67119 17.1558 6.53513C17.0578 6.46772 16.9688 6.41432 16.8951 6.38507C16.8582 6.36978 16.8213 6.35963 16.7857 6.35707C16.7513 6.35453 16.7081 6.36088 16.675 6.39394L12.089 10.8605C12.0382 10.9101 11.9555 10.9101 11.9046 10.8605L7.3186 6.39394C7.28553 6.36216 7.24228 6.35582 7.20797 6.35707C7.17363 6.35963 7.13547 6.36978 7.0986 6.38507C7.02481 6.41432 6.93453 6.46772 6.83788 6.53513C6.64203 6.67119 6.40038 6.8785 6.16385 7.11507V7.11632C5.94253 7.35035 5.74288 7.59835 5.61063 7.80053C5.54447 7.90103 5.49235 7.99385 5.46435 8.07016C5.45038 8.10832 5.44019 8.14647 5.43766 8.18082C5.43638 8.21516 5.44275 8.25966 5.47706 8.29272L10.6011 13.2794C10.6468 13.3239 10.6723 13.3849 10.6723 13.4485L10.6672 19.548C10.6672 19.5938 10.6939 19.6282 10.7168 19.6498C10.7409 19.6727 10.7728 19.6917 10.8083 19.7083C10.8796 19.7426 10.9775 19.7744 11.0932 19.8011C11.3272 19.8545 11.6464 19.8927 12 19.8927C12.3536 19.8927 12.6728 19.8545 12.9068 19.8011C13.0225 19.7744 13.1204 19.7426 13.1917 19.7083C13.2273 19.6917 13.2591 19.6714 13.2832 19.6498C13.3061 19.6282 13.3328 19.5938 13.3328 19.548L13.3277 13.4485C13.3277 13.3849 13.3532 13.3239 13.3989 13.2794L18.5229 8.29272C18.5573 8.25966 18.5636 8.21516 18.5623 8.18082C18.5611 8.14519 18.5496 8.10703 18.5357 8.07016H18.5293Z" fill="url(#paint0_linear_2256_2)"/>
                    <defs>
                        <linearGradient id="paint0_linear_2256_2" x1="5.4375" y1="13.3804" x2="18.439" y2="12.2566" gradientUnits="userSpaceOnUse">
                            <stop offset="0.3" stopColor="#FF6A16"/>
                            <stop offset="0.542948" stopColor="#FF3227"/>
                            <stop offset="0.89" stopColor="#FF66DD"/>
                        </linearGradient>
                    </defs>
                </symbol>
                <symbol
                    id="lbaic-settings-browser-samsung"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <path d="M21.8115 9.01742C21.5641 7.16015 20.9072 5.47725 19.7515 4.24448C18.5187 3.08875 16.8358 2.43181 14.9785 2.18445C13.2064 1.94925 11.998 2.00602 11.998 2.00602C11.998 2.00602 10.7895 1.94925 9.01742 2.18445C7.16015 2.43181 5.47725 3.08875 4.24853 4.24448C3.08875 5.47725 2.43181 7.16015 2.18445 9.01742C1.94925 10.7895 2.00602 11.998 2.00602 11.998C2.00602 11.998 1.94925 13.2064 2.18445 14.9785C2.43181 16.8358 3.08875 18.5187 4.24448 19.7515C5.47725 20.9113 7.16015 21.5682 9.01336 21.8156C10.7855 22.0508 11.9939 21.994 11.9939 21.994C11.9939 21.994 13.2024 22.0508 14.9745 21.8156C16.8317 21.5682 18.5146 20.9113 19.7434 19.7515C20.9031 18.5187 21.5601 16.8358 21.8034 14.9785C22.0386 13.2064 21.9818 11.998 21.9818 11.998C21.9818 11.998 22.0467 10.7895 21.8115 9.01742Z" fill="#7882FF"/>
                    <path d="M17.1156 10.5178C17.9064 13.3565 16.2437 16.3005 13.4051 17.0913C10.5665 17.882 7.62244 16.2194 6.83168 13.3808C6.04092 10.5422 7.70354 7.5981 10.5422 6.80734C13.3808 6.01658 16.3248 7.67921 17.1156 10.5178Z" fill="white"/>
                    <path d="M17.1156 10.5178C17.4116 11.5843 17.363 12.663 17.0385 13.6363C17.0142 13.7133 16.9858 13.7944 16.9534 13.8715" fill="white"/>
                    <path d="M17.0304 10.5178C17.2373 11.264 17.2778 12.0182 17.1683 12.736Z" fill="white"/>
                    <path d="M15.5422 15.6963C14.1918 15.6963 12.5495 15.3516 10.9112 14.7312C9.2729 14.1107 7.81709 13.2754 6.80735 12.3792C5.16906 10.9234 5.27044 9.79602 5.47725 9.25262C5.68406 8.70923 6.35722 7.79681 8.54702 7.79681C9.89739 7.79681 11.5397 8.1415 13.178 8.76195C14.8163 9.38239 16.2721 10.2178 17.2819 11.1139C18.9202 12.5698 18.8188 13.6971 18.612 14.2405C18.4092 14.7839 17.736 15.6963 15.5422 15.6963ZM8.55107 9.48782C7.53728 9.48782 7.10338 9.73924 7.05877 9.85279C7.01416 9.96633 7.17637 10.4448 7.93469 11.118C8.78222 11.8682 10.088 12.6144 11.5154 13.1537C12.9428 13.6971 14.4149 14.0093 15.5463 14.0093C16.56 14.0093 16.9939 13.7579 17.0386 13.6444C17.0832 13.5308 16.921 13.0523 16.1667 12.3792C15.3192 11.629 14.0134 10.8828 12.586 10.3435C11.1504 9.80007 9.68247 9.48782 8.55107 9.48782Z" fill="#4D5CC1"/>
                    <path d="M7.05876 9.869L17.0304 13.6565C17.363 12.6752 17.4157 11.5884 17.1156 10.5178C16.3248 7.67921 13.3848 6.01658 10.5422 6.80734C8.91198 7.26152 7.67109 8.42536 7.05876 9.869Z" fill="white"/>
                </symbol>
                <symbol
                    id="lbaic-settings-browser-uc"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <path d="M17.611 22H6.38904C3.96712 22 2 20.0329 2 17.611V6.38904C2 3.96712 3.96712 2 6.38904 2H17.611C20.0329 2 22 3.96712 22 6.38904V17.611C22 20.0329 20.0329 22 17.611 22Z" fill="url(#paint0_linear_2258_15)"/>
                    <path d="M9.74247 19.4302C9.72056 19.4247 9.69316 19.4137 9.67124 19.4082C7.60549 18.8274 6.63562 16.5315 7.19453 14.6685C7.49042 13.6877 8.12603 12.9644 8.95343 12.4C9.51234 12.0219 10.0877 11.6713 10.6466 11.2932C11.4411 10.7507 12.0438 10.0439 12.3452 9.11235C12.7123 7.97263 12.5918 6.90413 11.7753 5.99455C10.9206 5.03564 9.81371 4.66304 8.54795 4.82742C6.92603 5.03564 5.7096 5.89044 4.8274 7.24934C4.78905 7.30413 4.76713 7.36441 4.73425 7.42468C5.10138 7.18907 5.47946 7.03564 5.90138 6.98633C6.75617 6.88222 7.57809 7.4466 7.73699 8.26852C7.86302 8.89866 7.69864 9.47948 7.32055 9.97811C6.92055 10.5096 6.47672 11.0137 6.04384 11.5233C5.0411 12.6904 4.52055 14.0165 4.73973 15.5726C4.92055 16.8822 5.58905 17.9014 6.67398 18.6356C7.59453 19.2548 8.64658 19.4356 9.74247 19.4302Z" fill="white"/>
                    <path d="M12.4877 11.0137C13.0795 11.0083 13.6603 11.1233 14.2301 11.2877C15.0466 11.5233 15.8082 11.874 16.526 12.3179C17.2055 12.7398 17.9342 12.8603 18.7123 12.7288C18.8658 12.7014 19.0137 12.6521 19.1562 12.5973C19.2055 12.5754 19.2658 12.4987 19.2658 12.4439C19.2767 12.2576 19.2767 12.0658 19.2603 11.8795C19.2055 11.2439 19.0027 10.6576 18.6411 10.1316C18.2027 9.49046 17.589 9.09046 16.8658 8.84389C16.7452 8.80005 16.6959 8.73978 16.674 8.62471C16.6411 8.46032 16.5918 8.30142 16.537 8.14252C16.4274 7.84662 16.2795 7.56717 16.0274 7.33704C15.9836 7.39183 15.9397 7.43567 15.9068 7.48498C15.5616 7.97813 15.4247 8.54252 15.4247 9.1343C15.4247 9.30416 15.3753 9.43019 15.2384 9.51786C14.8603 9.76443 14.4986 10.0384 14.0986 10.2521C13.5836 10.537 13.0301 10.7672 12.4877 11.0137Z" fill="white"/>
                    <path d="M14.5479 18.2028C14.7288 17.6767 14.8164 17.1726 14.811 16.6521C14.8055 15.9671 14.6849 15.3041 14.3397 14.7124C13.5562 13.3754 12.3836 12.6795 10.8219 12.6904C10.0493 12.6959 9.36439 12.9589 8.8 13.5069C8.52603 13.7754 8.31233 14.0877 8.15343 14.4822C9.62192 12.9315 12.0055 13.3973 12.9151 14.7945C13.4685 15.6439 13.6055 16.5534 13.2767 17.5124C12.9479 18.4767 12.2356 19.074 11.2986 19.4411C13.0466 19.4356 14.7836 19.4137 16.5644 19.2493C16.137 18.3836 15.3644 18.263 14.5479 18.2028Z" fill="white"/>
                    <path d="M19.337 14.5644C19.3205 14.2466 19.1616 14.0329 18.926 13.874C18.6356 13.6822 18.2959 13.6274 17.9562 13.6C17.337 13.5452 16.7452 13.3973 16.1973 13.0959C15.7315 12.8384 15.2822 12.5425 14.8055 12.3069C14.0493 11.9397 13.2438 11.7589 12.411 11.6822C11.8411 11.6274 11.2822 11.6767 10.7342 11.8521C10.6685 11.874 10.6082 11.9069 10.5479 11.9343C10.6192 11.9616 10.6794 11.9616 10.7397 11.9616C11.3808 11.9452 12.011 12.0384 12.6137 12.263C13.863 12.7397 14.7726 13.6055 15.4137 14.7562C15.474 14.8658 15.5507 14.9479 15.6658 14.9589C15.9562 14.9863 16.2521 15.0247 16.5479 15.0082C16.926 14.9863 17.2603 14.8164 17.6 14.6575C18 14.4712 18.4164 14.3781 18.8603 14.4493C19.0027 14.4822 19.1562 14.5206 19.337 14.5644Z" fill="white"/>
                    <path d="M9.74246 19.4301C8.64657 19.4356 7.59452 19.2548 6.67397 18.6356C5.58904 17.9014 4.92055 16.8822 4.73972 15.5726C4.52602 14.0164 5.04109 12.6904 6.04931 11.5233C6.48767 11.0192 6.92602 10.5151 7.32602 9.97809C7.70411 9.47946 7.86849 8.89864 7.74246 8.2685C7.58356 7.44659 6.76164 6.8822 5.90685 6.98631C5.48493 7.03563 5.10685 7.18905 4.73972 7.42467C4.7726 7.36439 4.8 7.30412 4.83287 7.24933C5.70959 5.89042 6.92602 5.03015 8.54794 4.82193C9.8137 4.65755 10.9151 5.03015 11.7753 5.98905C12.5918 6.89864 12.7123 7.96713 12.3452 9.10686C12.0438 10.0384 11.4411 10.7452 10.6466 11.2877C10.0877 11.6658 9.51233 12.0164 8.95342 12.3945C8.12602 12.9589 7.49041 13.6877 7.19452 14.663C6.63013 16.526 7.60548 18.8219 9.67123 19.4028C9.69315 19.4137 9.71507 19.4192 9.74246 19.4301Z" fill="white"/>
                    <path d="M12.4877 11.0137C13.0301 10.7617 13.5781 10.5316 14.1041 10.2521C14.5041 10.0384 14.8658 9.76443 15.2438 9.51786C15.3808 9.43019 15.4301 9.30416 15.4301 9.1343C15.4301 8.54252 15.5671 7.98361 15.9123 7.48498C15.9452 7.43567 15.9836 7.39731 16.0329 7.33704C16.2795 7.56717 16.4274 7.84662 16.5425 8.14252C16.5973 8.30142 16.6466 8.46032 16.6795 8.62471C16.7068 8.73978 16.7507 8.80553 16.8712 8.84389C17.5945 9.08498 18.2082 9.49046 18.6466 10.1316C19.0082 10.6576 19.211 11.2439 19.2658 11.8795C19.2822 12.0658 19.2822 12.2576 19.2712 12.4439C19.2658 12.4987 19.211 12.5754 19.1616 12.5973C19.0192 12.6576 18.8658 12.7069 18.7178 12.7288C17.9397 12.8603 17.211 12.7398 16.5315 12.3179C15.8137 11.874 15.0521 11.5179 14.2356 11.2877C13.6603 11.1233 13.0795 11.0083 12.4877 11.0137Z" fill="white"/>
                    <path d="M14.5479 18.2028C15.3644 18.263 16.137 18.3891 16.5699 19.2438C14.789 19.4028 13.0521 19.4301 11.3041 19.4356C12.2411 19.0685 12.9534 18.4712 13.2822 17.5069C13.611 16.548 13.4685 15.6384 12.9205 14.7891C12.011 13.3918 9.6274 12.926 8.15891 14.4767C8.31781 14.0822 8.52603 13.7699 8.80548 13.5014C9.36438 12.9534 10.0548 12.6904 10.8274 12.6849C12.389 12.674 13.5616 13.3754 14.3452 14.7069C14.6904 15.2986 14.811 15.9617 14.8164 16.6466C14.8164 17.1726 14.7288 17.6767 14.5479 18.2028Z" fill="white"/>
                    <path d="M19.337 14.5644C19.1562 14.526 19.0027 14.4822 18.8493 14.4548C18.411 14.3836 17.989 14.4767 17.589 14.663C17.2493 14.8219 16.9151 14.9918 16.537 15.0137C16.2466 15.0302 15.9507 14.9918 15.6548 14.9644C15.5397 14.9534 15.463 14.8712 15.4027 14.7617C14.7562 13.6055 13.8521 12.7397 12.6027 12.2685C12 12.0384 11.3753 11.9507 10.7288 11.9671C10.6685 11.9671 10.6137 11.9671 10.537 11.9397C10.5973 11.9123 10.6575 11.8795 10.7233 11.8576C11.2712 11.6822 11.8247 11.6329 12.4 11.6877C13.2329 11.7644 14.0438 11.9452 14.7945 12.3123C15.2712 12.548 15.7205 12.8439 16.1863 13.1014C16.7342 13.4028 17.326 13.5507 17.9452 13.6055C18.2849 13.6384 18.6247 13.6877 18.9151 13.8795C19.1616 14.0329 19.3205 14.2466 19.337 14.5644Z" fill="white"/>
                    <path d="M10.3781 14.4055C9.2 14.4055 8.2411 15.3589 8.2411 16.5315C8.23562 17.7151 9.19452 18.6685 10.3836 18.6631C11.5671 18.6631 12.5096 17.7151 12.5096 16.5315C12.5041 15.3535 11.5562 14.4055 10.3781 14.4055ZM10.3616 17.5178C9.82466 17.5178 9.3863 17.074 9.38082 16.537C9.38082 16 9.83014 15.5507 10.3726 15.5507C10.9151 15.5507 11.3589 16 11.3534 16.5425C11.3479 17.0959 10.9205 17.5178 10.3616 17.5178Z" fill="white"/>
                    <defs>
                        <linearGradient id="paint0_linear_2258_15" x1="12.0005" y1="21.9996" x2="12.0005" y2="2.00072" gradientUnits="userSpaceOnUse">
                            <stop stopColor="#FF780B"/>
                            <stop offset="1" stopColor="#FFA322"/>
                        </linearGradient>
                    </defs>
                </symbol>
                <symbol
                    id="lbaic-settings-browser-ie"
                    viewBox="0 0 24 24"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <path
                        d="M22.0133 12.4685C22.0133 10.8586 21.6043 9.34606 20.887 8.03175C23.9444 0.990248 17.6108 2.02162 17.2582 2.09183C15.9163 2.35902 14.6749 2.78798 13.5298 3.33175C13.361 3.32208 13.1911 3.31676 13.0199 3.31676C8.74634 3.31676 5.16912 6.34996 4.25358 10.4161C6.50602 7.84474 8.08236 6.8072 9.02634 6.392C8.87566 6.52901 8.72816 6.66754 8.58307 6.80711C8.53477 6.85351 8.48824 6.90057 8.4406 6.94725C8.34493 7.0409 8.24945 7.13464 8.15621 7.22924C8.10073 7.2855 8.04675 7.34224 7.99211 7.39889C7.9094 7.48457 7.82688 7.57015 7.74613 7.6563C7.68879 7.7175 7.63285 7.77889 7.57653 7.84019C7.5011 7.92236 7.42613 8.00462 7.35256 8.08717C7.2954 8.15131 7.23918 8.21545 7.18305 8.27978C7.1133 8.35967 7.04421 8.43956 6.97605 8.51964C6.91955 8.58606 6.86351 8.65247 6.80812 8.71899C6.74351 8.7966 6.67973 8.87421 6.61661 8.95183C6.56076 9.02052 6.50509 9.08912 6.45045 9.15772C6.39133 9.23192 6.33352 9.30602 6.27581 9.38003C6.21986 9.45176 6.16392 9.5234 6.10928 9.59504C6.05725 9.66326 6.00671 9.73119 5.9558 9.79922C5.89837 9.87608 5.84046 9.95293 5.78452 10.0294C5.74452 10.0842 5.7061 10.1383 5.66685 10.1929C5.3115 10.6863 4.98683 11.1702 4.69359 11.635C4.69284 11.6361 4.6921 11.6373 4.69145 11.6384C4.61424 11.7608 4.53974 11.8814 4.46673 12.001C4.46282 12.0074 4.45871 12.014 4.4548 12.0205C4.3817 12.1405 4.31111 12.2585 4.2423 12.3752C4.23988 12.3793 4.23736 12.3834 4.23493 12.3875C4.04994 12.7017 3.87838 13.0045 3.72388 13.2895C2.91389 14.7832 2.51957 15.8268 2.50251 15.8888C-0.0552983 25.1941 7.92768 21.2645 9.04163 20.678C10.2411 21.2809 11.5914 21.6203 13.0199 21.6203C16.9304 21.6203 20.2576 19.0802 21.496 15.5331H16.7705C16.0713 16.7351 14.7252 17.5493 13.1787 17.5493C10.9128 17.5493 9.07604 15.8023 9.07604 13.6473H21.9397C21.9884 13.2613 22.0137 12.8679 22.0137 12.4685H22.0133ZM20.3333 3.46269C21.1078 3.9946 21.7289 4.82995 20.6621 7.64311C19.639 5.96872 18.0997 4.65527 16.2701 3.93331C17.1024 3.52427 19.1635 2.65913 20.3333 3.46269ZM3.87428 20.6592C3.2435 20.0009 3.13198 18.3976 4.52389 15.4759C5.22637 17.5312 6.62817 19.2533 8.44004 20.3463C7.53895 20.8509 5.14675 21.9872 3.87428 20.6592ZM9.0558 11.1444C9.12769 9.04984 10.9191 7.37279 13.12 7.37279C15.3209 7.37279 17.1123 9.04984 17.1842 11.1444H9.0558Z"
                        fill="#1EBBEE"/>
                </symbol>

            </svg>
        </div>
    )
}

export default Utilities;