import {__} from '@wordpress/i18n';

export default function Search({onSearchChange}) {
    /**
     * Searched
     *
     * @param {Event} e Search event
     */
    const searched = (e) => {
        onSearchChange(e.target.value);
    }

    return (
        <div className='lbaic-settings-search'>
            <svg className='lbaic-settings-search-i' xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 24 24'>
                <use href='#lbaic-settings-search'/>
            </svg>
            <input
                type='search'
                placeholder={__("Search", 'limb-chatbot')}
                className='lbaic-settings-search-input lbaic-settings-input-reset'
                onChange={searched}
                autoComplete="off"
            />
        </div>
    )
}