import {useEffect, useState} from "@wordpress/element";

export default function NavListItemHeader({data, classPrefix = 'lbaic-settings-nav'}) {
    const [className, setClassName] = useState('');

    useEffect(() => {
        setClassName(LimbChatbot.Hooks.applyFilters('lbaic.admin.page.settings.dropdownNavLabel.classes', [], data).join(' '));
    }, []);

    return <>
        {data.icon}
        <span className={`${classPrefix}-item-label${className ? ' ' + className : ''}`}>{data.label}</span>
        {!!data.badge && data.badge}
    </>
}