import lbaicSettingsLogo from "../../../../../../../../../resources/admin/page/settings/logo.svg";

export default function Header({isNavOpened, toggleNav}) {
    return (
        <div className='lbaic-settings-nav-header'>
            <div className='lbaic-settings-nav-logo'>
                <div className='lbaic-settings-nav-logo-container'>
                    <img className='lbaic-settings-nav-logo-in' src={lbaicSettingsLogo} alt=''/>
                    <div className="lbaic-settings-nav-plugin-version">
                        <span className="lbaic-settings-nav-plugin-version-label">v{LimbChatbot?.version || '1.0.0'}</span>
                    </div>
                </div>
                <h2 className='lbaic-settings-nav-welcome-text'>Style is everything. Find your own.</h2>
            </div>
            <div className='lbaic-settings-nav-mobile-toggle'>
                <button className='lbaic-settings-nav-mobile-toggle-in lbaic-settings-button' onClick={toggleNav}>
                    <svg
                        className='lbaic-settings-nav-mobile-toggle-i'
                        xmlns='http://www.w3.org/2000/svg'
                        fill='none'
                        viewBox='0 0 24 24'
                    >
                        <use href={`#lbaic-settings-${isNavOpened ? 'close' : 'menu'}`}/>
                    </svg>
                </button>
            </div>
        </div>
    )
}