import {useContext} from "@wordpress/element";
import {useNavigate} from 'react-router-dom';
import useSettings from "../../state";
import {NotificationsContext} from "../../../../contexts/notifications";

export default function CurrentComponent({pageData, setChatbotPreview, updatePositions, children}) {
    const notifications = useContext(NotificationsContext);
    const navigate = useNavigate();

    const {pages} = useSettings();

    const RenderContent = pageData.key in pages ? pages[pageData.key] : () => null;

    return (
        <RenderContent
            notifications={notifications}
            navigate={navigate}
            setChatbotPreview={setChatbotPreview}
            updatePositions={updatePositions}
        >
            {children}
        </RenderContent>
    );
}