import {__} from '@wordpress/i18n';
import ContentFooterLayout from "./_components/layout";

export default function ContentFooter({
                                          save,
                                          discard,
                                          loading,
                                          saving,
                                          previewSaving,
                                          hasUnsavedChanges,
                                          saveIcon,
                                          saveLabel,
                                          discardLabel,
                                          children,
                                          disableDiscardButton = true
                                      }) {
    return <ContentFooterLayout loading={!!loading || saving || previewSaving}>
        <button onClick={save}
                className={`lbaic-settings-button lbaic-settings-button-center lbaic-settings-button-h-40 lbaic-settings-button-primary lbaic-settings-content-footer-actions-in${loading || saving || hasUnsavedChanges === false ? ' lbaic-settings-button-disabled' : ''}`}>
            {!saving && !!saveIcon &&
                <svg className='lbaic-settings-button-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                     viewBox='0 0 24 24'>
                    <use href={`#lbaic-settings-${saveIcon}`}/>
                </svg>}
            {saving &&
                <svg className='lbaic-settings-button-i lbaic-settings-loading-circle'
                     xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 24 24'>
                    <use href='#lbaic-settings-circle'/>
                </svg>}
            <span className='lbaic-settings-button-label'>{saveLabel || __("Save changes", 'limb-chatbot')}</span>
        </button>
        <button onClick={discard}
                className={`lbaic-settings-button lbaic-settings-button-center lbaic-settings-button-h-40 lbaic-settings-button-secondary lbaic-settings-content-footer-actions-in${disableDiscardButton && hasUnsavedChanges === false ? ' lbaic-settings-button-disabled' : ''}`}>
            <span className='lbaic-settings-button-label'>{discardLabel || __("Discard changes", 'limb-chatbot')}</span>
        </button>
        {children}
    </ContentFooterLayout>
}