export default function Empty({className, title, titleClassName, subtitle, subtitleClassName, icon = 'equalizer', children}) {
    return (
        <div className={`lbaic-settings-empty${className ? ' ' + className : ''}`}>
            <div className='lbaic-settings-empty-in'>
                {icon &&
                    <div className='lbaic-settings-empty-icon'>
                        <svg className='lbaic-settings-empty-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                             viewBox='0 0 24 24'>
                            <use href={`#lbaic-settings-${icon}`}/>
                        </svg>
                    </div>}
                <div className='lbaic-settings-empty-desc'>
                    <span className={`lbaic-settings-empty-title${titleClassName ? ' ' + titleClassName : ''}`}>{title}</span>
                    <span className={`lbaic-settings-empty-subtitle${subtitleClassName ? ' ' + subtitleClassName : ''}`} dangerouslySetInnerHTML={{__html: subtitle}}></span>
                </div>
                {children}
            </div>
        </div>
    )
}